/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor.base;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.james.imap.api.ImapConfiguration;
import org.apache.james.imap.api.ImapMessage;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.util.MDCBuilder;
import org.apache.james.util.ReactorUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;
import reactor.util.context.ContextView;

public abstract class AbstractProcessor<M extends ImapMessage>
implements ImapProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractProcessor.class);
    private final Class<M> acceptableClass;

    public AbstractProcessor(Class<M> acceptableClass) {
        this.acceptableClass = acceptableClass;
    }

    @Override
    public Mono<Void> processReactive(ImapMessage message, ImapProcessor.Responder responder, ImapSession session) {
        ImapMessage acceptableMessage = message;
        if (LOGGER.isDebugEnabled()) {
            return this.initialLog(message).then(this.doProcess(acceptableMessage, responder, session)).contextWrite((ContextView)ReactorUtils.context((String)"imap-processor", (MDCBuilder)this.mdc(acceptableMessage)));
        }
        return this.doProcess(acceptableMessage, responder, session).contextWrite((ContextView)ReactorUtils.context((String)"imap-processor", (MDCBuilder)this.mdc(acceptableMessage)));
    }

    private Mono<Void> initialLog(ImapMessage message) {
        if (LOGGER.isDebugEnabled()) {
            return ReactorUtils.logAsMono(() -> LOGGER.debug("Processing {}", (Object)message.toString()));
        }
        return Mono.empty();
    }

    @Override
    public void configure(ImapConfiguration imapConfiguration) {
    }

    protected Class<M> acceptableClass() {
        return this.acceptableClass;
    }

    public List<Class<? extends M>> acceptableClasses() {
        return ImmutableList.of(this.acceptableClass);
    }

    protected abstract Mono<Void> doProcess(M var1, ImapProcessor.Responder var2, ImapSession var3);

    protected abstract MDCBuilder mdc(M var1);
}

