/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.consensus.deletion.recover;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.apache.iotdb.db.pipe.consensus.deletion.DeletionResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeletionReader
implements Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(DeletionReader.class);
    private static final int MAGIC_STRING_BYTES_SIZE = "DELETION_V1".getBytes(StandardCharsets.UTF_8).length;
    private final String regionId;
    private final Consumer<DeletionResource> removeHook;
    private final File logFile;
    private final FileInputStream fileInputStream;
    private final FileChannel fileChannel;

    public DeletionReader(File logFile, String regionId, Consumer<DeletionResource> removeHook) throws IOException {
        this.logFile = logFile;
        this.regionId = regionId;
        this.fileInputStream = new FileInputStream(logFile);
        this.fileChannel = this.fileInputStream.getChannel();
        this.removeHook = removeHook;
    }

    public List<DeletionResource> readAllDeletions() throws IOException {
        try {
            ByteBuffer magicStringBuffer = ByteBuffer.allocate(MAGIC_STRING_BYTES_SIZE);
            this.fileChannel.read(magicStringBuffer);
            magicStringBuffer.flip();
            String magicVersion = new String(magicStringBuffer.array(), StandardCharsets.UTF_8);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Read deletion file-{} magic version: {}", (Object)this.logFile, (Object)magicVersion);
            }
            long remainingBytes = this.fileChannel.size() - this.fileChannel.position();
            ByteBuffer byteBuffer = ByteBuffer.allocate((int)remainingBytes);
            this.fileChannel.read(byteBuffer);
            byteBuffer.flip();
            ArrayList<DeletionResource> deletions = new ArrayList<DeletionResource>();
            while (byteBuffer.hasRemaining()) {
                DeletionResource deletionResource = DeletionResource.deserialize(byteBuffer, this.regionId, this.removeHook);
                deletions.add(deletionResource);
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.debug("Read deletion: {} from file {}", (Object)deletionResource, (Object)this.logFile);
            }
            return deletions;
        }
        catch (IOException e) {
            LOGGER.warn("Failed to read deletion file {}, may because this file corrupted when writing it.", (Object)this.logFile, (Object)e);
            throw e;
        }
    }

    @Override
    public void close() throws IOException {
        this.fileChannel.close();
        this.fileInputStream.close();
    }
}

