/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.persistence.schema;

import java.util.HashMap;
import java.util.Map;

public enum CNSnapshotFileType {
    INVALID(0),
    USER(1),
    ROLE(2),
    USER_ROLE(3),
    SCHEMA(4),
    TTL(5);

    private static final Map<Byte, CNSnapshotFileType> TYPE_SNAPSHOT_MAP;
    private final byte type;

    private CNSnapshotFileType(byte type) {
        this.type = type;
    }

    public byte getType() {
        return this.type;
    }

    public static CNSnapshotFileType deserialize(byte type) {
        return TYPE_SNAPSHOT_MAP.get(type);
    }

    static {
        TYPE_SNAPSHOT_MAP = new HashMap<Byte, CNSnapshotFileType>();
        for (CNSnapshotFileType type : CNSnapshotFileType.values()) {
            TYPE_SNAPSHOT_MAP.put(type.getType(), type);
        }
    }
}

