/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsfile.utils;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class RegexUtils {
    private RegexUtils() {
    }

    public static String parseLikePatternToRegex(String likePattern) {
        String unescapeValue = RegexUtils.unescapeString(likePattern);
        String specialRegexStr = ".^$*+?{}[]|()";
        StringBuilder patternStrBuild = new StringBuilder();
        patternStrBuild.append("^");
        for (int i = 0; i < unescapeValue.length(); ++i) {
            String ch = String.valueOf(unescapeValue.charAt(i));
            if (specialRegexStr.contains(ch)) {
                ch = "\\" + unescapeValue.charAt(i);
            }
            if (i == 0 || !"\\".equals(String.valueOf(unescapeValue.charAt(i - 1))) || i >= 2 && "\\\\".equals(patternStrBuild.substring(patternStrBuild.length() - 2, patternStrBuild.length()))) {
                String replaceStr = ch.replace("%", ".*?").replace("_", ".");
                patternStrBuild.append(replaceStr);
                continue;
            }
            patternStrBuild.append(ch);
        }
        patternStrBuild.append("$");
        return patternStrBuild.toString();
    }

    private static String unescapeString(String value) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int curIndex = 0; curIndex < value.length(); ++curIndex) {
            String ch = String.valueOf(value.charAt(curIndex));
            if ("\\".equals(ch) && curIndex < value.length() - 1) {
                String nextChar = String.valueOf(value.charAt(curIndex + 1));
                if (!"%".equals(nextChar) && !"_".equals(nextChar) && !"\\".equals(nextChar)) continue;
                stringBuilder.append(ch);
                if (!"\\".equals(nextChar)) continue;
                ++curIndex;
                continue;
            }
            stringBuilder.append(ch);
        }
        return stringBuilder.toString();
    }

    public static Pattern compileRegex(String regex) {
        try {
            return Pattern.compile(regex);
        }
        catch (PatternSyntaxException e) {
            throw new PatternSyntaxException("Illegal regex expression: ", regex, e.getIndex());
        }
    }
}

