/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsfile.encoding.encoder;

import java.io.ByteArrayOutputStream;
import org.apache.tsfile.encoding.encoder.Encoder;
import org.apache.tsfile.file.metadata.enums.TSEncoding;

public abstract class GorillaEncoderV2
extends Encoder {
    protected boolean firstValueWasWritten = false;
    protected int storedLeadingZeros = Integer.MAX_VALUE;
    protected int storedTrailingZeros = 0;
    private byte buffer = 0;
    protected int bitsLeft = 8;

    protected GorillaEncoderV2() {
        super(TSEncoding.GORILLA);
    }

    @Override
    public final long getMaxByteSize() {
        return 0L;
    }

    protected void reset() {
        this.firstValueWasWritten = false;
        this.storedLeadingZeros = Integer.MAX_VALUE;
        this.storedTrailingZeros = 0;
        this.buffer = 0;
        this.bitsLeft = 8;
    }

    protected void skipBit(ByteArrayOutputStream out) {
        --this.bitsLeft;
        this.flipByte(out);
    }

    protected void writeBit(ByteArrayOutputStream out) {
        this.buffer = (byte)(this.buffer | 1 << this.bitsLeft - 1);
        --this.bitsLeft;
        this.flipByte(out);
    }

    protected void writeBits(long value, int bits, ByteArrayOutputStream out) {
        while (bits > 0) {
            int shift = bits - this.bitsLeft;
            if (shift >= 0) {
                this.buffer = (byte)(this.buffer | (byte)(value >> shift & (long)((1 << this.bitsLeft) - 1)));
                bits -= this.bitsLeft;
                this.bitsLeft = 0;
            } else {
                shift = this.bitsLeft - bits;
                this.buffer = (byte)(this.buffer | (byte)(value << shift));
                this.bitsLeft -= bits;
                bits = 0;
            }
            this.flipByte(out);
        }
    }

    protected void flipByte(ByteArrayOutputStream out) {
        if (this.bitsLeft == 0) {
            out.write(this.buffer);
            this.buffer = 0;
            this.bitsLeft = 8;
        }
    }
}

