/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import java.util.Arrays;
import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaResponseMessage;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.DiagnosticInfo;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.structured.ResponseHeader;
import org.eclipse.milo.opcua.stack.core.types.structured.Structure;

public class RegisterServer2Response
extends Structure
implements UaResponseMessage {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=12194");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=12212");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=12200");
    private final ResponseHeader responseHeader;
    private final StatusCode[] configurationResults;
    private final DiagnosticInfo[] diagnosticInfos;

    public RegisterServer2Response(ResponseHeader responseHeader, StatusCode[] configurationResults, DiagnosticInfo[] diagnosticInfos) {
        this.responseHeader = responseHeader;
        this.configurationResults = configurationResults;
        this.diagnosticInfos = diagnosticInfos;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    @Override
    public ResponseHeader getResponseHeader() {
        return this.responseHeader;
    }

    public StatusCode[] getConfigurationResults() {
        return this.configurationResults;
    }

    public DiagnosticInfo[] getDiagnosticInfos() {
        return this.diagnosticInfos;
    }

    protected RegisterServer2Response(RegisterServer2ResponseBuilder<?, ?> b) {
        super(b);
        this.responseHeader = ((RegisterServer2ResponseBuilder)b).responseHeader;
        this.configurationResults = ((RegisterServer2ResponseBuilder)b).configurationResults;
        this.diagnosticInfos = ((RegisterServer2ResponseBuilder)b).diagnosticInfos;
    }

    public static RegisterServer2ResponseBuilder<?, ?> builder() {
        return new RegisterServer2ResponseBuilderImpl();
    }

    public RegisterServer2ResponseBuilder<?, ?> toBuilder() {
        return new RegisterServer2ResponseBuilderImpl().$fillValuesFrom(this);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RegisterServer2Response)) {
            return false;
        }
        RegisterServer2Response other = (RegisterServer2Response)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ResponseHeader this$responseHeader = this.getResponseHeader();
        ResponseHeader other$responseHeader = other.getResponseHeader();
        if (this$responseHeader == null ? other$responseHeader != null : !((Object)this$responseHeader).equals(other$responseHeader)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getConfigurationResults(), other.getConfigurationResults())) {
            return false;
        }
        return Arrays.deepEquals(this.getDiagnosticInfos(), other.getDiagnosticInfos());
    }

    protected boolean canEqual(Object other) {
        return other instanceof RegisterServer2Response;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ResponseHeader $responseHeader = this.getResponseHeader();
        result = result * 59 + ($responseHeader == null ? 43 : ((Object)$responseHeader).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getConfigurationResults());
        result = result * 59 + Arrays.deepHashCode(this.getDiagnosticInfos());
        return result;
    }

    @Override
    public String toString() {
        return "RegisterServer2Response(responseHeader=" + this.getResponseHeader() + ", configurationResults=" + Arrays.deepToString(this.getConfigurationResults()) + ", diagnosticInfos=" + Arrays.deepToString(this.getDiagnosticInfos()) + ")";
    }

    private static final class RegisterServer2ResponseBuilderImpl
    extends RegisterServer2ResponseBuilder<RegisterServer2Response, RegisterServer2ResponseBuilderImpl> {
        private RegisterServer2ResponseBuilderImpl() {
        }

        @Override
        protected RegisterServer2ResponseBuilderImpl self() {
            return this;
        }

        @Override
        public RegisterServer2Response build() {
            return new RegisterServer2Response(this);
        }
    }

    public static abstract class RegisterServer2ResponseBuilder<C extends RegisterServer2Response, B extends RegisterServer2ResponseBuilder<C, B>>
    extends Structure.StructureBuilder<C, B> {
        private ResponseHeader responseHeader;
        private StatusCode[] configurationResults;
        private DiagnosticInfo[] diagnosticInfos;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            RegisterServer2ResponseBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(RegisterServer2Response instance, RegisterServer2ResponseBuilder<?, ?> b) {
            b.responseHeader(instance.responseHeader);
            b.configurationResults(instance.configurationResults);
            b.diagnosticInfos(instance.diagnosticInfos);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B responseHeader(ResponseHeader responseHeader) {
            this.responseHeader = responseHeader;
            return (B)this.self();
        }

        public B configurationResults(StatusCode[] configurationResults) {
            this.configurationResults = configurationResults;
            return (B)this.self();
        }

        public B diagnosticInfos(DiagnosticInfo[] diagnosticInfos) {
            this.diagnosticInfos = diagnosticInfos;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "RegisterServer2Response.RegisterServer2ResponseBuilder(super=" + super.toString() + ", responseHeader=" + this.responseHeader + ", configurationResults=" + Arrays.deepToString(this.configurationResults) + ", diagnosticInfos=" + Arrays.deepToString(this.diagnosticInfos) + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<RegisterServer2Response> {
        @Override
        public Class<RegisterServer2Response> getType() {
            return RegisterServer2Response.class;
        }

        @Override
        public RegisterServer2Response decode(SerializationContext context, UaDecoder decoder) {
            ResponseHeader responseHeader = (ResponseHeader)decoder.readStruct("ResponseHeader", ResponseHeader.TYPE_ID);
            StatusCode[] configurationResults = decoder.readStatusCodeArray("ConfigurationResults");
            DiagnosticInfo[] diagnosticInfos = decoder.readDiagnosticInfoArray("DiagnosticInfos");
            return new RegisterServer2Response(responseHeader, configurationResults, diagnosticInfos);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, RegisterServer2Response value) {
            encoder.writeStruct("ResponseHeader", (Object)value.getResponseHeader(), ResponseHeader.TYPE_ID);
            encoder.writeStatusCodeArray("ConfigurationResults", value.getConfigurationResults());
            encoder.writeDiagnosticInfoArray("DiagnosticInfos", value.getDiagnosticInfos());
        }
    }
}

