/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.service.thrift;

import java.util.Objects;
import org.apache.iotdb.commons.concurrent.ThreadName;
import org.apache.iotdb.commons.service.AbstractThriftServiceThread;
import org.apache.iotdb.commons.service.metric.enums.Metric;
import org.apache.iotdb.commons.service.metric.enums.Tag;
import org.apache.iotdb.metrics.AbstractMetricService;
import org.apache.iotdb.metrics.metricsets.IMetricSet;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.iotdb.metrics.utils.MetricType;

public class ConfigNodeRPCServiceMetrics
implements IMetricSet {
    private final AbstractThriftServiceThread thriftServiceThread;

    public ConfigNodeRPCServiceMetrics(AbstractThriftServiceThread thriftServiceThread) {
        this.thriftServiceThread = thriftServiceThread;
    }

    public void bindTo(AbstractMetricService metricService) {
        metricService.createAutoGauge(Metric.THRIFT_ACTIVE_THREADS.toString(), MetricLevel.CORE, (Object)this.thriftServiceThread, AbstractThriftServiceThread::getActiveThreadCount, new String[]{Tag.NAME.toString(), ThreadName.CONFIGNODE_RPC_SERVICE.getName()});
    }

    public void unbindFrom(AbstractMetricService metricService) {
        metricService.remove(MetricType.AUTO_GAUGE, Metric.THRIFT_ACTIVE_THREADS.toString(), new String[]{Tag.NAME.toString(), ThreadName.CONFIGNODE_RPC_SERVICE.getName()});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConfigNodeRPCServiceMetrics that = (ConfigNodeRPCServiceMetrics)o;
        return Objects.equals(this.thriftServiceThread, that.thriftServiceThread);
    }

    public int hashCode() {
        return Objects.hash(this.thriftServiceThread);
    }
}

