/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.inlong.sort.protocol.constant;

/**
 * Postgres options constant
 */
public class PostgresConstant {

    public static final String CONNECTOR = "connector";

    public static final String POSTGRES_CDC = "postgres-cdc-inlong";

    public static final String DATABASE_NAME = "database-name";

    public static final String HOSTNAME = "hostname";

    public static final String PORT = "port";

    public static final String USERNAME = "username";

    public static final String PASSWORD = "password";

    public static final String TABLE_NAME = "table-name";

    public static final String SCHEMA_NAME = "schema-name";

    public static final String DECODING_PLUGIN_NAME = "decoding.plugin.name";

    public static final String PGOUTPUT = "pgoutput";

    public static final String SLOT_NAME = "slot.name";

    public static final String SERVER_TIME_ZONE = "server-time-zone";

    public static final String DEBEZIUM_SNAPSHOT_MODE = "debezium.snapshot.mode";

    public static final String URL = "url";

    public static final String JDBC_INLONG = "jdbc-inlong";

    public static final String JDBC = "jdbc";

}
