/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.namingserver.manager;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.github.benmanes.caffeine.cache.RemovalListener;
import jakarta.annotation.PostConstruct;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import okhttp3.Response;
import org.apache.http.entity.ContentType;
import org.apache.seata.common.metadata.Cluster;
import org.apache.seata.common.metadata.ClusterRole;
import org.apache.seata.common.metadata.Node;
import org.apache.seata.common.metadata.namingserver.NamingServerNode;
import org.apache.seata.common.metadata.namingserver.Unit;
import org.apache.seata.common.result.Result;
import org.apache.seata.common.result.SingleResult;
import org.apache.seata.common.util.HttpClientUtil;
import org.apache.seata.common.util.StringUtils;
import org.apache.seata.namingserver.entity.bo.ClusterBO;
import org.apache.seata.namingserver.entity.bo.NamespaceBO;
import org.apache.seata.namingserver.entity.bo.NamespaceData;
import org.apache.seata.namingserver.entity.pojo.ClusterData;
import org.apache.seata.namingserver.entity.vo.NamespaceVO;
import org.apache.seata.namingserver.entity.vo.v2.ClusterVO;
import org.apache.seata.namingserver.listener.ClusterChangeEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.scheduling.concurrent.CustomizableThreadFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class NamingManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(NamingManager.class);
    private final ConcurrentMap<InetSocketAddress, Long> instanceLiveTable;
    private volatile LoadingCache<String, ConcurrentMap<String, NamespaceBO>> vGroupMap;
    private final ConcurrentMap<String, ConcurrentMap<String, ClusterData>> namespaceClusterDataMap;
    @Value(value="${heartbeat.threshold:90000}")
    private int heartbeatTimeThreshold;
    @Value(value="${heartbeat.period:60000}")
    private int heartbeatCheckTimePeriod;
    protected final ScheduledExecutorService heartBeatCheckService = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new CustomizableThreadFactory("heartBeatCheckExcuter"));
    @Autowired
    private ApplicationContext applicationContext;

    public NamingManager() {
        this.instanceLiveTable = new ConcurrentHashMap();
        this.namespaceClusterDataMap = new ConcurrentHashMap();
    }

    @PostConstruct
    public void init() {
        this.vGroupMap = Caffeine.newBuilder().expireAfterAccess((long)(this.heartbeatTimeThreshold + 1000), TimeUnit.MILLISECONDS).maximumSize(Integer.MAX_VALUE).removalListener((RemovalListener)new /* Unavailable Anonymous Inner Class!! */).build(k -> new ConcurrentHashMap());
        this.heartBeatCheckService.scheduleAtFixedRate(() -> {
            try {
                this.instanceHeartBeatCheck();
            }
            catch (Exception e) {
                LOGGER.error("Heart Beat Check Exception:{}", (Object)e.getMessage(), (Object)e);
            }
        }, this.heartbeatCheckTimePeriod, this.heartbeatCheckTimePeriod, TimeUnit.MILLISECONDS);
    }

    public List<org.apache.seata.namingserver.entity.vo.monitor.ClusterVO> monitorCluster(String namespace) {
        HashMap<String, org.apache.seata.namingserver.entity.vo.monitor.ClusterVO> clusterVOHashMap = new HashMap<String, org.apache.seata.namingserver.entity.vo.monitor.ClusterVO>();
        Map clusterDataMap = (Map)this.namespaceClusterDataMap.get(namespace);
        if (clusterDataMap != null) {
            for (Map.Entry entry : clusterDataMap.entrySet()) {
                String clusterName = (String)entry.getKey();
                ClusterData clusterData = (ClusterData)entry.getValue();
                clusterVOHashMap.put(clusterName, org.apache.seata.namingserver.entity.vo.monitor.ClusterVO.convertFromClusterData((ClusterData)clusterData));
            }
        } else {
            LOGGER.warn("no cluster in namespace:{}", (Object)namespace);
        }
        this.vGroupMap.asMap().forEach((vGroup, namespaceMap) -> {
            NamespaceBO namespaceBO = (NamespaceBO)namespaceMap.get(namespace);
            if (namespaceBO != null) {
                namespaceBO.getClusterMap().forEach((clusterName, clusterBO) -> {
                    org.apache.seata.namingserver.entity.vo.monitor.ClusterVO clusterVO = (org.apache.seata.namingserver.entity.vo.monitor.ClusterVO)clusterVOHashMap.get(clusterName);
                    if (clusterVO != null) {
                        clusterVO.addMapping(vGroup);
                    }
                });
            }
        });
        return new ArrayList<org.apache.seata.namingserver.entity.vo.monitor.ClusterVO>(clusterVOHashMap.values());
    }

    public ClusterData getClusterData(String namespace, String clusterName) {
        Map clusterDataMap = (Map)this.namespaceClusterDataMap.get(namespace);
        if (clusterDataMap != null) {
            return (ClusterData)clusterDataMap.get(clusterName);
        }
        return null;
    }

    public Result<String> createGroup(String namespace, String vGroup, String clusterName, String unitName) {
        return this.createGroup(namespace, vGroup, clusterName, unitName, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Result<String> createGroup(String namespace, String vGroup, String clusterName, String unitName, boolean checkExist) {
        Optional optionalEntry;
        ClusterData clusterData;
        Map clusterDataMap;
        String actualUnitName = unitName;
        if (StringUtils.isBlank((String)unitName) && (clusterDataMap = (Map)this.namespaceClusterDataMap.get(namespace)) != null && (clusterData = (ClusterData)clusterDataMap.get(clusterName)) != null && !CollectionUtils.isEmpty((Map)clusterData.getUnitData()) && (optionalEntry = clusterData.getUnitData().entrySet().stream().findFirst()).isPresent()) {
            actualUnitName = (String)((Map.Entry)optionalEntry.get()).getKey();
        }
        if (StringUtils.isBlank((String)actualUnitName)) {
            LOGGER.error("no available unit for namespace {} and cluster {}", (Object)namespace, (Object)clusterName);
            return new Result("400", "no available unit for cluster: " + clusterName);
        }
        if (checkExist && this.vGroupMap.getIfPresent((Object)vGroup) != null) {
            LOGGER.error("vGroup {} already exists", (Object)vGroup);
            return new Result("400", "vGroup " + vGroup + " already exists");
        }
        List nodeList = this.getInstances(namespace, clusterName);
        if (nodeList == null || nodeList.size() == 0) {
            LOGGER.error("no instance in cluster {}", (Object)clusterName);
            return new Result("301", "no instance in cluster:" + clusterName);
        }
        List filteredNodes = nodeList.stream().filter(n -> n.getRole() == ClusterRole.LEADER || n.getRole() == ClusterRole.MEMBER).sorted((o1, o2) -> Long.compare(o2.getTerm(), o1.getTerm())).collect(Collectors.toList());
        if (filteredNodes.isEmpty()) {
            LOGGER.error("no suitable instance (LEADER or MEMBER) in cluster {}", (Object)clusterName);
            return new Result("301", "no suitable instance in cluster:" + clusterName);
        }
        NamingServerNode node = (NamingServerNode)filteredNodes.get(0);
        String controlHost = node.getControl().getHost();
        int controlPort = node.getControl().getPort();
        String httpUrl = "http://" + controlHost + ":" + controlPort + "/vgroup/v1/addVGroup?";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("vGroup", vGroup);
        params.put("unit", actualUnitName);
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Content-Type", ContentType.APPLICATION_FORM_URLENCODED.getMimeType());
        try (Response httpResponse = HttpClientUtil.doGet((String)httpUrl, params, header, (int)3000);){
            if (httpResponse == null || httpResponse.code() != 200) {
                Result result = new Result(String.valueOf(httpResponse != null ? httpResponse.code() : 500), "add vGroup in new cluster failed");
                return result;
            }
            LOGGER.info("namespace: {} add vGroup: {} in new cluster: {} successfully!", new Object[]{namespace, vGroup, clusterName});
            return new Result("200", "add vGroup successfully!");
        }
        catch (IOException e) {
            LOGGER.error("add vGroup in new cluster failed:{}", (Object)e.getMessage(), (Object)e);
            return new Result("500", "add vGroup in new cluster failed");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Result<String> removeGroup(Unit unit, String vGroup, String clusterName, String namespace, String unitName) {
        if (unit == null) return new Result("200", "remove group in old cluster successfully!");
        if (CollectionUtils.isEmpty((Collection)unit.getNamingInstanceList())) return new Result("200", "remove group in old cluster successfully!");
        Node node = (Node)unit.getNamingInstanceList().get(0);
        String httpUrl = "http://" + node.getControl().getHost() + ":" + node.getControl().getPort() + "/vgroup/v1/removeVGroup?";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("vGroup", vGroup);
        params.put("unit", unitName);
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Content-Type", ContentType.APPLICATION_FORM_URLENCODED.getMimeType());
        try (Response httpResponse = HttpClientUtil.doGet((String)httpUrl, params, header, (int)3000);){
            if (httpResponse == null || httpResponse.code() != 200) {
                LOGGER.warn("remove vGroup in old cluster failed");
                Result result = new Result(String.valueOf(httpResponse != null ? httpResponse.code() : 500), "removing vGroup " + vGroup + " in old cluster " + clusterName + " failed");
                return result;
            }
            LOGGER.info("namespace: {} remove vGroup: {} in new cluster: {} successfully!", new Object[]{namespace, vGroup, clusterName});
            return new Result("200", "remove group in old cluster successfully!");
        }
        catch (IOException e) {
            LOGGER.error("handle removing vGroup in old cluster failed:{}", (Object)e.getMessage(), (Object)e);
            return new Result("500", "handle removing vGroup " + vGroup + " in old cluster " + clusterName + " failed");
        }
    }

    public boolean addGroup(String namespace, String clusterName, String unitName, String vGroup) {
        try {
            ClusterBO clusterBO = ((ConcurrentMap)this.vGroupMap.get((Object)vGroup, k -> new ConcurrentHashMap())).computeIfAbsent(namespace, k -> new NamespaceBO()).getCluster(clusterName);
            if (clusterBO != null) {
                boolean needNotify = !clusterBO.getUnitNames().contains(unitName);
                NamespaceBO namespaceBO = (NamespaceBO)((ConcurrentMap)this.vGroupMap.getIfPresent((Object)vGroup)).get(namespace);
                namespaceBO.removeOldCluster(clusterName);
                if (needNotify) {
                    clusterBO.addUnit(unitName);
                }
                return needNotify;
            }
        }
        catch (Exception e) {
            LOGGER.error("change vGroup mapping failed,vGroup:{},error:{}", new Object[]{vGroup, e.getMessage(), e});
        }
        return false;
    }

    public void notifyClusterChange(String vGroup, String namespace, String clusterName, String unitName, long term) {
        Optional.ofNullable((ConcurrentMap)this.vGroupMap.asMap().get(vGroup)).flatMap(map -> Optional.ofNullable((NamespaceBO)map.get(namespace)).flatMap(namespaceBO -> Optional.ofNullable(namespaceBO.getCluster(clusterName)))).ifPresent(clusterBO -> this.applicationContext.publishEvent((ApplicationEvent)new ClusterChangeEvent((Object)this, vGroup, term)));
    }

    public boolean registerInstances(List<NamingServerNode> node, String namespace, String clusterName) {
        boolean result = true;
        for (NamingServerNode namingServerNode : node) {
            result = this.registerInstance(namingServerNode, namespace, clusterName, namingServerNode.getUnit());
        }
        return result;
    }

    public boolean registerInstance(NamingServerNode node, String namespace, String clusterName, String unitName) {
        if (node == null) {
            return false;
        }
        try {
            Map clusterDataHashMap = this.namespaceClusterDataMap.computeIfAbsent(namespace, k -> new ConcurrentHashMap());
            ClusterData clusterData = clusterDataHashMap.computeIfAbsent(clusterName, key -> new ClusterData(clusterName, (String)node.getMetadata().get("cluster-type")));
            boolean hasChanged = clusterData.registerInstance(node, unitName);
            Object mappingObj = node.getMetadata().get("vGroup");
            if (mappingObj instanceof Map) {
                Map vGroups = (Map)mappingObj;
                vGroups.forEach((k, v) -> {
                    boolean changed = this.addGroup(namespace, clusterName, StringUtils.isBlank((String)v) ? unitName : v, k);
                    if (hasChanged || changed) {
                        this.notifyClusterChange(k, namespace, clusterName, unitName, node.getTerm());
                    }
                });
            }
            this.instanceLiveTable.put(new InetSocketAddress(node.getTransaction().getHost(), node.getTransaction().getPort()), System.currentTimeMillis());
        }
        catch (Exception e) {
            LOGGER.error("Instance registered failed:{}", (Object)e.getMessage(), (Object)e);
            return false;
        }
        return true;
    }

    public boolean unregisterInstance(String namespace, String clusterName, String unitName, NamingServerNode node) {
        try {
            ClusterData clusterData;
            Map clusterMap = (Map)this.namespaceClusterDataMap.get(namespace);
            if (clusterMap != null && (clusterData = (ClusterData)clusterMap.get(clusterName)).getUnitData() != null && clusterData.getUnitData().containsKey(unitName)) {
                clusterData.removeInstance((Node)node, unitName);
                Object vgroupMap = node.getMetadata().get("vGroup");
                if (vgroupMap instanceof Map) {
                    ((Map)vgroupMap).forEach((group, realUnitName) -> {
                        ((NamespaceBO)((ConcurrentMap)this.vGroupMap.get(group, k -> new ConcurrentHashMap())).get(namespace)).getCluster(clusterName).remove(realUnitName == null ? unitName : (String)realUnitName);
                        this.notifyClusterChange(group, namespace, clusterName, unitName, node.getTerm());
                    });
                }
                this.instanceLiveTable.remove(new InetSocketAddress(node.getTransaction().getHost(), node.getTransaction().getPort()));
            }
        }
        catch (Exception e) {
            LOGGER.error("Instance unregistered failed:{}", (Object)e.getMessage(), (Object)e);
            return false;
        }
        return true;
    }

    public List<Cluster> getClusterListByVgroup(String vGroup, String namespace) {
        HashMap concurrentVgroupMap = new HashMap(this.vGroupMap.asMap());
        Map vgroupNamespaceMap = (Map)concurrentVgroupMap.get(vGroup);
        ArrayList<Cluster> clusterList = new ArrayList<Cluster>();
        if (!CollectionUtils.isEmpty((Map)vgroupNamespaceMap)) {
            NamespaceBO namespaceBO = (NamespaceBO)vgroupNamespaceMap.get(namespace);
            ConcurrentMap clusterDataMap = (ConcurrentMap)this.namespaceClusterDataMap.get(namespace);
            if (namespaceBO != null && !CollectionUtils.isEmpty((Map)clusterDataMap)) {
                clusterList.addAll(namespaceBO.getCluster((Map)clusterDataMap));
            }
        }
        return clusterList;
    }

    public List<NamingServerNode> getInstances(String namespace, String clusterName) {
        return this.getInstances(namespace, clusterName, false);
    }

    public List<NamingServerNode> getInstances(String namespace, String clusterName, boolean readOnly) {
        Map clusterDataHashMap = (Map)this.namespaceClusterDataMap.get(namespace);
        if (clusterDataHashMap == null) {
            LOGGER.warn("no clusters in namespace: {}", (Object)namespace);
            return Collections.emptyList();
        }
        ClusterData clusterData = (ClusterData)clusterDataHashMap.get(clusterName);
        if (clusterData == null) {
            LOGGER.warn("no instances in {} : {}", (Object)namespace, (Object)clusterName);
            return Collections.emptyList();
        }
        return readOnly ? clusterData.getInstanceList() : clusterData.getInstanceList().stream().filter(node -> node.getRole() == ClusterRole.LEADER || node.getRole() == ClusterRole.MEMBER).collect(Collectors.toList());
    }

    public List<NamingServerNode> getInstancesByVgroupAndNamespace(String namespace, String vgroup, boolean readOnly) {
        List clusters = this.getClusterListByVgroup(vgroup, namespace);
        if (CollectionUtils.isEmpty((Collection)clusters)) {
            return Collections.emptyList();
        }
        return this.getInstances(namespace, ((Cluster)clusters.get(0)).getClusterName(), readOnly);
    }

    public void instanceHeartBeatCheck() {
        for (String namespace : this.namespaceClusterDataMap.keySet()) {
            for (ClusterData clusterData : ((ConcurrentMap)this.namespaceClusterDataMap.get(namespace)).values()) {
                for (Unit unit : clusterData.getUnitData().values()) {
                    ArrayList<NamingServerNode> removeList = new ArrayList<NamingServerNode>();
                    for (NamingServerNode instance : unit.getNamingInstanceList()) {
                        InetSocketAddress inetSocketAddress = new InetSocketAddress(instance.getTransaction().getHost(), instance.getTransaction().getPort());
                        long lastHeatBeatTimeStamp = this.instanceLiveTable.getOrDefault(inetSocketAddress, 0L);
                        if (Math.abs(lastHeatBeatTimeStamp - System.currentTimeMillis()) <= (long)this.heartbeatTimeThreshold) continue;
                        this.instanceLiveTable.remove(inetSocketAddress);
                        removeList.add(instance);
                    }
                    if (CollectionUtils.isEmpty(removeList)) continue;
                    unit.getNamingInstanceList().removeAll(removeList);
                    for (NamingServerNode instance : removeList) {
                        clusterData.removeInstance((Node)instance, unit.getUnitName());
                        Object vgoupMap = instance.getMetadata().get("vGroup");
                        if (vgoupMap instanceof Map) {
                            ((Map)vgoupMap).forEach((group, unitName) -> {
                                ClusterBO clusterBO = ((ConcurrentMap)this.vGroupMap.get(group)).computeIfAbsent(namespace, k -> new NamespaceBO()).getCluster(clusterData.getClusterName());
                                Set units = clusterBO.getUnitNames();
                                if (units != null) {
                                    units.remove(unitName == null ? instance.getUnit() : unitName);
                                    this.notifyClusterChange(group, namespace, clusterData.getClusterName(), unit.getUnitName(), -1L);
                                }
                            });
                        }
                        LOGGER.warn("{} instance has gone offline", (Object)(instance.getTransaction().getHost() + ":" + instance.getTransaction().getPort()));
                    }
                }
            }
        }
    }

    public Result<String> changeGroup(String namespace, String vGroup, String clusterName, String unitName) {
        long changeTime = System.currentTimeMillis();
        ConcurrentHashMap namespaceMap = new ConcurrentHashMap((Map)this.vGroupMap.get((Object)vGroup));
        Result res = this.createGroup(namespace, vGroup, clusterName, unitName, false);
        if (!res.isSuccess()) {
            LOGGER.error("add vgroup failed! {}", (Object)res.getMessage());
            return res;
        }
        Set currentNamespaces = namespaceMap.keySet();
        HashMap<String, Set> namespaceClusters = new HashMap<String, Set>();
        for (String currentNamespace : currentNamespaces) {
            namespaceClusters.put(currentNamespace, new HashSet(((NamespaceBO)namespaceMap.get(currentNamespace)).getClusterMap().keySet()));
        }
        AtomicReference result = new AtomicReference();
        namespaceClusters.forEach((oldNamespace, clusters) -> {
            for (String cluster : clusters) {
                Optional.ofNullable((ConcurrentMap)this.namespaceClusterDataMap.get(oldNamespace)).flatMap(map -> Optional.ofNullable((ClusterData)map.get(cluster))).ifPresent(clusterData -> {
                    Optional optionalEntry;
                    if (!CollectionUtils.isEmpty((Map)clusterData.getUnitData()) && (optionalEntry = clusterData.getUnitData().entrySet().stream().findFirst()).isPresent()) {
                        String unit = (String)((Map.Entry)optionalEntry.get()).getKey();
                        Unit unitData = (Unit)((Map.Entry)optionalEntry.get()).getValue();
                        result.set(this.removeGroup(unitData, vGroup, cluster, oldNamespace, unitData.getUnitName()));
                        this.notifyClusterChange(vGroup, namespace, cluster, unit, changeTime);
                    }
                });
            }
        });
        return Optional.ofNullable((Result)result.get()).orElseGet(() -> new Result("200", "change vGroup successfully!"));
    }

    public SingleResult<Map<String, NamespaceVO>> namespace() {
        NamespaceData data = this.collectNamespaceData();
        HashMap namespaceVOs = new HashMap();
        if (data.getVgroupsMap().isEmpty()) {
            data.getClustersMap().forEach((namespace, clusters) -> {
                NamespaceVO namespaceVO = new NamespaceVO();
                namespaceVO.setClusters(new ArrayList(clusters));
                namespaceVOs.put(namespace, namespaceVO);
            });
        } else {
            data.getVgroupsMap().forEach((namespace, vgroups) -> {
                NamespaceVO namespaceVO = namespaceVOs.computeIfAbsent(namespace, k -> new NamespaceVO());
                Set clusters = (Set)data.getClustersMap().get(namespace);
                namespaceVO.setClusters(new ArrayList(clusters != null ? clusters : Collections.emptyList()));
                namespaceVO.setVgroups(new ArrayList(vgroups));
            });
        }
        return SingleResult.success(namespaceVOs);
    }

    public SingleResult<Map<String, org.apache.seata.namingserver.entity.vo.v2.NamespaceVO>> namespaceV2() {
        NamespaceData data = this.collectNamespaceData();
        HashMap namespaceVOs = new HashMap();
        data.getClustersMap().forEach((namespace, clusters) -> {
            org.apache.seata.namingserver.entity.vo.v2.NamespaceVO namespaceVO = new org.apache.seata.namingserver.entity.vo.v2.NamespaceVO();
            HashMap clusterVOMap = new HashMap();
            clusters.forEach(cluster -> {
                ClusterData clusterData;
                ClusterVO clusterVO = new ClusterVO();
                Map clusterDataMap = (Map)this.namespaceClusterDataMap.get(namespace);
                String clusterType = "default";
                List<Object> unitNames = new ArrayList();
                if (clusterDataMap != null && (clusterData = (ClusterData)clusterDataMap.get(cluster)) != null) {
                    unitNames = clusterData.getUnitData().values().stream().map(Unit::getUnitName).collect(Collectors.toList());
                    clusterType = clusterData.getClusterType();
                    clusterVO.setType(clusterType);
                }
                clusterVO.setUnits(unitNames);
                Map clusterVgSet = (Map)data.getClusterVgroupsMap().get(namespace);
                Set vgSet = clusterVgSet != null ? (Set)clusterVgSet.get(cluster) : null;
                clusterVO.setVgroups(vgSet != null ? new ArrayList(vgSet) : new ArrayList());
                clusterVOMap.put(cluster, clusterVO);
            });
            namespaceVO.setClusters(clusterVOMap);
            namespaceVOs.put(namespace, namespaceVO);
        });
        return SingleResult.success(namespaceVOs);
    }

    private NamespaceData collectNamespaceData() {
        HashMap clustersMap = new HashMap();
        HashMap vgroupsMap = new HashMap();
        HashMap clusterVgroupsMap = new HashMap();
        HashSet allNamespaces = new HashSet(this.namespaceClusterDataMap.keySet());
        this.vGroupMap.asMap().values().forEach(namespaceMap -> allNamespaces.addAll(namespaceMap.keySet()));
        allNamespaces.forEach(namespace -> {
            clustersMap.computeIfAbsent(namespace, k -> new HashSet());
            vgroupsMap.computeIfAbsent(namespace, k -> new HashSet());
            clusterVgroupsMap.computeIfAbsent(namespace, k -> new HashMap());
        });
        this.namespaceClusterDataMap.forEach((namespace, clusterDataMap) -> {
            Set clusters = (Set)clustersMap.get(namespace);
            clusters.addAll(clusterDataMap.keySet());
        });
        HashMap<String, ConcurrentMap> currentVGroupMap = new HashMap<String, ConcurrentMap>(this.vGroupMap.asMap());
        currentVGroupMap.forEach((vGroup, namespaceMap) -> namespaceMap.forEach((namespace, namespaceBO) -> {
            Set vgroups = (Set)vgroupsMap.get(namespace);
            vgroups.add(vGroup);
            Map clusterVg = (Map)clusterVgroupsMap.get(namespace);
            namespaceBO.getClusterMap().forEach((clusterName, clusterBO) -> {
                Set vgSet = clusterVg.computeIfAbsent(clusterName, k -> new HashSet());
                vgSet.add(vGroup);
            });
        }));
        return new NamespaceData(clustersMap, vgroupsMap, clusterVgroupsMap);
    }
}

