/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.server.instance;

import java.util.Arrays;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import org.apache.seata.common.metadata.Instance;
import org.apache.seata.common.thread.NamedThreadFactory;
import org.apache.seata.core.protocol.Version;
import org.apache.seata.server.instance.SeataInstanceStrategy;
import org.apache.seata.server.session.SessionHolder;
import org.apache.seata.server.store.VGroupMappingStoreManager;
import org.apache.seata.spring.boot.autoconfigure.properties.registry.RegistryNamingServerProperties;
import org.apache.seata.spring.boot.autoconfigure.properties.registry.RegistryProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.context.ApplicationContext;

public abstract class AbstractSeataInstanceStrategy
implements SeataInstanceStrategy {
    @Resource
    protected RegistryProperties registryProperties;
    protected ServerProperties serverProperties;
    @Resource
    protected ApplicationContext applicationContext;
    @Resource
    protected RegistryNamingServerProperties registryNamingServerProperties;
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected static volatile ScheduledExecutorService EXECUTOR_SERVICE;
    protected AtomicBoolean init = new AtomicBoolean(false);

    @PostConstruct
    public void postConstruct() {
        this.serverProperties = (ServerProperties)this.applicationContext.getBean(ServerProperties.class);
    }

    public void init() {
        String types = this.registryProperties.getType();
        if (types == null || !Arrays.asList(types.split(",")).contains("seata")) {
            return;
        }
        Instance instance = this.serverInstanceInit();
        instance.setVersion(Version.getCurrent());
        if (this.init.compareAndSet(false, true)) {
            VGroupMappingStoreManager vGroupMappingStoreManager = SessionHolder.getRootVGroupMappingManager();
            instance.addMetadata("vGroup", (Object)vGroupMappingStoreManager.loadVGroups());
            EXECUTOR_SERVICE = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new NamedThreadFactory("scheduledExcuter", 1, true));
            EXECUTOR_SERVICE.scheduleAtFixedRate(() -> {
                try {
                    if (instance.getTerm() > 0L) {
                        SessionHolder.getRootVGroupMappingManager().notifyMapping();
                    }
                }
                catch (Exception e) {
                    this.logger.error("Naming server register Exception", (Throwable)e);
                }
            }, this.registryNamingServerProperties.getHeartbeatPeriod(), this.registryNamingServerProperties.getHeartbeatPeriod(), TimeUnit.MILLISECONDS);
        }
    }

    @PreDestroy
    public void destroy() {
        Optional.ofNullable(EXECUTOR_SERVICE).ifPresent(ExecutorService::shutdown);
    }
}

