/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.mcp.core.props;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@ConfigurationProperties(prefix="console.namingserver")
@Component
public class NamingServerProperties {
    private String protocol = "http";
    private List<String> addr = Collections.singletonList("127.0.0.1:8081");

    public String getNamingServerUrl() {
        if (this.addr == null || this.addr.isEmpty()) {
            throw new IllegalStateException("No naming servers addr configured");
        }
        int index = ThreadLocalRandom.current().nextInt(this.addr.size());
        return this.protocol + "://" + this.addr.get(index);
    }

    public void setAddr(List<String> addr) {
        this.addr = addr;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }
}

