/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.rest.requests;

import java.util.Map;
import java.util.Objects;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SortOrder;
import org.apache.iceberg.UnboundPartitionSpec;
import org.apache.iceberg.UnboundSortOrder;
import org.apache.iceberg.relocated.com.google.common.base.MoreObjects;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.rest.RESTRequest;

public class CreateTableRequest
implements RESTRequest {
    private String name;
    private String location;
    private Schema schema;
    private UnboundPartitionSpec partitionSpec;
    private UnboundSortOrder writeOrder;
    private Map<String, String> properties;
    private Boolean stageCreate = false;

    public CreateTableRequest() {
    }

    private CreateTableRequest(String name, String location, Schema schema, PartitionSpec partitionSpec, SortOrder writeOrder, Map<String, String> properties, boolean stageCreate) {
        this.name = name;
        this.location = location;
        this.schema = schema;
        this.partitionSpec = partitionSpec != null ? partitionSpec.toUnbound() : null;
        this.writeOrder = writeOrder != null ? writeOrder.toUnbound() : null;
        this.properties = properties;
        this.stageCreate = stageCreate;
        this.validate();
    }

    @Override
    public void validate() {
        Preconditions.checkArgument((this.name != null ? 1 : 0) != 0, (Object)"Invalid table name: null");
        Preconditions.checkArgument((this.schema != null ? 1 : 0) != 0, (Object)"Invalid schema: null");
        Preconditions.checkArgument((this.stageCreate != null ? 1 : 0) != 0, (Object)"Invalid stageCreate flag: null");
    }

    public String name() {
        return this.name;
    }

    public String location() {
        return this.location;
    }

    public Schema schema() {
        return this.schema;
    }

    public PartitionSpec spec() {
        return this.partitionSpec != null ? this.partitionSpec.bind(this.schema) : null;
    }

    public SortOrder writeOrder() {
        return this.writeOrder != null ? this.writeOrder.bind(this.schema) : null;
    }

    public Map<String, String> properties() {
        return this.properties != null ? this.properties : ImmutableMap.of();
    }

    public boolean stageCreate() {
        return this.stageCreate;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("location", (Object)this.location).add("properties", this.properties).add("schema", (Object)this.schema).add("partitionSpec", (Object)this.partitionSpec).add("writeOrder", (Object)this.writeOrder).add("stageCreate", (Object)this.stageCreate).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String name;
        private String location;
        private Schema schema;
        private PartitionSpec partitionSpec;
        private SortOrder writeOrder;
        private final ImmutableMap.Builder<String, String> properties = ImmutableMap.builder();
        private boolean stageCreate = false;

        private Builder() {
        }

        public Builder withName(String tableName) {
            Preconditions.checkNotNull((Object)tableName, (Object)"Invalid name: null");
            this.name = tableName;
            return this;
        }

        public Builder withLocation(String newLocation) {
            this.location = newLocation;
            return this;
        }

        public Builder setProperty(String property, String value) {
            Preconditions.checkArgument((property != null ? 1 : 0) != 0, (Object)"Invalid property: null");
            Preconditions.checkArgument((value != null ? 1 : 0) != 0, (String)"Invalid value for property %s: null", (Object)property);
            this.properties.put((Object)property, (Object)value);
            return this;
        }

        public Builder setProperties(Map<String, String> props) {
            Preconditions.checkNotNull(props, (Object)"Invalid collection of properties: null");
            Preconditions.checkArgument((!props.containsKey(null) ? 1 : 0) != 0, (Object)"Invalid property: null");
            Preconditions.checkArgument((!props.containsValue(null) ? 1 : 0) != 0, (String)"Invalid value for properties %s: null", Maps.filterValues(props, Objects::isNull).keySet());
            this.properties.putAll(props);
            return this;
        }

        public Builder withSchema(Schema tableSchema) {
            Preconditions.checkNotNull((Object)tableSchema, (Object)"Invalid schema: null");
            this.schema = tableSchema;
            return this;
        }

        public Builder withPartitionSpec(PartitionSpec tableSpec) {
            this.partitionSpec = tableSpec;
            return this;
        }

        public Builder withWriteOrder(SortOrder order) {
            this.writeOrder = order;
            return this;
        }

        public Builder stageCreate() {
            this.stageCreate = true;
            return this;
        }

        public CreateTableRequest build() {
            return new CreateTableRequest(this.name, this.location, this.schema, this.partitionSpec, this.writeOrder, (Map<String, String>)this.properties.build(), this.stageCreate);
        }
    }
}

