/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.awssdk.v2_2.internal;

import io.opentelemetry.context.Context;
import io.opentelemetry.context.ImplicitContextKeyed;
import io.opentelemetry.context.Scope;
import io.opentelemetry.context.propagation.TextMapPropagator;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.api.internal.InstrumenterUtil;
import io.opentelemetry.instrumentation.api.internal.Timer;
import io.opentelemetry.instrumentation.awssdk.v2_2.internal.Response;
import io.opentelemetry.instrumentation.awssdk.v2_2.internal.SqsMessageImpl;
import io.opentelemetry.instrumentation.awssdk.v2_2.internal.SqsReceiveRequest;
import io.opentelemetry.instrumentation.awssdk.v2_2.internal.SqsTracingContext;
import io.opentelemetry.instrumentation.awssdk.v2_2.internal.TracingExecutionInterceptor;
import io.opentelemetry.instrumentation.awssdk.v2_2.internal.TracingList;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkResponse;
import software.amazon.awssdk.core.interceptor.Context;
import software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import software.amazon.awssdk.core.interceptor.SdkExecutionAttribute;
import software.amazon.awssdk.http.SdkHttpRequest;
import software.amazon.awssdk.services.sqs.SqsAsyncClient;
import software.amazon.awssdk.services.sqs.SqsClient;
import software.amazon.awssdk.services.sqs.model.Message;
import software.amazon.awssdk.services.sqs.model.MessageAttributeValue;
import software.amazon.awssdk.services.sqs.model.ReceiveMessageRequest;
import software.amazon.awssdk.services.sqs.model.ReceiveMessageResponse;
import software.amazon.awssdk.services.sqs.model.SendMessageBatchRequest;
import software.amazon.awssdk.services.sqs.model.SendMessageBatchRequestEntry;
import software.amazon.awssdk.services.sqs.model.SendMessageRequest;
import software.amazon.awssdk.services.sqs.model.SendMessageResponse;

public final class SqsImpl {
    private static final Field messagesField;

    private SqsImpl() {
    }

    static boolean afterReceiveMessageExecution(Context.AfterExecution context, ExecutionAttributes executionAttributes, TracingExecutionInterceptor config, Timer timer) {
        SdkResponse rawResponse = context.response();
        if (!(rawResponse instanceof ReceiveMessageResponse)) {
            return false;
        }
        ReceiveMessageResponse response = (ReceiveMessageResponse)rawResponse;
        if (response.messages().isEmpty()) {
            return false;
        }
        Context parentContext = TracingExecutionInterceptor.getParentContext(executionAttributes);
        Instrumenter<SqsReceiveRequest, Response> consumerReceiveInstrumenter = config.getConsumerReceiveInstrumenter();
        Context receiveContext = null;
        SqsReceiveRequest receiveRequest = SqsReceiveRequest.create(executionAttributes, SqsMessageImpl.wrap(response.messages()));
        if (timer != null && consumerReceiveInstrumenter.shouldStart(parentContext, (Object)receiveRequest)) {
            receiveContext = InstrumenterUtil.startAndEnd(consumerReceiveInstrumenter, (Context)parentContext, (Object)receiveRequest, (Object)new Response(context.httpResponse(), (SdkResponse)response), null, (Instant)timer.startTime(), (Instant)timer.now());
        }
        ExecutionAttributes copy = new ExecutionAttributes();
        copy.putAttribute(TracingExecutionInterceptor.SDK_HTTP_REQUEST_ATTRIBUTE, (Object)((SdkHttpRequest)executionAttributes.getAttribute(TracingExecutionInterceptor.SDK_HTTP_REQUEST_ATTRIBUTE)));
        copy.putAttribute(TracingExecutionInterceptor.SDK_REQUEST_ATTRIBUTE, (Object)((SdkRequest)executionAttributes.getAttribute(TracingExecutionInterceptor.SDK_REQUEST_ATTRIBUTE)));
        copy.putAttribute(SdkExecutionAttribute.SERVICE_NAME, (Object)((String)executionAttributes.getAttribute(SdkExecutionAttribute.SERVICE_NAME)));
        copy.putAttribute(SdkExecutionAttribute.OPERATION_NAME, (Object)((String)executionAttributes.getAttribute(SdkExecutionAttribute.OPERATION_NAME)));
        TracingList tracingList = TracingList.wrap(response.messages(), config.getConsumerProcessInstrumenter(), copy, new Response(context.httpResponse(), (SdkResponse)response), config, receiveContext);
        SqsTracingContext.set(parentContext, tracingList);
        return true;
    }

    private static Field getMessagesField() {
        try {
            Field field = ReceiveMessageResponse.class.getDeclaredField("messages");
            field.setAccessible(true);
            return field;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void setMessages(ReceiveMessageResponse receiveMessageResponse, List<Message> messages) {
        try {
            messagesField.set(receiveMessageResponse, messages);
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    @Nullable
    static SdkRequest modifyRequest(SdkRequest request, Context otelContext, boolean useXrayPropagator, TextMapPropagator messagingPropagator) {
        if (request instanceof ReceiveMessageRequest) {
            return SqsImpl.modifyReceiveMessageRequest((ReceiveMessageRequest)request, useXrayPropagator, messagingPropagator);
        }
        if (messagingPropagator != null) {
            if (request instanceof SendMessageRequest) {
                return SqsImpl.injectIntoSendMessageRequest((SendMessageRequest)request, otelContext, messagingPropagator);
            }
            if (request instanceof SendMessageBatchRequest) {
                return SqsImpl.injectIntoSendMessageBatchRequest((SendMessageBatchRequest)request, otelContext, messagingPropagator);
            }
        }
        return null;
    }

    private static SdkRequest injectIntoSendMessageBatchRequest(SendMessageBatchRequest request, Context otelContext, TextMapPropagator messagingPropagator) {
        ArrayList<SendMessageBatchRequestEntry> entries = new ArrayList<SendMessageBatchRequestEntry>(request.entries());
        for (int i = 0; i < entries.size(); ++i) {
            SendMessageBatchRequestEntry entry = (SendMessageBatchRequestEntry)entries.get(i);
            HashMap<String, MessageAttributeValue> messageAttributes = new HashMap<String, MessageAttributeValue>(entry.messageAttributes());
            if (!SqsImpl.injectIntoMessageAttributes(messageAttributes, otelContext, messagingPropagator)) continue;
            entries.set(i, (SendMessageBatchRequestEntry)entry.toBuilder().messageAttributes(messageAttributes).build());
        }
        return (SdkRequest)request.toBuilder().entries(entries).build();
    }

    private static SdkRequest injectIntoSendMessageRequest(SendMessageRequest request, Context otelContext, TextMapPropagator messagingPropagator) {
        HashMap<String, MessageAttributeValue> messageAttributes = new HashMap<String, MessageAttributeValue>(request.messageAttributes());
        if (!SqsImpl.injectIntoMessageAttributes(messageAttributes, otelContext, messagingPropagator)) {
            return request;
        }
        return (SdkRequest)request.toBuilder().messageAttributes(messageAttributes).build();
    }

    private static boolean injectIntoMessageAttributes(Map<String, MessageAttributeValue> messageAttributes, Context otelContext, TextMapPropagator messagingPropagator) {
        messagingPropagator.inject(otelContext, messageAttributes, (carrier, k, v) -> carrier.put(k, (MessageAttributeValue)MessageAttributeValue.builder().stringValue(v).dataType("String").build()));
        return messageAttributes.size() <= 10;
    }

    private static SdkRequest modifyReceiveMessageRequest(ReceiveMessageRequest request, boolean useXrayPropagator, TextMapPropagator messagingPropagator) {
        boolean hasXrayAttribute = true;
        List existingAttributeNames = null;
        if (useXrayPropagator) {
            existingAttributeNames = request.attributeNamesAsStrings();
            hasXrayAttribute = existingAttributeNames.contains("AWSTraceHeader");
        }
        boolean hasMessageAttribute = true;
        List existingMessageAttributeNames = null;
        if (messagingPropagator != null) {
            existingMessageAttributeNames = request.messageAttributeNames();
            hasMessageAttribute = existingMessageAttributeNames.containsAll(messagingPropagator.fields());
        }
        if (hasMessageAttribute && hasXrayAttribute) {
            return request;
        }
        ReceiveMessageRequest.Builder builder = request.toBuilder();
        if (!hasXrayAttribute) {
            ArrayList<String> attributeNames = new ArrayList<String>(existingAttributeNames);
            attributeNames.add("AWSTraceHeader");
            builder.attributeNamesWithStrings(attributeNames);
        }
        if (messagingPropagator != null) {
            ArrayList<String> messageAttributeNames = new ArrayList<String>(existingMessageAttributeNames);
            for (String field : messagingPropagator.fields()) {
                if (existingMessageAttributeNames.contains(field)) continue;
                messageAttributeNames.add(field);
            }
            builder.messageAttributeNames(messageAttributeNames);
        }
        return (SdkRequest)builder.build();
    }

    static boolean isSqsProducerRequest(SdkRequest request) {
        return request instanceof SendMessageRequest || request instanceof SendMessageBatchRequest;
    }

    static String getQueueUrl(SdkRequest request) {
        if (request instanceof SendMessageRequest) {
            return ((SendMessageRequest)request).queueUrl();
        }
        if (request instanceof SendMessageBatchRequest) {
            return ((SendMessageBatchRequest)request).queueUrl();
        }
        if (request instanceof ReceiveMessageRequest) {
            return ((ReceiveMessageRequest)request).queueUrl();
        }
        return null;
    }

    static String getMessageAttribute(SdkRequest request, String name) {
        if (request instanceof SendMessageRequest) {
            MessageAttributeValue value = (MessageAttributeValue)((SendMessageRequest)request).messageAttributes().get(name);
            return value != null ? value.stringValue() : null;
        }
        return null;
    }

    static String getMessageId(SdkResponse response) {
        if (response instanceof SendMessageResponse) {
            return ((SendMessageResponse)response).messageId();
        }
        return null;
    }

    public static SqsClient wrap(SqsClient sqsClient) {
        return (SqsClient)Proxy.newProxyInstance(sqsClient.getClass().getClassLoader(), new Class[]{SqsClient.class}, (proxy, method, args) -> {
            if ("receiveMessage".equals(method.getName())) {
                SqsTracingContext sqsTracingContext = new SqsTracingContext();
                try (Scope ignored = Context.current().with((ImplicitContextKeyed)sqsTracingContext).makeCurrent();){
                    Object result = SqsImpl.invokeProxyMethod(method, sqsClient, args);
                    TracingList tracingList = sqsTracingContext.get();
                    if (tracingList != null) {
                        ReceiveMessageResponse response = (ReceiveMessageResponse)result;
                        SqsImpl.setMessages(response, tracingList);
                        ReceiveMessageResponse receiveMessageResponse = response;
                        return receiveMessageResponse;
                    }
                    Object object = result;
                    return object;
                }
            }
            return SqsImpl.invokeProxyMethod(method, sqsClient, args);
        });
    }

    public static SqsAsyncClient wrap(SqsAsyncClient sqsClient) {
        return (SqsAsyncClient)Proxy.newProxyInstance(sqsClient.getClass().getClassLoader(), new Class[]{SqsAsyncClient.class}, (proxy, method, args) -> {
            if ("receiveMessage".equals(method.getName())) {
                CompletableFuture completableFuture;
                block9: {
                    SqsTracingContext sqsTracingContext = new SqsTracingContext();
                    Scope ignored = Context.current().with((ImplicitContextKeyed)sqsTracingContext).makeCurrent();
                    try {
                        Object result = SqsImpl.invokeProxyMethod(method, sqsClient, args);
                        CompletableFuture originalFuture = (CompletableFuture)result;
                        CompletableFuture resultFuture = new CompletableFuture();
                        originalFuture.whenComplete((response, throwable) -> {
                            if (throwable != null) {
                                resultFuture.completeExceptionally((Throwable)throwable);
                            } else {
                                TracingList tracingList = sqsTracingContext.get();
                                if (tracingList != null) {
                                    SqsImpl.setMessages(response, tracingList);
                                }
                                resultFuture.complete(response);
                            }
                        });
                        completableFuture = resultFuture;
                        if (ignored == null) break block9;
                    }
                    catch (Throwable throwable2) {
                        try {
                            if (ignored != null) {
                                try {
                                    ignored.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable2.addSuppressed(throwable3);
                                }
                            }
                            throw throwable2;
                        }
                        catch (InvocationTargetException exception) {
                            throw exception.getCause();
                        }
                    }
                    ignored.close();
                }
                return completableFuture;
            }
            return SqsImpl.invokeProxyMethod(method, sqsClient, args);
        });
    }

    private static Object invokeProxyMethod(Method method, Object target, Object[] args) throws Throwable {
        try {
            return method.invoke(target, args);
        }
        catch (InvocationTargetException exception) {
            throw exception.getCause();
        }
    }

    static {
        String string = SqsClient.class.getName();
        messagesField = SqsImpl.getMessagesField();
    }
}

