/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.azure.adlsv2;

import com.azure.storage.file.datalake.DataLakeFileClient;
import com.azure.storage.file.datalake.models.DataLakeFileOpenInputStreamResult;
import com.azure.storage.file.datalake.models.FileRange;
import com.azure.storage.file.datalake.options.DataLakeFileInputStreamOptions;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.apache.iceberg.azure.AzureProperties;
import org.apache.iceberg.io.IOUtil;
import org.apache.iceberg.io.RangeReadable;
import org.apache.iceberg.io.SeekableInputStream;
import org.apache.iceberg.metrics.Counter;
import org.apache.iceberg.metrics.MetricsContext;
import org.apache.iceberg.relocated.com.google.common.base.Joiner;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.io.ByteStreams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ADLSInputStream
extends SeekableInputStream
implements RangeReadable {
    private static final Logger LOG = LoggerFactory.getLogger(ADLSInputStream.class);
    private static final int SKIP_SIZE = 0x100000;
    private final StackTraceElement[] createStack;
    private final DataLakeFileClient fileClient;
    private Long fileSize;
    private final AzureProperties azureProperties;
    private InputStream stream;
    private long pos;
    private long next;
    private boolean closed;
    private final Counter readBytes;
    private final Counter readOperations;

    ADLSInputStream(DataLakeFileClient fileClient, Long fileSize, AzureProperties azureProperties, MetricsContext metrics) {
        this.fileClient = fileClient;
        this.fileSize = fileSize;
        this.azureProperties = azureProperties;
        this.readBytes = metrics.counter("read.bytes", MetricsContext.Unit.BYTES);
        this.readOperations = metrics.counter("read.operations");
        this.createStack = Thread.currentThread().getStackTrace();
        this.openStream();
    }

    private void openStream() {
        DataLakeFileOpenInputStreamResult result = this.openRange(new FileRange(this.pos));
        this.fileSize = result.getProperties().getFileSize();
        this.stream = result.getInputStream();
    }

    private DataLakeFileInputStreamOptions getInputOptions(FileRange range) {
        DataLakeFileInputStreamOptions options = new DataLakeFileInputStreamOptions();
        this.azureProperties.adlsReadBlockSize().ifPresent(arg_0 -> ((DataLakeFileInputStreamOptions)options).setBlockSize(arg_0));
        options.setRange(range);
        return options;
    }

    public long getPos() {
        return this.next;
    }

    public void seek(long newPos) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Cannot seek: already closed");
        Preconditions.checkArgument((newPos >= 0L ? 1 : 0) != 0, (String)"Cannot seek: position %s is negative", (long)newPos);
        this.next = newPos;
    }

    public int read() throws IOException {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Cannot read: already closed");
        this.positionStream();
        ++this.pos;
        ++this.next;
        this.readBytes.increment();
        this.readOperations.increment();
        return this.stream.read();
    }

    public int read(byte[] b, int off, int len) throws IOException {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Cannot read: already closed");
        this.positionStream();
        int bytesRead = this.stream.read(b, off, len);
        this.pos += (long)bytesRead;
        this.next += (long)bytesRead;
        this.readBytes.increment(bytesRead);
        this.readOperations.increment();
        return bytesRead;
    }

    private void positionStream() throws IOException {
        long skip;
        if (this.stream != null && this.next == this.pos) {
            return;
        }
        if (this.stream != null && this.next > this.pos && (skip = this.next - this.pos) <= (long)Math.max(this.stream.available(), 0x100000)) {
            try {
                ByteStreams.skipFully((InputStream)this.stream, (long)skip);
                this.pos = this.next;
                return;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.pos = this.next;
        this.openStream();
    }

    public void readFully(long position, byte[] buffer, int offset, int length) throws IOException {
        Preconditions.checkPositionIndexes((int)offset, (int)(offset + length), (int)buffer.length);
        FileRange range = new FileRange(position, Long.valueOf(position + (long)length));
        try (InputStream inputStream = this.openRange(range).getInputStream();){
            IOUtil.readFully((InputStream)inputStream, (byte[])buffer, (int)offset, (int)length);
        }
    }

    public int readTail(byte[] buffer, int offset, int length) throws IOException {
        Preconditions.checkPositionIndexes((int)offset, (int)(offset + length), (int)buffer.length);
        if (this.fileSize == null) {
            this.fileSize = this.fileClient.getProperties().getFileSize();
        }
        long readStart = this.fileSize - (long)length;
        try (InputStream inputStream = this.openRange(new FileRange(readStart)).getInputStream();){
            int n = IOUtil.readRemaining((InputStream)inputStream, (byte[])buffer, (int)offset, (int)length);
            return n;
        }
    }

    private DataLakeFileOpenInputStreamResult openRange(FileRange range) {
        try {
            return this.fileClient.openInputStream(this.getInputOptions(range));
        }
        catch (RuntimeException e) {
            LOG.error("Failed to open input stream for file {}, range {}", new Object[]{this.fileClient.getFilePath(), range, e});
            throw e;
        }
    }

    public void close() throws IOException {
        super.close();
        this.closed = true;
        if (this.stream != null) {
            this.stream.close();
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (!this.closed) {
            this.close();
            String trace = Joiner.on((String)"\n\t").join((Object[])Arrays.copyOfRange(this.createStack, 1, this.createStack.length));
            LOG.warn("Unclosed input stream created by:\n\t{}", (Object)trace);
        }
    }
}

