/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.persistence.bootstrap;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import org.apache.polaris.core.persistence.bootstrap.BootstrapOptions;
import org.apache.polaris.core.persistence.bootstrap.RootCredentialsSet;
import org.apache.polaris.core.persistence.bootstrap.SchemaOptions;
import org.immutables.value.Generated;

@Generated(from="BootstrapOptions", generator="Immutables")
public final class ImmutableBootstrapOptions
implements BootstrapOptions {
    private final Iterable<String> realms;
    private final RootCredentialsSet rootCredentialsSet;
    private final SchemaOptions schemaOptions;
    private transient int hashCode;

    private ImmutableBootstrapOptions(Iterable<String> realms, RootCredentialsSet rootCredentialsSet, SchemaOptions schemaOptions) {
        this.realms = realms;
        this.rootCredentialsSet = rootCredentialsSet;
        this.schemaOptions = schemaOptions;
    }

    @Override
    public Iterable<String> realms() {
        return this.realms;
    }

    @Override
    public RootCredentialsSet rootCredentialsSet() {
        return this.rootCredentialsSet;
    }

    @Override
    public SchemaOptions schemaOptions() {
        return this.schemaOptions;
    }

    public final ImmutableBootstrapOptions withRealms(Iterable<String> value) {
        if (this.realms == value) {
            return this;
        }
        Iterable<String> newValue = Objects.requireNonNull(value, "realms");
        return new ImmutableBootstrapOptions(newValue, this.rootCredentialsSet, this.schemaOptions);
    }

    public final ImmutableBootstrapOptions withRootCredentialsSet(RootCredentialsSet value) {
        if (this.rootCredentialsSet == value) {
            return this;
        }
        RootCredentialsSet newValue = Objects.requireNonNull(value, "rootCredentialsSet");
        return new ImmutableBootstrapOptions(this.realms, newValue, this.schemaOptions);
    }

    public final ImmutableBootstrapOptions withSchemaOptions(SchemaOptions value) {
        if (this.schemaOptions == value) {
            return this;
        }
        SchemaOptions newValue = Objects.requireNonNull(value, "schemaOptions");
        return new ImmutableBootstrapOptions(this.realms, this.rootCredentialsSet, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBootstrapOptions && this.equalsByValue((ImmutableBootstrapOptions)another);
    }

    private boolean equalsByValue(ImmutableBootstrapOptions another) {
        if (this.hashCode != 0 && another.hashCode != 0 && this.hashCode != another.hashCode) {
            return false;
        }
        return this.realms.equals(another.realms) && this.rootCredentialsSet.equals(another.rootCredentialsSet) && this.schemaOptions.equals(another.schemaOptions);
    }

    public int hashCode() {
        int h = this.hashCode;
        if (h == 0) {
            this.hashCode = h = this.computeHashCode();
        }
        return h;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + this.realms.hashCode();
        h += (h << 5) + this.rootCredentialsSet.hashCode();
        h += (h << 5) + this.schemaOptions.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"BootstrapOptions").omitNullValues().add("realms", this.realms).add("rootCredentialsSet", (Object)this.rootCredentialsSet).add("schemaOptions", (Object)this.schemaOptions).toString();
    }

    public static ImmutableBootstrapOptions copyOf(BootstrapOptions instance) {
        if (instance instanceof ImmutableBootstrapOptions) {
            return (ImmutableBootstrapOptions)instance;
        }
        return ImmutableBootstrapOptions.builder().from(instance).build();
    }

    public Builder toBuilder() {
        return ImmutableBootstrapOptions.builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="BootstrapOptions", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_REALMS = 1L;
        private static final long INIT_BIT_ROOT_CREDENTIALS_SET = 2L;
        private static final long INIT_BIT_SCHEMA_OPTIONS = 4L;
        private long initBits = 7L;
        private Iterable<String> realms;
        private RootCredentialsSet rootCredentialsSet;
        private SchemaOptions schemaOptions;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(BootstrapOptions instance) {
            Objects.requireNonNull(instance, "instance");
            this.realms(instance.realms());
            this.rootCredentialsSet(instance.rootCredentialsSet());
            this.schemaOptions(instance.schemaOptions());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder realms(Iterable<String> realms) {
            this.realms = Objects.requireNonNull(realms, "realms");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder rootCredentialsSet(RootCredentialsSet rootCredentialsSet) {
            this.rootCredentialsSet = Objects.requireNonNull(rootCredentialsSet, "rootCredentialsSet");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder schemaOptions(SchemaOptions schemaOptions) {
            this.schemaOptions = Objects.requireNonNull(schemaOptions, "schemaOptions");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder clear() {
            this.initBits = 7L;
            this.realms = null;
            this.rootCredentialsSet = null;
            this.schemaOptions = null;
            return this;
        }

        public ImmutableBootstrapOptions build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableBootstrapOptions(this.realms, this.rootCredentialsSet, this.schemaOptions);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("realms");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("rootCredentialsSet");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("schemaOptions");
            }
            return "Cannot build BootstrapOptions, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

