/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudwatchlogs.model.CloudWatchLogsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetDeliveryDestinationPolicyRequest
extends CloudWatchLogsRequest
implements ToCopyableBuilder<Builder, GetDeliveryDestinationPolicyRequest> {
    private static final SdkField<String> DELIVERY_DESTINATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("deliveryDestinationName").getter(GetDeliveryDestinationPolicyRequest.getter(GetDeliveryDestinationPolicyRequest::deliveryDestinationName)).setter(GetDeliveryDestinationPolicyRequest.setter(Builder::deliveryDestinationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deliveryDestinationName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DELIVERY_DESTINATION_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetDeliveryDestinationPolicyRequest.memberNameToFieldInitializer();
    private final String deliveryDestinationName;

    private GetDeliveryDestinationPolicyRequest(BuilderImpl builder) {
        super(builder);
        this.deliveryDestinationName = builder.deliveryDestinationName;
    }

    public final String deliveryDestinationName() {
        return this.deliveryDestinationName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.deliveryDestinationName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDeliveryDestinationPolicyRequest)) {
            return false;
        }
        GetDeliveryDestinationPolicyRequest other = (GetDeliveryDestinationPolicyRequest)((Object)obj);
        return Objects.equals(this.deliveryDestinationName(), other.deliveryDestinationName());
    }

    public final String toString() {
        return ToString.builder((String)"GetDeliveryDestinationPolicyRequest").add("DeliveryDestinationName", (Object)this.deliveryDestinationName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "deliveryDestinationName": {
                return Optional.ofNullable(clazz.cast(this.deliveryDestinationName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("deliveryDestinationName", DELIVERY_DESTINATION_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetDeliveryDestinationPolicyRequest, T> g) {
        return obj -> g.apply((GetDeliveryDestinationPolicyRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudWatchLogsRequest.BuilderImpl
    implements Builder {
        private String deliveryDestinationName;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDeliveryDestinationPolicyRequest model) {
            super(model);
            this.deliveryDestinationName(model.deliveryDestinationName);
        }

        public final String getDeliveryDestinationName() {
            return this.deliveryDestinationName;
        }

        public final void setDeliveryDestinationName(String deliveryDestinationName) {
            this.deliveryDestinationName = deliveryDestinationName;
        }

        @Override
        public final Builder deliveryDestinationName(String deliveryDestinationName) {
            this.deliveryDestinationName = deliveryDestinationName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetDeliveryDestinationPolicyRequest build() {
            return new GetDeliveryDestinationPolicyRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CloudWatchLogsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetDeliveryDestinationPolicyRequest> {
        public Builder deliveryDestinationName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

