/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.internal;

import java.net.URI;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneOffset;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsExecutionAttribute;
import software.amazon.awssdk.awscore.endpoint.AwsClientEndpointProvider;
import software.amazon.awssdk.core.ClientEndpointProvider;
import software.amazon.awssdk.core.Protocol;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SelectedAuthScheme;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.interceptor.Context;
import software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import software.amazon.awssdk.core.interceptor.ExecutionInterceptor;
import software.amazon.awssdk.core.interceptor.SdkExecutionAttribute;
import software.amazon.awssdk.core.interceptor.SdkInternalExecutionAttribute;
import software.amazon.awssdk.http.ContentStreamProvider;
import software.amazon.awssdk.http.SdkHttpFullRequest;
import software.amazon.awssdk.http.SdkHttpMethod;
import software.amazon.awssdk.http.SdkHttpRequest;
import software.amazon.awssdk.http.auth.aws.signer.AwsV4FamilyHttpSigner;
import software.amazon.awssdk.http.auth.aws.signer.AwsV4HttpSigner;
import software.amazon.awssdk.http.auth.spi.scheme.AuthSchemeOption;
import software.amazon.awssdk.http.auth.spi.signer.HttpSigner;
import software.amazon.awssdk.http.auth.spi.signer.SignRequest;
import software.amazon.awssdk.http.auth.spi.signer.SignedRequest;
import software.amazon.awssdk.identity.spi.Identity;
import software.amazon.awssdk.protocols.query.AwsQueryProtocolFactory;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.rds.model.RdsRequest;
import software.amazon.awssdk.utils.CompletableFutureUtils;

@SdkInternalApi
public abstract class RdsPresignInterceptor<T extends RdsRequest>
implements ExecutionInterceptor {
    private static final ClientEndpointProvider CUSTOM_ENDPOINT_PROVIDER_LOCALHOST = ClientEndpointProvider.forEndpointOverride((URI)URI.create("http://localhost"));
    protected static final AwsQueryProtocolFactory PROTOCOL_FACTORY = AwsQueryProtocolFactory.builder().clientConfiguration(SdkClientConfiguration.builder().option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER, (Object)CUSTOM_ENDPOINT_PROVIDER_LOCALHOST).build()).build();
    private static final String SERVICE_NAME = "rds";
    private static final String PARAM_SOURCE_REGION = "SourceRegion";
    private static final String PARAM_DESTINATION_REGION = "DestinationRegion";
    private static final String PARAM_PRESIGNED_URL = "PreSignedUrl";
    private final Class<T> requestClassToPreSign;
    private final Clock signingClockOverride;

    protected RdsPresignInterceptor(Class<T> requestClassToPreSign) {
        this(requestClassToPreSign, null);
    }

    protected RdsPresignInterceptor(Class<T> requestClassToPreSign, Clock signingClockOverride) {
        this.requestClassToPreSign = requestClassToPreSign;
        this.signingClockOverride = signingClockOverride;
    }

    public final SdkHttpRequest modifyHttpRequest(Context.ModifyHttpRequest context, ExecutionAttributes executionAttributes) {
        SdkHttpRequest request = context.httpRequest();
        PresignableRequest presignableRequest = this.toPresignableRequest(request, context);
        if (presignableRequest == null) {
            return (SdkHttpRequest)((SdkHttpRequest.Builder)request.toBuilder()).removeQueryParameter(PARAM_SOURCE_REGION).build();
        }
        SelectedAuthScheme selectedAuthScheme = (SelectedAuthScheme)executionAttributes.getAttribute(SdkInternalExecutionAttribute.SELECTED_AUTH_SCHEME);
        String sourceRegion = presignableRequest.getSourceRegion();
        String destinationRegion = (String)selectedAuthScheme.authSchemeOption().signerProperty(AwsV4HttpSigner.REGION_NAME);
        URI endpoint = this.createEndpoint(sourceRegion, SERVICE_NAME, executionAttributes);
        SdkHttpFullRequest.Builder marshalledRequest = presignableRequest.marshall().toBuilder().uri(endpoint);
        SdkHttpFullRequest requestToPresign = marshalledRequest.method(SdkHttpMethod.GET).putRawQueryParameter(PARAM_DESTINATION_REGION, destinationRegion).removeQueryParameter(PARAM_SOURCE_REGION).build();
        requestToPresign = this.sraPresignRequest(executionAttributes, requestToPresign, sourceRegion);
        String presignedUrl = requestToPresign.getUri().toString();
        return (SdkHttpRequest)((SdkHttpRequest.Builder)request.toBuilder()).putRawQueryParameter(PARAM_PRESIGNED_URL, presignedUrl).removeQueryParameter(PARAM_SOURCE_REGION).build();
    }

    protected abstract PresignableRequest adaptRequest(T var1);

    private PresignableRequest toPresignableRequest(SdkHttpRequest request, Context.ModifyHttpRequest context) {
        SdkRequest originalRequest = context.request();
        if (!this.requestClassToPreSign.isInstance(originalRequest)) {
            return null;
        }
        if (request.firstMatchingRawQueryParameter(PARAM_PRESIGNED_URL).isPresent()) {
            return null;
        }
        PresignableRequest presignableRequest = this.adaptRequest((RdsRequest)((Object)this.requestClassToPreSign.cast(originalRequest)));
        String sourceRegion = presignableRequest.getSourceRegion();
        if (sourceRegion == null) {
            return null;
        }
        return presignableRequest;
    }

    private SdkHttpFullRequest sraPresignRequest(ExecutionAttributes executionAttributes, SdkHttpFullRequest request, String signingRegion) {
        SelectedAuthScheme selectedAuthScheme = (SelectedAuthScheme)executionAttributes.getAttribute(SdkInternalExecutionAttribute.SELECTED_AUTH_SCHEME);
        Instant signingInstant = this.signingClockOverride != null ? this.signingClockOverride.instant() : Instant.now();
        Clock signingClock = Clock.fixed(signingInstant, ZoneOffset.UTC);
        Duration expirationDuration = Duration.ofDays(7L);
        return this.doSraPresign(request, selectedAuthScheme, signingRegion, signingClock, expirationDuration);
    }

    private <T extends Identity> SdkHttpFullRequest doSraPresign(SdkHttpFullRequest request, SelectedAuthScheme<T> selectedAuthScheme, String signingRegion, Clock signingClock, Duration expirationDuration) {
        CompletableFuture identityFuture = selectedAuthScheme.identity();
        Identity identity = (Identity)CompletableFutureUtils.joinLikeSync((CompletableFuture)identityFuture);
        SignRequest.Builder signRequestBuilder = (SignRequest.Builder)((SignRequest.Builder)((SignRequest.Builder)((SignRequest.Builder)((SignRequest.Builder)SignRequest.builder((Identity)identity).putProperty(AwsV4FamilyHttpSigner.AUTH_LOCATION, (Object)AwsV4FamilyHttpSigner.AuthLocation.QUERY_STRING)).putProperty(AwsV4FamilyHttpSigner.EXPIRATION_DURATION, (Object)expirationDuration)).putProperty(HttpSigner.SIGNING_CLOCK, (Object)signingClock)).request((SdkHttpRequest)request)).payload((Object)request.contentStreamProvider().orElse(null));
        AuthSchemeOption authSchemeOption = selectedAuthScheme.authSchemeOption();
        authSchemeOption.forEachSignerProperty((arg_0, arg_1) -> ((SignRequest.Builder)signRequestBuilder).putProperty(arg_0, arg_1));
        signRequestBuilder.putProperty(AwsV4HttpSigner.REGION_NAME, (Object)signingRegion);
        HttpSigner signer = selectedAuthScheme.signer();
        SignedRequest signedRequest = signer.sign((SignRequest)signRequestBuilder.build());
        return this.toSdkHttpFullRequest(signedRequest);
    }

    private SdkHttpFullRequest toSdkHttpFullRequest(SignedRequest signedRequest) {
        SdkHttpRequest request = signedRequest.request();
        return SdkHttpFullRequest.builder().contentStreamProvider((ContentStreamProvider)signedRequest.payload().orElse(null)).protocol(request.protocol()).method(request.method()).host(request.host()).port(Integer.valueOf(request.port())).encodedPath(request.encodedPath()).applyMutation(r -> request.forEachHeader((arg_0, arg_1) -> ((SdkHttpRequest.Builder)r).putHeader(arg_0, arg_1))).applyMutation(r -> request.forEachRawQueryParameter((arg_0, arg_1) -> ((SdkHttpRequest.Builder)r).putRawQueryParameter(arg_0, arg_1))).removeQueryParameter(PARAM_SOURCE_REGION).build();
    }

    private URI createEndpoint(String regionName, String serviceName, ExecutionAttributes attributes) {
        return AwsClientEndpointProvider.builder().serviceEndpointPrefix(SERVICE_NAME).defaultProtocol(Protocol.HTTPS.toString()).region(Region.of((String)regionName)).profileFile((Supplier)attributes.getAttribute(SdkExecutionAttribute.PROFILE_FILE_SUPPLIER)).profileName((String)attributes.getAttribute(SdkExecutionAttribute.PROFILE_NAME)).dualstackEnabled((Boolean)attributes.getAttribute(AwsExecutionAttribute.DUALSTACK_ENDPOINT_ENABLED)).fipsEnabled((Boolean)attributes.getAttribute(AwsExecutionAttribute.FIPS_ENDPOINT_ENABLED)).build().clientEndpoint();
    }

    public static interface PresignableRequest {
        public String getSourceRegion();

        public SdkHttpFullRequest marshall();
    }
}

