/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.core.SettableApiFuture;
import com.google.api.gax.rpc.BidiStreamingCallable;
import com.google.cloud.storage.BidiAppendableUnbufferedWritableByteChannel;
import com.google.cloud.storage.BidiBlobWriteSessionConfig;
import com.google.cloud.storage.BidiUploadState;
import com.google.cloud.storage.BidiUploadStreamingStream;
import com.google.cloud.storage.BlobAppendableUpload;
import com.google.cloud.storage.BlobAppendableUploadImpl;
import com.google.cloud.storage.BlobInfo;
import com.google.cloud.storage.ByteStringStrategy;
import com.google.cloud.storage.ChannelSession;
import com.google.cloud.storage.ChunkSegmenter;
import com.google.cloud.storage.DefaultBlobWriteSessionConfig;
import com.google.cloud.storage.FlushPolicy;
import com.google.cloud.storage.GrpcStorageImpl;
import com.google.cloud.storage.Hasher;
import com.google.cloud.storage.TransportCompatibility;
import com.google.cloud.storage.UnifiedOpts;
import com.google.cloud.storage.WritableByteChannelSession;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.storage.v2.BidiWriteObjectRequest;
import com.google.storage.v2.BidiWriteObjectResponse;
import java.util.Objects;
import java.util.function.BiFunction;
import javax.annotation.concurrent.Immutable;

@BetaApi
@TransportCompatibility(value={TransportCompatibility.Transport.GRPC})
@Immutable
public final class BlobAppendableUploadConfig {
    private static final BlobAppendableUploadConfig INSTANCE = new BlobAppendableUploadConfig(FlushPolicy.minFlushSize(), CloseAction.CLOSE_WITHOUT_FINALIZING, 3);
    private final FlushPolicy flushPolicy;
    private final CloseAction closeAction;
    private final int maxRedirectsAllowed;

    private BlobAppendableUploadConfig(FlushPolicy flushPolicy, CloseAction closeAction, int maxRedirectsAllowed) {
        this.flushPolicy = flushPolicy;
        this.closeAction = closeAction;
        this.maxRedirectsAllowed = maxRedirectsAllowed;
    }

    @BetaApi
    public FlushPolicy getFlushPolicy() {
        return this.flushPolicy;
    }

    @BetaApi
    public BlobAppendableUploadConfig withFlushPolicy(FlushPolicy flushPolicy) {
        Objects.requireNonNull(flushPolicy, "flushPolicy must be non null");
        if (this.flushPolicy.equals(flushPolicy)) {
            return this;
        }
        return new BlobAppendableUploadConfig(flushPolicy, this.closeAction, this.maxRedirectsAllowed);
    }

    @BetaApi
    public CloseAction getCloseAction() {
        return this.closeAction;
    }

    @BetaApi
    public BlobAppendableUploadConfig withCloseAction(CloseAction closeAction) {
        Objects.requireNonNull(closeAction, "closeAction must be non null");
        if (this.closeAction == closeAction) {
            return this;
        }
        return new BlobAppendableUploadConfig(this.flushPolicy, closeAction, this.maxRedirectsAllowed);
    }

    @BetaApi
    int getMaxRedirectsAllowed() {
        return this.maxRedirectsAllowed;
    }

    @BetaApi
    BlobAppendableUploadConfig withMaxRedirectsAllowed(int maxRedirectsAllowed) {
        Preconditions.checkArgument((maxRedirectsAllowed >= 0 ? 1 : 0) != 0, (String)"maxRedirectsAllowed >= 0 (%s >= 0)", (int)maxRedirectsAllowed);
        if (this.maxRedirectsAllowed == maxRedirectsAllowed) {
            return this;
        }
        return new BlobAppendableUploadConfig(this.flushPolicy, this.closeAction, maxRedirectsAllowed);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BlobAppendableUploadConfig)) {
            return false;
        }
        BlobAppendableUploadConfig that = (BlobAppendableUploadConfig)o;
        return this.maxRedirectsAllowed == that.maxRedirectsAllowed && Objects.equals(this.flushPolicy, that.flushPolicy) && this.closeAction == that.closeAction;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.flushPolicy, this.closeAction, this.maxRedirectsAllowed});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("flushPolicy", (Object)this.flushPolicy).add("closeAction", (Object)this.closeAction).add("maxRedirectsAllowed", this.maxRedirectsAllowed).toString();
    }

    @BetaApi
    public static BlobAppendableUploadConfig of() {
        return INSTANCE;
    }

    BlobAppendableUpload create(GrpcStorageImpl storage, BlobInfo info, UnifiedOpts.Opts<UnifiedOpts.ObjectTargetOpt> opts) {
        long maxPendingBytes = this.getFlushPolicy().getMaxPendingBytes();
        BidiUploadState.AppendableUploadState state = storage.getAppendableState(info, opts, maxPendingBytes);
        AppendableSession build = new AppendableSession(ApiFutures.immediateFuture((Object)state), (start, resultFuture) -> {
            BidiAppendableUnbufferedWritableByteChannel c;
            BidiUploadStreamingStream stream = new BidiUploadStreamingStream((BidiUploadState)start, storage.storageDataClient.executor, (BidiStreamingCallable<BidiWriteObjectRequest, BidiWriteObjectResponse>)storage.storageClient.bidiWriteObjectCallable(), this.maxRedirectsAllowed, storage.storageDataClient.retryContextProvider.create());
            ChunkSegmenter chunkSegmenter = new ChunkSegmenter(Hasher.enabled(), ByteStringStrategy.copy(), Math.min(0x200000, Math.toIntExact(maxPendingBytes)), 1);
            if (state instanceof BidiUploadState.TakeoverAppendableUploadState) {
                stream.awaitTakeoverStateReconciliation();
                c = new BidiAppendableUnbufferedWritableByteChannel(stream, chunkSegmenter, BlobAppendableUploadConfig.flushInterval(this.flushPolicy), state.getConfirmedBytes());
            } else {
                c = new BidiAppendableUnbufferedWritableByteChannel(stream, chunkSegmenter, BlobAppendableUploadConfig.flushInterval(this.flushPolicy), 0L);
            }
            return new BlobAppendableUploadImpl.AppendableObjectBufferedWritableByteChannel(this.flushPolicy.createBufferedChannel(c, false), c, this.closeAction == CloseAction.FINALIZE_WHEN_CLOSING);
        }, state.getResultFuture());
        return new BlobAppendableUploadImpl(new DefaultBlobWriteSessionConfig.DecoratedWritableByteChannelSession<BlobAppendableUploadImpl.AppendableObjectBufferedWritableByteChannel, BidiWriteObjectResponse>(build, BidiBlobWriteSessionConfig.Factory.WRITE_OBJECT_RESPONSE_BLOB_INFO_DECODER));
    }

    private static long flushInterval(FlushPolicy fp) {
        if (fp instanceof FlushPolicy.MinFlushSizeFlushPolicy) {
            FlushPolicy.MinFlushSizeFlushPolicy min = (FlushPolicy.MinFlushSizeFlushPolicy)fp;
            return min.getMinFlushSize();
        }
        return fp.getMaxPendingBytes();
    }

    @BetaApi
    public static enum CloseAction {
        FINALIZE_WHEN_CLOSING,
        CLOSE_WITHOUT_FINALIZING;

    }

    private static final class AppendableSession
    extends ChannelSession<BidiUploadState.AppendableUploadState, BidiWriteObjectResponse, BlobAppendableUploadImpl.AppendableObjectBufferedWritableByteChannel>
    implements WritableByteChannelSession<BlobAppendableUploadImpl.AppendableObjectBufferedWritableByteChannel, BidiWriteObjectResponse> {
        private AppendableSession(ApiFuture<BidiUploadState.AppendableUploadState> startFuture, BiFunction<BidiUploadState.AppendableUploadState, SettableApiFuture<BidiWriteObjectResponse>, BlobAppendableUploadImpl.AppendableObjectBufferedWritableByteChannel> f, SettableApiFuture<BidiWriteObjectResponse> resultFuture) {
            super(startFuture, f, resultFuture);
        }
    }
}

