/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.admin.api;

import io.micrometer.core.annotation.Timed;
import io.micrometer.core.aop.MeterTag;
import jakarta.annotation.Nonnull;
import jakarta.annotation.security.RolesAllowed;
import jakarta.inject.Inject;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Pattern;
import jakarta.validation.constraints.Size;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.SecurityContext;
import org.apache.polaris.core.admin.model.CreatePrincipalRoleRequest;
import org.apache.polaris.core.admin.model.GrantCatalogRoleRequest;
import org.apache.polaris.core.admin.model.UpdatePrincipalRoleRequest;
import org.apache.polaris.core.context.RealmContext;
import org.apache.polaris.service.admin.api.PolarisPrincipalRolesApiService;
import org.eclipse.microprofile.faulttolerance.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/api/management/v1/principal-roles")
public class PolarisPrincipalRolesApi {
    private static final Logger LOGGER = LoggerFactory.getLogger(PolarisPrincipalRolesApi.class);
    private final PolarisPrincipalRolesApiService service;

    @Inject
    public PolarisPrincipalRolesApi(PolarisPrincipalRolesApiService service) {
        this.service = service;
    }

    @PUT
    @Path(value="/{principalRoleName}/catalog-roles/{catalogName}")
    @Consumes(value={"application/json"})
    @RolesAllowed(value={"**"})
    @Timed(value="polaris.principal-roles.assignCatalogRoleToPrincipalRole")
    @Timeout
    public Response assignCatalogRoleToPrincipalRole(@Pattern(regexp="^(?!\\s*[s|S][y|Y][s|S][t|T][e|E][m|M]\\$).*$") @Size(min=1, max=256) @PathParam(value="principalRoleName") @Pattern(regexp="^(?!\\s*[s|S][y|Y][s|S][t|T][e|E][m|M]\\$).*$") @Size(min=1, max=256) String principalRoleName, @Pattern(regexp="^(?!\\s*[s|S][y|Y][s|S][t|T][e|E][m|M]\\$).*$") @Size(min=1, max=256) @PathParam(value="catalogName") @Pattern(regexp="^(?!\\s*[s|S][y|Y][s|S][t|T][e|E][m|M]\\$).*$") @Size(min=1, max=256) String catalogName, @Nonnull @Valid GrantCatalogRoleRequest grantCatalogRoleRequest, @Context @MeterTag(key="realm_id", expression="realmIdentifier") RealmContext realmContext, @Context @MeterTag(key="principal", expression="userPrincipal") SecurityContext securityContext) {
        LOGGER.atDebug().setMessage("Invoking principal-roles with params").addKeyValue("operation", (Object)"assignCatalogRoleToPrincipalRole").addKeyValue("principalRoleName", (Object)principalRoleName).addKeyValue("catalogName", (Object)catalogName).addKeyValue("grantCatalogRoleRequest", (Object)String.valueOf(grantCatalogRoleRequest)).log();
        Response ret = this.service.assignCatalogRoleToPrincipalRole(principalRoleName, catalogName, grantCatalogRoleRequest, realmContext, securityContext);
        LOGGER.debug("Completed execution of assignCatalogRoleToPrincipalRole API with status code {}", (Object)ret.getStatus());
        return ret;
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @RolesAllowed(value={"**"})
    @Timed(value="polaris.principal-roles.createPrincipalRole")
    @Timeout
    public Response createPrincipalRole(@Nonnull @Valid CreatePrincipalRoleRequest createPrincipalRoleRequest, @Context @MeterTag(key="realm_id", expression="realmIdentifier") RealmContext realmContext, @Context @MeterTag(key="principal", expression="userPrincipal") SecurityContext securityContext) {
        LOGGER.atDebug().setMessage("Invoking principal-roles with params").addKeyValue("operation", (Object)"createPrincipalRole").addKeyValue("createPrincipalRoleRequest", (Object)String.valueOf(createPrincipalRoleRequest)).log();
        Response ret = this.service.createPrincipalRole(createPrincipalRoleRequest, realmContext, securityContext);
        LOGGER.debug("Completed execution of createPrincipalRole API with status code {}", (Object)ret.getStatus());
        return ret;
    }

    @DELETE
    @Path(value="/{principalRoleName}")
    @RolesAllowed(value={"**"})
    @Timed(value="polaris.principal-roles.deletePrincipalRole")
    @Timeout
    public Response deletePrincipalRole(@Pattern(regexp="^(?!\\s*[s|S][y|Y][s|S][t|T][e|E][m|M]\\$).*$") @Size(min=1, max=256) @PathParam(value="principalRoleName") @Pattern(regexp="^(?!\\s*[s|S][y|Y][s|S][t|T][e|E][m|M]\\$).*$") @Size(min=1, max=256) String principalRoleName, @Context @MeterTag(key="realm_id", expression="realmIdentifier") RealmContext realmContext, @Context @MeterTag(key="principal", expression="userPrincipal") SecurityContext securityContext) {
        LOGGER.atDebug().setMessage("Invoking principal-roles with params").addKeyValue("operation", (Object)"deletePrincipalRole").addKeyValue("principalRoleName", (Object)principalRoleName).log();
        Response ret = this.service.deletePrincipalRole(principalRoleName, realmContext, securityContext);
        LOGGER.debug("Completed execution of deletePrincipalRole API with status code {}", (Object)ret.getStatus());
        return ret;
    }

    @GET
    @Path(value="/{principalRoleName}")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"**"})
    @Timed(value="polaris.principal-roles.getPrincipalRole")
    @Timeout
    public Response getPrincipalRole(@Pattern(regexp="^(?!\\s*[s|S][y|Y][s|S][t|T][e|E][m|M]\\$).*$") @Size(min=1, max=256) @PathParam(value="principalRoleName") @Pattern(regexp="^(?!\\s*[s|S][y|Y][s|S][t|T][e|E][m|M]\\$).*$") @Size(min=1, max=256) String principalRoleName, @Context @MeterTag(key="realm_id", expression="realmIdentifier") RealmContext realmContext, @Context @MeterTag(key="principal", expression="userPrincipal") SecurityContext securityContext) {
        LOGGER.atDebug().setMessage("Invoking principal-roles with params").addKeyValue("operation", (Object)"getPrincipalRole").addKeyValue("principalRoleName", (Object)principalRoleName).log();
        Response ret = this.service.getPrincipalRole(principalRoleName, realmContext, securityContext);
        LOGGER.debug("Completed execution of getPrincipalRole API with status code {}", (Object)ret.getStatus());
        return ret;
    }

    @GET
    @Path(value="/{principalRoleName}/principals")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"**"})
    @Timed(value="polaris.principal-roles.listAssigneePrincipalsForPrincipalRole")
    @Timeout
    public Response listAssigneePrincipalsForPrincipalRole(@Pattern(regexp="^(?!\\s*[s|S][y|Y][s|S][t|T][e|E][m|M]\\$).*$") @Size(min=1, max=256) @PathParam(value="principalRoleName") @Pattern(regexp="^(?!\\s*[s|S][y|Y][s|S][t|T][e|E][m|M]\\$).*$") @Size(min=1, max=256) String principalRoleName, @Context @MeterTag(key="realm_id", expression="realmIdentifier") RealmContext realmContext, @Context @MeterTag(key="principal", expression="userPrincipal") SecurityContext securityContext) {
        LOGGER.atDebug().setMessage("Invoking principal-roles with params").addKeyValue("operation", (Object)"listAssigneePrincipalsForPrincipalRole").addKeyValue("principalRoleName", (Object)principalRoleName).log();
        Response ret = this.service.listAssigneePrincipalsForPrincipalRole(principalRoleName, realmContext, securityContext);
        LOGGER.debug("Completed execution of listAssigneePrincipalsForPrincipalRole API with status code {}", (Object)ret.getStatus());
        return ret;
    }

    @GET
    @Path(value="/{principalRoleName}/catalog-roles/{catalogName}")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"**"})
    @Timed(value="polaris.principal-roles.listCatalogRolesForPrincipalRole")
    @Timeout
    public Response listCatalogRolesForPrincipalRole(@Pattern(regexp="^(?!\\s*[s|S][y|Y][s|S][t|T][e|E][m|M]\\$).*$") @Size(min=1, max=256) @PathParam(value="principalRoleName") @Pattern(regexp="^(?!\\s*[s|S][y|Y][s|S][t|T][e|E][m|M]\\$).*$") @Size(min=1, max=256) String principalRoleName, @Pattern(regexp="^(?!\\s*[s|S][y|Y][s|S][t|T][e|E][m|M]\\$).*$") @Size(min=1, max=256) @PathParam(value="catalogName") @Pattern(regexp="^(?!\\s*[s|S][y|Y][s|S][t|T][e|E][m|M]\\$).*$") @Size(min=1, max=256) String catalogName, @Context @MeterTag(key="realm_id", expression="realmIdentifier") RealmContext realmContext, @Context @MeterTag(key="principal", expression="userPrincipal") SecurityContext securityContext) {
        LOGGER.atDebug().setMessage("Invoking principal-roles with params").addKeyValue("operation", (Object)"listCatalogRolesForPrincipalRole").addKeyValue("principalRoleName", (Object)principalRoleName).addKeyValue("catalogName", (Object)catalogName).log();
        Response ret = this.service.listCatalogRolesForPrincipalRole(principalRoleName, catalogName, realmContext, securityContext);
        LOGGER.debug("Completed execution of listCatalogRolesForPrincipalRole API with status code {}", (Object)ret.getStatus());
        return ret;
    }

    @GET
    @Produces(value={"application/json"})
    @RolesAllowed(value={"**"})
    @Timed(value="polaris.principal-roles.listPrincipalRoles")
    @Timeout
    public Response listPrincipalRoles(@Context @MeterTag(key="realm_id", expression="realmIdentifier") RealmContext realmContext, @Context @MeterTag(key="principal", expression="userPrincipal") SecurityContext securityContext) {
        LOGGER.atDebug().setMessage("Invoking principal-roles with params").addKeyValue("operation", (Object)"listPrincipalRoles").log();
        Response ret = this.service.listPrincipalRoles(realmContext, securityContext);
        LOGGER.debug("Completed execution of listPrincipalRoles API with status code {}", (Object)ret.getStatus());
        return ret;
    }

    @DELETE
    @Path(value="/{principalRoleName}/catalog-roles/{catalogName}/{catalogRoleName}")
    @RolesAllowed(value={"**"})
    @Timed(value="polaris.principal-roles.revokeCatalogRoleFromPrincipalRole")
    @Timeout
    public Response revokeCatalogRoleFromPrincipalRole(@Pattern(regexp="^(?!\\s*[s|S][y|Y][s|S][t|T][e|E][m|M]\\$).*$") @Size(min=1, max=256) @PathParam(value="principalRoleName") @Pattern(regexp="^(?!\\s*[s|S][y|Y][s|S][t|T][e|E][m|M]\\$).*$") @Size(min=1, max=256) String principalRoleName, @Pattern(regexp="^(?!\\s*[s|S][y|Y][s|S][t|T][e|E][m|M]\\$).*$") @Size(min=1, max=256) @PathParam(value="catalogName") @Pattern(regexp="^(?!\\s*[s|S][y|Y][s|S][t|T][e|E][m|M]\\$).*$") @Size(min=1, max=256) String catalogName, @Pattern(regexp="^(?!\\s*[s|S][y|Y][s|S][t|T][e|E][m|M]\\$).*$") @Size(min=1, max=256) @PathParam(value="catalogRoleName") @Pattern(regexp="^(?!\\s*[s|S][y|Y][s|S][t|T][e|E][m|M]\\$).*$") @Size(min=1, max=256) String catalogRoleName, @Context @MeterTag(key="realm_id", expression="realmIdentifier") RealmContext realmContext, @Context @MeterTag(key="principal", expression="userPrincipal") SecurityContext securityContext) {
        LOGGER.atDebug().setMessage("Invoking principal-roles with params").addKeyValue("operation", (Object)"revokeCatalogRoleFromPrincipalRole").addKeyValue("principalRoleName", (Object)principalRoleName).addKeyValue("catalogName", (Object)catalogName).addKeyValue("catalogRoleName", (Object)catalogRoleName).log();
        Response ret = this.service.revokeCatalogRoleFromPrincipalRole(principalRoleName, catalogName, catalogRoleName, realmContext, securityContext);
        LOGGER.debug("Completed execution of revokeCatalogRoleFromPrincipalRole API with status code {}", (Object)ret.getStatus());
        return ret;
    }

    @PUT
    @Path(value="/{principalRoleName}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @RolesAllowed(value={"**"})
    @Timed(value="polaris.principal-roles.updatePrincipalRole")
    @Timeout
    public Response updatePrincipalRole(@Pattern(regexp="^(?!\\s*[s|S][y|Y][s|S][t|T][e|E][m|M]\\$).*$") @Size(min=1, max=256) @PathParam(value="principalRoleName") @Pattern(regexp="^(?!\\s*[s|S][y|Y][s|S][t|T][e|E][m|M]\\$).*$") @Size(min=1, max=256) String principalRoleName, @Nonnull @Valid UpdatePrincipalRoleRequest updatePrincipalRoleRequest, @Context @MeterTag(key="realm_id", expression="realmIdentifier") RealmContext realmContext, @Context @MeterTag(key="principal", expression="userPrincipal") SecurityContext securityContext) {
        LOGGER.atDebug().setMessage("Invoking principal-roles with params").addKeyValue("operation", (Object)"updatePrincipalRole").addKeyValue("principalRoleName", (Object)principalRoleName).addKeyValue("updatePrincipalRoleRequest", (Object)String.valueOf(updatePrincipalRoleRequest)).log();
        Response ret = this.service.updatePrincipalRole(principalRoleName, updatePrincipalRoleRequest, realmContext, securityContext);
        LOGGER.debug("Completed execution of updatePrincipalRole API with status code {}", (Object)ret.getStatus());
        return ret;
    }
}

