/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.admin.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ResetPrincipalRequest {
    private final String clientId;
    private final String clientSecret;

    @ApiModelProperty(value="Optional client ID to set for the principal. Must be a valid client ID previously generated by this service. ")
    @JsonProperty(value="clientId")
    public String getClientId() {
        return this.clientId;
    }

    @ApiModelProperty(value="Optional client secret to set for the principal. Polaris service implementations may impose extra requirements on what is accepted as a secret (special chars, length, etc.) ")
    @JsonProperty(value="clientSecret")
    public String getClientSecret() {
        return this.clientSecret;
    }

    @JsonCreator
    public ResetPrincipalRequest(@JsonProperty(value="clientId") String clientId, @JsonProperty(value="clientSecret") String clientSecret) {
        this.clientId = clientId;
        this.clientSecret = clientSecret;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResetPrincipalRequest resetPrincipalRequest = (ResetPrincipalRequest)o;
        return Objects.equals(this.clientId, resetPrincipalRequest.clientId) && Objects.equals(this.clientSecret, resetPrincipalRequest.clientSecret);
    }

    public int hashCode() {
        return Objects.hash(this.clientId, this.clientSecret);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ResetPrincipalRequest {\n");
        sb.append("    clientId: ").append(this.toIndentedString(this.clientId)).append("\n");
        sb.append("    clientSecret: ").append(this.toIndentedString(this.clientSecret)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static final class Builder {
        private String clientId;
        private String clientSecret;

        private Builder() {
        }

        public Builder setClientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public Builder setClientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
            return this;
        }

        public ResetPrincipalRequest build() {
            ResetPrincipalRequest inst = new ResetPrincipalRequest(this.clientId, this.clientSecret);
            return inst;
        }
    }
}

