/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.rest.auth;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.iceberg.rest.HTTPHeaders;
import org.apache.iceberg.rest.auth.DefaultAuthSession;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="DefaultAuthSession", generator="Immutables")
@Immutable
public final class ImmutableDefaultAuthSession
implements DefaultAuthSession {
    private final HTTPHeaders headers;

    private ImmutableDefaultAuthSession(HTTPHeaders headers) {
        this.headers = headers;
    }

    @Override
    public HTTPHeaders headers() {
        return this.headers;
    }

    public final ImmutableDefaultAuthSession withHeaders(HTTPHeaders value) {
        if (this.headers == value) {
            return this;
        }
        HTTPHeaders newValue = Objects.requireNonNull(value, "headers");
        return new ImmutableDefaultAuthSession(newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDefaultAuthSession && this.equalsByValue((ImmutableDefaultAuthSession)another);
    }

    private boolean equalsByValue(ImmutableDefaultAuthSession another) {
        return this.headers.equals(another.headers);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.headers.hashCode();
        return h;
    }

    public String toString() {
        return "DefaultAuthSession{headers=" + String.valueOf(this.headers) + "}";
    }

    public static ImmutableDefaultAuthSession copyOf(DefaultAuthSession instance) {
        if (instance instanceof ImmutableDefaultAuthSession) {
            return (ImmutableDefaultAuthSession)instance;
        }
        return ImmutableDefaultAuthSession.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="DefaultAuthSession", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_HEADERS = 1L;
        private long initBits = 1L;
        @Nullable
        private HTTPHeaders headers;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(DefaultAuthSession instance) {
            Objects.requireNonNull(instance, "instance");
            this.headers(instance.headers());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder headers(HTTPHeaders headers) {
            this.headers = Objects.requireNonNull(headers, "headers");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableDefaultAuthSession build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableDefaultAuthSession(this.headers);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("headers");
            }
            return "Cannot build DefaultAuthSession, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

