/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.events.jsonEventListener.aws.cloudwatch;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.smallrye.common.annotation.Identifier;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.SecurityContext;
import java.time.Clock;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;
import org.apache.polaris.core.auth.PolarisPrincipal;
import org.apache.polaris.core.context.CallContext;
import org.apache.polaris.service.config.PolarisIcebergObjectMapperCustomizer;
import org.apache.polaris.service.events.jsonEventListener.PropertyMapEventListener;
import org.apache.polaris.service.events.jsonEventListener.aws.cloudwatch.AwsCloudWatchConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.cloudwatchlogs.CloudWatchLogsAsyncClient;
import software.amazon.awssdk.services.cloudwatchlogs.CloudWatchLogsAsyncClientBuilder;
import software.amazon.awssdk.services.cloudwatchlogs.model.CreateLogGroupRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.CreateLogStreamRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeLogGroupsRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeLogGroupsResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeLogStreamsRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeLogStreamsResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.InputLogEvent;
import software.amazon.awssdk.services.cloudwatchlogs.model.PutLogEventsRequest;

@ApplicationScoped
@Identifier(value="aws-cloudwatch")
public class AwsCloudWatchEventListener
extends PropertyMapEventListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(AwsCloudWatchEventListener.class);
    final ObjectMapper objectMapper;
    private CloudWatchLogsAsyncClient client;
    private final String logGroup;
    private final String logStream;
    private final Region region;
    private final boolean synchronousMode;
    private final Clock clock;
    @Inject
    CallContext callContext;
    @Context
    SecurityContext securityContext;

    @Inject
    public AwsCloudWatchEventListener(AwsCloudWatchConfiguration config, Clock clock, PolarisIcebergObjectMapperCustomizer customizer) {
        this.objectMapper = new ObjectMapper();
        this.logStream = config.awsCloudWatchLogStream();
        this.logGroup = config.awsCloudWatchLogGroup();
        this.region = Region.of((String)config.awsCloudWatchRegion());
        this.synchronousMode = config.synchronousMode();
        this.clock = clock;
        customizer.customize(this.objectMapper);
    }

    @PostConstruct
    void start() {
        this.client = this.createCloudWatchAsyncClient();
        this.ensureLogGroupAndStream();
    }

    protected CloudWatchLogsAsyncClient createCloudWatchAsyncClient() {
        return (CloudWatchLogsAsyncClient)((CloudWatchLogsAsyncClientBuilder)CloudWatchLogsAsyncClient.builder().region(this.region)).build();
    }

    private void ensureLogGroupAndStream() {
        AwsCloudWatchEventListener.ensureResourceExists(() -> ((DescribeLogGroupsResponse)this.client.describeLogGroups((DescribeLogGroupsRequest)DescribeLogGroupsRequest.builder().logGroupNamePrefix(this.logGroup).build()).join()).logGroups().stream().anyMatch(g -> g.logGroupName().equals(this.logGroup)), () -> this.client.createLogGroup((CreateLogGroupRequest)CreateLogGroupRequest.builder().logGroupName(this.logGroup).build()).join(), "group", this.logGroup);
        AwsCloudWatchEventListener.ensureResourceExists(() -> ((DescribeLogStreamsResponse)this.client.describeLogStreams((DescribeLogStreamsRequest)DescribeLogStreamsRequest.builder().logGroupName(this.logGroup).logStreamNamePrefix(this.logStream).build()).join()).logStreams().stream().anyMatch(s -> s.logStreamName().equals(this.logStream)), () -> this.client.createLogStream((CreateLogStreamRequest)CreateLogStreamRequest.builder().logGroupName(this.logGroup).logStreamName(this.logStream).build()).join(), "stream", this.logStream);
    }

    private static void ensureResourceExists(Supplier<Boolean> existsCheck, Runnable createAction, String resourceType, String resourceName) {
        if (existsCheck.get().booleanValue()) {
            LOGGER.debug("Log {} [{}] already exists", (Object)resourceType, (Object)resourceName);
        } else {
            LOGGER.debug("Attempting to create log {}: {}", (Object)resourceType, (Object)resourceName);
            createAction.run();
        }
    }

    @PreDestroy
    void shutdown() {
        if (this.client != null) {
            this.client.close();
            this.client = null;
        }
    }

    protected void transformAndSendEvent(HashMap<String, Object> properties) {
        String eventAsJson;
        properties.put("realm_id", this.callContext.getRealmContext().getRealmIdentifier());
        properties.put("principal", this.securityContext.getUserPrincipal().getName());
        properties.put("activated_roles", ((PolarisPrincipal)this.securityContext.getUserPrincipal()).getRoles());
        try {
            eventAsJson = this.objectMapper.writeValueAsString(properties);
        }
        catch (JsonProcessingException e) {
            LOGGER.error("Error processing event into JSON string: ", (Throwable)e);
            LOGGER.debug("Failed to convert the following object into JSON string: {}", properties);
            return;
        }
        InputLogEvent inputLogEvent = (InputLogEvent)InputLogEvent.builder().message(eventAsJson).timestamp(Long.valueOf(this.clock.millis())).build();
        PutLogEventsRequest.Builder requestBuilder = PutLogEventsRequest.builder().logGroupName(this.logGroup).logStreamName(this.logStream).logEvents(List.of(inputLogEvent));
        CompletionStage future = this.client.putLogEvents((PutLogEventsRequest)requestBuilder.build()).whenComplete((resp, err) -> {
            if (err != null) {
                LOGGER.error("Error writing log to CloudWatch. Event: {}, Error: ", (Object)inputLogEvent, err);
            }
        });
        if (this.synchronousMode) {
            ((CompletableFuture)future).join();
        }
    }

    public AwsCloudWatchEventListener() {
    }
}

