/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DBProxyStatus {
    AVAILABLE("available"),
    MODIFYING("modifying"),
    INCOMPATIBLE_NETWORK("incompatible-network"),
    INSUFFICIENT_RESOURCE_LIMITS("insufficient-resource-limits"),
    CREATING("creating"),
    DELETING("deleting"),
    SUSPENDED("suspended"),
    SUSPENDING("suspending"),
    REACTIVATING("reactivating"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DBProxyStatus> VALUE_MAP;
    private final String value;

    private DBProxyStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DBProxyStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DBProxyStatus> knownValues() {
        EnumSet<DBProxyStatus> knownValues = EnumSet.allOf(DBProxyStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DBProxyStatus.class, DBProxyStatus::toString);
    }
}

