/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.events.listeners;

import io.smallrye.common.annotation.Identifier;
import jakarta.enterprise.context.ApplicationScoped;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.polaris.service.events.AfterAttemptTaskEvent;
import org.apache.polaris.service.events.BeforeAttemptTaskEvent;
import org.apache.polaris.service.events.BeforeLimitRequestRateEvent;
import org.apache.polaris.service.events.CatalogGenericTableServiceEvents;
import org.apache.polaris.service.events.CatalogPolicyServiceEvents;
import org.apache.polaris.service.events.CatalogsServiceEvents;
import org.apache.polaris.service.events.IcebergRestCatalogEvents;
import org.apache.polaris.service.events.PolarisEvent;
import org.apache.polaris.service.events.PrincipalRolesServiceEvents;
import org.apache.polaris.service.events.PrincipalsServiceEvents;
import org.apache.polaris.service.events.listeners.PolarisEventListener;

@ApplicationScoped
@Identifier(value="test")
public class TestPolarisEventListener
implements PolarisEventListener {
    private final Map<Class<? extends PolarisEvent>, PolarisEvent> latestEvents = new ConcurrentHashMap<Class<? extends PolarisEvent>, PolarisEvent>();

    private void recordEvent(PolarisEvent event) {
        this.latestEvents.put(event.getClass(), event);
    }

    public void clear() {
        this.latestEvents.clear();
    }

    public <T> T getLatest(Class<T> type) {
        PolarisEvent latest = this.latestEvents.get(type);
        if (latest == null) {
            throw new IllegalStateException("No event of type " + String.valueOf(type) + " recorded");
        }
        return type.cast(latest);
    }

    @Override
    public void onBeforeCreateCatalog(CatalogsServiceEvents.BeforeCreateCatalogEvent event) {
        this.recordEvent(event);
    }

    @Override
    public void onAfterCreateCatalog(CatalogsServiceEvents.AfterCreateCatalogEvent event) {
        this.recordEvent(event);
    }

    @Override
    public void onBeforeDeleteCatalog(CatalogsServiceEvents.BeforeDeleteCatalogEvent event) {
        this.recordEvent(event);
    }

    @Override
    public void onAfterDeleteCatalog(CatalogsServiceEvents.AfterDeleteCatalogEvent event) {
        this.recordEvent(event);
    }

    @Override
    public void onBeforeGetCatalog(CatalogsServiceEvents.BeforeGetCatalogEvent event) {
        this.recordEvent(event);
    }

    @Override
    public void onAfterGetCatalog(CatalogsServiceEvents.AfterGetCatalogEvent event) {
        this.recordEvent(event);
    }

    @Override
    public void onBeforeUpdateCatalog(CatalogsServiceEvents.BeforeUpdateCatalogEvent event) {
        this.recordEvent(event);
    }

    @Override
    public void onAfterUpdateCatalog(CatalogsServiceEvents.AfterUpdateCatalogEvent event) {
        this.recordEvent(event);
    }

    @Override
    public void onBeforeListCatalogs(CatalogsServiceEvents.BeforeListCatalogsEvent event) {
        this.recordEvent(event);
    }

    @Override
    public void onAfterListCatalogs(CatalogsServiceEvents.AfterListCatalogsEvent event) {
        this.recordEvent(event);
    }

    @Override
    public void onBeforeCreatePrincipal(PrincipalsServiceEvents.BeforeCreatePrincipalEvent event) {
        this.recordEvent(event);
    }

    @Override
    public void onAfterCreatePrincipal(PrincipalsServiceEvents.AfterCreatePrincipalEvent event) {
        this.recordEvent(event);
    }

    @Override
    public void onBeforeDeletePrincipal(PrincipalsServiceEvents.BeforeDeletePrincipalEvent event) {
        this.recordEvent(event);
    }

    @Override
    public void onAfterDeletePrincipal(PrincipalsServiceEvents.AfterDeletePrincipalEvent event) {
        this.recordEvent(event);
    }

    @Override
    public void onBeforeGetPrincipal(PrincipalsServiceEvents.BeforeGetPrincipalEvent event) {
        this.recordEvent(event);
    }

    @Override
    public void onAfterGetPrincipal(PrincipalsServiceEvents.AfterGetPrincipalEvent event) {
        this.recordEvent(event);
    }

    @Override
    public void onBeforeUpdatePrincipal(PrincipalsServiceEvents.BeforeUpdatePrincipalEvent event) {
        this.recordEvent(event);
    }

    @Override
    public void onAfterUpdatePrincipal(PrincipalsServiceEvents.AfterUpdatePrincipalEvent event) {
        this.recordEvent(event);
    }

    @Override
    public void onBeforeRotateCredentials(PrincipalsServiceEvents.BeforeRotateCredentialsEvent event) {
        this.recordEvent(event);
    }

    @Override
    public void onAfterRotateCredentials(PrincipalsServiceEvents.AfterRotateCredentialsEvent event) {
        this.recordEvent(event);
    }

    @Override
    public void onBeforeListPrincipals(PrincipalsServiceEvents.BeforeListPrincipalsEvent event) {
        this.recordEvent(event);
    }

    @Override
    public void onAfterListPrincipals(PrincipalsServiceEvents.AfterListPrincipalsEvent event) {
        this.recordEvent(event);
    }

    @Override
    public void onBeforeResetCredentials(PrincipalsServiceEvents.BeforeResetCredentialsEvent event) {
        this.recordEvent(event);
    }

    @Override
    public void onAfterResetCredentials(PrincipalsServiceEvents.AfterResetCredentialsEvent event) {
        this.recordEvent(event);
    }

    @Override
    public void onBeforeAssignPrincipalRole(PrincipalsServiceEvents.BeforeAssignPrincipalRoleEvent event) {
        this.recordEvent(event);
    }

    @Override
    public void onAfterAssignPrincipalRole(PrincipalsServiceEvents.AfterAssignPrincipalRoleEvent event) {
        this.recordEvent(event);
    }

    @Override
    public void onBeforeRevokePrincipalRole(PrincipalsServiceEvents.BeforeRevokePrincipalRoleEvent event) {
        this.recordEvent(event);
    }

    @Override
    public void onAfterRevokePrincipalRole(PrincipalsServiceEvents.AfterRevokePrincipalRoleEvent event) {
        this.recordEvent(event);
    }

    @Override
    public void onBeforeListAssignedPrincipalRoles(PrincipalsServiceEvents.BeforeListAssignedPrincipalRolesEvent event) {
        this.recordEvent(event);
    }

    @Override
    public void onAfterListAssignedPrincipalRoles(PrincipalsServiceEvents.AfterListAssignedPrincipalRolesEvent event) {
        this.recordEvent(event);
    }

    @Override
    public void onBeforeCreatePrincipalRole(PrincipalRolesServiceEvents.BeforeCreatePrincipalRoleEvent event) {
        this.recordEvent(event);
    }

    @Override
    public void onAfterCreatePrincipalRole(PrincipalRolesServiceEvents.AfterCreatePrincipalRoleEvent event) {
        this.recordEvent(event);
    }

    @Override
    public void onBeforeDeletePrincipalRole(PrincipalRolesServiceEvents.BeforeDeletePrincipalRoleEvent event) {
        this.recordEvent(event);
    }

    @Override
    public void onAfterDeletePrincipalRole(PrincipalRolesServiceEvents.AfterDeletePrincipalRoleEvent event) {
        this.recordEvent(event);
    }

    @Override
    public void onBeforeGetPrincipalRole(PrincipalRolesServiceEvents.BeforeGetPrincipalRoleEvent event) {
        this.recordEvent(event);
    }

    @Override
    public void onAfterGetPrincipalRole(PrincipalRolesServiceEvents.AfterGetPrincipalRoleEvent event) {
        this.recordEvent(event);
    }

    @Override
    public void onBeforeUpdatePrincipalRole(PrincipalRolesServiceEvents.BeforeUpdatePrincipalRoleEvent event) {
        this.recordEvent(event);
    }

    @Override
    public void onAfterUpdatePrincipalRole(PrincipalRolesServiceEvents.AfterUpdatePrincipalRoleEvent event) {
        this.recordEvent(event);
    }

    @Override
    public void onBeforeListPrincipalRoles(PrincipalRolesServiceEvents.BeforeListPrincipalRolesEvent event) {
        this.recordEvent(event);
    }

    @Override
    public void onAfterListPrincipalRoles(PrincipalRolesServiceEvents.AfterListPrincipalRolesEvent event) {
        this.recordEvent(event);
    }

    @Override
    public void onBeforeCreateCatalogRole(CatalogsServiceEvents.BeforeCreateCatalogRoleEvent event) {
        this.recordEvent(event);
    }

    @Override
    public void onAfterCreateCatalogRole(CatalogsServiceEvents.AfterCreateCatalogRoleEvent event) {
        this.recordEvent(event);
    }

    @Override
    public void onBeforeDeleteCatalogRole(CatalogsServiceEvents.BeforeDeleteCatalogRoleEvent event) {
        this.recordEvent(event);
    }

    @Override
    public void onAfterDeleteCatalogRole(CatalogsServiceEvents.AfterDeleteCatalogRoleEvent event) {
        this.recordEvent(event);
    }

    @Override
    public void onBeforeGetCatalogRole(CatalogsServiceEvents.BeforeGetCatalogRoleEvent event) {
        this.recordEvent(event);
    }

    @Override
    public void onAfterGetCatalogRole(CatalogsServiceEvents.AfterGetCatalogRoleEvent event) {
        this.recordEvent(event);
    }

    @Override
    public void onBeforeUpdateCatalogRole(CatalogsServiceEvents.BeforeUpdateCatalogRoleEvent event) {
        this.recordEvent(event);
    }

    @Override
    public void onAfterUpdateCatalogRole(CatalogsServiceEvents.AfterUpdateCatalogRoleEvent event) {
        this.recordEvent(event);
    }

    @Override
    public void onBeforeListCatalogRoles(CatalogsServiceEvents.BeforeListCatalogRolesEvent event) {
        this.recordEvent(event);
    }

    @Override
    public void onAfterListCatalogRoles(CatalogsServiceEvents.AfterListCatalogRolesEvent event) {
        this.recordEvent(event);
    }

    @Override
    public void onBeforeAssignCatalogRoleToPrincipalRole(PrincipalRolesServiceEvents.BeforeAssignCatalogRoleToPrincipalRoleEvent event) {
        this.recordEvent(event);
    }

    @Override
    public void onAfterAssignCatalogRoleToPrincipalRole(PrincipalRolesServiceEvents.AfterAssignCatalogRoleToPrincipalRoleEvent event) {
        this.recordEvent(event);
    }

    @Override
    public void onBeforeRevokeCatalogRoleFromPrincipalRole(PrincipalRolesServiceEvents.BeforeRevokeCatalogRoleFromPrincipalRoleEvent event) {
        this.recordEvent(event);
    }

    @Override
    public void onAfterRevokeCatalogRoleFromPrincipalRole(PrincipalRolesServiceEvents.AfterRevokeCatalogRoleFromPrincipalRoleEvent event) {
        this.recordEvent(event);
    }

    @Override
    public void onBeforeListAssigneePrincipalsForPrincipalRole(PrincipalRolesServiceEvents.BeforeListAssigneePrincipalsForPrincipalRoleEvent event) {
        this.recordEvent(event);
    }

    @Override
    public void onAfterListAssigneePrincipalsForPrincipalRole(PrincipalRolesServiceEvents.AfterListAssigneePrincipalsForPrincipalRoleEvent event) {
        this.recordEvent(event);
    }

    @Override
    public void onBeforeListCatalogRolesForPrincipalRole(PrincipalRolesServiceEvents.BeforeListCatalogRolesForPrincipalRoleEvent event) {
        this.recordEvent(event);
    }

    @Override
    public void onAfterListCatalogRolesForPrincipalRole(PrincipalRolesServiceEvents.AfterListCatalogRolesForPrincipalRoleEvent event) {
        this.recordEvent(event);
    }

    @Override
    public void onBeforeAddGrantToCatalogRole(CatalogsServiceEvents.BeforeAddGrantToCatalogRoleEvent event) {
        this.recordEvent(event);
    }

    @Override
    public void onAfterAddGrantToCatalogRole(CatalogsServiceEvents.AfterAddGrantToCatalogRoleEvent event) {
        this.recordEvent(event);
    }

    @Override
    public void onBeforeRevokeGrantFromCatalogRole(CatalogsServiceEvents.BeforeRevokeGrantFromCatalogRoleEvent event) {
        this.recordEvent(event);
    }

    @Override
    public void onAfterRevokeGrantFromCatalogRole(CatalogsServiceEvents.AfterRevokeGrantFromCatalogRoleEvent event) {
        this.recordEvent(event);
    }

    @Override
    public void onBeforeListAssigneePrincipalRolesForCatalogRole(CatalogsServiceEvents.BeforeListAssigneePrincipalRolesForCatalogRoleEvent event) {
        this.recordEvent(event);
    }

    @Override
    public void onAfterListAssigneePrincipalRolesForCatalogRole(CatalogsServiceEvents.AfterListAssigneePrincipalRolesForCatalogRoleEvent event) {
        this.recordEvent(event);
    }

    @Override
    public void onBeforeListGrantsForCatalogRole(CatalogsServiceEvents.BeforeListGrantsForCatalogRoleEvent event) {
        this.recordEvent(event);
    }

    @Override
    public void onAfterListGrantsForCatalogRole(CatalogsServiceEvents.AfterListGrantsForCatalogRoleEvent event) {
        this.recordEvent(event);
    }

    @Override
    public void onBeforeCreateNamespace(IcebergRestCatalogEvents.BeforeCreateNamespaceEvent event) {
        this.recordEvent(event);
    }

    @Override
    public void onAfterCreateNamespace(IcebergRestCatalogEvents.AfterCreateNamespaceEvent event) {
        this.recordEvent(event);
    }

    @Override
    public void onBeforeListNamespaces(IcebergRestCatalogEvents.BeforeListNamespacesEvent event) {
        this.recordEvent(event);
    }

    @Override
    public void onAfterListNamespaces(IcebergRestCatalogEvents.AfterListNamespacesEvent event) {
        this.recordEvent(event);
    }

    @Override
    public void onBeforeLoadNamespaceMetadata(IcebergRestCatalogEvents.BeforeLoadNamespaceMetadataEvent event) {
        this.recordEvent(event);
    }

    @Override
    public void onAfterLoadNamespaceMetadata(IcebergRestCatalogEvents.AfterLoadNamespaceMetadataEvent event) {
        this.recordEvent(event);
    }

    @Override
    public void onBeforeCheckExistsNamespace(IcebergRestCatalogEvents.BeforeCheckExistsNamespaceEvent event) {
        this.recordEvent(event);
    }

    @Override
    public void onAfterCheckExistsNamespace(IcebergRestCatalogEvents.AfterCheckExistsNamespaceEvent event) {
        this.recordEvent(event);
    }

    @Override
    public void onBeforeDropNamespace(IcebergRestCatalogEvents.BeforeDropNamespaceEvent event) {
        this.recordEvent(event);
    }

    @Override
    public void onAfterDropNamespace(IcebergRestCatalogEvents.AfterDropNamespaceEvent event) {
        this.recordEvent(event);
    }

    @Override
    public void onBeforeUpdateNamespaceProperties(IcebergRestCatalogEvents.BeforeUpdateNamespacePropertiesEvent event) {
        this.recordEvent(event);
    }

    @Override
    public void onAfterUpdateNamespaceProperties(IcebergRestCatalogEvents.AfterUpdateNamespacePropertiesEvent event) {
        this.recordEvent(event);
    }

    @Override
    public void onBeforeCreateTable(IcebergRestCatalogEvents.BeforeCreateTableEvent event) {
        this.recordEvent(event);
    }

    @Override
    public void onAfterCreateTable(IcebergRestCatalogEvents.AfterCreateTableEvent event) {
        this.recordEvent(event);
    }

    @Override
    public void onBeforeCommitTable(IcebergRestCatalogEvents.BeforeCommitTableEvent event) {
        this.recordEvent(event);
    }

    @Override
    public void onAfterCommitTable(IcebergRestCatalogEvents.AfterCommitTableEvent event) {
        this.recordEvent(event);
    }

    @Override
    public void onBeforeRefreshTable(IcebergRestCatalogEvents.BeforeRefreshTableEvent event) {
        this.recordEvent(event);
    }

    @Override
    public void onAfterRefreshTable(IcebergRestCatalogEvents.AfterRefreshTableEvent event) {
        this.recordEvent(event);
    }

    @Override
    public void onBeforeListTables(IcebergRestCatalogEvents.BeforeListTablesEvent event) {
        this.recordEvent(event);
    }

    @Override
    public void onAfterListTables(IcebergRestCatalogEvents.AfterListTablesEvent event) {
        this.recordEvent(event);
    }

    @Override
    public void onBeforeLoadTable(IcebergRestCatalogEvents.BeforeLoadTableEvent event) {
        this.recordEvent(event);
    }

    @Override
    public void onAfterLoadTable(IcebergRestCatalogEvents.AfterLoadTableEvent event) {
        this.recordEvent(event);
    }

    @Override
    public void onBeforeCheckExistsTable(IcebergRestCatalogEvents.BeforeCheckExistsTableEvent event) {
        this.recordEvent(event);
    }

    @Override
    public void onAfterCheckExistsTable(IcebergRestCatalogEvents.AfterCheckExistsTableEvent event) {
        this.recordEvent(event);
    }

    @Override
    public void onBeforeDropTable(IcebergRestCatalogEvents.BeforeDropTableEvent event) {
        this.recordEvent(event);
    }

    @Override
    public void onAfterDropTable(IcebergRestCatalogEvents.AfterDropTableEvent event) {
        this.recordEvent(event);
    }

    @Override
    public void onBeforeRegisterTable(IcebergRestCatalogEvents.BeforeRegisterTableEvent event) {
        this.recordEvent(event);
    }

    @Override
    public void onAfterRegisterTable(IcebergRestCatalogEvents.AfterRegisterTableEvent event) {
        this.recordEvent(event);
    }

    @Override
    public void onBeforeRenameTable(IcebergRestCatalogEvents.BeforeRenameTableEvent event) {
        this.recordEvent(event);
    }

    @Override
    public void onAfterRenameTable(IcebergRestCatalogEvents.AfterRenameTableEvent event) {
        this.recordEvent(event);
    }

    @Override
    public void onBeforeUpdateTable(IcebergRestCatalogEvents.BeforeUpdateTableEvent event) {
        this.recordEvent(event);
    }

    @Override
    public void onAfterUpdateTable(IcebergRestCatalogEvents.AfterUpdateTableEvent event) {
        this.recordEvent(event);
    }

    @Override
    public void onBeforeCreateView(IcebergRestCatalogEvents.BeforeCreateViewEvent event) {
        this.recordEvent(event);
    }

    @Override
    public void onAfterCreateView(IcebergRestCatalogEvents.AfterCreateViewEvent event) {
        this.recordEvent(event);
    }

    @Override
    public void onBeforeCommitView(IcebergRestCatalogEvents.BeforeCommitViewEvent event) {
        this.recordEvent(event);
    }

    @Override
    public void onAfterCommitView(IcebergRestCatalogEvents.AfterCommitViewEvent event) {
        this.recordEvent(event);
    }

    @Override
    public void onBeforeRefreshView(IcebergRestCatalogEvents.BeforeRefreshViewEvent event) {
        this.recordEvent(event);
    }

    @Override
    public void onAfterRefreshView(IcebergRestCatalogEvents.AfterRefreshViewEvent event) {
        this.recordEvent(event);
    }

    @Override
    public void onBeforeListViews(IcebergRestCatalogEvents.BeforeListViewsEvent event) {
        this.recordEvent(event);
    }

    @Override
    public void onAfterListViews(IcebergRestCatalogEvents.AfterListViewsEvent event) {
        this.recordEvent(event);
    }

    @Override
    public void onBeforeLoadView(IcebergRestCatalogEvents.BeforeLoadViewEvent event) {
        this.recordEvent(event);
    }

    @Override
    public void onAfterLoadView(IcebergRestCatalogEvents.AfterLoadViewEvent event) {
        this.recordEvent(event);
    }

    @Override
    public void onBeforeCheckExistsView(IcebergRestCatalogEvents.BeforeCheckExistsViewEvent event) {
        this.recordEvent(event);
    }

    @Override
    public void onAfterCheckExistsView(IcebergRestCatalogEvents.AfterCheckExistsViewEvent event) {
        this.recordEvent(event);
    }

    @Override
    public void onBeforeDropView(IcebergRestCatalogEvents.BeforeDropViewEvent event) {
        this.recordEvent(event);
    }

    @Override
    public void onAfterDropView(IcebergRestCatalogEvents.AfterDropViewEvent event) {
        this.recordEvent(event);
    }

    @Override
    public void onBeforeRenameView(IcebergRestCatalogEvents.BeforeRenameViewEvent event) {
        this.recordEvent(event);
    }

    @Override
    public void onAfterRenameView(IcebergRestCatalogEvents.AfterRenameViewEvent event) {
        this.recordEvent(event);
    }

    @Override
    public void onBeforeReplaceView(IcebergRestCatalogEvents.BeforeReplaceViewEvent event) {
        this.recordEvent(event);
    }

    @Override
    public void onAfterReplaceView(IcebergRestCatalogEvents.AfterReplaceViewEvent event) {
        this.recordEvent(event);
    }

    @Override
    public void onBeforeLoadCredentials(IcebergRestCatalogEvents.BeforeLoadCredentialsEvent event) {
        this.recordEvent(event);
    }

    @Override
    public void onAfterLoadCredentials(IcebergRestCatalogEvents.AfterLoadCredentialsEvent event) {
        this.recordEvent(event);
    }

    @Override
    public void onBeforeCommitTransaction(IcebergRestCatalogEvents.BeforeCommitTransactionEvent event) {
        this.recordEvent(event);
    }

    @Override
    public void onAfterCommitTransaction(IcebergRestCatalogEvents.AfterCommitTransactionEvent event) {
        this.recordEvent(event);
    }

    @Override
    public void onBeforeSendNotification(IcebergRestCatalogEvents.BeforeSendNotificationEvent event) {
        this.recordEvent(event);
    }

    @Override
    public void onAfterSendNotification(IcebergRestCatalogEvents.AfterSendNotificationEvent event) {
        this.recordEvent(event);
    }

    @Override
    public void onBeforeGetConfig(IcebergRestCatalogEvents.BeforeGetConfigEvent event) {
        this.recordEvent(event);
    }

    @Override
    public void onAfterGetConfig(IcebergRestCatalogEvents.AfterGetConfigEvent event) {
        this.recordEvent(event);
    }

    @Override
    public void onBeforeCreatePolicy(CatalogPolicyServiceEvents.BeforeCreatePolicyEvent event) {
        this.recordEvent(event);
    }

    @Override
    public void onAfterCreatePolicy(CatalogPolicyServiceEvents.AfterCreatePolicyEvent event) {
        this.recordEvent(event);
    }

    @Override
    public void onBeforeListPolicies(CatalogPolicyServiceEvents.BeforeListPoliciesEvent event) {
        this.recordEvent(event);
    }

    @Override
    public void onAfterListPolicies(CatalogPolicyServiceEvents.AfterListPoliciesEvent event) {
        this.recordEvent(event);
    }

    @Override
    public void onBeforeLoadPolicy(CatalogPolicyServiceEvents.BeforeLoadPolicyEvent event) {
        this.recordEvent(event);
    }

    @Override
    public void onAfterLoadPolicy(CatalogPolicyServiceEvents.AfterLoadPolicyEvent event) {
        this.recordEvent(event);
    }

    @Override
    public void onBeforeUpdatePolicy(CatalogPolicyServiceEvents.BeforeUpdatePolicyEvent event) {
        this.recordEvent(event);
    }

    @Override
    public void onAfterUpdatePolicy(CatalogPolicyServiceEvents.AfterUpdatePolicyEvent event) {
        this.recordEvent(event);
    }

    @Override
    public void onBeforeDropPolicy(CatalogPolicyServiceEvents.BeforeDropPolicyEvent event) {
        this.recordEvent(event);
    }

    @Override
    public void onAfterDropPolicy(CatalogPolicyServiceEvents.AfterDropPolicyEvent event) {
        this.recordEvent(event);
    }

    @Override
    public void onBeforeAttachPolicy(CatalogPolicyServiceEvents.BeforeAttachPolicyEvent event) {
        this.recordEvent(event);
    }

    @Override
    public void onAfterAttachPolicy(CatalogPolicyServiceEvents.AfterAttachPolicyEvent event) {
        this.recordEvent(event);
    }

    @Override
    public void onBeforeDetachPolicy(CatalogPolicyServiceEvents.BeforeDetachPolicyEvent event) {
        this.recordEvent(event);
    }

    @Override
    public void onAfterDetachPolicy(CatalogPolicyServiceEvents.AfterDetachPolicyEvent event) {
        this.recordEvent(event);
    }

    @Override
    public void onBeforeGetApplicablePolicies(CatalogPolicyServiceEvents.BeforeGetApplicablePoliciesEvent event) {
        this.recordEvent(event);
    }

    @Override
    public void onAfterGetApplicablePolicies(CatalogPolicyServiceEvents.AfterGetApplicablePoliciesEvent event) {
        this.recordEvent(event);
    }

    @Override
    public void onBeforeCreateGenericTable(CatalogGenericTableServiceEvents.BeforeCreateGenericTableEvent event) {
        this.recordEvent(event);
    }

    @Override
    public void onAfterCreateGenericTable(CatalogGenericTableServiceEvents.AfterCreateGenericTableEvent event) {
        this.recordEvent(event);
    }

    @Override
    public void onBeforeDropGenericTable(CatalogGenericTableServiceEvents.BeforeDropGenericTableEvent event) {
        this.recordEvent(event);
    }

    @Override
    public void onAfterDropGenericTable(CatalogGenericTableServiceEvents.AfterDropGenericTableEvent event) {
        this.recordEvent(event);
    }

    @Override
    public void onBeforeListGenericTables(CatalogGenericTableServiceEvents.BeforeListGenericTablesEvent event) {
        this.recordEvent(event);
    }

    @Override
    public void onAfterListGenericTables(CatalogGenericTableServiceEvents.AfterListGenericTablesEvent event) {
        this.recordEvent(event);
    }

    @Override
    public void onBeforeLoadGenericTable(CatalogGenericTableServiceEvents.BeforeLoadGenericTableEvent event) {
        this.recordEvent(event);
    }

    @Override
    public void onAfterLoadGenericTable(CatalogGenericTableServiceEvents.AfterLoadGenericTableEvent event) {
        this.recordEvent(event);
    }

    @Override
    public void onBeforeAttemptTask(BeforeAttemptTaskEvent event) {
        this.recordEvent(event);
    }

    @Override
    public void onAfterAttemptTask(AfterAttemptTaskEvent event) {
        this.recordEvent(event);
    }

    @Override
    public void onBeforeLimitRequestRate(BeforeLimitRequestRateEvent event) {
        this.recordEvent(event);
    }
}

