/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.catalog.policy;

import com.google.common.base.Strings;
import jakarta.annotation.Nullable;
import jakarta.enterprise.inject.Instance;
import jakarta.ws.rs.core.SecurityContext;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.exceptions.NoSuchNamespaceException;
import org.apache.iceberg.exceptions.NoSuchTableException;
import org.apache.iceberg.exceptions.NotFoundException;
import org.apache.polaris.core.PolarisDiagnostics;
import org.apache.polaris.core.auth.PolarisAuthorizableOperation;
import org.apache.polaris.core.auth.PolarisAuthorizer;
import org.apache.polaris.core.catalog.ExternalCatalogFactory;
import org.apache.polaris.core.catalog.PolarisCatalogHelpers;
import org.apache.polaris.core.context.CallContext;
import org.apache.polaris.core.entity.PolarisEntitySubType;
import org.apache.polaris.core.entity.PolarisEntityType;
import org.apache.polaris.core.persistence.PolarisMetaStoreManager;
import org.apache.polaris.core.persistence.PolarisResolvedPathWrapper;
import org.apache.polaris.core.persistence.resolver.PolarisResolutionManifestCatalogView;
import org.apache.polaris.core.persistence.resolver.ResolutionManifestFactory;
import org.apache.polaris.core.persistence.resolver.ResolverPath;
import org.apache.polaris.core.persistence.resolver.ResolverStatus;
import org.apache.polaris.core.policy.PolicyType;
import org.apache.polaris.core.policy.exceptions.NoSuchPolicyException;
import org.apache.polaris.core.secrets.UserSecretsManager;
import org.apache.polaris.service.catalog.common.CatalogHandler;
import org.apache.polaris.service.catalog.policy.PolicyCatalog;
import org.apache.polaris.service.catalog.policy.PolicyCatalogUtils;
import org.apache.polaris.service.types.ApplicablePolicy;
import org.apache.polaris.service.types.AttachPolicyRequest;
import org.apache.polaris.service.types.CreatePolicyRequest;
import org.apache.polaris.service.types.DetachPolicyRequest;
import org.apache.polaris.service.types.GetApplicablePoliciesResponse;
import org.apache.polaris.service.types.ListPoliciesResponse;
import org.apache.polaris.service.types.LoadPolicyResponse;
import org.apache.polaris.service.types.PolicyAttachmentTarget;
import org.apache.polaris.service.types.PolicyIdentifier;
import org.apache.polaris.service.types.UpdatePolicyRequest;

public class PolicyCatalogHandler
extends CatalogHandler {
    private PolarisMetaStoreManager metaStoreManager;
    private PolicyCatalog policyCatalog;

    public PolicyCatalogHandler(PolarisDiagnostics diagnostics, CallContext callContext, ResolutionManifestFactory resolutionManifestFactory, PolarisMetaStoreManager metaStoreManager, SecurityContext securityContext, String catalogName, PolarisAuthorizer authorizer, UserSecretsManager userSecretsManager, Instance<ExternalCatalogFactory> externalCatalogFactories) {
        super(diagnostics, callContext, resolutionManifestFactory, securityContext, catalogName, authorizer, userSecretsManager, externalCatalogFactories);
        this.metaStoreManager = metaStoreManager;
    }

    @Override
    protected void initializeCatalog() {
        this.policyCatalog = new PolicyCatalog(this.metaStoreManager, this.callContext, (PolarisResolutionManifestCatalogView)this.resolutionManifest);
    }

    public ListPoliciesResponse listPolicies(Namespace parent, @Nullable PolicyType policyType) {
        PolarisAuthorizableOperation op = PolarisAuthorizableOperation.LIST_POLICY;
        this.authorizeBasicNamespaceOperationOrThrow(op, parent);
        return ListPoliciesResponse.builder().setIdentifiers(new HashSet<PolicyIdentifier>(this.policyCatalog.listPolicies(parent, policyType))).build();
    }

    public LoadPolicyResponse createPolicy(Namespace namespace, CreatePolicyRequest request) {
        PolarisAuthorizableOperation op = PolarisAuthorizableOperation.CREATE_POLICY;
        PolicyIdentifier identifier = PolicyIdentifier.builder().setNamespace(namespace).setName(request.getName()).build();
        this.authorizeBasicNamespaceOperationOrThrow(op, identifier.getNamespace(), null, null, List.of(identifier));
        return LoadPolicyResponse.builder().setPolicy(this.policyCatalog.createPolicy(identifier, request.getType(), request.getDescription(), request.getContent())).build();
    }

    public LoadPolicyResponse loadPolicy(PolicyIdentifier identifier) {
        PolarisAuthorizableOperation op = PolarisAuthorizableOperation.LOAD_POLICY;
        this.authorizeBasicPolicyOperationOrThrow(op, identifier);
        return LoadPolicyResponse.builder().setPolicy(this.policyCatalog.loadPolicy(identifier)).build();
    }

    public LoadPolicyResponse updatePolicy(PolicyIdentifier identifier, UpdatePolicyRequest request) {
        PolarisAuthorizableOperation op = PolarisAuthorizableOperation.UPDATE_POLICY;
        this.authorizeBasicPolicyOperationOrThrow(op, identifier);
        return LoadPolicyResponse.builder().setPolicy(this.policyCatalog.updatePolicy(identifier, request.getDescription(), request.getContent(), request.getCurrentPolicyVersion())).build();
    }

    public boolean dropPolicy(PolicyIdentifier identifier, boolean detachAll) {
        PolarisAuthorizableOperation op = PolarisAuthorizableOperation.DROP_POLICY;
        this.authorizeBasicPolicyOperationOrThrow(op, identifier);
        return this.policyCatalog.dropPolicy(identifier, detachAll);
    }

    public boolean attachPolicy(PolicyIdentifier identifier, AttachPolicyRequest request) {
        this.authorizePolicyMappingOperationOrThrow(identifier, request.getTarget(), true);
        return this.policyCatalog.attachPolicy(identifier, request.getTarget(), request.getParameters());
    }

    public boolean detachPolicy(PolicyIdentifier identifier, DetachPolicyRequest request) {
        this.authorizePolicyMappingOperationOrThrow(identifier, request.getTarget(), false);
        return this.policyCatalog.detachPolicy(identifier, request.getTarget());
    }

    public GetApplicablePoliciesResponse getApplicablePolicies(@Nullable Namespace namespace, @Nullable String targetName, @Nullable PolicyType policyType) {
        this.authorizeGetApplicablePoliciesOperationOrThrow(namespace, targetName);
        return GetApplicablePoliciesResponse.builder().setApplicablePolicies(new HashSet<ApplicablePolicy>(this.policyCatalog.getApplicablePolicies(namespace, targetName, policyType))).build();
    }

    private void authorizeBasicPolicyOperationOrThrow(PolarisAuthorizableOperation op, PolicyIdentifier identifier) {
        this.resolutionManifest = this.newResolutionManifest();
        this.resolutionManifest.addPassthroughPath(new ResolverPath(PolarisCatalogHelpers.identifierToList((Namespace)identifier.getNamespace(), (String)identifier.getName()), PolarisEntityType.POLICY, true), (Object)identifier);
        this.resolutionManifest.resolveAll();
        PolarisResolvedPathWrapper target = this.resolutionManifest.getResolvedPath((Object)identifier, true);
        if (target == null) {
            throw new NoSuchPolicyException(String.format("Policy does not exist: %s", identifier));
        }
        this.authorizer.authorizeOrThrow(this.polarisPrincipal, this.resolutionManifest.getAllActivatedCatalogRoleAndPrincipalRoles(), op, target, null);
        this.initializeCatalog();
    }

    private void authorizeGetApplicablePoliciesOperationOrThrow(@Nullable Namespace namespace, @Nullable String targetName) {
        if (namespace == null || namespace.isEmpty()) {
            PolarisAuthorizableOperation op = PolarisAuthorizableOperation.GET_APPLICABLE_POLICIES_ON_CATALOG;
            this.authorizeBasicCatalogOperationOrThrow(op);
        } else if (Strings.isNullOrEmpty((String)targetName)) {
            PolarisAuthorizableOperation op = PolarisAuthorizableOperation.GET_APPLICABLE_POLICIES_ON_NAMESPACE;
            this.authorizeBasicNamespaceOperationOrThrow(op, namespace);
        } else {
            TableIdentifier tableIdentifier = TableIdentifier.of((Namespace)namespace, (String)targetName);
            PolarisAuthorizableOperation op = PolarisAuthorizableOperation.GET_APPLICABLE_POLICIES_ON_TABLE;
            this.authorizeBasicTableLikeOperationOrThrow(op, PolarisEntitySubType.ICEBERG_TABLE, tableIdentifier);
        }
    }

    private void authorizeBasicCatalogOperationOrThrow(PolarisAuthorizableOperation op) {
        this.resolutionManifest = this.newResolutionManifest();
        this.resolutionManifest.resolveAll();
        PolarisResolvedPathWrapper targetCatalog = this.resolutionManifest.getResolvedReferenceCatalogEntity();
        if (targetCatalog == null) {
            throw new NotFoundException("Catalog not found", new Object[0]);
        }
        this.authorizer.authorizeOrThrow(this.polarisPrincipal, this.resolutionManifest.getAllActivatedCatalogRoleAndPrincipalRoles(), op, targetCatalog, null);
        this.initializeCatalog();
    }

    private void authorizePolicyMappingOperationOrThrow(PolicyIdentifier identifier, PolicyAttachmentTarget target, boolean isAttach) {
        this.resolutionManifest = this.newResolutionManifest();
        this.resolutionManifest.addPassthroughPath(new ResolverPath(PolarisCatalogHelpers.identifierToList((Namespace)identifier.getNamespace(), (String)identifier.getName()), PolarisEntityType.POLICY, true), (Object)identifier);
        switch (target.getType()) {
            case CATALOG: {
                break;
            }
            case NAMESPACE: {
                Namespace targetNamespace = Namespace.of((String[])target.getPath().toArray(new String[0]));
                this.resolutionManifest.addPath(new ResolverPath(Arrays.asList(targetNamespace.levels()), PolarisEntityType.NAMESPACE), (Object)targetNamespace);
                break;
            }
            case TABLE_LIKE: {
                TableIdentifier targetIdentifier = TableIdentifier.of((String[])target.getPath().toArray(new String[0]));
                this.resolutionManifest.addPath(new ResolverPath(PolarisCatalogHelpers.tableIdentifierToList((TableIdentifier)targetIdentifier), PolarisEntityType.TABLE_LIKE), (Object)targetIdentifier);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported target type: " + String.valueOf(target.getType()));
            }
        }
        ResolverStatus status = this.resolutionManifest.resolveAll();
        this.throwNotFoundExceptionIfFailToResolve(status, identifier);
        PolarisResolvedPathWrapper policyWrapper = this.resolutionManifest.getPassthroughResolvedPath((Object)identifier, PolarisEntityType.POLICY, PolarisEntitySubType.NULL_SUBTYPE);
        if (policyWrapper == null) {
            throw new NoSuchPolicyException(String.format("Policy does not exist: %s", identifier));
        }
        PolarisResolvedPathWrapper targetWrapper = PolicyCatalogUtils.getResolvedPathWrapper(this.resolutionManifest, target);
        PolarisAuthorizableOperation op = this.determinePolicyMappingOperation(target, targetWrapper, isAttach);
        this.authorizer.authorizeOrThrow(this.polarisPrincipal, this.resolutionManifest.getAllActivatedCatalogRoleAndPrincipalRoles(), op, policyWrapper, targetWrapper);
        this.initializeCatalog();
    }

    private PolarisAuthorizableOperation determinePolicyMappingOperation(PolicyAttachmentTarget target, PolarisResolvedPathWrapper targetWrapper, boolean isAttach) {
        return switch (targetWrapper.getRawLeafEntity().getType()) {
            case PolarisEntityType.CATALOG -> {
                if (isAttach) {
                    yield PolarisAuthorizableOperation.ATTACH_POLICY_TO_CATALOG;
                }
                yield PolarisAuthorizableOperation.DETACH_POLICY_FROM_CATALOG;
            }
            case PolarisEntityType.NAMESPACE -> {
                if (isAttach) {
                    yield PolarisAuthorizableOperation.ATTACH_POLICY_TO_NAMESPACE;
                }
                yield PolarisAuthorizableOperation.DETACH_POLICY_FROM_NAMESPACE;
            }
            case PolarisEntityType.TABLE_LIKE -> {
                PolarisEntitySubType subType = targetWrapper.getRawLeafEntity().getSubType();
                if (subType == PolarisEntitySubType.ICEBERG_TABLE) {
                    if (isAttach) {
                        yield PolarisAuthorizableOperation.ATTACH_POLICY_TO_TABLE;
                    }
                    yield PolarisAuthorizableOperation.DETACH_POLICY_FROM_TABLE;
                }
                throw new IllegalArgumentException("Unsupported table-like subtype: " + String.valueOf(subType));
            }
            default -> throw new IllegalArgumentException("Unsupported target type: " + String.valueOf(target.getType()));
        };
    }

    private void throwNotFoundExceptionIfFailToResolve(ResolverStatus status, PolicyIdentifier identifier) {
        if (status.getStatus() == ResolverStatus.StatusEnum.PATH_COULD_NOT_BE_FULLY_RESOLVED) {
            switch (status.getFailedToResolvePath().getLastEntityType()) {
                case TABLE_LIKE: {
                    throw new NoSuchTableException("Table or view does not exist: %s", new Object[]{PolarisCatalogHelpers.listToTableIdentifier((List)status.getFailedToResolvePath().getEntityNames())});
                }
                case NAMESPACE: {
                    throw new NoSuchNamespaceException("Namespace does not exist: %s", new Object[]{Namespace.of((String[])status.getFailedToResolvePath().getEntityNames().toArray(new String[0]))});
                }
                case POLICY: {
                    throw new NoSuchPolicyException(String.format("Policy does not exist: %s", identifier));
                }
            }
            throw new IllegalStateException("Cannot resolve");
        }
    }
}

