/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.admin;

import jakarta.annotation.Priority;
import jakarta.decorator.Decorator;
import jakarta.decorator.Delegate;
import jakarta.inject.Inject;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.SecurityContext;
import org.apache.polaris.core.admin.model.CreatePrincipalRequest;
import org.apache.polaris.core.admin.model.GrantPrincipalRoleRequest;
import org.apache.polaris.core.admin.model.Principal;
import org.apache.polaris.core.admin.model.PrincipalWithCredentials;
import org.apache.polaris.core.admin.model.ResetPrincipalRequest;
import org.apache.polaris.core.admin.model.UpdatePrincipalRequest;
import org.apache.polaris.core.context.RealmContext;
import org.apache.polaris.service.admin.api.PolarisPrincipalsApiService;
import org.apache.polaris.service.events.PrincipalsServiceEvents;
import org.apache.polaris.service.events.listeners.PolarisEventListener;

@Decorator
@Priority(value=1000)
public class PolarisPrincipalsEventServiceDelegator
implements PolarisPrincipalsApiService {
    @Inject
    @Delegate
    PolarisPrincipalsApiService delegate;
    @Inject
    PolarisEventListener polarisEventListener;

    public Response createPrincipal(CreatePrincipalRequest request, RealmContext realmContext, SecurityContext securityContext) {
        this.polarisEventListener.onBeforeCreatePrincipal(new PrincipalsServiceEvents.BeforeCreatePrincipalEvent(request.getPrincipal().getName()));
        Response resp = this.delegate.createPrincipal(request, realmContext, securityContext);
        this.polarisEventListener.onAfterCreatePrincipal(new PrincipalsServiceEvents.AfterCreatePrincipalEvent(((PrincipalWithCredentials)resp.getEntity()).getPrincipal()));
        return resp;
    }

    public Response resetCredentials(String principalName, ResetPrincipalRequest resetPrincipalRequest, RealmContext realmContext, SecurityContext securityContext) {
        this.polarisEventListener.onBeforeResetCredentials(new PrincipalsServiceEvents.BeforeResetCredentialsEvent(principalName));
        Response resp = this.delegate.resetCredentials(principalName, resetPrincipalRequest, realmContext, securityContext);
        this.polarisEventListener.onAfterResetCredentials(new PrincipalsServiceEvents.AfterResetCredentialsEvent(((PrincipalWithCredentials)resp.getEntity()).getPrincipal()));
        return resp;
    }

    public Response deletePrincipal(String principalName, RealmContext realmContext, SecurityContext securityContext) {
        this.polarisEventListener.onBeforeDeletePrincipal(new PrincipalsServiceEvents.BeforeDeletePrincipalEvent(principalName));
        Response resp = this.delegate.deletePrincipal(principalName, realmContext, securityContext);
        this.polarisEventListener.onAfterDeletePrincipal(new PrincipalsServiceEvents.AfterDeletePrincipalEvent(principalName));
        return resp;
    }

    public Response getPrincipal(String principalName, RealmContext realmContext, SecurityContext securityContext) {
        this.polarisEventListener.onBeforeGetPrincipal(new PrincipalsServiceEvents.BeforeGetPrincipalEvent(principalName));
        Response resp = this.delegate.getPrincipal(principalName, realmContext, securityContext);
        this.polarisEventListener.onAfterGetPrincipal(new PrincipalsServiceEvents.AfterGetPrincipalEvent((Principal)resp.getEntity()));
        return resp;
    }

    public Response updatePrincipal(String principalName, UpdatePrincipalRequest updateRequest, RealmContext realmContext, SecurityContext securityContext) {
        this.polarisEventListener.onBeforeUpdatePrincipal(new PrincipalsServiceEvents.BeforeUpdatePrincipalEvent(principalName, updateRequest));
        Response resp = this.delegate.updatePrincipal(principalName, updateRequest, realmContext, securityContext);
        this.polarisEventListener.onAfterUpdatePrincipal(new PrincipalsServiceEvents.AfterUpdatePrincipalEvent((Principal)resp.getEntity()));
        return resp;
    }

    public Response rotateCredentials(String principalName, RealmContext realmContext, SecurityContext securityContext) {
        this.polarisEventListener.onBeforeRotateCredentials(new PrincipalsServiceEvents.BeforeRotateCredentialsEvent(principalName));
        Response resp = this.delegate.rotateCredentials(principalName, realmContext, securityContext);
        PrincipalWithCredentials principalWithCredentials = (PrincipalWithCredentials)resp.getEntity();
        this.polarisEventListener.onAfterRotateCredentials(new PrincipalsServiceEvents.AfterRotateCredentialsEvent(principalWithCredentials.getPrincipal()));
        return resp;
    }

    public Response listPrincipals(RealmContext realmContext, SecurityContext securityContext) {
        this.polarisEventListener.onBeforeListPrincipals(new PrincipalsServiceEvents.BeforeListPrincipalsEvent());
        Response resp = this.delegate.listPrincipals(realmContext, securityContext);
        this.polarisEventListener.onAfterListPrincipals(new PrincipalsServiceEvents.AfterListPrincipalsEvent());
        return resp;
    }

    public Response assignPrincipalRole(String principalName, GrantPrincipalRoleRequest request, RealmContext realmContext, SecurityContext securityContext) {
        this.polarisEventListener.onBeforeAssignPrincipalRole(new PrincipalsServiceEvents.BeforeAssignPrincipalRoleEvent(principalName, request.getPrincipalRole()));
        Response resp = this.delegate.assignPrincipalRole(principalName, request, realmContext, securityContext);
        this.polarisEventListener.onAfterAssignPrincipalRole(new PrincipalsServiceEvents.AfterAssignPrincipalRoleEvent(principalName, request.getPrincipalRole()));
        return resp;
    }

    public Response revokePrincipalRole(String principalName, String principalRoleName, RealmContext realmContext, SecurityContext securityContext) {
        this.polarisEventListener.onBeforeRevokePrincipalRole(new PrincipalsServiceEvents.BeforeRevokePrincipalRoleEvent(principalName, principalRoleName));
        Response resp = this.delegate.revokePrincipalRole(principalName, principalRoleName, realmContext, securityContext);
        this.polarisEventListener.onAfterRevokePrincipalRole(new PrincipalsServiceEvents.AfterRevokePrincipalRoleEvent(principalName, principalRoleName));
        return resp;
    }

    public Response listPrincipalRolesAssigned(String principalName, RealmContext realmContext, SecurityContext securityContext) {
        this.polarisEventListener.onBeforeListAssignedPrincipalRoles(new PrincipalsServiceEvents.BeforeListAssignedPrincipalRolesEvent(principalName));
        Response resp = this.delegate.listPrincipalRolesAssigned(principalName, realmContext, securityContext);
        this.polarisEventListener.onAfterListAssignedPrincipalRoles(new PrincipalsServiceEvents.AfterListAssignedPrincipalRolesEvent(principalName));
        return resp;
    }
}

