/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum EventSource {
    CLOUD_TRAIL("CloudTrail"),
    ROUTE53_RESOLVER("Route53Resolver"),
    VPC_FLOW("VPCFlow"),
    EKS_AUDIT("EKSAudit"),
    AWSWAF("AWSWAF"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, EventSource> VALUE_MAP;
    private final String value;

    private EventSource(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static EventSource fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<EventSource> knownValues() {
        EnumSet<EventSource> knownValues = EnumSet.allOf(EventSource.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(EventSource.class, EventSource::toString);
    }
}

