/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage;

import com.google.cloud.BaseServiceException;
import com.google.cloud.storage.BidiUploadStreamingStream;
import com.google.cloud.storage.Buffers;
import com.google.cloud.storage.ChunkSegmenter;
import com.google.cloud.storage.RewindableContent;
import com.google.cloud.storage.StorageException;
import com.google.cloud.storage.UnbufferedWritableByteChannelSession;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

final class BidiAppendableUnbufferedWritableByteChannel
implements UnbufferedWritableByteChannelSession.UnbufferedWritableByteChannel {
    private final BidiUploadStreamingStream stream;
    private final ChunkSegmenter chunkSegmenter;
    private final long flushInterval;
    private boolean open;
    private long writeOffset;
    private volatile boolean nextWriteShouldFinalize;
    private boolean writeCalledAtLeastOnce;
    private long lastFlushOffset;
    private boolean writeThrewError;

    BidiAppendableUnbufferedWritableByteChannel(BidiUploadStreamingStream stream, ChunkSegmenter chunkSegmenter, long flushInterval, long writeOffset) {
        this.stream = stream;
        this.chunkSegmenter = chunkSegmenter;
        this.flushInterval = flushInterval;
        this.open = true;
        this.writeOffset = writeOffset;
        this.nextWriteShouldFinalize = false;
        this.writeThrewError = false;
        this.lastFlushOffset = writeOffset;
    }

    @Override
    public long write(ByteBuffer[] srcs, int srcsOffset, int srcsLength) throws IOException {
        return this.internalWrite(srcs, srcsOffset, srcsLength);
    }

    @Override
    public long writeAndClose(ByteBuffer[] srcs, int offset, int length) throws IOException {
        long totalRemaining = Buffers.totalRemaining(srcs, offset, length);
        long written = 0L;
        while ((written += this.internalWrite(srcs, offset, length)) < totalRemaining) {
        }
        this.close();
        return written;
    }

    @Override
    public boolean isOpen() {
        return this.open;
    }

    @Override
    public void close() throws IOException {
        if (!this.open) {
            return;
        }
        try {
            if (this.writeThrewError) {
                return;
            }
            if (!this.writeCalledAtLeastOnce) {
                this.stream.flush();
            }
            if (this.nextWriteShouldFinalize) {
                while (!this.stream.finishWrite(this.writeOffset)) {
                }
            } else {
                while (!this.stream.closeStream(this.writeOffset)) {
                }
            }
            this.awaitResultFuture();
        }
        finally {
            this.stream.sendClose();
            this.open = false;
        }
    }

    public void nextWriteShouldFinalize() {
        this.nextWriteShouldFinalize = true;
    }

    void flush() throws InterruptedException {
        this.stream.flush();
        this.stream.awaitAckOf(this.writeOffset);
    }

    private long internalWrite(ByteBuffer[] srcs, int srcsOffset, int srcsLength) throws IOException {
        if (!this.open) {
            throw new ClosedChannelException();
        }
        if (this.stream.getResultFuture().isDone()) {
            this.awaitResultFuture();
            return 0L;
        }
        this.writeCalledAtLeastOnce = true;
        long availableCapacity = this.stream.availableCapacity();
        if (availableCapacity <= 0L) {
            return 0L;
        }
        RewindableContent rewindableContent = RewindableContent.of(srcs, srcsOffset, srcsLength);
        long totalBufferRemaining = rewindableContent.getLength();
        ChunkSegmenter.ChunkSegment[] data = this.chunkSegmenter.segmentBuffers(srcs, srcsOffset, srcsLength, true, availableCapacity);
        if (data.length == 0) {
            return 0L;
        }
        rewindableContent.flagDirty();
        long remainingAfterPacking = Buffers.totalRemaining(srcs, srcsOffset, srcsLength);
        long bytesConsumed = 0L;
        int len = data.length;
        int lastIdx = len - 1;
        for (int i = 0; i < len; ++i) {
            boolean shouldFlush;
            ChunkSegmenter.ChunkSegment datum = data[i];
            int size = datum.getB().size();
            boolean bl = shouldFlush = this.writeOffset + (long)size >= this.lastFlushOffset + this.flushInterval;
            boolean appended = i < lastIdx && !shouldFlush ? this.stream.append(datum) : (i == lastIdx && remainingAfterPacking == 0L && this.nextWriteShouldFinalize ? this.stream.appendAndFinalize(datum) : this.stream.appendAndFlush(datum));
            if (appended) {
                bytesConsumed += (long)size;
                this.writeOffset += (long)size;
                if (!shouldFlush) continue;
                this.lastFlushOffset = this.writeOffset;
                continue;
            }
            this.stream.flush();
            break;
        }
        if (bytesConsumed != totalBufferRemaining) {
            rewindableContent.rewindTo(bytesConsumed);
        }
        return bytesConsumed;
    }

    private void awaitResultFuture() throws IOException {
        try {
            this.stream.awaitAckOf(this.writeOffset);
            this.stream.getResultFuture().get(10717L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            InterruptedIOException ioe = new InterruptedIOException();
            ioe.initCause(e);
            this.writeThrewError = true;
            throw ioe;
        }
        catch (ExecutionException e) {
            int firstNewLineIndex;
            String message;
            BaseServiceException coalesce = StorageException.coalesce(e.getCause());
            String ioExceptionMessage = message = coalesce.getMessage();
            int n = firstNewLineIndex = message != null ? message.indexOf(10) : -1;
            if (firstNewLineIndex > -1) {
                ioExceptionMessage = message.substring(0, firstNewLineIndex);
            }
            IOException ioException = new IOException(ioExceptionMessage, (Throwable)coalesce);
            this.writeThrewError = true;
            throw ioException;
        }
        catch (TimeoutException e) {
            this.writeThrewError = true;
            throw new IOException(e);
        }
    }
}

