/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.rds.RdsClient;
import software.amazon.awssdk.services.rds.internal.UserAgentUtils;
import software.amazon.awssdk.services.rds.model.DBInstanceAutomatedBackup;
import software.amazon.awssdk.services.rds.model.DescribeDbInstanceAutomatedBackupsRequest;
import software.amazon.awssdk.services.rds.model.DescribeDbInstanceAutomatedBackupsResponse;

public class DescribeDBInstanceAutomatedBackupsIterable
implements SdkIterable<DescribeDbInstanceAutomatedBackupsResponse> {
    private final RdsClient client;
    private final DescribeDbInstanceAutomatedBackupsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeDBInstanceAutomatedBackupsIterable(RdsClient client, DescribeDbInstanceAutomatedBackupsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeDbInstanceAutomatedBackupsResponseFetcher();
    }

    public Iterator<DescribeDbInstanceAutomatedBackupsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<DBInstanceAutomatedBackup> dbInstanceAutomatedBackups() {
        Function<DescribeDbInstanceAutomatedBackupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.dbInstanceAutomatedBackups() != null) {
                return response.dbInstanceAutomatedBackups().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeDbInstanceAutomatedBackupsResponseFetcher
    implements SyncPageFetcher<DescribeDbInstanceAutomatedBackupsResponse> {
        private DescribeDbInstanceAutomatedBackupsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeDbInstanceAutomatedBackupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public DescribeDbInstanceAutomatedBackupsResponse nextPage(DescribeDbInstanceAutomatedBackupsResponse previousPage) {
            if (previousPage == null) {
                return DescribeDBInstanceAutomatedBackupsIterable.this.client.describeDBInstanceAutomatedBackups(DescribeDBInstanceAutomatedBackupsIterable.this.firstRequest);
            }
            return DescribeDBInstanceAutomatedBackupsIterable.this.client.describeDBInstanceAutomatedBackups((DescribeDbInstanceAutomatedBackupsRequest)((Object)DescribeDBInstanceAutomatedBackupsIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

