/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum EndpointNetworkType {
    IPV4("IPV4"),
    IPV6("IPV6"),
    DUAL("DUAL"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, EndpointNetworkType> VALUE_MAP;
    private final String value;

    private EndpointNetworkType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static EndpointNetworkType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<EndpointNetworkType> knownValues() {
        EnumSet<EndpointNetworkType> knownValues = EnumSet.allOf(EndpointNetworkType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(EndpointNetworkType.class, EndpointNetworkType::toString);
    }
}

