/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.deletes;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Collection;
import java.util.List;
import java.util.function.LongConsumer;
import java.util.zip.CRC32;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.deletes.PositionDeleteIndex;
import org.apache.iceberg.deletes.RoaringPositionBitmap;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;

class BitmapPositionDeleteIndex
implements PositionDeleteIndex {
    private static final int LENGTH_SIZE_BYTES = 4;
    private static final int MAGIC_NUMBER_SIZE_BYTES = 4;
    private static final int CRC_SIZE_BYTES = 4;
    private static final int BITMAP_DATA_OFFSET = 4;
    private static final int MAGIC_NUMBER = 1681511377;
    private final RoaringPositionBitmap bitmap;
    private final List<DeleteFile> deleteFiles;

    BitmapPositionDeleteIndex() {
        this.bitmap = new RoaringPositionBitmap();
        this.deleteFiles = Lists.newArrayList();
    }

    BitmapPositionDeleteIndex(Collection<DeleteFile> deleteFiles) {
        this.bitmap = new RoaringPositionBitmap();
        this.deleteFiles = Lists.newArrayList(deleteFiles);
    }

    BitmapPositionDeleteIndex(DeleteFile deleteFile) {
        this.bitmap = new RoaringPositionBitmap();
        this.deleteFiles = deleteFile != null ? Lists.newArrayList((Object[])new DeleteFile[]{deleteFile}) : Lists.newArrayList();
    }

    BitmapPositionDeleteIndex(RoaringPositionBitmap bitmap, DeleteFile deleteFile) {
        this.bitmap = bitmap;
        this.deleteFiles = deleteFile != null ? Lists.newArrayList((Object[])new DeleteFile[]{deleteFile}) : Lists.newArrayList();
    }

    void merge(BitmapPositionDeleteIndex that) {
        this.bitmap.setAll(that.bitmap);
        this.deleteFiles.addAll(that.deleteFiles);
    }

    @Override
    public void delete(long position) {
        this.bitmap.set(position);
    }

    @Override
    public void delete(long posStart, long posEnd) {
        this.bitmap.setRange(posStart, posEnd);
    }

    @Override
    public void merge(PositionDeleteIndex that) {
        if (that instanceof BitmapPositionDeleteIndex) {
            this.merge((BitmapPositionDeleteIndex)that);
        } else {
            that.forEach(this::delete);
            this.deleteFiles.addAll(that.deleteFiles());
        }
    }

    @Override
    public boolean isDeleted(long position) {
        return this.bitmap.contains(position);
    }

    @Override
    public boolean isEmpty() {
        return this.bitmap.isEmpty();
    }

    @Override
    public void forEach(LongConsumer consumer) {
        this.bitmap.forEach(consumer);
    }

    @Override
    public Collection<DeleteFile> deleteFiles() {
        return this.deleteFiles;
    }

    @Override
    public long cardinality() {
        return this.bitmap.cardinality();
    }

    @Override
    public ByteBuffer serialize() {
        this.bitmap.runLengthEncode();
        int bitmapDataLength = BitmapPositionDeleteIndex.computeBitmapDataLength(this.bitmap);
        byte[] bytes = new byte[4 + bitmapDataLength + 4];
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        buffer.putInt(bitmapDataLength);
        BitmapPositionDeleteIndex.serializeBitmapData(bytes, bitmapDataLength, this.bitmap);
        int crcOffset = 4 + bitmapDataLength;
        int crc = BitmapPositionDeleteIndex.computeChecksum(bytes, bitmapDataLength);
        buffer.putInt(crcOffset, crc);
        buffer.rewind();
        return buffer;
    }

    public static PositionDeleteIndex deserialize(byte[] bytes, DeleteFile deleteFile) {
        int crcOffset;
        int expectedCrc;
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        int bitmapDataLength = BitmapPositionDeleteIndex.readBitmapDataLength(buffer, deleteFile);
        RoaringPositionBitmap bitmap = BitmapPositionDeleteIndex.deserializeBitmap(bytes, bitmapDataLength, deleteFile);
        int crc = BitmapPositionDeleteIndex.computeChecksum(bytes, bitmapDataLength);
        Preconditions.checkArgument((crc == (expectedCrc = buffer.getInt(crcOffset = 4 + bitmapDataLength)) ? 1 : 0) != 0, (Object)"Invalid CRC");
        return new BitmapPositionDeleteIndex(bitmap, deleteFile);
    }

    private static int computeBitmapDataLength(RoaringPositionBitmap bitmap) {
        long length = 4L + bitmap.serializedSizeInBytes();
        long bufferSize = 4L + length + 4L;
        Preconditions.checkState((bufferSize <= Integer.MAX_VALUE ? 1 : 0) != 0, (Object)"Can't serialize index > 2GB");
        return (int)length;
    }

    private static void serializeBitmapData(byte[] bytes, int bitmapDataLength, RoaringPositionBitmap bitmap) {
        ByteBuffer bitmapData = BitmapPositionDeleteIndex.pointToBitmapData(bytes, bitmapDataLength);
        bitmapData.putInt(1681511377);
        bitmap.serialize(bitmapData);
    }

    private static ByteBuffer pointToBitmapData(byte[] bytes, int bitmapDataLength) {
        ByteBuffer bitmapData = ByteBuffer.wrap(bytes, 4, bitmapDataLength);
        bitmapData.order(ByteOrder.LITTLE_ENDIAN);
        return bitmapData;
    }

    private static int readBitmapDataLength(ByteBuffer buffer, DeleteFile deleteFile) {
        long expectedLength;
        int length = buffer.getInt();
        Preconditions.checkArgument(((long)length == (expectedLength = deleteFile.contentSizeInBytes() - 4L - 4L) ? 1 : 0) != 0, (String)"Invalid bitmap data length: %s, expected %s", (int)length, (long)expectedLength);
        return length;
    }

    private static RoaringPositionBitmap deserializeBitmap(byte[] bytes, int bitmapDataLength, DeleteFile deleteFile) {
        ByteBuffer bitmapData = BitmapPositionDeleteIndex.pointToBitmapData(bytes, bitmapDataLength);
        int magicNumber = bitmapData.getInt();
        Preconditions.checkArgument((magicNumber == 1681511377 ? 1 : 0) != 0, (String)"Invalid magic number: %s, expected %s", (int)magicNumber, (int)1681511377);
        RoaringPositionBitmap bitmap = RoaringPositionBitmap.deserialize(bitmapData);
        long cardinality = bitmap.cardinality();
        long expectedCardinality = deleteFile.recordCount();
        Preconditions.checkArgument((cardinality == expectedCardinality ? 1 : 0) != 0, (String)"Invalid cardinality: %s, expected %s", (long)cardinality, (long)expectedCardinality);
        return bitmap;
    }

    private static int computeChecksum(byte[] bytes, int bitmapDataLength) {
        CRC32 crc = new CRC32();
        crc.update(bytes, 4, bitmapDataLength);
        return (int)crc.getValue();
    }
}

