/*
 * Decompiled with CFR 0.152.
 */
package org.apache.livy.server.auth;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.NamingException;
import javax.naming.directory.InitialDirContext;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.StartTlsRequest;
import javax.naming.ldap.StartTlsResponse;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSession;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.apache.hadoop.security.authentication.client.AuthenticationException;
import org.apache.hadoop.security.authentication.server.AuthenticationHandler;
import org.apache.hadoop.security.authentication.server.AuthenticationToken;
import org.apache.livy.Logging;
import org.apache.livy.server.auth.LdapAuthenticationHandlerImpl$;
import org.apache.livy.server.auth.LdapUtils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001\tMs!B\u0001\u0003\u0011\u0003i\u0011!\b'eCB\fU\u000f\u001e5f]RL7-\u0019;j_:D\u0015M\u001c3mKJLU\u000e\u001d7\u000b\u0005\r!\u0011\u0001B1vi\"T!!\u0002\u0004\u0002\rM,'O^3s\u0015\t9\u0001\"\u0001\u0003mSZL(BA\u0005\u000b\u0003\u0019\t\u0007/Y2iK*\t1\"A\u0002pe\u001e\u001c\u0001\u0001\u0005\u0002\u000f\u001f5\t!AB\u0003\u0011\u0005!\u0005\u0011CA\u000fMI\u0006\u0004\u0018)\u001e;iK:$\u0018nY1uS>t\u0007*\u00198eY\u0016\u0014\u0018*\u001c9m'\ty!\u0003\u0005\u0002\u0014-5\tACC\u0001\u0016\u0003\u0015\u00198-\u00197b\u0013\t9BC\u0001\u0004B]f\u0014VM\u001a\u0005\u00063=!\tAG\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00035Aq\u0001H\bC\u0002\u0013\u0005Q$\u0001\u000bB+RCuJU%[\u0003RKuJT0T\u0007\"+U*R\u000b\u0002=A\u0011q\u0004J\u0007\u0002A)\u0011\u0011EI\u0001\u0005Y\u0006twMC\u0001$\u0003\u0011Q\u0017M^1\n\u0005\u0015\u0002#AB*ue&tw\r\u0003\u0004(\u001f\u0001\u0006IAH\u0001\u0016\u0003V#\u0006j\u0014*J5\u0006#\u0016j\u0014(`'\u000eCU)T#!\u0011\u001dIsB1A\u0005\u0002u\tA\u0001V-Q\u000b\"11f\u0004Q\u0001\ny\tQ\u0001V-Q\u000b\u0002Bq!L\bC\u0002\u0013\u0005Q$A\fT\u000b\u000e+&+\u0013+Z?\u0006+F\u000bS#O)&\u001b\u0015\tV%P\u001d\"1qf\u0004Q\u0001\ny\t\u0001dU#D+JKE+W0B+RCUI\u0014+J\u0007\u0006#\u0016j\u0014(!\u0011\u001d\ttB1A\u0005\u0002u\tA\u0002\u0015*P-&#UIU0V%2CaaM\b!\u0002\u0013q\u0012!\u0004)S\u001fZKE)\u0012*`+Jc\u0005\u0005C\u00046\u001f\t\u0007I\u0011A\u000f\u0002\u000f\t\u000b5+R0E\u001d\"1qg\u0004Q\u0001\ny\t\u0001BQ!T\u000b~#e\n\t\u0005\bs=\u0011\r\u0011\"\u0001\u001e\u0003AaE)\u0011)`\u0005&sEi\u0018#P\u001b\u0006Ke\n\u0003\u0004<\u001f\u0001\u0006IAH\u0001\u0012\u0019\u0012\u000b\u0005k\u0018\"J\u001d\u0012{FiT'B\u0013:\u0003\u0003bB\u001f\u0010\u0005\u0004%\t!H\u0001\u0011\u000b:\u000b%\tT#`'R\u000b%\u000bV0U\u0019NCaaP\b!\u0002\u0013q\u0012!E#O\u0003\ncUiX*U\u0003J#v\f\u0016'TA\u0019!\u0001C\u0001\u0001B'\u0011\u0001%)\u0012)\u0011\u0005}\u0019\u0015B\u0001#!\u0005\u0019y%M[3diB\u0011aIT\u0007\u0002\u000f*\u0011Q\u0001\u0013\u0006\u0003\u0013*\u000ba\"Y;uQ\u0016tG/[2bi&|gN\u0003\u0002L\u0019\u0006A1/Z2ve&$\u0018P\u0003\u0002N\u0011\u00051\u0001.\u00193p_BL!aT$\u0003+\u0005+H\u000f[3oi&\u001c\u0017\r^5p]\"\u000bg\u000e\u001a7feB\u0011\u0011KU\u0007\u0002\r%\u00111K\u0002\u0002\b\u0019><w-\u001b8h\u0011\u0015I\u0002\t\"\u0001V)\u00051\u0006C\u0001\bA\u0011\u001dA\u0006\t1A\u0005\nu\t!\u0002\u001c3ba\u0012{W.Y5o\u0011\u001dQ\u0006\t1A\u0005\nm\u000ba\u0002\u001c3ba\u0012{W.Y5o?\u0012*\u0017\u000f\u0006\u0002]?B\u00111#X\u0005\u0003=R\u0011A!\u00168ji\"9\u0001-WA\u0001\u0002\u0004q\u0012a\u0001=%c!1!\r\u0011Q!\ny\t1\u0002\u001c3ba\u0012{W.Y5oA!9A\r\u0011a\u0001\n\u0013i\u0012A\u00022bg\u0016$e\nC\u0004g\u0001\u0002\u0007I\u0011B4\u0002\u0015\t\f7/\u001a#O?\u0012*\u0017\u000f\u0006\u0002]Q\"9\u0001-ZA\u0001\u0002\u0004q\u0002B\u00026AA\u0003&a$A\u0004cCN,GI\u0014\u0011\t\u000f1\u0004\u0005\u0019!C\u0005;\u0005Y\u0001O]8wS\u0012,'/\u0016:m\u0011\u001dq\u0007\t1A\u0005\n=\fq\u0002\u001d:pm&$WM]+sY~#S-\u001d\u000b\u00039BDq\u0001Y7\u0002\u0002\u0003\u0007a\u0004\u0003\u0004s\u0001\u0002\u0006KAH\u0001\raJ|g/\u001b3feV\u0013H\u000e\t\u0005\bi\u0002\u0003\r\u0011\"\u0003v\u00039)g.\u00192mKN#\u0018M\u001d;UYN,\u0012A\u001e\t\u0003']L!\u0001\u001f\u000b\u0003\u000f\t{w\u000e\\3b]\"9!\u0010\u0011a\u0001\n\u0013Y\u0018AE3oC\ndWm\u0015;beR$Fn]0%KF$\"\u0001\u0018?\t\u000f\u0001L\u0018\u0011!a\u0001m\"1a\u0010\u0011Q!\nY\fq\"\u001a8bE2,7\u000b^1siRc7\u000f\t\u0005\t\u0003\u0003\u0001\u0005\u0019!C\u0005k\u0006YB-[:bE2,\u0007j\\:u\u001d\u0006lWMV3sS\u001aL7-\u0019;j_:D\u0011\"!\u0002A\u0001\u0004%I!a\u0002\u0002?\u0011L7/\u00192mK\"{7\u000f\u001e(b[\u00164VM]5gS\u000e\fG/[8o?\u0012*\u0017\u000fF\u0002]\u0003\u0013A\u0001\u0002YA\u0002\u0003\u0003\u0005\rA\u001e\u0005\b\u0003\u001b\u0001\u0005\u0015)\u0003w\u0003q!\u0017n]1cY\u0016Dun\u001d;OC6,g+\u001a:jM&\u001c\u0017\r^5p]\u0002Bq!!\u0005A\t\u0003\t\u0019\"A\u0004hKR$\u0016\u0010]3\u0015\u0005\u0005U\u0001\u0003BA\f\u0003;q1aEA\r\u0013\r\tY\u0002F\u0001\u0007!J,G-\u001a4\n\u0007\u0015\nyBC\u0002\u0002\u001cQAq!a\tA\t\u0003\t)#\u0001\u0003j]&$Hc\u0001/\u0002(!A\u0011\u0011FA\u0011\u0001\u0004\tY#\u0001\u0004d_:4\u0017n\u001a\t\u0005\u0003[\t\u0019$\u0004\u0002\u00020)\u0019\u0011\u0011\u0007\u0012\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003k\tyC\u0001\u0006Qe>\u0004XM\u001d;jKNDc!!\t\u0002:\u0005=\u0003#B\n\u0002<\u0005}\u0012bAA\u001f)\t1A\u000f\u001b:poN\u0004B!!\u0011\u0002L5\u0011\u00111\t\u0006\u0005\u0003\u000b\n9%A\u0004tKJ4H.\u001a;\u000b\u0005\u0005%\u0013!\u00026bm\u0006D\u0018\u0002BA'\u0003\u0007\u0012\u0001cU3sm2,G/\u0012=dKB$\u0018n\u001c82\u000fy\t)\"!\u0015\u0002\u0004FJ1%a\u0015\u0002\\\u0005e\u0014QL\u000b\u0005\u0003+\n9&\u0006\u0002\u0002\u0016\u00119\u0011\u0011\f\u0001C\u0002\u0005\r$!\u0001+\n\t\u0005u\u0013qL\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u0019\u000b\u0007\u0005\u0005D#\u0001\u0004uQJ|wo]\t\u0005\u0003K\nY\u0007E\u0002\u0014\u0003OJ1!!\u001b\u0015\u0005\u001dqu\u000e\u001e5j]\u001e\u0004B!!\u001c\u0002t9\u00191#a\u001c\n\u0007\u0005ED#A\u0004qC\u000e\\\u0017mZ3\n\t\u0005U\u0014q\u000f\u0002\n)\"\u0014xn^1cY\u0016T1!!\u001d\u0015c%\u0019\u00131PA?\u0003\u007f\n\tGD\u0002\u0014\u0003{J1!!\u0019\u0015c\u0015\u00113\u0003FAA\u0005\u0015\u00198-\u00197bc\r1\u0013q\b\u0005\b\u0003\u000f\u0003E\u0011AAE\u0003\u001d!Wm\u001d;s_f$\u0012\u0001\u0018\u0005\b\u0003\u001b\u0003E\u0011AAH\u0003Mi\u0017M\\1hK6,g\u000e^(qKJ\fG/[8o)\u001d1\u0018\u0011SAN\u0003WC\u0001\"a%\u0002\f\u0002\u0007\u0011QS\u0001\u0006i>\\WM\u001c\t\u0004\r\u0006]\u0015bAAM\u000f\n\u0019\u0012)\u001e;iK:$\u0018nY1uS>tGk\\6f]\"A\u0011QTAF\u0001\u0004\ty*A\u0004sKF,Xm\u001d;\u0011\t\u0005\u0005\u0016qU\u0007\u0003\u0003GSA!!*\u0002D\u0005!\u0001\u000e\u001e;q\u0013\u0011\tI+a)\u0003%!#H\u000f]*feZdW\r\u001e*fcV,7\u000f\u001e\u0005\t\u0003[\u000bY\t1\u0001\u00020\u0006A!/Z:q_:\u001cX\r\u0005\u0003\u0002\"\u0006E\u0016\u0002BAZ\u0003G\u00131\u0003\u0013;uaN+'O\u001e7fiJ+7\u000f]8og\u0016Dc!a#\u00028\u0006\u0015\u0007#B\n\u0002<\u0005e\u0006\u0003BA^\u0003\u0003l!!!0\u000b\u0007\u0005}\u0006*\u0001\u0004dY&,g\u000e^\u0005\u0005\u0003\u0007\fiLA\fBkRDWM\u001c;jG\u0006$\u0018n\u001c8Fq\u000e,\u0007\u000f^5p]F:a$!\u0006\u0002H\u00065\u0017'C\u0012\u0002T\u0005m\u0013\u0011ZA/c%\u0019\u00131PA?\u0003\u0017\f\t'M\u0003#'Q\t\t)M\u0002'\u0003sCc!a#\u0002R\u0006}\u0007#B\n\u0002<\u0005M\u0007\u0003BAk\u00037l!!a6\u000b\u0007\u0005e'%\u0001\u0002j_&!\u0011Q\\Al\u0005-Iu*\u0012=dKB$\u0018n\u001c82\u000fy\t)\"!9\u0002hFJ1%a\u0015\u0002\\\u0005\r\u0018QL\u0019\nG\u0005m\u0014QPAs\u0003C\nTAI\n\u0015\u0003\u0003\u000b4AJAj\u0011\u001d\tY\u000f\u0011C\u0001\u0003[\fA\"Y;uQ\u0016tG/[2bi\u0016$b!!&\u0002p\u0006E\b\u0002CAO\u0003S\u0004\r!a(\t\u0011\u00055\u0016\u0011\u001ea\u0001\u0003_Cc!!;\u00028\u0006U\u0018g\u0002\u0010\u0002\u0016\u0005]\u0018Q`\u0019\nG\u0005M\u00131LA}\u0003;\n\u0014bIA>\u0003{\nY0!\u00192\u000b\t\u001aB#!!2\u0007\u0019\nI\f\u000b\u0004\u0002j\u0006E'\u0011A\u0019\b=\u0005U!1\u0001B\u0005c%\u0019\u00131KA.\u0005\u000b\ti&M\u0005$\u0003w\niHa\u0002\u0002bE*!e\u0005\u000b\u0002\u0002F\u001aa%a5\t\u000f\t5\u0001\t\"\u0003\u0003\u0010\u0005\u0001\u0012-\u001e;iK:$\u0018nY1uKV\u001bXM\u001d\u000b\u0007\u0003+\u0013\tB!\u0006\t\u0011\tM!1\u0002a\u0001\u0003+\t\u0001\"^:fe:\u000bW.\u001a\u0005\t\u0005/\u0011Y\u00011\u0001\u0002\u0016\u0005A\u0001/Y:to>\u0014H\r\u000b\u0004\u0003\f\u0005]&1D\u0019\b=\u0005U!Q\u0004B\u0012c%\u0019\u00131KA.\u0005?\ti&M\u0005$\u0003w\niH!\t\u0002bE*!e\u0005\u000b\u0002\u0002F\u001aa%!/\t\u000f\t\u001d\u0002\t\"\u0003\u0003*\u0005a\u0012-\u001e;iK:$\u0018nY1uK^KG\u000f\u001b+mg\u0016CH/\u001a8tS>tG#\u0002/\u0003,\t=\u0002\u0002\u0003B\u0017\u0005K\u0001\r!!\u0006\u0002\rU\u001cXM\u001d#O\u0011!\u00119B!\nA\u0002\u0005U\u0001F\u0002B\u0013\u0003o\u0013\u0019$M\u0004\u001f\u0003+\u0011)Da\u000f2\u0013\r\n\u0019&a\u0017\u00038\u0005u\u0013'C\u0012\u0002|\u0005u$\u0011HA1c\u0015\u00113\u0003FAAc\r1\u0013\u0011\u0018\u0005\b\u0005\u007f\u0001E\u0011\u0002B!\u0003}\tW\u000f\u001e5f]RL7-\u0019;f/&$\bn\\;u)2\u001cX\t\u001f;f]NLwN\u001c\u000b\u00069\n\r#Q\t\u0005\t\u0005[\u0011i\u00041\u0001\u0002\u0016!A!q\u0003B\u001f\u0001\u0004\t)\u0002\u000b\u0004\u0003>\u0005]&\u0011J\u0019\b=\u0005U!1\nB)c%\u0019\u00131KA.\u0005\u001b\ni&M\u0005$\u0003w\niHa\u0014\u0002bE*!e\u0005\u000b\u0002\u0002F\u001aa%!/")
public class LdapAuthenticationHandlerImpl
implements AuthenticationHandler,
Logging {
    private String ldapDomain;
    private String baseDN;
    private String providerUrl;
    private boolean enableStartTls;
    private boolean disableHostNameVerification;
    private final Logger logger;
    private volatile boolean bitmap$0;

    public static String ENABLE_START_TLS() {
        return LdapAuthenticationHandlerImpl$.MODULE$.ENABLE_START_TLS();
    }

    public static String LDAP_BIND_DOMAIN() {
        return LdapAuthenticationHandlerImpl$.MODULE$.LDAP_BIND_DOMAIN();
    }

    public static String BASE_DN() {
        return LdapAuthenticationHandlerImpl$.MODULE$.BASE_DN();
    }

    public static String PROVIDER_URL() {
        return LdapAuthenticationHandlerImpl$.MODULE$.PROVIDER_URL();
    }

    public static String SECURITY_AUTHENTICATION() {
        return LdapAuthenticationHandlerImpl$.MODULE$.SECURITY_AUTHENTICATION();
    }

    public static String TYPE() {
        return LdapAuthenticationHandlerImpl$.MODULE$.TYPE();
    }

    public static String AUTHORIZATION_SCHEME() {
        return LdapAuthenticationHandlerImpl$.MODULE$.AUTHORIZATION_SCHEME();
    }

    private Logger logger$lzycompute() {
        LdapAuthenticationHandlerImpl ldapAuthenticationHandlerImpl = this;
        synchronized (ldapAuthenticationHandlerImpl) {
            if (!this.bitmap$0) {
                this.logger = Logging.class.logger((Logging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public void trace(Function0<Object> message) {
        Logging.class.trace((Logging)this, message);
    }

    public void debug(Function0<Object> message) {
        Logging.class.debug((Logging)this, message);
    }

    public void info(Function0<Object> message) {
        Logging.class.info((Logging)this, message);
    }

    public void warn(Function0<Object> message) {
        Logging.class.warn((Logging)this, message);
    }

    public void warn(Function0<Object> message, Throwable t) {
        Logging.class.warn((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message, Throwable t) {
        Logging.class.error((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message) {
        Logging.class.error((Logging)this, message);
    }

    private String ldapDomain() {
        return this.ldapDomain;
    }

    private void ldapDomain_$eq(String x$1) {
        this.ldapDomain = x$1;
    }

    private String baseDN() {
        return this.baseDN;
    }

    private void baseDN_$eq(String x$1) {
        this.baseDN = x$1;
    }

    private String providerUrl() {
        return this.providerUrl;
    }

    private void providerUrl_$eq(String x$1) {
        this.providerUrl = x$1;
    }

    private boolean enableStartTls() {
        return this.enableStartTls;
    }

    private void enableStartTls_$eq(boolean x$1) {
        this.enableStartTls = x$1;
    }

    private boolean disableHostNameVerification() {
        return this.disableHostNameVerification;
    }

    private void disableHostNameVerification_$eq(boolean x$1) {
        this.disableHostNameVerification = x$1;
    }

    public String getType() {
        return LdapAuthenticationHandlerImpl$.MODULE$.TYPE();
    }

    public void init(Properties config) throws ServletException {
        this.baseDN_$eq(config.getProperty(LdapAuthenticationHandlerImpl$.MODULE$.BASE_DN()));
        this.providerUrl_$eq(config.getProperty(LdapAuthenticationHandlerImpl$.MODULE$.PROVIDER_URL()));
        this.ldapDomain_$eq(config.getProperty(LdapAuthenticationHandlerImpl$.MODULE$.LDAP_BIND_DOMAIN()));
        this.enableStartTls_$eq(new StringOps(Predef$.MODULE$.augmentString(config.getProperty(LdapAuthenticationHandlerImpl$.MODULE$.ENABLE_START_TLS(), "false"))).toBoolean());
        Predef$.MODULE$.require(this.providerUrl() != null, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "The LDAP URI can not be null";
            }
        });
        if (this.enableStartTls()) {
            Predef$.MODULE$.require(!this.providerUrl().toLowerCase().startsWith("ldaps"), (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Can not use ldaps and StartTLS option at the same time";
                }
            });
        }
    }

    public void destroy() {
    }

    public boolean managementOperation(AuthenticationToken token, HttpServletRequest request, HttpServletResponse response) throws IOException, AuthenticationException {
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public AuthenticationToken authenticate(HttpServletRequest request, HttpServletResponse response) throws IOException, AuthenticationException {
        void var3_3;
        AuthenticationToken token = null;
        ObjectRef authorization = ObjectRef.create((Object)request.getHeader("Authorization"));
        if ((String)authorization.elem != null && ((String)authorization.elem).regionMatches(true, 0, LdapAuthenticationHandlerImpl$.MODULE$.AUTHORIZATION_SCHEME(), 0, LdapAuthenticationHandlerImpl$.MODULE$.AUTHORIZATION_SCHEME().length())) {
            authorization.elem = ((String)authorization.elem).substring("Basic".length()).trim();
            Base64 base64 = new Base64(0);
            String[] credentials = new String(base64.decode((String)authorization.elem), StandardCharsets.UTF_8).split(":", 2);
            if (credentials.length == 2) {
                this.debug((Function0<Object>)new Serializable(this, credentials){
                    public static final long serialVersionUID = 0L;
                    private final String[] credentials$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Authenticating [", "] user"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.credentials$1[0]}));
                    }
                    {
                        this.credentials$1 = credentials$1;
                    }
                });
                token = this.authenticateUser(credentials[0], credentials[1]);
                response.setStatus(200);
            }
        } else {
            response.setHeader("WWW-Authenticate", "Basic");
            response.setStatus(401);
            if ((String)authorization.elem == null) {
                this.trace((Function0<Object>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Basic auth starting";
                    }
                });
            } else {
                this.warn((Function0<Object>)new Serializable(this, authorization){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef authorization$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Authorization does not start with Basic : ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{(String)this.authorization$1.elem}));
                    }
                    {
                        this.authorization$1 = authorization$1;
                    }
                });
            }
        }
        return var3_3;
    }

    private AuthenticationToken authenticateUser(String userName, String password) throws AuthenticationException {
        String bindDN;
        if (userName == null || userName.isEmpty()) {
            throw new AuthenticationException("Error validating LDAP user: a null or blank username has been provided");
        }
        if (password == null || password.isEmpty()) {
            throw new AuthenticationException("Error validating LDAP user: a null or blank password has been provided");
        }
        String principle = userName;
        if (!LdapUtils$.MODULE$.hasDomain(userName) && this.ldapDomain() != null) {
            principle = new StringBuilder().append((Object)userName).append((Object)"@").append((Object)this.ldapDomain()).toString();
        }
        String string = bindDN = this.baseDN() == null ? principle : new StringBuilder().append((Object)"uid=").append((Object)principle).append((Object)",").append((Object)this.baseDN()).toString();
        if (this.enableStartTls()) {
            this.authenticateWithTlsExtension(bindDN, password);
        } else {
            this.authenticateWithoutTlsExtension(bindDN, password);
        }
        return new AuthenticationToken(userName, userName, "ldap");
    }

    private void authenticateWithTlsExtension(String userDN, String password) throws AuthenticationException {
        block11: {
            InitialLdapContext ctx = null;
            Hashtable<String, String> env = new Hashtable<String, String>();
            env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
            env.put("java.naming.provider.url", this.providerUrl());
            try {
                ctx = new InitialLdapContext(env, null);
                StartTlsResponse ex = (StartTlsResponse)ctx.extendedOperation(new StartTlsRequest());
                if (this.disableHostNameVerification()) {
                    ex.setHostnameVerifier(new HostnameVerifier(this){

                        public boolean verify(String hostname, SSLSession session) {
                            return true;
                        }
                    });
                }
                ex.negotiate();
                ctx.addToEnvironment("java.naming.security.authentication", LdapAuthenticationHandlerImpl$.MODULE$.SECURITY_AUTHENTICATION());
                ctx.addToEnvironment("java.naming.security.principal", userDN);
                ctx.addToEnvironment("java.naming.security.credentials", password);
                ctx.lookup(userDN);
                this.debug((Function0<Object>)new Serializable(this, userDN){
                    public static final long serialVersionUID = 0L;
                    private final String userDN$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Authentication successful for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.userDN$1}));
                    }
                    {
                        this.userDN$1 = userDN$1;
                    }
                });
                if (ctx == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    Throwable throwable2 = throwable;
                    boolean bl = throwable2 instanceof IOException ? true : throwable2 instanceof NamingException;
                    if (bl) {
                        throw new AuthenticationException("Error validating LDAP user", throwable2);
                    }
                    throw throwable;
                }
                catch (Throwable throwable3) {
                    if (ctx != null) {
                        try {
                            ctx.close();
                        }
                        catch (NamingException namingException) {
                            // empty catch block
                        }
                    }
                    throw throwable3;
                }
            }
            try {
                ctx.close();
            }
            catch (NamingException namingException) {
                // empty catch block
            }
        }
    }

    private void authenticateWithoutTlsExtension(String userDN, String password) throws AuthenticationException {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", this.providerUrl());
        env.put("java.naming.security.authentication", LdapAuthenticationHandlerImpl$.MODULE$.SECURITY_AUTHENTICATION());
        env.put("java.naming.security.principal", userDN);
        env.put("java.naming.security.credentials", password);
        try {
            InitialDirContext e = new InitialDirContext(env);
            e.close();
            this.debug((Function0<Object>)new Serializable(this, userDN){
                public static final long serialVersionUID = 0L;
                private final String userDN$2;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Authentication successful for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.userDN$2}));
                }
                {
                    this.userDN$2 = userDN$2;
                }
            });
            return;
        }
        catch (NamingException namingException) {
            throw new AuthenticationException("Error validating LDAP user", (Throwable)namingException);
        }
    }

    public LdapAuthenticationHandlerImpl() {
        Logging.class.$init$((Logging)this);
        this.ldapDomain = "null";
        this.baseDN = "null";
        this.providerUrl = "null";
        this.enableStartTls = false;
        this.disableHostNameVerification = false;
    }
}

