// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// Code generated by generator/main.go; DO NOT EDIT.

package ierror

import "fmt"

type IggyError interface {
	error
	Code() Code
}

type Error struct{}

func (e Error) Error() string { return "error" }
func (e Error) Code() Code    { return 1 }
func (e Error) Is(target error) bool {
	_, ok := target.(Error)
	return ok
}

type InvalidConfiguration struct{}

func (e InvalidConfiguration) Error() string { return "invalid configuration" }
func (e InvalidConfiguration) Code() Code    { return 2 }
func (e InvalidConfiguration) Is(target error) bool {
	_, ok := target.(InvalidConfiguration)
	return ok
}

type InvalidCommand struct{}

func (e InvalidCommand) Error() string { return "invalid command" }
func (e InvalidCommand) Code() Code    { return 3 }
func (e InvalidCommand) Is(target error) bool {
	_, ok := target.(InvalidCommand)
	return ok
}

type InvalidFormat struct{}

func (e InvalidFormat) Error() string { return "invalid format" }
func (e InvalidFormat) Code() Code    { return 4 }
func (e InvalidFormat) Is(target error) bool {
	_, ok := target.(InvalidFormat)
	return ok
}

type FeatureUnavailable struct{}

func (e FeatureUnavailable) Error() string { return "feature is unavailable" }
func (e FeatureUnavailable) Code() Code    { return 5 }
func (e FeatureUnavailable) Is(target error) bool {
	_, ok := target.(FeatureUnavailable)
	return ok
}

type InvalidIdentifier struct{}

func (e InvalidIdentifier) Error() string { return "invalid identifier" }
func (e InvalidIdentifier) Code() Code    { return 6 }
func (e InvalidIdentifier) Is(target error) bool {
	_, ok := target.(InvalidIdentifier)
	return ok
}

type InvalidVersion struct {
	Version string
}

func (e InvalidVersion) Error() string {
	return fmt.Sprintf("invalid version: %s", e.Version)
}
func (e InvalidVersion) Code() Code { return 7 }
func (e InvalidVersion) Is(target error) bool {
	_, ok := target.(InvalidVersion)
	return ok
}

type Disconnected struct{}

func (e Disconnected) Error() string { return "disconnected" }
func (e Disconnected) Code() Code    { return 8 }
func (e Disconnected) Is(target error) bool {
	_, ok := target.(Disconnected)
	return ok
}

type CannotEstablishConnection struct{}

func (e CannotEstablishConnection) Error() string { return "cannot establish connection" }
func (e CannotEstablishConnection) Code() Code    { return 9 }
func (e CannotEstablishConnection) Is(target error) bool {
	_, ok := target.(CannotEstablishConnection)
	return ok
}

type CannotCreateBaseDirectory struct {
	Path string
}

func (e CannotCreateBaseDirectory) Error() string {
	return fmt.Sprintf("cannot create base directory, path: %s", e.Path)
}
func (e CannotCreateBaseDirectory) Code() Code { return 10 }
func (e CannotCreateBaseDirectory) Is(target error) bool {
	_, ok := target.(CannotCreateBaseDirectory)
	return ok
}

type CannotCreateRuntimeDirectory struct {
	Path string
}

func (e CannotCreateRuntimeDirectory) Error() string {
	return fmt.Sprintf("cannot create runtime directory, path: %s", e.Path)
}
func (e CannotCreateRuntimeDirectory) Code() Code { return 11 }
func (e CannotCreateRuntimeDirectory) Is(target error) bool {
	_, ok := target.(CannotCreateRuntimeDirectory)
	return ok
}

type CannotRemoveRuntimeDirectory struct {
	Path string
}

func (e CannotRemoveRuntimeDirectory) Error() string {
	return fmt.Sprintf("cannot remove runtime directory, path: %s", e.Path)
}
func (e CannotRemoveRuntimeDirectory) Code() Code { return 12 }
func (e CannotRemoveRuntimeDirectory) Is(target error) bool {
	_, ok := target.(CannotRemoveRuntimeDirectory)
	return ok
}

type CannotCreateStateDirectory struct {
	Path string
}

func (e CannotCreateStateDirectory) Error() string {
	return fmt.Sprintf("cannot create state directory, path: %s", e.Path)
}
func (e CannotCreateStateDirectory) Code() Code { return 13 }
func (e CannotCreateStateDirectory) Is(target error) bool {
	_, ok := target.(CannotCreateStateDirectory)
	return ok
}

type StateFileNotFound struct{}

func (e StateFileNotFound) Error() string { return "state file not found" }
func (e StateFileNotFound) Code() Code    { return 14 }
func (e StateFileNotFound) Is(target error) bool {
	_, ok := target.(StateFileNotFound)
	return ok
}

type StateFileCorrupted struct{}

func (e StateFileCorrupted) Error() string { return "state file corrupted" }
func (e StateFileCorrupted) Code() Code    { return 15 }
func (e StateFileCorrupted) Is(target error) bool {
	_, ok := target.(StateFileCorrupted)
	return ok
}

type InvalidStateEntryChecksum struct {
	Actual   uint32
	Expected uint32
	Index    uint64
}

func (e InvalidStateEntryChecksum) Error() string {
	return fmt.Sprintf("invalid state entry checksum: %d, expected: %d, for index: %d", e.Actual, e.Expected, e.Index)
}
func (e InvalidStateEntryChecksum) Code() Code { return 16 }
func (e InvalidStateEntryChecksum) Is(target error) bool {
	_, ok := target.(InvalidStateEntryChecksum)
	return ok
}

type CannotOpenDatabase struct {
	Path string
}

func (e CannotOpenDatabase) Error() string {
	return fmt.Sprintf("cannot open database, path: %s", e.Path)
}
func (e CannotOpenDatabase) Code() Code { return 19 }
func (e CannotOpenDatabase) Is(target error) bool {
	_, ok := target.(CannotOpenDatabase)
	return ok
}

type ResourceNotFound struct {
	Key string
}

func (e ResourceNotFound) Error() string {
	return fmt.Sprintf("resource with key: %s was not found.", e.Key)
}
func (e ResourceNotFound) Code() Code { return 20 }
func (e ResourceNotFound) Is(target error) bool {
	_, ok := target.(ResourceNotFound)
	return ok
}

type StaleClient struct{}

func (e StaleClient) Error() string { return "stale client" }
func (e StaleClient) Code() Code    { return 30 }
func (e StaleClient) Is(target error) bool {
	_, ok := target.(StaleClient)
	return ok
}

type TcpError struct{}

func (e TcpError) Error() string { return "tcp error" }
func (e TcpError) Code() Code    { return 31 }
func (e TcpError) Is(target error) bool {
	_, ok := target.(TcpError)
	return ok
}

type QuicError struct{}

func (e QuicError) Error() string { return "quic error" }
func (e QuicError) Code() Code    { return 32 }
func (e QuicError) Is(target error) bool {
	_, ok := target.(QuicError)
	return ok
}

type InvalidServerAddress struct{}

func (e InvalidServerAddress) Error() string { return "invalid server address" }
func (e InvalidServerAddress) Code() Code    { return 33 }
func (e InvalidServerAddress) Is(target error) bool {
	_, ok := target.(InvalidServerAddress)
	return ok
}

type InvalidClientAddress struct{}

func (e InvalidClientAddress) Error() string { return "invalid client address" }
func (e InvalidClientAddress) Code() Code    { return 34 }
func (e InvalidClientAddress) Is(target error) bool {
	_, ok := target.(InvalidClientAddress)
	return ok
}

type InvalidIpAddress struct {
	IP   string
	Port string
}

func (e InvalidIpAddress) Error() string {
	return fmt.Sprintf("invalid ip address: %s:%s", e.IP, e.Port)
}
func (e InvalidIpAddress) Code() Code { return 35 }
func (e InvalidIpAddress) Is(target error) bool {
	_, ok := target.(InvalidIpAddress)
	return ok
}

type Unauthenticated struct{}

func (e Unauthenticated) Error() string { return "unauthenticated" }
func (e Unauthenticated) Code() Code    { return 40 }
func (e Unauthenticated) Is(target error) bool {
	_, ok := target.(Unauthenticated)
	return ok
}

type Unauthorized struct{}

func (e Unauthorized) Error() string { return "unauthorized" }
func (e Unauthorized) Code() Code    { return 41 }
func (e Unauthorized) Is(target error) bool {
	_, ok := target.(Unauthorized)
	return ok
}

type InvalidCredentials struct{}

func (e InvalidCredentials) Error() string { return "invalid credentials" }
func (e InvalidCredentials) Code() Code    { return 42 }
func (e InvalidCredentials) Is(target error) bool {
	_, ok := target.(InvalidCredentials)
	return ok
}

type InvalidUsername struct{}

func (e InvalidUsername) Error() string { return "invalid username" }
func (e InvalidUsername) Code() Code    { return 43 }
func (e InvalidUsername) Is(target error) bool {
	_, ok := target.(InvalidUsername)
	return ok
}

type InvalidPassword struct{}

func (e InvalidPassword) Error() string { return "invalid password" }
func (e InvalidPassword) Code() Code    { return 44 }
func (e InvalidPassword) Is(target error) bool {
	_, ok := target.(InvalidPassword)
	return ok
}

type InvalidUserStatus struct{}

func (e InvalidUserStatus) Error() string { return "invalid user status" }
func (e InvalidUserStatus) Code() Code    { return 45 }
func (e InvalidUserStatus) Is(target error) bool {
	_, ok := target.(InvalidUserStatus)
	return ok
}

type UserAlreadyExists struct{}

func (e UserAlreadyExists) Error() string { return "user already exists" }
func (e UserAlreadyExists) Code() Code    { return 46 }
func (e UserAlreadyExists) Is(target error) bool {
	_, ok := target.(UserAlreadyExists)
	return ok
}

type UserInactive struct{}

func (e UserInactive) Error() string { return "user inactive" }
func (e UserInactive) Code() Code    { return 47 }
func (e UserInactive) Is(target error) bool {
	_, ok := target.(UserInactive)
	return ok
}

type CannotDeleteUser struct {
	ID uint32
}

func (e CannotDeleteUser) Error() string {
	return fmt.Sprintf("cannot delete user with id: %d", e.ID)
}
func (e CannotDeleteUser) Code() Code { return 48 }
func (e CannotDeleteUser) Is(target error) bool {
	_, ok := target.(CannotDeleteUser)
	return ok
}

type CannotChangePermissions struct {
	ID uint32
}

func (e CannotChangePermissions) Error() string {
	return fmt.Sprintf("cannot change permissions for user with id: %d", e.ID)
}
func (e CannotChangePermissions) Code() Code { return 49 }
func (e CannotChangePermissions) Is(target error) bool {
	_, ok := target.(CannotChangePermissions)
	return ok
}

type InvalidPersonalAccessTokenName struct{}

func (e InvalidPersonalAccessTokenName) Error() string { return "invalid personal access token name" }
func (e InvalidPersonalAccessTokenName) Code() Code    { return 50 }
func (e InvalidPersonalAccessTokenName) Is(target error) bool {
	_, ok := target.(InvalidPersonalAccessTokenName)
	return ok
}

type PersonalAccessTokenAlreadyExists struct {
	Token string
	ID    uint32
}

func (e PersonalAccessTokenAlreadyExists) Error() string {
	return fmt.Sprintf("personal access token: %s for user with id: %d already exists", e.Token, e.ID)
}
func (e PersonalAccessTokenAlreadyExists) Code() Code { return 51 }
func (e PersonalAccessTokenAlreadyExists) Is(target error) bool {
	_, ok := target.(PersonalAccessTokenAlreadyExists)
	return ok
}

type PersonalAccessTokensLimitReached struct {
	ID    uint32
	Limit uint32
}

func (e PersonalAccessTokensLimitReached) Error() string {
	return fmt.Sprintf("user with id: %d has reached the maximum number of personal access tokens: %d", e.ID, e.Limit)
}
func (e PersonalAccessTokensLimitReached) Code() Code { return 52 }
func (e PersonalAccessTokensLimitReached) Is(target error) bool {
	_, ok := target.(PersonalAccessTokensLimitReached)
	return ok
}

type InvalidPersonalAccessToken struct{}

func (e InvalidPersonalAccessToken) Error() string { return "invalid personal access token" }
func (e InvalidPersonalAccessToken) Code() Code    { return 53 }
func (e InvalidPersonalAccessToken) Is(target error) bool {
	_, ok := target.(InvalidPersonalAccessToken)
	return ok
}

type PersonalAccessTokenExpired struct {
	Token string
	ID    uint32
}

func (e PersonalAccessTokenExpired) Error() string {
	return fmt.Sprintf("personal access token: %s for user with id: %d has expired.", e.Token, e.ID)
}
func (e PersonalAccessTokenExpired) Code() Code { return 54 }
func (e PersonalAccessTokenExpired) Is(target error) bool {
	_, ok := target.(PersonalAccessTokenExpired)
	return ok
}

type UsersLimitReached struct{}

func (e UsersLimitReached) Error() string { return "users limit reached." }
func (e UsersLimitReached) Code() Code    { return 55 }
func (e UsersLimitReached) Is(target error) bool {
	_, ok := target.(UsersLimitReached)
	return ok
}

type NotConnected struct{}

func (e NotConnected) Error() string { return "not connected" }
func (e NotConnected) Code() Code    { return 61 }
func (e NotConnected) Is(target error) bool {
	_, ok := target.(NotConnected)
	return ok
}

type ClientShutdown struct{}

func (e ClientShutdown) Error() string { return "client shutdown" }
func (e ClientShutdown) Code() Code    { return 63 }
func (e ClientShutdown) Is(target error) bool {
	_, ok := target.(ClientShutdown)
	return ok
}

type InvalidTlsDomain struct{}

func (e InvalidTlsDomain) Error() string { return "invalid tls domain" }
func (e InvalidTlsDomain) Code() Code    { return 64 }
func (e InvalidTlsDomain) Is(target error) bool {
	_, ok := target.(InvalidTlsDomain)
	return ok
}

type InvalidTlsCertificatePath struct{}

func (e InvalidTlsCertificatePath) Error() string { return "invalid tls certificate path" }
func (e InvalidTlsCertificatePath) Code() Code    { return 65 }
func (e InvalidTlsCertificatePath) Is(target error) bool {
	_, ok := target.(InvalidTlsCertificatePath)
	return ok
}

type InvalidTlsCertificate struct{}

func (e InvalidTlsCertificate) Error() string { return "invalid tls certificate" }
func (e InvalidTlsCertificate) Code() Code    { return 66 }
func (e InvalidTlsCertificate) Is(target error) bool {
	_, ok := target.(InvalidTlsCertificate)
	return ok
}

type FailedToAddCertificate struct{}

func (e FailedToAddCertificate) Error() string { return "failed to add certificate" }
func (e FailedToAddCertificate) Code() Code    { return 67 }
func (e FailedToAddCertificate) Is(target error) bool {
	_, ok := target.(FailedToAddCertificate)
	return ok
}

type InvalidEncryptionKey struct{}

func (e InvalidEncryptionKey) Error() string { return "invalid encryption key" }
func (e InvalidEncryptionKey) Code() Code    { return 70 }
func (e InvalidEncryptionKey) Is(target error) bool {
	_, ok := target.(InvalidEncryptionKey)
	return ok
}

type CannotEncryptData struct{}

func (e CannotEncryptData) Error() string { return "cannot encrypt data" }
func (e CannotEncryptData) Code() Code    { return 71 }
func (e CannotEncryptData) Is(target error) bool {
	_, ok := target.(CannotEncryptData)
	return ok
}

type CannotDecryptData struct{}

func (e CannotDecryptData) Error() string { return "cannot decrypt data" }
func (e CannotDecryptData) Code() Code    { return 72 }
func (e CannotDecryptData) Is(target error) bool {
	_, ok := target.(CannotDecryptData)
	return ok
}

type InvalidJwtAlgorithm struct {
	Algorithm string
}

func (e InvalidJwtAlgorithm) Error() string {
	return fmt.Sprintf("invalid jwt algorithm: %s", e.Algorithm)
}
func (e InvalidJwtAlgorithm) Code() Code { return 73 }
func (e InvalidJwtAlgorithm) Is(target error) bool {
	_, ok := target.(InvalidJwtAlgorithm)
	return ok
}

type InvalidJwtSecret struct{}

func (e InvalidJwtSecret) Error() string { return "invalid jwt secret" }
func (e InvalidJwtSecret) Code() Code    { return 74 }
func (e InvalidJwtSecret) Is(target error) bool {
	_, ok := target.(InvalidJwtSecret)
	return ok
}

type JwtMissing struct{}

func (e JwtMissing) Error() string { return "jwt is missing" }
func (e JwtMissing) Code() Code    { return 75 }
func (e JwtMissing) Is(target error) bool {
	_, ok := target.(JwtMissing)
	return ok
}

type CannotGenerateJwt struct{}

func (e CannotGenerateJwt) Error() string { return "cannot generate jwt" }
func (e CannotGenerateJwt) Code() Code    { return 76 }
func (e CannotGenerateJwt) Is(target error) bool {
	_, ok := target.(CannotGenerateJwt)
	return ok
}

type AccessTokenMissing struct{}

func (e AccessTokenMissing) Error() string { return "access token is missing" }
func (e AccessTokenMissing) Code() Code    { return 77 }
func (e AccessTokenMissing) Is(target error) bool {
	_, ok := target.(AccessTokenMissing)
	return ok
}

type InvalidAccessToken struct{}

func (e InvalidAccessToken) Error() string { return "invalid access token" }
func (e InvalidAccessToken) Code() Code    { return 78 }
func (e InvalidAccessToken) Is(target error) bool {
	_, ok := target.(InvalidAccessToken)
	return ok
}

type InvalidSizeBytes struct{}

func (e InvalidSizeBytes) Error() string { return "invalid size bytes" }
func (e InvalidSizeBytes) Code() Code    { return 80 }
func (e InvalidSizeBytes) Is(target error) bool {
	_, ok := target.(InvalidSizeBytes)
	return ok
}

type InvalidUtf8 struct{}

func (e InvalidUtf8) Error() string { return "invalid utf-8" }
func (e InvalidUtf8) Code() Code    { return 81 }
func (e InvalidUtf8) Is(target error) bool {
	_, ok := target.(InvalidUtf8)
	return ok
}

type InvalidNumberEncoding struct{}

func (e InvalidNumberEncoding) Error() string { return "invalid number encoding" }
func (e InvalidNumberEncoding) Code() Code    { return 82 }
func (e InvalidNumberEncoding) Is(target error) bool {
	_, ok := target.(InvalidNumberEncoding)
	return ok
}

type InvalidBooleanValue struct{}

func (e InvalidBooleanValue) Error() string { return "invalid boolean value" }
func (e InvalidBooleanValue) Code() Code    { return 83 }
func (e InvalidBooleanValue) Is(target error) bool {
	_, ok := target.(InvalidBooleanValue)
	return ok
}

type InvalidNumberValue struct{}

func (e InvalidNumberValue) Error() string { return "invalid number value" }
func (e InvalidNumberValue) Code() Code    { return 84 }
func (e InvalidNumberValue) Is(target error) bool {
	_, ok := target.(InvalidNumberValue)
	return ok
}

type ClientNotFound struct {
	ID uint32
}

func (e ClientNotFound) Error() string {
	return fmt.Sprintf("client with id: %d was not found.", e.ID)
}
func (e ClientNotFound) Code() Code { return 100 }
func (e ClientNotFound) Is(target error) bool {
	_, ok := target.(ClientNotFound)
	return ok
}

type InvalidClientId struct{}

func (e InvalidClientId) Error() string { return "invalid client id" }
func (e InvalidClientId) Code() Code    { return 101 }
func (e InvalidClientId) Is(target error) bool {
	_, ok := target.(InvalidClientId)
	return ok
}

type ConnectionClosed struct{}

func (e ConnectionClosed) Error() string { return "connection closed" }
func (e ConnectionClosed) Code() Code    { return 206 }
func (e ConnectionClosed) Is(target error) bool {
	_, ok := target.(ConnectionClosed)
	return ok
}

type CannotParseHeaderKind struct {
	Str string
}

func (e CannotParseHeaderKind) Error() string {
	return fmt.Sprintf("cannot parse header kind from %s", e.Str)
}
func (e CannotParseHeaderKind) Code() Code { return 209 }
func (e CannotParseHeaderKind) Is(target error) bool {
	_, ok := target.(CannotParseHeaderKind)
	return ok
}

type HttpResponseError struct {
	Status uint16
	Reason string
}

func (e HttpResponseError) Error() string {
	return fmt.Sprintf("http response error, status: %d, body: %s", e.Status, e.Reason)
}
func (e HttpResponseError) Code() Code { return 300 }
func (e HttpResponseError) Is(target error) bool {
	_, ok := target.(HttpResponseError)
	return ok
}

type InvalidHttpRequest struct{}

func (e InvalidHttpRequest) Error() string { return "invalid http request" }
func (e InvalidHttpRequest) Code() Code    { return 301 }
func (e InvalidHttpRequest) Is(target error) bool {
	_, ok := target.(InvalidHttpRequest)
	return ok
}

type InvalidJsonResponse struct{}

func (e InvalidJsonResponse) Error() string { return "invalid json response" }
func (e InvalidJsonResponse) Code() Code    { return 302 }
func (e InvalidJsonResponse) Is(target error) bool {
	_, ok := target.(InvalidJsonResponse)
	return ok
}

type InvalidBytesResponse struct{}

func (e InvalidBytesResponse) Error() string { return "invalid bytes response" }
func (e InvalidBytesResponse) Code() Code    { return 303 }
func (e InvalidBytesResponse) Is(target error) bool {
	_, ok := target.(InvalidBytesResponse)
	return ok
}

type EmptyResponse struct{}

func (e EmptyResponse) Error() string { return "empty response" }
func (e EmptyResponse) Code() Code    { return 304 }
func (e EmptyResponse) Is(target error) bool {
	_, ok := target.(EmptyResponse)
	return ok
}

type CannotCreateEndpoint struct{}

func (e CannotCreateEndpoint) Error() string { return "cannot create endpoint" }
func (e CannotCreateEndpoint) Code() Code    { return 305 }
func (e CannotCreateEndpoint) Is(target error) bool {
	_, ok := target.(CannotCreateEndpoint)
	return ok
}

type CannotParseUrl struct{}

func (e CannotParseUrl) Error() string { return "cannot parse url" }
func (e CannotParseUrl) Code() Code    { return 306 }
func (e CannotParseUrl) Is(target error) bool {
	_, ok := target.(CannotParseUrl)
	return ok
}

type CannotCreateStreamsDirectory struct {
	Path string
}

func (e CannotCreateStreamsDirectory) Error() string {
	return fmt.Sprintf("cannot create streams directory, path: %s", e.Path)
}
func (e CannotCreateStreamsDirectory) Code() Code { return 1000 }
func (e CannotCreateStreamsDirectory) Is(target error) bool {
	_, ok := target.(CannotCreateStreamsDirectory)
	return ok
}

type CannotCreateStreamDirectory struct {
	ID   uint32
	Path string
}

func (e CannotCreateStreamDirectory) Error() string {
	return fmt.Sprintf("cannot create stream with id: %d directory, path: %s", e.ID, e.Path)
}
func (e CannotCreateStreamDirectory) Code() Code { return 1001 }
func (e CannotCreateStreamDirectory) Is(target error) bool {
	_, ok := target.(CannotCreateStreamDirectory)
	return ok
}

type CannotCreateStreamInfo struct {
	ID uint32
}

func (e CannotCreateStreamInfo) Error() string {
	return fmt.Sprintf("failed to create stream info file for stream with id: %d", e.ID)
}
func (e CannotCreateStreamInfo) Code() Code { return 1002 }
func (e CannotCreateStreamInfo) Is(target error) bool {
	_, ok := target.(CannotCreateStreamInfo)
	return ok
}

type CannotUpdateStreamInfo struct {
	ID uint32
}

func (e CannotUpdateStreamInfo) Error() string {
	return fmt.Sprintf("failed to update stream info for stream with id: %d", e.ID)
}
func (e CannotUpdateStreamInfo) Code() Code { return 1003 }
func (e CannotUpdateStreamInfo) Is(target error) bool {
	_, ok := target.(CannotUpdateStreamInfo)
	return ok
}

type CannotOpenStreamInfo struct {
	ID uint32
}

func (e CannotOpenStreamInfo) Error() string {
	return fmt.Sprintf("failed to open stream info file for stream with id: %d", e.ID)
}
func (e CannotOpenStreamInfo) Code() Code { return 1004 }
func (e CannotOpenStreamInfo) Is(target error) bool {
	_, ok := target.(CannotOpenStreamInfo)
	return ok
}

type CannotReadStreamInfo struct {
	ID uint32
}

func (e CannotReadStreamInfo) Error() string {
	return fmt.Sprintf("failed to read stream info file for stream with id: %d", e.ID)
}
func (e CannotReadStreamInfo) Code() Code { return 1005 }
func (e CannotReadStreamInfo) Is(target error) bool {
	_, ok := target.(CannotReadStreamInfo)
	return ok
}

type CannotCreateStream struct {
	ID uint32
}

func (e CannotCreateStream) Error() string {
	return fmt.Sprintf("failed to create stream with id: %d", e.ID)
}
func (e CannotCreateStream) Code() Code { return 1006 }
func (e CannotCreateStream) Is(target error) bool {
	_, ok := target.(CannotCreateStream)
	return ok
}

type CannotDeleteStream struct {
	ID uint32
}

func (e CannotDeleteStream) Error() string {
	return fmt.Sprintf("failed to delete stream with id: %d", e.ID)
}
func (e CannotDeleteStream) Code() Code { return 1007 }
func (e CannotDeleteStream) Is(target error) bool {
	_, ok := target.(CannotDeleteStream)
	return ok
}

type CannotDeleteStreamDirectory struct {
	ID uint32
}

func (e CannotDeleteStreamDirectory) Error() string {
	return fmt.Sprintf("failed to delete stream directory with id: %d", e.ID)
}
func (e CannotDeleteStreamDirectory) Code() Code { return 1008 }
func (e CannotDeleteStreamDirectory) Is(target error) bool {
	_, ok := target.(CannotDeleteStreamDirectory)
	return ok
}

type StreamIdNotFound struct {
	ID uint32
}

func (e StreamIdNotFound) Error() string {
	return fmt.Sprintf("stream with id: %d was not found.", e.ID)
}
func (e StreamIdNotFound) Code() Code { return 1009 }
func (e StreamIdNotFound) Is(target error) bool {
	_, ok := target.(StreamIdNotFound)
	return ok
}

type StreamNameNotFound struct {
	Name string
}

func (e StreamNameNotFound) Error() string {
	return fmt.Sprintf("stream with name: %s was not found.", e.Name)
}
func (e StreamNameNotFound) Code() Code { return 1010 }
func (e StreamNameNotFound) Is(target error) bool {
	_, ok := target.(StreamNameNotFound)
	return ok
}

type StreamIdAlreadyExists struct {
	ID uint32
}

func (e StreamIdAlreadyExists) Error() string {
	return fmt.Sprintf("stream with id: %d already exists.", e.ID)
}
func (e StreamIdAlreadyExists) Code() Code { return 1011 }
func (e StreamIdAlreadyExists) Is(target error) bool {
	_, ok := target.(StreamIdAlreadyExists)
	return ok
}

type StreamNameAlreadyExists struct {
	Name string
}

func (e StreamNameAlreadyExists) Error() string {
	return fmt.Sprintf("stream with name: %s already exists.", e.Name)
}
func (e StreamNameAlreadyExists) Code() Code { return 1012 }
func (e StreamNameAlreadyExists) Is(target error) bool {
	_, ok := target.(StreamNameAlreadyExists)
	return ok
}

type InvalidStreamName struct{}

func (e InvalidStreamName) Error() string { return "invalid stream name" }
func (e InvalidStreamName) Code() Code    { return 1013 }
func (e InvalidStreamName) Is(target error) bool {
	_, ok := target.(InvalidStreamName)
	return ok
}

type InvalidStreamId struct{}

func (e InvalidStreamId) Error() string { return "invalid stream id" }
func (e InvalidStreamId) Code() Code    { return 1014 }
func (e InvalidStreamId) Is(target error) bool {
	_, ok := target.(InvalidStreamId)
	return ok
}

type CannotReadStreams struct{}

func (e CannotReadStreams) Error() string { return "cannot read streams" }
func (e CannotReadStreams) Code() Code    { return 1015 }
func (e CannotReadStreams) Is(target error) bool {
	_, ok := target.(CannotReadStreams)
	return ok
}

type InvalidTopicSize struct {
	MaxTopicSize uint64
	SegmentSize  uint64
}

func (e InvalidTopicSize) Error() string {
	return fmt.Sprintf("max topic size cannot be lower than segment size. max topic size: %v < segment size: %v.", e.MaxTopicSize, e.SegmentSize)
}
func (e InvalidTopicSize) Code() Code { return 1019 }
func (e InvalidTopicSize) Is(target error) bool {
	_, ok := target.(InvalidTopicSize)
	return ok
}

type CannotCreateTopicsDirectory struct {
	ID   uint32
	Path string
}

func (e CannotCreateTopicsDirectory) Error() string {
	return fmt.Sprintf("cannot create topics directory for stream with id: %d, path: %s", e.ID, e.Path)
}
func (e CannotCreateTopicsDirectory) Code() Code { return 2000 }
func (e CannotCreateTopicsDirectory) Is(target error) bool {
	_, ok := target.(CannotCreateTopicsDirectory)
	return ok
}

type CannotCreateTopicDirectory struct {
	TopicId  uint32
	StreamId uint32
	Path     string
}

func (e CannotCreateTopicDirectory) Error() string {
	return fmt.Sprintf("failed to create directory for topic with id: %d for stream with id: %d, path: %s", e.TopicId, e.StreamId, e.Path)
}
func (e CannotCreateTopicDirectory) Code() Code { return 2001 }
func (e CannotCreateTopicDirectory) Is(target error) bool {
	_, ok := target.(CannotCreateTopicDirectory)
	return ok
}

type CannotCreateTopicInfo struct {
	TopicId  uint32
	StreamId uint32
}

func (e CannotCreateTopicInfo) Error() string {
	return fmt.Sprintf("failed to create topic info file for topic with id: %d for stream with id: %d.", e.TopicId, e.StreamId)
}
func (e CannotCreateTopicInfo) Code() Code { return 2002 }
func (e CannotCreateTopicInfo) Is(target error) bool {
	_, ok := target.(CannotCreateTopicInfo)
	return ok
}

type CannotUpdateTopicInfo struct {
	TopicId  uint32
	StreamId uint32
}

func (e CannotUpdateTopicInfo) Error() string {
	return fmt.Sprintf("failed to update topic info for topic with id: %d for stream with id: %d.", e.TopicId, e.StreamId)
}
func (e CannotUpdateTopicInfo) Code() Code { return 2003 }
func (e CannotUpdateTopicInfo) Is(target error) bool {
	_, ok := target.(CannotUpdateTopicInfo)
	return ok
}

type CannotOpenTopicInfo struct {
	TopicId  uint32
	StreamId uint32
}

func (e CannotOpenTopicInfo) Error() string {
	return fmt.Sprintf("failed to open topic info file for topic with id: %d for stream with id: %d.", e.TopicId, e.StreamId)
}
func (e CannotOpenTopicInfo) Code() Code { return 2004 }
func (e CannotOpenTopicInfo) Is(target error) bool {
	_, ok := target.(CannotOpenTopicInfo)
	return ok
}

type CannotReadTopicInfo struct {
	TopicId  uint32
	StreamId uint32
}

func (e CannotReadTopicInfo) Error() string {
	return fmt.Sprintf("failed to read topic info file for topic with id: %d for stream with id: %d.", e.TopicId, e.StreamId)
}
func (e CannotReadTopicInfo) Code() Code { return 2005 }
func (e CannotReadTopicInfo) Is(target error) bool {
	_, ok := target.(CannotReadTopicInfo)
	return ok
}

type CannotCreateTopic struct {
	TopicId  uint32
	StreamId uint32
}

func (e CannotCreateTopic) Error() string {
	return fmt.Sprintf("failed to create topic with id: %d for stream with id: %d.", e.TopicId, e.StreamId)
}
func (e CannotCreateTopic) Code() Code { return 2006 }
func (e CannotCreateTopic) Is(target error) bool {
	_, ok := target.(CannotCreateTopic)
	return ok
}

type CannotDeleteTopic struct {
	TopicId  uint32
	StreamId uint32
}

func (e CannotDeleteTopic) Error() string {
	return fmt.Sprintf("failed to delete topic with id: %d for stream with id: %d.", e.TopicId, e.StreamId)
}
func (e CannotDeleteTopic) Code() Code { return 2007 }
func (e CannotDeleteTopic) Is(target error) bool {
	_, ok := target.(CannotDeleteTopic)
	return ok
}

type CannotDeleteTopicDirectory struct {
	TopicId  uint32
	StreamId uint32
	Path     string
}

func (e CannotDeleteTopicDirectory) Error() string {
	return fmt.Sprintf("failed to delete topic directory with id: %d for stream with id: %d, path: %s", e.TopicId, e.StreamId, e.Path)
}
func (e CannotDeleteTopicDirectory) Code() Code { return 2008 }
func (e CannotDeleteTopicDirectory) Is(target error) bool {
	_, ok := target.(CannotDeleteTopicDirectory)
	return ok
}

type CannotPollTopic struct{}

func (e CannotPollTopic) Error() string { return "cannot poll topic" }
func (e CannotPollTopic) Code() Code    { return 2009 }
func (e CannotPollTopic) Is(target error) bool {
	_, ok := target.(CannotPollTopic)
	return ok
}

type TopicIdNotFound struct {
	TopicId  uint32
	StreamId uint32
}

func (e TopicIdNotFound) Error() string {
	return fmt.Sprintf("topic with id: %d for stream with id: %d was not found.", e.TopicId, e.StreamId)
}
func (e TopicIdNotFound) Code() Code { return 2010 }
func (e TopicIdNotFound) Is(target error) bool {
	_, ok := target.(TopicIdNotFound)
	return ok
}

type TopicNameNotFound struct {
	TopicName string
	StreamId  string
}

func (e TopicNameNotFound) Error() string {
	return fmt.Sprintf("topic with name: %s for stream with id: %s was not found.", e.TopicName, e.StreamId)
}
func (e TopicNameNotFound) Code() Code { return 2011 }
func (e TopicNameNotFound) Is(target error) bool {
	_, ok := target.(TopicNameNotFound)
	return ok
}

type TopicIdAlreadyExists struct {
	TopicId  uint32
	StreamId uint32
}

func (e TopicIdAlreadyExists) Error() string {
	return fmt.Sprintf("topic with id: %d for stream with id: %d already exists.", e.TopicId, e.StreamId)
}
func (e TopicIdAlreadyExists) Code() Code { return 2012 }
func (e TopicIdAlreadyExists) Is(target error) bool {
	_, ok := target.(TopicIdAlreadyExists)
	return ok
}

type TopicNameAlreadyExists struct {
	TopicName string
	StreamId  uint32
}

func (e TopicNameAlreadyExists) Error() string {
	return fmt.Sprintf("topic with name: %s for stream with id: %d already exists.", e.TopicName, e.StreamId)
}
func (e TopicNameAlreadyExists) Code() Code { return 2013 }
func (e TopicNameAlreadyExists) Is(target error) bool {
	_, ok := target.(TopicNameAlreadyExists)
	return ok
}

type InvalidTopicName struct{}

func (e InvalidTopicName) Error() string { return "invalid topic name" }
func (e InvalidTopicName) Code() Code    { return 2014 }
func (e InvalidTopicName) Is(target error) bool {
	_, ok := target.(InvalidTopicName)
	return ok
}

type TooManyPartitions struct{}

func (e TooManyPartitions) Error() string { return "too many partitions" }
func (e TooManyPartitions) Code() Code    { return 2015 }
func (e TooManyPartitions) Is(target error) bool {
	_, ok := target.(TooManyPartitions)
	return ok
}

type InvalidTopicId struct{}

func (e InvalidTopicId) Error() string { return "invalid topic id" }
func (e InvalidTopicId) Code() Code    { return 2016 }
func (e InvalidTopicId) Is(target error) bool {
	_, ok := target.(InvalidTopicId)
	return ok
}

type CannotReadTopics struct {
	ID uint32
}

func (e CannotReadTopics) Error() string {
	return fmt.Sprintf("cannot read topics for stream with id: %d", e.ID)
}
func (e CannotReadTopics) Code() Code { return 2017 }
func (e CannotReadTopics) Is(target error) bool {
	_, ok := target.(CannotReadTopics)
	return ok
}

type InvalidReplicationFactor struct{}

func (e InvalidReplicationFactor) Error() string { return "invalid replication factor" }
func (e InvalidReplicationFactor) Code() Code    { return 2018 }
func (e InvalidReplicationFactor) Is(target error) bool {
	_, ok := target.(InvalidReplicationFactor)
	return ok
}

type CannotCreatePartition struct {
	PartitionId uint32
	StreamId    uint32
	TopicId     uint32
}

func (e CannotCreatePartition) Error() string {
	return fmt.Sprintf("cannot create partition with id: %d for stream with id: %d and topic with id: %d", e.PartitionId, e.StreamId, e.TopicId)
}
func (e CannotCreatePartition) Code() Code { return 3000 }
func (e CannotCreatePartition) Is(target error) bool {
	_, ok := target.(CannotCreatePartition)
	return ok
}

type CannotCreatePartitionsDirectory struct {
	StreamId uint32
	TopicId  uint32
}

func (e CannotCreatePartitionsDirectory) Error() string {
	return fmt.Sprintf("failed to create directory for partitions for stream with id: %d and topic with id: %d", e.StreamId, e.TopicId)
}
func (e CannotCreatePartitionsDirectory) Code() Code { return 3001 }
func (e CannotCreatePartitionsDirectory) Is(target error) bool {
	_, ok := target.(CannotCreatePartitionsDirectory)
	return ok
}

type CannotCreatePartitionDirectory struct {
	PartitionId uint32
	StreamId    uint32
	TopicId     uint32
}

func (e CannotCreatePartitionDirectory) Error() string {
	return fmt.Sprintf("failed to create directory for partition with id: %d for stream with id: %d and topic with id: %d", e.PartitionId, e.StreamId, e.TopicId)
}
func (e CannotCreatePartitionDirectory) Code() Code { return 3002 }
func (e CannotCreatePartitionDirectory) Is(target error) bool {
	_, ok := target.(CannotCreatePartitionDirectory)
	return ok
}

type CannotOpenPartitionLogFile struct{}

func (e CannotOpenPartitionLogFile) Error() string { return "cannot open partition log file" }
func (e CannotOpenPartitionLogFile) Code() Code    { return 3003 }
func (e CannotOpenPartitionLogFile) Is(target error) bool {
	_, ok := target.(CannotOpenPartitionLogFile)
	return ok
}

type CannotReadPartitions struct{}

func (e CannotReadPartitions) Error() string { return "cannot read partitions directories." }
func (e CannotReadPartitions) Code() Code    { return 3004 }
func (e CannotReadPartitions) Is(target error) bool {
	_, ok := target.(CannotReadPartitions)
	return ok
}

type CannotDeletePartition struct {
	PartitionId uint32
	StreamId    uint32
	TopicId     uint32
}

func (e CannotDeletePartition) Error() string {
	return fmt.Sprintf("failed to delete partition with id: %d for stream with id: %d and topic with id: %d", e.PartitionId, e.StreamId, e.TopicId)
}
func (e CannotDeletePartition) Code() Code { return 3005 }
func (e CannotDeletePartition) Is(target error) bool {
	_, ok := target.(CannotDeletePartition)
	return ok
}

type CannotDeletePartitionDirectory struct {
	PartitionId uint32
	StreamId    uint32
	TopicId     uint32
}

func (e CannotDeletePartitionDirectory) Error() string {
	return fmt.Sprintf("failed to delete partition directory with id: %d for stream with id: %d and topic with id: %d", e.PartitionId, e.StreamId, e.TopicId)
}
func (e CannotDeletePartitionDirectory) Code() Code { return 3006 }
func (e CannotDeletePartitionDirectory) Is(target error) bool {
	_, ok := target.(CannotDeletePartitionDirectory)
	return ok
}

type PartitionNotFound struct {
	PartitionId uint32
	TopicId     uint32
	StreamId    uint32
}

func (e PartitionNotFound) Error() string {
	return fmt.Sprintf("partition with id: %d for topic with id: %d for stream with id: %d was not found.", e.PartitionId, e.TopicId, e.StreamId)
}
func (e PartitionNotFound) Code() Code { return 3007 }
func (e PartitionNotFound) Is(target error) bool {
	_, ok := target.(PartitionNotFound)
	return ok
}

type NoPartitions struct {
	TopicId  uint32
	StreamId uint32
}

func (e NoPartitions) Error() string {
	return fmt.Sprintf("topic with id: %d for stream with id: %d has no partitions.", e.TopicId, e.StreamId)
}
func (e NoPartitions) Code() Code { return 3008 }
func (e NoPartitions) Is(target error) bool {
	_, ok := target.(NoPartitions)
	return ok
}

type TopicFull struct {
	TopicId  uint32
	StreamId uint32
}

func (e TopicFull) Error() string {
	return fmt.Sprintf("cannot read partitions for topic with id: %d for stream with id: %d", e.TopicId, e.StreamId)
}
func (e TopicFull) Code() Code { return 3009 }
func (e TopicFull) Is(target error) bool {
	_, ok := target.(TopicFull)
	return ok
}

type CannotDeleteConsumerOffsetsDirectory struct {
	Path string
}

func (e CannotDeleteConsumerOffsetsDirectory) Error() string {
	return fmt.Sprintf("failed to delete consumer offsets directory for path: %s", e.Path)
}
func (e CannotDeleteConsumerOffsetsDirectory) Code() Code { return 3010 }
func (e CannotDeleteConsumerOffsetsDirectory) Is(target error) bool {
	_, ok := target.(CannotDeleteConsumerOffsetsDirectory)
	return ok
}

type CannotDeleteConsumerOffsetFile struct {
	Path string
}

func (e CannotDeleteConsumerOffsetFile) Error() string {
	return fmt.Sprintf("failed to delete consumer offset file for path: %s", e.Path)
}
func (e CannotDeleteConsumerOffsetFile) Code() Code { return 3011 }
func (e CannotDeleteConsumerOffsetFile) Is(target error) bool {
	_, ok := target.(CannotDeleteConsumerOffsetFile)
	return ok
}

type CannotCreateConsumerOffsetsDirectory struct {
	Path string
}

func (e CannotCreateConsumerOffsetsDirectory) Error() string {
	return fmt.Sprintf("failed to create consumer offsets directory for path: %s", e.Path)
}
func (e CannotCreateConsumerOffsetsDirectory) Code() Code { return 3012 }
func (e CannotCreateConsumerOffsetsDirectory) Is(target error) bool {
	_, ok := target.(CannotCreateConsumerOffsetsDirectory)
	return ok
}

type CannotReadConsumerOffsets struct {
	Path string
}

func (e CannotReadConsumerOffsets) Error() string {
	return fmt.Sprintf("failed to read consumers offsets from path: %s", e.Path)
}
func (e CannotReadConsumerOffsets) Code() Code { return 3020 }
func (e CannotReadConsumerOffsets) Is(target error) bool {
	_, ok := target.(CannotReadConsumerOffsets)
	return ok
}

type ConsumerOffsetNotFound struct {
	ID uint32
}

func (e ConsumerOffsetNotFound) Error() string {
	return fmt.Sprintf("consumer offset for consumer with id: %d was not found.", e.ID)
}
func (e ConsumerOffsetNotFound) Code() Code { return 3021 }
func (e ConsumerOffsetNotFound) Is(target error) bool {
	_, ok := target.(ConsumerOffsetNotFound)
	return ok
}

type SegmentNotFound struct{}

func (e SegmentNotFound) Error() string { return "segment not found" }
func (e SegmentNotFound) Code() Code    { return 4000 }
func (e SegmentNotFound) Is(target error) bool {
	_, ok := target.(SegmentNotFound)
	return ok
}

type SegmentClosed struct {
	StartOffset uint64
	PartitionId uint32
}

func (e SegmentClosed) Error() string {
	return fmt.Sprintf("segment with start offset: %d and partition with id: %d is closed", e.StartOffset, e.PartitionId)
}
func (e SegmentClosed) Code() Code { return 4001 }
func (e SegmentClosed) Is(target error) bool {
	_, ok := target.(SegmentClosed)
	return ok
}

type InvalidSegmentSize struct{}

func (e InvalidSegmentSize) Error() string { return "segment size is invalid" }
func (e InvalidSegmentSize) Code() Code    { return 4002 }
func (e InvalidSegmentSize) Is(target error) bool {
	_, ok := target.(InvalidSegmentSize)
	return ok
}

type CannotCreateSegmentLogFile struct {
	Path string
}

func (e CannotCreateSegmentLogFile) Error() string {
	return fmt.Sprintf("failed to create segment log file for path: %s.", e.Path)
}
func (e CannotCreateSegmentLogFile) Code() Code { return 4003 }
func (e CannotCreateSegmentLogFile) Is(target error) bool {
	_, ok := target.(CannotCreateSegmentLogFile)
	return ok
}

type CannotCreateSegmentIndexFile struct {
	Path string
}

func (e CannotCreateSegmentIndexFile) Error() string {
	return fmt.Sprintf("failed to create segment index file for path: %s.", e.Path)
}
func (e CannotCreateSegmentIndexFile) Code() Code { return 4004 }
func (e CannotCreateSegmentIndexFile) Is(target error) bool {
	_, ok := target.(CannotCreateSegmentIndexFile)
	return ok
}

type CannotCreateSegmentTimeIndexFile struct {
	Path string
}

func (e CannotCreateSegmentTimeIndexFile) Error() string {
	return fmt.Sprintf("failed to create segment time index file for path: %s.", e.Path)
}
func (e CannotCreateSegmentTimeIndexFile) Code() Code { return 4005 }
func (e CannotCreateSegmentTimeIndexFile) Is(target error) bool {
	_, ok := target.(CannotCreateSegmentTimeIndexFile)
	return ok
}

type CannotSaveMessagesToSegment struct{}

func (e CannotSaveMessagesToSegment) Error() string { return "cannot save messages to segment." }
func (e CannotSaveMessagesToSegment) Code() Code    { return 4006 }
func (e CannotSaveMessagesToSegment) Is(target error) bool {
	_, ok := target.(CannotSaveMessagesToSegment)
	return ok
}

type CannotSaveIndexToSegment struct{}

func (e CannotSaveIndexToSegment) Error() string { return "cannot save index to segment." }
func (e CannotSaveIndexToSegment) Code() Code    { return 4007 }
func (e CannotSaveIndexToSegment) Is(target error) bool {
	_, ok := target.(CannotSaveIndexToSegment)
	return ok
}

type CannotSaveTimeIndexToSegment struct{}

func (e CannotSaveTimeIndexToSegment) Error() string { return "cannot save time index to segment." }
func (e CannotSaveTimeIndexToSegment) Code() Code    { return 4008 }
func (e CannotSaveTimeIndexToSegment) Is(target error) bool {
	_, ok := target.(CannotSaveTimeIndexToSegment)
	return ok
}

type InvalidMessagesCount struct{}

func (e InvalidMessagesCount) Error() string { return "invalid messages count" }
func (e InvalidMessagesCount) Code() Code    { return 4009 }
func (e InvalidMessagesCount) Is(target error) bool {
	_, ok := target.(InvalidMessagesCount)
	return ok
}

type CannotAppendMessage struct{}

func (e CannotAppendMessage) Error() string { return "cannot append message" }
func (e CannotAppendMessage) Code() Code    { return 4010 }
func (e CannotAppendMessage) Is(target error) bool {
	_, ok := target.(CannotAppendMessage)
	return ok
}

type CannotReadMessage struct{}

func (e CannotReadMessage) Error() string { return "cannot read message" }
func (e CannotReadMessage) Code() Code    { return 4011 }
func (e CannotReadMessage) Is(target error) bool {
	_, ok := target.(CannotReadMessage)
	return ok
}

type CannotReadMessageId struct{}

func (e CannotReadMessageId) Error() string { return "cannot read message id" }
func (e CannotReadMessageId) Code() Code    { return 4012 }
func (e CannotReadMessageId) Is(target error) bool {
	_, ok := target.(CannotReadMessageId)
	return ok
}

type CannotReadMessageState struct{}

func (e CannotReadMessageState) Error() string { return "cannot read message state" }
func (e CannotReadMessageState) Code() Code    { return 4013 }
func (e CannotReadMessageState) Is(target error) bool {
	_, ok := target.(CannotReadMessageState)
	return ok
}

type CannotReadMessageTimestamp struct{}

func (e CannotReadMessageTimestamp) Error() string { return "cannot read message timestamp" }
func (e CannotReadMessageTimestamp) Code() Code    { return 4014 }
func (e CannotReadMessageTimestamp) Is(target error) bool {
	_, ok := target.(CannotReadMessageTimestamp)
	return ok
}

type CannotReadHeadersLength struct{}

func (e CannotReadHeadersLength) Error() string { return "cannot read headers length" }
func (e CannotReadHeadersLength) Code() Code    { return 4015 }
func (e CannotReadHeadersLength) Is(target error) bool {
	_, ok := target.(CannotReadHeadersLength)
	return ok
}

type CannotReadHeadersPayload struct{}

func (e CannotReadHeadersPayload) Error() string { return "cannot read headers payload" }
func (e CannotReadHeadersPayload) Code() Code    { return 4016 }
func (e CannotReadHeadersPayload) Is(target error) bool {
	_, ok := target.(CannotReadHeadersPayload)
	return ok
}

type TooBigUserHeaders struct{}

func (e TooBigUserHeaders) Error() string { return "too big headers payload" }
func (e TooBigUserHeaders) Code() Code    { return 4017 }
func (e TooBigUserHeaders) Is(target error) bool {
	_, ok := target.(TooBigUserHeaders)
	return ok
}

type InvalidHeaderKey struct{}

func (e InvalidHeaderKey) Error() string { return "invalid header key" }
func (e InvalidHeaderKey) Code() Code    { return 4018 }
func (e InvalidHeaderKey) Is(target error) bool {
	_, ok := target.(InvalidHeaderKey)
	return ok
}

type InvalidHeaderValue struct{}

func (e InvalidHeaderValue) Error() string { return "invalid header value" }
func (e InvalidHeaderValue) Code() Code    { return 4019 }
func (e InvalidHeaderValue) Is(target error) bool {
	_, ok := target.(InvalidHeaderValue)
	return ok
}

type CannotReadMessageLength struct{}

func (e CannotReadMessageLength) Error() string { return "cannot read message length" }
func (e CannotReadMessageLength) Code() Code    { return 4020 }
func (e CannotReadMessageLength) Is(target error) bool {
	_, ok := target.(CannotReadMessageLength)
	return ok
}

type CannotReadMessagePayload struct{}

func (e CannotReadMessagePayload) Error() string { return "cannot save messages to segment" }
func (e CannotReadMessagePayload) Code() Code    { return 4021 }
func (e CannotReadMessagePayload) Is(target error) bool {
	_, ok := target.(CannotReadMessagePayload)
	return ok
}

type TooBigMessagePayload struct{}

func (e TooBigMessagePayload) Error() string { return "too big message payload" }
func (e TooBigMessagePayload) Code() Code    { return 4022 }
func (e TooBigMessagePayload) Is(target error) bool {
	_, ok := target.(TooBigMessagePayload)
	return ok
}

type TooManyMessages struct{}

func (e TooManyMessages) Error() string { return "too many messages" }
func (e TooManyMessages) Code() Code    { return 4023 }
func (e TooManyMessages) Is(target error) bool {
	_, ok := target.(TooManyMessages)
	return ok
}

type EmptyMessagePayload struct{}

func (e EmptyMessagePayload) Error() string { return "empty message payload" }
func (e EmptyMessagePayload) Code() Code    { return 4024 }
func (e EmptyMessagePayload) Is(target error) bool {
	_, ok := target.(EmptyMessagePayload)
	return ok
}

type InvalidMessagePayloadLength struct{}

func (e InvalidMessagePayloadLength) Error() string { return "invalid message payload length" }
func (e InvalidMessagePayloadLength) Code() Code    { return 4025 }
func (e InvalidMessagePayloadLength) Is(target error) bool {
	_, ok := target.(InvalidMessagePayloadLength)
	return ok
}

type CannotReadMessageChecksum struct{}

func (e CannotReadMessageChecksum) Error() string { return "cannot read message checksum" }
func (e CannotReadMessageChecksum) Code() Code    { return 4026 }
func (e CannotReadMessageChecksum) Is(target error) bool {
	_, ok := target.(CannotReadMessageChecksum)
	return ok
}

type InvalidMessageChecksum struct {
	Actual   uint64
	Expected uint64
	Offset   uint64
}

func (e InvalidMessageChecksum) Error() string {
	return fmt.Sprintf("invalid message checksum: %d, expected: %d, for offset: %d", e.Actual, e.Expected, e.Offset)
}
func (e InvalidMessageChecksum) Code() Code { return 4027 }
func (e InvalidMessageChecksum) Is(target error) bool {
	_, ok := target.(InvalidMessageChecksum)
	return ok
}

type InvalidKeyValueLength struct{}

func (e InvalidKeyValueLength) Error() string { return "invalid key value length" }
func (e InvalidKeyValueLength) Code() Code    { return 4028 }
func (e InvalidKeyValueLength) Is(target error) bool {
	_, ok := target.(InvalidKeyValueLength)
	return ok
}

type CommandLengthError struct {
	Detail string
}

func (e CommandLengthError) Error() string {
	return fmt.Sprintf("command length error: %s", e.Detail)
}
func (e CommandLengthError) Code() Code { return 4029 }
func (e CommandLengthError) Is(target error) bool {
	_, ok := target.(CommandLengthError)
	return ok
}

type InvalidSegmentsCount struct {
	Count uint32
}

func (e InvalidSegmentsCount) Error() string {
	return fmt.Sprintf("incorrect segments count size: %d", e.Count)
}
func (e InvalidSegmentsCount) Code() Code { return 4030 }
func (e InvalidSegmentsCount) Is(target error) bool {
	_, ok := target.(InvalidSegmentsCount)
	return ok
}

type NonZeroOffset struct {
	Offset uint64
	Index  uint32
}

func (e NonZeroOffset) Error() string {
	return fmt.Sprintf("non-zero offset: %d at index: %d", e.Offset, e.Index)
}
func (e NonZeroOffset) Code() Code { return 4031 }
func (e NonZeroOffset) Is(target error) bool {
	_, ok := target.(NonZeroOffset)
	return ok
}

type NonZeroTimestamp struct {
	Timestamp uint64
	Index     uint32
}

func (e NonZeroTimestamp) Error() string {
	return fmt.Sprintf("non-zero timestamp: %d at index: %d", e.Timestamp, e.Index)
}
func (e NonZeroTimestamp) Code() Code { return 4032 }
func (e NonZeroTimestamp) Is(target error) bool {
	_, ok := target.(NonZeroTimestamp)
	return ok
}

type MissingIndex struct {
	Index uint32
}

func (e MissingIndex) Error() string {
	return fmt.Sprintf("missing index: %d", e.Index)
}
func (e MissingIndex) Code() Code { return 4033 }
func (e MissingIndex) Is(target error) bool {
	_, ok := target.(MissingIndex)
	return ok
}

type InvalidIndexesByteSize struct {
	Size uint32
}

func (e InvalidIndexesByteSize) Error() string {
	return fmt.Sprintf("invalid indexes byte size: %dB, should be divisible by 16", e.Size)
}
func (e InvalidIndexesByteSize) Code() Code { return 4034 }
func (e InvalidIndexesByteSize) Is(target error) bool {
	_, ok := target.(InvalidIndexesByteSize)
	return ok
}

type InvalidIndexesCount struct {
	Count    uint32
	Expected uint32
}

func (e InvalidIndexesCount) Error() string {
	return fmt.Sprintf("invalid indexes count: %d, expected: %d", e.Count, e.Expected)
}
func (e InvalidIndexesCount) Code() Code { return 4035 }
func (e InvalidIndexesCount) Is(target error) bool {
	_, ok := target.(InvalidIndexesCount)
	return ok
}

type InvalidMessagesSize struct {
	Actual   uint32
	Expected uint32
}

func (e InvalidMessagesSize) Error() string {
	return fmt.Sprintf("invalid messages byte size: %dB, expected: %dB", e.Actual, e.Expected)
}
func (e InvalidMessagesSize) Code() Code { return 4036 }
func (e InvalidMessagesSize) Is(target error) bool {
	_, ok := target.(InvalidMessagesSize)
	return ok
}

type TooSmallMessage struct {
	Actual   uint32
	Expected uint32
}

func (e TooSmallMessage) Error() string {
	return fmt.Sprintf("too small message: %dB, expected: %dB", e.Actual, e.Expected)
}
func (e TooSmallMessage) Code() Code { return 4037 }
func (e TooSmallMessage) Is(target error) bool {
	_, ok := target.(TooSmallMessage)
	return ok
}

type CannotSendMessagesDueToClientDisconnection struct{}

func (e CannotSendMessagesDueToClientDisconnection) Error() string {
	return "cannot sed messages due to client disconnection"
}
func (e CannotSendMessagesDueToClientDisconnection) Code() Code { return 4050 }
func (e CannotSendMessagesDueToClientDisconnection) Is(target error) bool {
	_, ok := target.(CannotSendMessagesDueToClientDisconnection)
	return ok
}

type BackgroundSendError struct{}

func (e BackgroundSendError) Error() string { return "background send error" }
func (e BackgroundSendError) Code() Code    { return 4051 }
func (e BackgroundSendError) Is(target error) bool {
	_, ok := target.(BackgroundSendError)
	return ok
}

type BackgroundSendTimeout struct{}

func (e BackgroundSendTimeout) Error() string { return "background send timeout" }
func (e BackgroundSendTimeout) Code() Code    { return 4052 }
func (e BackgroundSendTimeout) Is(target error) bool {
	_, ok := target.(BackgroundSendTimeout)
	return ok
}

type BackgroundSendBufferFull struct{}

func (e BackgroundSendBufferFull) Error() string { return "background send buffer is full" }
func (e BackgroundSendBufferFull) Code() Code    { return 4053 }
func (e BackgroundSendBufferFull) Is(target error) bool {
	_, ok := target.(BackgroundSendBufferFull)
	return ok
}

type BackgroundWorkerDisconnected struct{}

func (e BackgroundWorkerDisconnected) Error() string { return "background worker disconnected" }
func (e BackgroundWorkerDisconnected) Code() Code    { return 4054 }
func (e BackgroundWorkerDisconnected) Is(target error) bool {
	_, ok := target.(BackgroundWorkerDisconnected)
	return ok
}

type BackgroundSendBufferOverflow struct{}

func (e BackgroundSendBufferOverflow) Error() string { return "background send buffer overflow" }
func (e BackgroundSendBufferOverflow) Code() Code    { return 4055 }
func (e BackgroundSendBufferOverflow) Is(target error) bool {
	_, ok := target.(BackgroundSendBufferOverflow)
	return ok
}

type ProducerSendFailed struct{}

func (e ProducerSendFailed) Error() string { return "producer send failed" }
func (e ProducerSendFailed) Code() Code    { return 4056 }
func (e ProducerSendFailed) Is(target error) bool {
	_, ok := target.(ProducerSendFailed)
	return ok
}

type ProducerClosed struct{}

func (e ProducerClosed) Error() string { return "producer closed" }
func (e ProducerClosed) Code() Code    { return 4057 }
func (e ProducerClosed) Is(target error) bool {
	_, ok := target.(ProducerClosed)
	return ok
}

type InvalidOffset struct {
	Offset uint64
}

func (e InvalidOffset) Error() string {
	return fmt.Sprintf("invalid offset: %d", e.Offset)
}
func (e InvalidOffset) Code() Code { return 4100 }
func (e InvalidOffset) Is(target error) bool {
	_, ok := target.(InvalidOffset)
	return ok
}

type ConsumerGroupIdNotFound struct {
	GroupId uint32
	TopicId uint32
}

func (e ConsumerGroupIdNotFound) Error() string {
	return fmt.Sprintf("consumer group with id: %d for topic with id: %d was not found.", e.GroupId, e.TopicId)
}
func (e ConsumerGroupIdNotFound) Code() Code { return 5000 }
func (e ConsumerGroupIdNotFound) Is(target error) bool {
	_, ok := target.(ConsumerGroupIdNotFound)
	return ok
}

type ConsumerGroupIdAlreadyExists struct {
	GroupId uint32
	TopicId uint32
}

func (e ConsumerGroupIdAlreadyExists) Error() string {
	return fmt.Sprintf("consumer group with id: %d for topic with id: %d already exists.", e.GroupId, e.TopicId)
}
func (e ConsumerGroupIdAlreadyExists) Code() Code { return 5001 }
func (e ConsumerGroupIdAlreadyExists) Is(target error) bool {
	_, ok := target.(ConsumerGroupIdAlreadyExists)
	return ok
}

type InvalidConsumerGroupId struct{}

func (e InvalidConsumerGroupId) Error() string { return "invalid consumer group id" }
func (e InvalidConsumerGroupId) Code() Code    { return 5002 }
func (e InvalidConsumerGroupId) Is(target error) bool {
	_, ok := target.(InvalidConsumerGroupId)
	return ok
}

type ConsumerGroupNameNotFound struct {
	Name    string
	TopicId string
}

func (e ConsumerGroupNameNotFound) Error() string {
	return fmt.Sprintf("consumer group with name: %s for topic with id: %s was not found.", e.Name, e.TopicId)
}
func (e ConsumerGroupNameNotFound) Code() Code { return 5003 }
func (e ConsumerGroupNameNotFound) Is(target error) bool {
	_, ok := target.(ConsumerGroupNameNotFound)
	return ok
}

type ConsumerGroupNameAlreadyExists struct {
	Name    string
	TopicId uint32
}

func (e ConsumerGroupNameAlreadyExists) Error() string {
	return fmt.Sprintf("consumer group with name: %s for topic with id: %d already exists.", e.Name, e.TopicId)
}
func (e ConsumerGroupNameAlreadyExists) Code() Code { return 5004 }
func (e ConsumerGroupNameAlreadyExists) Is(target error) bool {
	_, ok := target.(ConsumerGroupNameAlreadyExists)
	return ok
}

type InvalidConsumerGroupName struct{}

func (e InvalidConsumerGroupName) Error() string { return "invalid consumer group name" }
func (e InvalidConsumerGroupName) Code() Code    { return 5005 }
func (e InvalidConsumerGroupName) Is(target error) bool {
	_, ok := target.(InvalidConsumerGroupName)
	return ok
}

type ConsumerGroupMemberNotFound struct {
	MemberId uint32
	GroupId  uint32
	TopicId  uint32
}

func (e ConsumerGroupMemberNotFound) Error() string {
	return fmt.Sprintf("consumer group member with id: %d for group with id: %d for topic with id: %d was not found.", e.MemberId, e.GroupId, e.TopicId)
}
func (e ConsumerGroupMemberNotFound) Code() Code { return 5006 }
func (e ConsumerGroupMemberNotFound) Is(target error) bool {
	_, ok := target.(ConsumerGroupMemberNotFound)
	return ok
}

type CannotCreateConsumerGroupInfo struct {
	GroupId  uint32
	TopicId  uint32
	StreamId uint32
}

func (e CannotCreateConsumerGroupInfo) Error() string {
	return fmt.Sprintf("failed to create consumer group info file for id: %d for topic with id: %d for stream with id: %d.", e.GroupId, e.TopicId, e.StreamId)
}
func (e CannotCreateConsumerGroupInfo) Code() Code { return 5007 }
func (e CannotCreateConsumerGroupInfo) Is(target error) bool {
	_, ok := target.(CannotCreateConsumerGroupInfo)
	return ok
}

type CannotDeleteConsumerGroupInfo struct {
	GroupId  uint32
	TopicId  uint32
	StreamId uint32
}

func (e CannotDeleteConsumerGroupInfo) Error() string {
	return fmt.Sprintf("failed to delete consumer group info file for id: %d for topic with id: %d for stream with id: %d.", e.GroupId, e.TopicId, e.StreamId)
}
func (e CannotDeleteConsumerGroupInfo) Code() Code { return 5008 }
func (e CannotDeleteConsumerGroupInfo) Is(target error) bool {
	_, ok := target.(CannotDeleteConsumerGroupInfo)
	return ok
}

type MissingBaseOffsetRetainedMessageBatch struct{}

func (e MissingBaseOffsetRetainedMessageBatch) Error() string { return "base offset is missing" }
func (e MissingBaseOffsetRetainedMessageBatch) Code() Code    { return 6000 }
func (e MissingBaseOffsetRetainedMessageBatch) Is(target error) bool {
	_, ok := target.(MissingBaseOffsetRetainedMessageBatch)
	return ok
}

type MissingLastOffsetDeltaRetainedMessageBatch struct{}

func (e MissingLastOffsetDeltaRetainedMessageBatch) Error() string {
	return "last offset delta is missing"
}
func (e MissingLastOffsetDeltaRetainedMessageBatch) Code() Code { return 6001 }
func (e MissingLastOffsetDeltaRetainedMessageBatch) Is(target error) bool {
	_, ok := target.(MissingLastOffsetDeltaRetainedMessageBatch)
	return ok
}

type MissingMaxTimestampRetainedMessageBatch struct{}

func (e MissingMaxTimestampRetainedMessageBatch) Error() string { return "max timestamp is missing" }
func (e MissingMaxTimestampRetainedMessageBatch) Code() Code    { return 6002 }
func (e MissingMaxTimestampRetainedMessageBatch) Is(target error) bool {
	_, ok := target.(MissingMaxTimestampRetainedMessageBatch)
	return ok
}

type MissingLengthRetainedMessageBatch struct{}

func (e MissingLengthRetainedMessageBatch) Error() string { return "length is missing" }
func (e MissingLengthRetainedMessageBatch) Code() Code    { return 6003 }
func (e MissingLengthRetainedMessageBatch) Is(target error) bool {
	_, ok := target.(MissingLengthRetainedMessageBatch)
	return ok
}

type MissingPayloadRetainedMessageBatch struct{}

func (e MissingPayloadRetainedMessageBatch) Error() string { return "payload is missing" }
func (e MissingPayloadRetainedMessageBatch) Code() Code    { return 6004 }
func (e MissingPayloadRetainedMessageBatch) Is(target error) bool {
	_, ok := target.(MissingPayloadRetainedMessageBatch)
	return ok
}

type CannotReadBatchBaseOffset struct{}

func (e CannotReadBatchBaseOffset) Error() string { return "cannot read batch base offset" }
func (e CannotReadBatchBaseOffset) Code() Code    { return 7000 }
func (e CannotReadBatchBaseOffset) Is(target error) bool {
	_, ok := target.(CannotReadBatchBaseOffset)
	return ok
}

type CannotReadBatchLength struct{}

func (e CannotReadBatchLength) Error() string { return "cannot read batch length" }
func (e CannotReadBatchLength) Code() Code    { return 7001 }
func (e CannotReadBatchLength) Is(target error) bool {
	_, ok := target.(CannotReadBatchLength)
	return ok
}

type CannotReadLastOffsetDelta struct{}

func (e CannotReadLastOffsetDelta) Error() string { return "cannot read batch last offset delta" }
func (e CannotReadLastOffsetDelta) Code() Code    { return 7002 }
func (e CannotReadLastOffsetDelta) Is(target error) bool {
	_, ok := target.(CannotReadLastOffsetDelta)
	return ok
}

type CannotReadMaxTimestamp struct{}

func (e CannotReadMaxTimestamp) Error() string { return "cannot read batch maximum timestamp" }
func (e CannotReadMaxTimestamp) Code() Code    { return 7003 }
func (e CannotReadMaxTimestamp) Is(target error) bool {
	_, ok := target.(CannotReadMaxTimestamp)
	return ok
}

type CannotReadBatchPayload struct{}

func (e CannotReadBatchPayload) Error() string { return "cannot read batch payload" }
func (e CannotReadBatchPayload) Code() Code    { return 7004 }
func (e CannotReadBatchPayload) Is(target error) bool {
	_, ok := target.(CannotReadBatchPayload)
	return ok
}

type InvalidConnectionString struct{}

func (e InvalidConnectionString) Error() string { return "invalid connection string" }
func (e InvalidConnectionString) Code() Code    { return 8000 }
func (e InvalidConnectionString) Is(target error) bool {
	_, ok := target.(InvalidConnectionString)
	return ok
}

type SnapshotFileCompletionFailed struct{}

func (e SnapshotFileCompletionFailed) Error() string { return "snapshot file completion failed" }
func (e SnapshotFileCompletionFailed) Code() Code    { return 9000 }
func (e SnapshotFileCompletionFailed) Is(target error) bool {
	_, ok := target.(SnapshotFileCompletionFailed)
	return ok
}

type CannotSerializeResource struct{}

func (e CannotSerializeResource) Error() string { return "cannot serialize resource" }
func (e CannotSerializeResource) Code() Code    { return 10000 }
func (e CannotSerializeResource) Is(target error) bool {
	_, ok := target.(CannotSerializeResource)
	return ok
}

type CannotDeserializeResource struct{}

func (e CannotDeserializeResource) Error() string { return "cannot deserialize resource" }
func (e CannotDeserializeResource) Code() Code    { return 10001 }
func (e CannotDeserializeResource) Is(target error) bool {
	_, ok := target.(CannotDeserializeResource)
	return ok
}

type CannotReadFile struct{}

func (e CannotReadFile) Error() string { return "cannot read file" }
func (e CannotReadFile) Code() Code    { return 10002 }
func (e CannotReadFile) Is(target error) bool {
	_, ok := target.(CannotReadFile)
	return ok
}

type CannotReadFileMetadata struct{}

func (e CannotReadFileMetadata) Error() string { return "cannot read file metadata" }
func (e CannotReadFileMetadata) Code() Code    { return 10003 }
func (e CannotReadFileMetadata) Is(target error) bool {
	_, ok := target.(CannotReadFileMetadata)
	return ok
}

type CannotSeekFile struct{}

func (e CannotSeekFile) Error() string { return "cannot seek file" }
func (e CannotSeekFile) Code() Code    { return 10004 }
func (e CannotSeekFile) Is(target error) bool {
	_, ok := target.(CannotSeekFile)
	return ok
}

type CannotAppendToFile struct{}

func (e CannotAppendToFile) Error() string { return "cannot append to file" }
func (e CannotAppendToFile) Code() Code    { return 10005 }
func (e CannotAppendToFile) Is(target error) bool {
	_, ok := target.(CannotAppendToFile)
	return ok
}

type CannotWriteToFile struct{}

func (e CannotWriteToFile) Error() string { return "cannot write to file" }
func (e CannotWriteToFile) Code() Code    { return 10006 }
func (e CannotWriteToFile) Is(target error) bool {
	_, ok := target.(CannotWriteToFile)
	return ok
}

type CannotOverwriteFile struct{}

func (e CannotOverwriteFile) Error() string { return "cannot overwrite file" }
func (e CannotOverwriteFile) Code() Code    { return 10007 }
func (e CannotOverwriteFile) Is(target error) bool {
	_, ok := target.(CannotOverwriteFile)
	return ok
}

type CannotDeleteFile struct{}

func (e CannotDeleteFile) Error() string { return "cannot delete file" }
func (e CannotDeleteFile) Code() Code    { return 10008 }
func (e CannotDeleteFile) Is(target error) bool {
	_, ok := target.(CannotDeleteFile)
	return ok
}

type CannotSyncFile struct{}

func (e CannotSyncFile) Error() string { return "cannot sync file" }
func (e CannotSyncFile) Code() Code    { return 10009 }
func (e CannotSyncFile) Is(target error) bool {
	_, ok := target.(CannotSyncFile)
	return ok
}

type CannotReadIndexOffset struct{}

func (e CannotReadIndexOffset) Error() string { return "cannot read index offset" }
func (e CannotReadIndexOffset) Code() Code    { return 10010 }
func (e CannotReadIndexOffset) Is(target error) bool {
	_, ok := target.(CannotReadIndexOffset)
	return ok
}

type CannotReadIndexPosition struct{}

func (e CannotReadIndexPosition) Error() string { return "cannot read index position" }
func (e CannotReadIndexPosition) Code() Code    { return 10011 }
func (e CannotReadIndexPosition) Is(target error) bool {
	_, ok := target.(CannotReadIndexPosition)
	return ok
}

type CannotReadIndexTimestamp struct{}

func (e CannotReadIndexTimestamp) Error() string { return "cannot read index timestamp" }
func (e CannotReadIndexTimestamp) Code() Code    { return 10012 }
func (e CannotReadIndexTimestamp) Is(target error) bool {
	_, ok := target.(CannotReadIndexTimestamp)
	return ok
}

var (
	ErrError                                      = Error{}
	ErrInvalidConfiguration                       = InvalidConfiguration{}
	ErrInvalidCommand                             = InvalidCommand{}
	ErrInvalidFormat                              = InvalidFormat{}
	ErrFeatureUnavailable                         = FeatureUnavailable{}
	ErrInvalidIdentifier                          = InvalidIdentifier{}
	ErrInvalidVersion                             = InvalidVersion{}
	ErrDisconnected                               = Disconnected{}
	ErrCannotEstablishConnection                  = CannotEstablishConnection{}
	ErrCannotCreateBaseDirectory                  = CannotCreateBaseDirectory{}
	ErrCannotCreateRuntimeDirectory               = CannotCreateRuntimeDirectory{}
	ErrCannotRemoveRuntimeDirectory               = CannotRemoveRuntimeDirectory{}
	ErrCannotCreateStateDirectory                 = CannotCreateStateDirectory{}
	ErrStateFileNotFound                          = StateFileNotFound{}
	ErrStateFileCorrupted                         = StateFileCorrupted{}
	ErrInvalidStateEntryChecksum                  = InvalidStateEntryChecksum{}
	ErrCannotOpenDatabase                         = CannotOpenDatabase{}
	ErrResourceNotFound                           = ResourceNotFound{}
	ErrStaleClient                                = StaleClient{}
	ErrTcpError                                   = TcpError{}
	ErrQuicError                                  = QuicError{}
	ErrInvalidServerAddress                       = InvalidServerAddress{}
	ErrInvalidClientAddress                       = InvalidClientAddress{}
	ErrInvalidIpAddress                           = InvalidIpAddress{}
	ErrUnauthenticated                            = Unauthenticated{}
	ErrUnauthorized                               = Unauthorized{}
	ErrInvalidCredentials                         = InvalidCredentials{}
	ErrInvalidUsername                            = InvalidUsername{}
	ErrInvalidPassword                            = InvalidPassword{}
	ErrInvalidUserStatus                          = InvalidUserStatus{}
	ErrUserAlreadyExists                          = UserAlreadyExists{}
	ErrUserInactive                               = UserInactive{}
	ErrCannotDeleteUser                           = CannotDeleteUser{}
	ErrCannotChangePermissions                    = CannotChangePermissions{}
	ErrInvalidPersonalAccessTokenName             = InvalidPersonalAccessTokenName{}
	ErrPersonalAccessTokenAlreadyExists           = PersonalAccessTokenAlreadyExists{}
	ErrPersonalAccessTokensLimitReached           = PersonalAccessTokensLimitReached{}
	ErrInvalidPersonalAccessToken                 = InvalidPersonalAccessToken{}
	ErrPersonalAccessTokenExpired                 = PersonalAccessTokenExpired{}
	ErrUsersLimitReached                          = UsersLimitReached{}
	ErrNotConnected                               = NotConnected{}
	ErrClientShutdown                             = ClientShutdown{}
	ErrInvalidTlsDomain                           = InvalidTlsDomain{}
	ErrInvalidTlsCertificatePath                  = InvalidTlsCertificatePath{}
	ErrInvalidTlsCertificate                      = InvalidTlsCertificate{}
	ErrFailedToAddCertificate                     = FailedToAddCertificate{}
	ErrInvalidEncryptionKey                       = InvalidEncryptionKey{}
	ErrCannotEncryptData                          = CannotEncryptData{}
	ErrCannotDecryptData                          = CannotDecryptData{}
	ErrInvalidJwtAlgorithm                        = InvalidJwtAlgorithm{}
	ErrInvalidJwtSecret                           = InvalidJwtSecret{}
	ErrJwtMissing                                 = JwtMissing{}
	ErrCannotGenerateJwt                          = CannotGenerateJwt{}
	ErrAccessTokenMissing                         = AccessTokenMissing{}
	ErrInvalidAccessToken                         = InvalidAccessToken{}
	ErrInvalidSizeBytes                           = InvalidSizeBytes{}
	ErrInvalidUtf8                                = InvalidUtf8{}
	ErrInvalidNumberEncoding                      = InvalidNumberEncoding{}
	ErrInvalidBooleanValue                        = InvalidBooleanValue{}
	ErrInvalidNumberValue                         = InvalidNumberValue{}
	ErrClientNotFound                             = ClientNotFound{}
	ErrInvalidClientId                            = InvalidClientId{}
	ErrConnectionClosed                           = ConnectionClosed{}
	ErrCannotParseHeaderKind                      = CannotParseHeaderKind{}
	ErrHttpResponseError                          = HttpResponseError{}
	ErrInvalidHttpRequest                         = InvalidHttpRequest{}
	ErrInvalidJsonResponse                        = InvalidJsonResponse{}
	ErrInvalidBytesResponse                       = InvalidBytesResponse{}
	ErrEmptyResponse                              = EmptyResponse{}
	ErrCannotCreateEndpoint                       = CannotCreateEndpoint{}
	ErrCannotParseUrl                             = CannotParseUrl{}
	ErrCannotCreateStreamsDirectory               = CannotCreateStreamsDirectory{}
	ErrCannotCreateStreamDirectory                = CannotCreateStreamDirectory{}
	ErrCannotCreateStreamInfo                     = CannotCreateStreamInfo{}
	ErrCannotUpdateStreamInfo                     = CannotUpdateStreamInfo{}
	ErrCannotOpenStreamInfo                       = CannotOpenStreamInfo{}
	ErrCannotReadStreamInfo                       = CannotReadStreamInfo{}
	ErrCannotCreateStream                         = CannotCreateStream{}
	ErrCannotDeleteStream                         = CannotDeleteStream{}
	ErrCannotDeleteStreamDirectory                = CannotDeleteStreamDirectory{}
	ErrStreamIdNotFound                           = StreamIdNotFound{}
	ErrStreamNameNotFound                         = StreamNameNotFound{}
	ErrStreamIdAlreadyExists                      = StreamIdAlreadyExists{}
	ErrStreamNameAlreadyExists                    = StreamNameAlreadyExists{}
	ErrInvalidStreamName                          = InvalidStreamName{}
	ErrInvalidStreamId                            = InvalidStreamId{}
	ErrCannotReadStreams                          = CannotReadStreams{}
	ErrInvalidTopicSize                           = InvalidTopicSize{}
	ErrCannotCreateTopicsDirectory                = CannotCreateTopicsDirectory{}
	ErrCannotCreateTopicDirectory                 = CannotCreateTopicDirectory{}
	ErrCannotCreateTopicInfo                      = CannotCreateTopicInfo{}
	ErrCannotUpdateTopicInfo                      = CannotUpdateTopicInfo{}
	ErrCannotOpenTopicInfo                        = CannotOpenTopicInfo{}
	ErrCannotReadTopicInfo                        = CannotReadTopicInfo{}
	ErrCannotCreateTopic                          = CannotCreateTopic{}
	ErrCannotDeleteTopic                          = CannotDeleteTopic{}
	ErrCannotDeleteTopicDirectory                 = CannotDeleteTopicDirectory{}
	ErrCannotPollTopic                            = CannotPollTopic{}
	ErrTopicIdNotFound                            = TopicIdNotFound{}
	ErrTopicNameNotFound                          = TopicNameNotFound{}
	ErrTopicIdAlreadyExists                       = TopicIdAlreadyExists{}
	ErrTopicNameAlreadyExists                     = TopicNameAlreadyExists{}
	ErrInvalidTopicName                           = InvalidTopicName{}
	ErrTooManyPartitions                          = TooManyPartitions{}
	ErrInvalidTopicId                             = InvalidTopicId{}
	ErrCannotReadTopics                           = CannotReadTopics{}
	ErrInvalidReplicationFactor                   = InvalidReplicationFactor{}
	ErrCannotCreatePartition                      = CannotCreatePartition{}
	ErrCannotCreatePartitionsDirectory            = CannotCreatePartitionsDirectory{}
	ErrCannotCreatePartitionDirectory             = CannotCreatePartitionDirectory{}
	ErrCannotOpenPartitionLogFile                 = CannotOpenPartitionLogFile{}
	ErrCannotReadPartitions                       = CannotReadPartitions{}
	ErrCannotDeletePartition                      = CannotDeletePartition{}
	ErrCannotDeletePartitionDirectory             = CannotDeletePartitionDirectory{}
	ErrPartitionNotFound                          = PartitionNotFound{}
	ErrNoPartitions                               = NoPartitions{}
	ErrTopicFull                                  = TopicFull{}
	ErrCannotDeleteConsumerOffsetsDirectory       = CannotDeleteConsumerOffsetsDirectory{}
	ErrCannotDeleteConsumerOffsetFile             = CannotDeleteConsumerOffsetFile{}
	ErrCannotCreateConsumerOffsetsDirectory       = CannotCreateConsumerOffsetsDirectory{}
	ErrCannotReadConsumerOffsets                  = CannotReadConsumerOffsets{}
	ErrConsumerOffsetNotFound                     = ConsumerOffsetNotFound{}
	ErrSegmentNotFound                            = SegmentNotFound{}
	ErrSegmentClosed                              = SegmentClosed{}
	ErrInvalidSegmentSize                         = InvalidSegmentSize{}
	ErrCannotCreateSegmentLogFile                 = CannotCreateSegmentLogFile{}
	ErrCannotCreateSegmentIndexFile               = CannotCreateSegmentIndexFile{}
	ErrCannotCreateSegmentTimeIndexFile           = CannotCreateSegmentTimeIndexFile{}
	ErrCannotSaveMessagesToSegment                = CannotSaveMessagesToSegment{}
	ErrCannotSaveIndexToSegment                   = CannotSaveIndexToSegment{}
	ErrCannotSaveTimeIndexToSegment               = CannotSaveTimeIndexToSegment{}
	ErrInvalidMessagesCount                       = InvalidMessagesCount{}
	ErrCannotAppendMessage                        = CannotAppendMessage{}
	ErrCannotReadMessage                          = CannotReadMessage{}
	ErrCannotReadMessageId                        = CannotReadMessageId{}
	ErrCannotReadMessageState                     = CannotReadMessageState{}
	ErrCannotReadMessageTimestamp                 = CannotReadMessageTimestamp{}
	ErrCannotReadHeadersLength                    = CannotReadHeadersLength{}
	ErrCannotReadHeadersPayload                   = CannotReadHeadersPayload{}
	ErrTooBigUserHeaders                          = TooBigUserHeaders{}
	ErrInvalidHeaderKey                           = InvalidHeaderKey{}
	ErrInvalidHeaderValue                         = InvalidHeaderValue{}
	ErrCannotReadMessageLength                    = CannotReadMessageLength{}
	ErrCannotReadMessagePayload                   = CannotReadMessagePayload{}
	ErrTooBigMessagePayload                       = TooBigMessagePayload{}
	ErrTooManyMessages                            = TooManyMessages{}
	ErrEmptyMessagePayload                        = EmptyMessagePayload{}
	ErrInvalidMessagePayloadLength                = InvalidMessagePayloadLength{}
	ErrCannotReadMessageChecksum                  = CannotReadMessageChecksum{}
	ErrInvalidMessageChecksum                     = InvalidMessageChecksum{}
	ErrInvalidKeyValueLength                      = InvalidKeyValueLength{}
	ErrCommandLengthError                         = CommandLengthError{}
	ErrInvalidSegmentsCount                       = InvalidSegmentsCount{}
	ErrNonZeroOffset                              = NonZeroOffset{}
	ErrNonZeroTimestamp                           = NonZeroTimestamp{}
	ErrMissingIndex                               = MissingIndex{}
	ErrInvalidIndexesByteSize                     = InvalidIndexesByteSize{}
	ErrInvalidIndexesCount                        = InvalidIndexesCount{}
	ErrInvalidMessagesSize                        = InvalidMessagesSize{}
	ErrTooSmallMessage                            = TooSmallMessage{}
	ErrCannotSendMessagesDueToClientDisconnection = CannotSendMessagesDueToClientDisconnection{}
	ErrBackgroundSendError                        = BackgroundSendError{}
	ErrBackgroundSendTimeout                      = BackgroundSendTimeout{}
	ErrBackgroundSendBufferFull                   = BackgroundSendBufferFull{}
	ErrBackgroundWorkerDisconnected               = BackgroundWorkerDisconnected{}
	ErrBackgroundSendBufferOverflow               = BackgroundSendBufferOverflow{}
	ErrProducerSendFailed                         = ProducerSendFailed{}
	ErrProducerClosed                             = ProducerClosed{}
	ErrInvalidOffset                              = InvalidOffset{}
	ErrConsumerGroupIdNotFound                    = ConsumerGroupIdNotFound{}
	ErrConsumerGroupIdAlreadyExists               = ConsumerGroupIdAlreadyExists{}
	ErrInvalidConsumerGroupId                     = InvalidConsumerGroupId{}
	ErrConsumerGroupNameNotFound                  = ConsumerGroupNameNotFound{}
	ErrConsumerGroupNameAlreadyExists             = ConsumerGroupNameAlreadyExists{}
	ErrInvalidConsumerGroupName                   = InvalidConsumerGroupName{}
	ErrConsumerGroupMemberNotFound                = ConsumerGroupMemberNotFound{}
	ErrCannotCreateConsumerGroupInfo              = CannotCreateConsumerGroupInfo{}
	ErrCannotDeleteConsumerGroupInfo              = CannotDeleteConsumerGroupInfo{}
	ErrMissingBaseOffsetRetainedMessageBatch      = MissingBaseOffsetRetainedMessageBatch{}
	ErrMissingLastOffsetDeltaRetainedMessageBatch = MissingLastOffsetDeltaRetainedMessageBatch{}
	ErrMissingMaxTimestampRetainedMessageBatch    = MissingMaxTimestampRetainedMessageBatch{}
	ErrMissingLengthRetainedMessageBatch          = MissingLengthRetainedMessageBatch{}
	ErrMissingPayloadRetainedMessageBatch         = MissingPayloadRetainedMessageBatch{}
	ErrCannotReadBatchBaseOffset                  = CannotReadBatchBaseOffset{}
	ErrCannotReadBatchLength                      = CannotReadBatchLength{}
	ErrCannotReadLastOffsetDelta                  = CannotReadLastOffsetDelta{}
	ErrCannotReadMaxTimestamp                     = CannotReadMaxTimestamp{}
	ErrCannotReadBatchPayload                     = CannotReadBatchPayload{}
	ErrInvalidConnectionString                    = InvalidConnectionString{}
	ErrSnapshotFileCompletionFailed               = SnapshotFileCompletionFailed{}
	ErrCannotSerializeResource                    = CannotSerializeResource{}
	ErrCannotDeserializeResource                  = CannotDeserializeResource{}
	ErrCannotReadFile                             = CannotReadFile{}
	ErrCannotReadFileMetadata                     = CannotReadFileMetadata{}
	ErrCannotSeekFile                             = CannotSeekFile{}
	ErrCannotAppendToFile                         = CannotAppendToFile{}
	ErrCannotWriteToFile                          = CannotWriteToFile{}
	ErrCannotOverwriteFile                        = CannotOverwriteFile{}
	ErrCannotDeleteFile                           = CannotDeleteFile{}
	ErrCannotSyncFile                             = CannotSyncFile{}
	ErrCannotReadIndexOffset                      = CannotReadIndexOffset{}
	ErrCannotReadIndexPosition                    = CannotReadIndexPosition{}
	ErrCannotReadIndexTimestamp                   = CannotReadIndexTimestamp{}
)

type Code uint32

const (
	ErrorCode                                      Code = 1
	InvalidConfigurationCode                       Code = 2
	InvalidCommandCode                             Code = 3
	InvalidFormatCode                              Code = 4
	FeatureUnavailableCode                         Code = 5
	InvalidIdentifierCode                          Code = 6
	InvalidVersionCode                             Code = 7
	DisconnectedCode                               Code = 8
	CannotEstablishConnectionCode                  Code = 9
	CannotCreateBaseDirectoryCode                  Code = 10
	CannotCreateRuntimeDirectoryCode               Code = 11
	CannotRemoveRuntimeDirectoryCode               Code = 12
	CannotCreateStateDirectoryCode                 Code = 13
	StateFileNotFoundCode                          Code = 14
	StateFileCorruptedCode                         Code = 15
	InvalidStateEntryChecksumCode                  Code = 16
	CannotOpenDatabaseCode                         Code = 19
	ResourceNotFoundCode                           Code = 20
	StaleClientCode                                Code = 30
	TcpErrorCode                                   Code = 31
	QuicErrorCode                                  Code = 32
	InvalidServerAddressCode                       Code = 33
	InvalidClientAddressCode                       Code = 34
	InvalidIpAddressCode                           Code = 35
	UnauthenticatedCode                            Code = 40
	UnauthorizedCode                               Code = 41
	InvalidCredentialsCode                         Code = 42
	InvalidUsernameCode                            Code = 43
	InvalidPasswordCode                            Code = 44
	InvalidUserStatusCode                          Code = 45
	UserAlreadyExistsCode                          Code = 46
	UserInactiveCode                               Code = 47
	CannotDeleteUserCode                           Code = 48
	CannotChangePermissionsCode                    Code = 49
	InvalidPersonalAccessTokenNameCode             Code = 50
	PersonalAccessTokenAlreadyExistsCode           Code = 51
	PersonalAccessTokensLimitReachedCode           Code = 52
	InvalidPersonalAccessTokenCode                 Code = 53
	PersonalAccessTokenExpiredCode                 Code = 54
	UsersLimitReachedCode                          Code = 55
	NotConnectedCode                               Code = 61
	ClientShutdownCode                             Code = 63
	InvalidTlsDomainCode                           Code = 64
	InvalidTlsCertificatePathCode                  Code = 65
	InvalidTlsCertificateCode                      Code = 66
	FailedToAddCertificateCode                     Code = 67
	InvalidEncryptionKeyCode                       Code = 70
	CannotEncryptDataCode                          Code = 71
	CannotDecryptDataCode                          Code = 72
	InvalidJwtAlgorithmCode                        Code = 73
	InvalidJwtSecretCode                           Code = 74
	JwtMissingCode                                 Code = 75
	CannotGenerateJwtCode                          Code = 76
	AccessTokenMissingCode                         Code = 77
	InvalidAccessTokenCode                         Code = 78
	InvalidSizeBytesCode                           Code = 80
	InvalidUtf8Code                                Code = 81
	InvalidNumberEncodingCode                      Code = 82
	InvalidBooleanValueCode                        Code = 83
	InvalidNumberValueCode                         Code = 84
	ClientNotFoundCode                             Code = 100
	InvalidClientIdCode                            Code = 101
	ConnectionClosedCode                           Code = 206
	CannotParseHeaderKindCode                      Code = 209
	HttpResponseErrorCode                          Code = 300
	InvalidHttpRequestCode                         Code = 301
	InvalidJsonResponseCode                        Code = 302
	InvalidBytesResponseCode                       Code = 303
	EmptyResponseCode                              Code = 304
	CannotCreateEndpointCode                       Code = 305
	CannotParseUrlCode                             Code = 306
	CannotCreateStreamsDirectoryCode               Code = 1000
	CannotCreateStreamDirectoryCode                Code = 1001
	CannotCreateStreamInfoCode                     Code = 1002
	CannotUpdateStreamInfoCode                     Code = 1003
	CannotOpenStreamInfoCode                       Code = 1004
	CannotReadStreamInfoCode                       Code = 1005
	CannotCreateStreamCode                         Code = 1006
	CannotDeleteStreamCode                         Code = 1007
	CannotDeleteStreamDirectoryCode                Code = 1008
	StreamIdNotFoundCode                           Code = 1009
	StreamNameNotFoundCode                         Code = 1010
	StreamIdAlreadyExistsCode                      Code = 1011
	StreamNameAlreadyExistsCode                    Code = 1012
	InvalidStreamNameCode                          Code = 1013
	InvalidStreamIdCode                            Code = 1014
	CannotReadStreamsCode                          Code = 1015
	InvalidTopicSizeCode                           Code = 1019
	CannotCreateTopicsDirectoryCode                Code = 2000
	CannotCreateTopicDirectoryCode                 Code = 2001
	CannotCreateTopicInfoCode                      Code = 2002
	CannotUpdateTopicInfoCode                      Code = 2003
	CannotOpenTopicInfoCode                        Code = 2004
	CannotReadTopicInfoCode                        Code = 2005
	CannotCreateTopicCode                          Code = 2006
	CannotDeleteTopicCode                          Code = 2007
	CannotDeleteTopicDirectoryCode                 Code = 2008
	CannotPollTopicCode                            Code = 2009
	TopicIdNotFoundCode                            Code = 2010
	TopicNameNotFoundCode                          Code = 2011
	TopicIdAlreadyExistsCode                       Code = 2012
	TopicNameAlreadyExistsCode                     Code = 2013
	InvalidTopicNameCode                           Code = 2014
	TooManyPartitionsCode                          Code = 2015
	InvalidTopicIdCode                             Code = 2016
	CannotReadTopicsCode                           Code = 2017
	InvalidReplicationFactorCode                   Code = 2018
	CannotCreatePartitionCode                      Code = 3000
	CannotCreatePartitionsDirectoryCode            Code = 3001
	CannotCreatePartitionDirectoryCode             Code = 3002
	CannotOpenPartitionLogFileCode                 Code = 3003
	CannotReadPartitionsCode                       Code = 3004
	CannotDeletePartitionCode                      Code = 3005
	CannotDeletePartitionDirectoryCode             Code = 3006
	PartitionNotFoundCode                          Code = 3007
	NoPartitionsCode                               Code = 3008
	TopicFullCode                                  Code = 3009
	CannotDeleteConsumerOffsetsDirectoryCode       Code = 3010
	CannotDeleteConsumerOffsetFileCode             Code = 3011
	CannotCreateConsumerOffsetsDirectoryCode       Code = 3012
	CannotReadConsumerOffsetsCode                  Code = 3020
	ConsumerOffsetNotFoundCode                     Code = 3021
	SegmentNotFoundCode                            Code = 4000
	SegmentClosedCode                              Code = 4001
	InvalidSegmentSizeCode                         Code = 4002
	CannotCreateSegmentLogFileCode                 Code = 4003
	CannotCreateSegmentIndexFileCode               Code = 4004
	CannotCreateSegmentTimeIndexFileCode           Code = 4005
	CannotSaveMessagesToSegmentCode                Code = 4006
	CannotSaveIndexToSegmentCode                   Code = 4007
	CannotSaveTimeIndexToSegmentCode               Code = 4008
	InvalidMessagesCountCode                       Code = 4009
	CannotAppendMessageCode                        Code = 4010
	CannotReadMessageCode                          Code = 4011
	CannotReadMessageIdCode                        Code = 4012
	CannotReadMessageStateCode                     Code = 4013
	CannotReadMessageTimestampCode                 Code = 4014
	CannotReadHeadersLengthCode                    Code = 4015
	CannotReadHeadersPayloadCode                   Code = 4016
	TooBigUserHeadersCode                          Code = 4017
	InvalidHeaderKeyCode                           Code = 4018
	InvalidHeaderValueCode                         Code = 4019
	CannotReadMessageLengthCode                    Code = 4020
	CannotReadMessagePayloadCode                   Code = 4021
	TooBigMessagePayloadCode                       Code = 4022
	TooManyMessagesCode                            Code = 4023
	EmptyMessagePayloadCode                        Code = 4024
	InvalidMessagePayloadLengthCode                Code = 4025
	CannotReadMessageChecksumCode                  Code = 4026
	InvalidMessageChecksumCode                     Code = 4027
	InvalidKeyValueLengthCode                      Code = 4028
	CommandLengthErrorCode                         Code = 4029
	InvalidSegmentsCountCode                       Code = 4030
	NonZeroOffsetCode                              Code = 4031
	NonZeroTimestampCode                           Code = 4032
	MissingIndexCode                               Code = 4033
	InvalidIndexesByteSizeCode                     Code = 4034
	InvalidIndexesCountCode                        Code = 4035
	InvalidMessagesSizeCode                        Code = 4036
	TooSmallMessageCode                            Code = 4037
	CannotSendMessagesDueToClientDisconnectionCode Code = 4050
	BackgroundSendErrorCode                        Code = 4051
	BackgroundSendTimeoutCode                      Code = 4052
	BackgroundSendBufferFullCode                   Code = 4053
	BackgroundWorkerDisconnectedCode               Code = 4054
	BackgroundSendBufferOverflowCode               Code = 4055
	ProducerSendFailedCode                         Code = 4056
	ProducerClosedCode                             Code = 4057
	InvalidOffsetCode                              Code = 4100
	ConsumerGroupIdNotFoundCode                    Code = 5000
	ConsumerGroupIdAlreadyExistsCode               Code = 5001
	InvalidConsumerGroupIdCode                     Code = 5002
	ConsumerGroupNameNotFoundCode                  Code = 5003
	ConsumerGroupNameAlreadyExistsCode             Code = 5004
	InvalidConsumerGroupNameCode                   Code = 5005
	ConsumerGroupMemberNotFoundCode                Code = 5006
	CannotCreateConsumerGroupInfoCode              Code = 5007
	CannotDeleteConsumerGroupInfoCode              Code = 5008
	MissingBaseOffsetRetainedMessageBatchCode      Code = 6000
	MissingLastOffsetDeltaRetainedMessageBatchCode Code = 6001
	MissingMaxTimestampRetainedMessageBatchCode    Code = 6002
	MissingLengthRetainedMessageBatchCode          Code = 6003
	MissingPayloadRetainedMessageBatchCode         Code = 6004
	CannotReadBatchBaseOffsetCode                  Code = 7000
	CannotReadBatchLengthCode                      Code = 7001
	CannotReadLastOffsetDeltaCode                  Code = 7002
	CannotReadMaxTimestampCode                     Code = 7003
	CannotReadBatchPayloadCode                     Code = 7004
	InvalidConnectionStringCode                    Code = 8000
	SnapshotFileCompletionFailedCode               Code = 9000
	CannotSerializeResourceCode                    Code = 10000
	CannotDeserializeResourceCode                  Code = 10001
	CannotReadFileCode                             Code = 10002
	CannotReadFileMetadataCode                     Code = 10003
	CannotSeekFileCode                             Code = 10004
	CannotAppendToFileCode                         Code = 10005
	CannotWriteToFileCode                          Code = 10006
	CannotOverwriteFileCode                        Code = 10007
	CannotDeleteFileCode                           Code = 10008
	CannotSyncFileCode                             Code = 10009
	CannotReadIndexOffsetCode                      Code = 10010
	CannotReadIndexPositionCode                    Code = 10011
	CannotReadIndexTimestampCode                   Code = 10012
)

func (c Code) String() string {
	switch c {
	case ErrorCode:
		return "Error"
	case InvalidConfigurationCode:
		return "InvalidConfiguration"
	case InvalidCommandCode:
		return "InvalidCommand"
	case InvalidFormatCode:
		return "InvalidFormat"
	case FeatureUnavailableCode:
		return "FeatureUnavailable"
	case InvalidIdentifierCode:
		return "InvalidIdentifier"
	case InvalidVersionCode:
		return "InvalidVersion"
	case DisconnectedCode:
		return "Disconnected"
	case CannotEstablishConnectionCode:
		return "CannotEstablishConnection"
	case CannotCreateBaseDirectoryCode:
		return "CannotCreateBaseDirectory"
	case CannotCreateRuntimeDirectoryCode:
		return "CannotCreateRuntimeDirectory"
	case CannotRemoveRuntimeDirectoryCode:
		return "CannotRemoveRuntimeDirectory"
	case CannotCreateStateDirectoryCode:
		return "CannotCreateStateDirectory"
	case StateFileNotFoundCode:
		return "StateFileNotFound"
	case StateFileCorruptedCode:
		return "StateFileCorrupted"
	case InvalidStateEntryChecksumCode:
		return "InvalidStateEntryChecksum"
	case CannotOpenDatabaseCode:
		return "CannotOpenDatabase"
	case ResourceNotFoundCode:
		return "ResourceNotFound"
	case StaleClientCode:
		return "StaleClient"
	case TcpErrorCode:
		return "TcpError"
	case QuicErrorCode:
		return "QuicError"
	case InvalidServerAddressCode:
		return "InvalidServerAddress"
	case InvalidClientAddressCode:
		return "InvalidClientAddress"
	case InvalidIpAddressCode:
		return "InvalidIpAddress"
	case UnauthenticatedCode:
		return "Unauthenticated"
	case UnauthorizedCode:
		return "Unauthorized"
	case InvalidCredentialsCode:
		return "InvalidCredentials"
	case InvalidUsernameCode:
		return "InvalidUsername"
	case InvalidPasswordCode:
		return "InvalidPassword"
	case InvalidUserStatusCode:
		return "InvalidUserStatus"
	case UserAlreadyExistsCode:
		return "UserAlreadyExists"
	case UserInactiveCode:
		return "UserInactive"
	case CannotDeleteUserCode:
		return "CannotDeleteUser"
	case CannotChangePermissionsCode:
		return "CannotChangePermissions"
	case InvalidPersonalAccessTokenNameCode:
		return "InvalidPersonalAccessTokenName"
	case PersonalAccessTokenAlreadyExistsCode:
		return "PersonalAccessTokenAlreadyExists"
	case PersonalAccessTokensLimitReachedCode:
		return "PersonalAccessTokensLimitReached"
	case InvalidPersonalAccessTokenCode:
		return "InvalidPersonalAccessToken"
	case PersonalAccessTokenExpiredCode:
		return "PersonalAccessTokenExpired"
	case UsersLimitReachedCode:
		return "UsersLimitReached"
	case NotConnectedCode:
		return "NotConnected"
	case ClientShutdownCode:
		return "ClientShutdown"
	case InvalidTlsDomainCode:
		return "InvalidTlsDomain"
	case InvalidTlsCertificatePathCode:
		return "InvalidTlsCertificatePath"
	case InvalidTlsCertificateCode:
		return "InvalidTlsCertificate"
	case FailedToAddCertificateCode:
		return "FailedToAddCertificate"
	case InvalidEncryptionKeyCode:
		return "InvalidEncryptionKey"
	case CannotEncryptDataCode:
		return "CannotEncryptData"
	case CannotDecryptDataCode:
		return "CannotDecryptData"
	case InvalidJwtAlgorithmCode:
		return "InvalidJwtAlgorithm"
	case InvalidJwtSecretCode:
		return "InvalidJwtSecret"
	case JwtMissingCode:
		return "JwtMissing"
	case CannotGenerateJwtCode:
		return "CannotGenerateJwt"
	case AccessTokenMissingCode:
		return "AccessTokenMissing"
	case InvalidAccessTokenCode:
		return "InvalidAccessToken"
	case InvalidSizeBytesCode:
		return "InvalidSizeBytes"
	case InvalidUtf8Code:
		return "InvalidUtf8"
	case InvalidNumberEncodingCode:
		return "InvalidNumberEncoding"
	case InvalidBooleanValueCode:
		return "InvalidBooleanValue"
	case InvalidNumberValueCode:
		return "InvalidNumberValue"
	case ClientNotFoundCode:
		return "ClientNotFound"
	case InvalidClientIdCode:
		return "InvalidClientId"
	case ConnectionClosedCode:
		return "ConnectionClosed"
	case CannotParseHeaderKindCode:
		return "CannotParseHeaderKind"
	case HttpResponseErrorCode:
		return "HttpResponseError"
	case InvalidHttpRequestCode:
		return "InvalidHttpRequest"
	case InvalidJsonResponseCode:
		return "InvalidJsonResponse"
	case InvalidBytesResponseCode:
		return "InvalidBytesResponse"
	case EmptyResponseCode:
		return "EmptyResponse"
	case CannotCreateEndpointCode:
		return "CannotCreateEndpoint"
	case CannotParseUrlCode:
		return "CannotParseUrl"
	case CannotCreateStreamsDirectoryCode:
		return "CannotCreateStreamsDirectory"
	case CannotCreateStreamDirectoryCode:
		return "CannotCreateStreamDirectory"
	case CannotCreateStreamInfoCode:
		return "CannotCreateStreamInfo"
	case CannotUpdateStreamInfoCode:
		return "CannotUpdateStreamInfo"
	case CannotOpenStreamInfoCode:
		return "CannotOpenStreamInfo"
	case CannotReadStreamInfoCode:
		return "CannotReadStreamInfo"
	case CannotCreateStreamCode:
		return "CannotCreateStream"
	case CannotDeleteStreamCode:
		return "CannotDeleteStream"
	case CannotDeleteStreamDirectoryCode:
		return "CannotDeleteStreamDirectory"
	case StreamIdNotFoundCode:
		return "StreamIdNotFound"
	case StreamNameNotFoundCode:
		return "StreamNameNotFound"
	case StreamIdAlreadyExistsCode:
		return "StreamIdAlreadyExists"
	case StreamNameAlreadyExistsCode:
		return "StreamNameAlreadyExists"
	case InvalidStreamNameCode:
		return "InvalidStreamName"
	case InvalidStreamIdCode:
		return "InvalidStreamId"
	case CannotReadStreamsCode:
		return "CannotReadStreams"
	case InvalidTopicSizeCode:
		return "InvalidTopicSize"
	case CannotCreateTopicsDirectoryCode:
		return "CannotCreateTopicsDirectory"
	case CannotCreateTopicDirectoryCode:
		return "CannotCreateTopicDirectory"
	case CannotCreateTopicInfoCode:
		return "CannotCreateTopicInfo"
	case CannotUpdateTopicInfoCode:
		return "CannotUpdateTopicInfo"
	case CannotOpenTopicInfoCode:
		return "CannotOpenTopicInfo"
	case CannotReadTopicInfoCode:
		return "CannotReadTopicInfo"
	case CannotCreateTopicCode:
		return "CannotCreateTopic"
	case CannotDeleteTopicCode:
		return "CannotDeleteTopic"
	case CannotDeleteTopicDirectoryCode:
		return "CannotDeleteTopicDirectory"
	case CannotPollTopicCode:
		return "CannotPollTopic"
	case TopicIdNotFoundCode:
		return "TopicIdNotFound"
	case TopicNameNotFoundCode:
		return "TopicNameNotFound"
	case TopicIdAlreadyExistsCode:
		return "TopicIdAlreadyExists"
	case TopicNameAlreadyExistsCode:
		return "TopicNameAlreadyExists"
	case InvalidTopicNameCode:
		return "InvalidTopicName"
	case TooManyPartitionsCode:
		return "TooManyPartitions"
	case InvalidTopicIdCode:
		return "InvalidTopicId"
	case CannotReadTopicsCode:
		return "CannotReadTopics"
	case InvalidReplicationFactorCode:
		return "InvalidReplicationFactor"
	case CannotCreatePartitionCode:
		return "CannotCreatePartition"
	case CannotCreatePartitionsDirectoryCode:
		return "CannotCreatePartitionsDirectory"
	case CannotCreatePartitionDirectoryCode:
		return "CannotCreatePartitionDirectory"
	case CannotOpenPartitionLogFileCode:
		return "CannotOpenPartitionLogFile"
	case CannotReadPartitionsCode:
		return "CannotReadPartitions"
	case CannotDeletePartitionCode:
		return "CannotDeletePartition"
	case CannotDeletePartitionDirectoryCode:
		return "CannotDeletePartitionDirectory"
	case PartitionNotFoundCode:
		return "PartitionNotFound"
	case NoPartitionsCode:
		return "NoPartitions"
	case TopicFullCode:
		return "TopicFull"
	case CannotDeleteConsumerOffsetsDirectoryCode:
		return "CannotDeleteConsumerOffsetsDirectory"
	case CannotDeleteConsumerOffsetFileCode:
		return "CannotDeleteConsumerOffsetFile"
	case CannotCreateConsumerOffsetsDirectoryCode:
		return "CannotCreateConsumerOffsetsDirectory"
	case CannotReadConsumerOffsetsCode:
		return "CannotReadConsumerOffsets"
	case ConsumerOffsetNotFoundCode:
		return "ConsumerOffsetNotFound"
	case SegmentNotFoundCode:
		return "SegmentNotFound"
	case SegmentClosedCode:
		return "SegmentClosed"
	case InvalidSegmentSizeCode:
		return "InvalidSegmentSize"
	case CannotCreateSegmentLogFileCode:
		return "CannotCreateSegmentLogFile"
	case CannotCreateSegmentIndexFileCode:
		return "CannotCreateSegmentIndexFile"
	case CannotCreateSegmentTimeIndexFileCode:
		return "CannotCreateSegmentTimeIndexFile"
	case CannotSaveMessagesToSegmentCode:
		return "CannotSaveMessagesToSegment"
	case CannotSaveIndexToSegmentCode:
		return "CannotSaveIndexToSegment"
	case CannotSaveTimeIndexToSegmentCode:
		return "CannotSaveTimeIndexToSegment"
	case InvalidMessagesCountCode:
		return "InvalidMessagesCount"
	case CannotAppendMessageCode:
		return "CannotAppendMessage"
	case CannotReadMessageCode:
		return "CannotReadMessage"
	case CannotReadMessageIdCode:
		return "CannotReadMessageId"
	case CannotReadMessageStateCode:
		return "CannotReadMessageState"
	case CannotReadMessageTimestampCode:
		return "CannotReadMessageTimestamp"
	case CannotReadHeadersLengthCode:
		return "CannotReadHeadersLength"
	case CannotReadHeadersPayloadCode:
		return "CannotReadHeadersPayload"
	case TooBigUserHeadersCode:
		return "TooBigUserHeaders"
	case InvalidHeaderKeyCode:
		return "InvalidHeaderKey"
	case InvalidHeaderValueCode:
		return "InvalidHeaderValue"
	case CannotReadMessageLengthCode:
		return "CannotReadMessageLength"
	case CannotReadMessagePayloadCode:
		return "CannotReadMessagePayload"
	case TooBigMessagePayloadCode:
		return "TooBigMessagePayload"
	case TooManyMessagesCode:
		return "TooManyMessages"
	case EmptyMessagePayloadCode:
		return "EmptyMessagePayload"
	case InvalidMessagePayloadLengthCode:
		return "InvalidMessagePayloadLength"
	case CannotReadMessageChecksumCode:
		return "CannotReadMessageChecksum"
	case InvalidMessageChecksumCode:
		return "InvalidMessageChecksum"
	case InvalidKeyValueLengthCode:
		return "InvalidKeyValueLength"
	case CommandLengthErrorCode:
		return "CommandLengthError"
	case InvalidSegmentsCountCode:
		return "InvalidSegmentsCount"
	case NonZeroOffsetCode:
		return "NonZeroOffset"
	case NonZeroTimestampCode:
		return "NonZeroTimestamp"
	case MissingIndexCode:
		return "MissingIndex"
	case InvalidIndexesByteSizeCode:
		return "InvalidIndexesByteSize"
	case InvalidIndexesCountCode:
		return "InvalidIndexesCount"
	case InvalidMessagesSizeCode:
		return "InvalidMessagesSize"
	case TooSmallMessageCode:
		return "TooSmallMessage"
	case CannotSendMessagesDueToClientDisconnectionCode:
		return "CannotSendMessagesDueToClientDisconnection"
	case BackgroundSendErrorCode:
		return "BackgroundSendError"
	case BackgroundSendTimeoutCode:
		return "BackgroundSendTimeout"
	case BackgroundSendBufferFullCode:
		return "BackgroundSendBufferFull"
	case BackgroundWorkerDisconnectedCode:
		return "BackgroundWorkerDisconnected"
	case BackgroundSendBufferOverflowCode:
		return "BackgroundSendBufferOverflow"
	case ProducerSendFailedCode:
		return "ProducerSendFailed"
	case ProducerClosedCode:
		return "ProducerClosed"
	case InvalidOffsetCode:
		return "InvalidOffset"
	case ConsumerGroupIdNotFoundCode:
		return "ConsumerGroupIdNotFound"
	case ConsumerGroupIdAlreadyExistsCode:
		return "ConsumerGroupIdAlreadyExists"
	case InvalidConsumerGroupIdCode:
		return "InvalidConsumerGroupId"
	case ConsumerGroupNameNotFoundCode:
		return "ConsumerGroupNameNotFound"
	case ConsumerGroupNameAlreadyExistsCode:
		return "ConsumerGroupNameAlreadyExists"
	case InvalidConsumerGroupNameCode:
		return "InvalidConsumerGroupName"
	case ConsumerGroupMemberNotFoundCode:
		return "ConsumerGroupMemberNotFound"
	case CannotCreateConsumerGroupInfoCode:
		return "CannotCreateConsumerGroupInfo"
	case CannotDeleteConsumerGroupInfoCode:
		return "CannotDeleteConsumerGroupInfo"
	case MissingBaseOffsetRetainedMessageBatchCode:
		return "MissingBaseOffsetRetainedMessageBatch"
	case MissingLastOffsetDeltaRetainedMessageBatchCode:
		return "MissingLastOffsetDeltaRetainedMessageBatch"
	case MissingMaxTimestampRetainedMessageBatchCode:
		return "MissingMaxTimestampRetainedMessageBatch"
	case MissingLengthRetainedMessageBatchCode:
		return "MissingLengthRetainedMessageBatch"
	case MissingPayloadRetainedMessageBatchCode:
		return "MissingPayloadRetainedMessageBatch"
	case CannotReadBatchBaseOffsetCode:
		return "CannotReadBatchBaseOffset"
	case CannotReadBatchLengthCode:
		return "CannotReadBatchLength"
	case CannotReadLastOffsetDeltaCode:
		return "CannotReadLastOffsetDelta"
	case CannotReadMaxTimestampCode:
		return "CannotReadMaxTimestamp"
	case CannotReadBatchPayloadCode:
		return "CannotReadBatchPayload"
	case InvalidConnectionStringCode:
		return "InvalidConnectionString"
	case SnapshotFileCompletionFailedCode:
		return "SnapshotFileCompletionFailed"
	case CannotSerializeResourceCode:
		return "CannotSerializeResource"
	case CannotDeserializeResourceCode:
		return "CannotDeserializeResource"
	case CannotReadFileCode:
		return "CannotReadFile"
	case CannotReadFileMetadataCode:
		return "CannotReadFileMetadata"
	case CannotSeekFileCode:
		return "CannotSeekFile"
	case CannotAppendToFileCode:
		return "CannotAppendToFile"
	case CannotWriteToFileCode:
		return "CannotWriteToFile"
	case CannotOverwriteFileCode:
		return "CannotOverwriteFile"
	case CannotDeleteFileCode:
		return "CannotDeleteFile"
	case CannotSyncFileCode:
		return "CannotSyncFile"
	case CannotReadIndexOffsetCode:
		return "CannotReadIndexOffset"
	case CannotReadIndexPositionCode:
		return "CannotReadIndexPosition"
	case CannotReadIndexTimestampCode:
		return "CannotReadIndexTimestamp"
	default:
		return "Unknown error code"
	}
}

func FromCode(code Code) IggyError {
	switch code {
	case ErrorCode:
		return ErrError
	case InvalidConfigurationCode:
		return ErrInvalidConfiguration
	case InvalidCommandCode:
		return ErrInvalidCommand
	case InvalidFormatCode:
		return ErrInvalidFormat
	case FeatureUnavailableCode:
		return ErrFeatureUnavailable
	case InvalidIdentifierCode:
		return ErrInvalidIdentifier
	case InvalidVersionCode:
		return ErrInvalidVersion
	case DisconnectedCode:
		return ErrDisconnected
	case CannotEstablishConnectionCode:
		return ErrCannotEstablishConnection
	case CannotCreateBaseDirectoryCode:
		return ErrCannotCreateBaseDirectory
	case CannotCreateRuntimeDirectoryCode:
		return ErrCannotCreateRuntimeDirectory
	case CannotRemoveRuntimeDirectoryCode:
		return ErrCannotRemoveRuntimeDirectory
	case CannotCreateStateDirectoryCode:
		return ErrCannotCreateStateDirectory
	case StateFileNotFoundCode:
		return ErrStateFileNotFound
	case StateFileCorruptedCode:
		return ErrStateFileCorrupted
	case InvalidStateEntryChecksumCode:
		return ErrInvalidStateEntryChecksum
	case CannotOpenDatabaseCode:
		return ErrCannotOpenDatabase
	case ResourceNotFoundCode:
		return ErrResourceNotFound
	case StaleClientCode:
		return ErrStaleClient
	case TcpErrorCode:
		return ErrTcpError
	case QuicErrorCode:
		return ErrQuicError
	case InvalidServerAddressCode:
		return ErrInvalidServerAddress
	case InvalidClientAddressCode:
		return ErrInvalidClientAddress
	case InvalidIpAddressCode:
		return ErrInvalidIpAddress
	case UnauthenticatedCode:
		return ErrUnauthenticated
	case UnauthorizedCode:
		return ErrUnauthorized
	case InvalidCredentialsCode:
		return ErrInvalidCredentials
	case InvalidUsernameCode:
		return ErrInvalidUsername
	case InvalidPasswordCode:
		return ErrInvalidPassword
	case InvalidUserStatusCode:
		return ErrInvalidUserStatus
	case UserAlreadyExistsCode:
		return ErrUserAlreadyExists
	case UserInactiveCode:
		return ErrUserInactive
	case CannotDeleteUserCode:
		return ErrCannotDeleteUser
	case CannotChangePermissionsCode:
		return ErrCannotChangePermissions
	case InvalidPersonalAccessTokenNameCode:
		return ErrInvalidPersonalAccessTokenName
	case PersonalAccessTokenAlreadyExistsCode:
		return ErrPersonalAccessTokenAlreadyExists
	case PersonalAccessTokensLimitReachedCode:
		return ErrPersonalAccessTokensLimitReached
	case InvalidPersonalAccessTokenCode:
		return ErrInvalidPersonalAccessToken
	case PersonalAccessTokenExpiredCode:
		return ErrPersonalAccessTokenExpired
	case UsersLimitReachedCode:
		return ErrUsersLimitReached
	case NotConnectedCode:
		return ErrNotConnected
	case ClientShutdownCode:
		return ErrClientShutdown
	case InvalidTlsDomainCode:
		return ErrInvalidTlsDomain
	case InvalidTlsCertificatePathCode:
		return ErrInvalidTlsCertificatePath
	case InvalidTlsCertificateCode:
		return ErrInvalidTlsCertificate
	case FailedToAddCertificateCode:
		return ErrFailedToAddCertificate
	case InvalidEncryptionKeyCode:
		return ErrInvalidEncryptionKey
	case CannotEncryptDataCode:
		return ErrCannotEncryptData
	case CannotDecryptDataCode:
		return ErrCannotDecryptData
	case InvalidJwtAlgorithmCode:
		return ErrInvalidJwtAlgorithm
	case InvalidJwtSecretCode:
		return ErrInvalidJwtSecret
	case JwtMissingCode:
		return ErrJwtMissing
	case CannotGenerateJwtCode:
		return ErrCannotGenerateJwt
	case AccessTokenMissingCode:
		return ErrAccessTokenMissing
	case InvalidAccessTokenCode:
		return ErrInvalidAccessToken
	case InvalidSizeBytesCode:
		return ErrInvalidSizeBytes
	case InvalidUtf8Code:
		return ErrInvalidUtf8
	case InvalidNumberEncodingCode:
		return ErrInvalidNumberEncoding
	case InvalidBooleanValueCode:
		return ErrInvalidBooleanValue
	case InvalidNumberValueCode:
		return ErrInvalidNumberValue
	case ClientNotFoundCode:
		return ErrClientNotFound
	case InvalidClientIdCode:
		return ErrInvalidClientId
	case ConnectionClosedCode:
		return ErrConnectionClosed
	case CannotParseHeaderKindCode:
		return ErrCannotParseHeaderKind
	case HttpResponseErrorCode:
		return ErrHttpResponseError
	case InvalidHttpRequestCode:
		return ErrInvalidHttpRequest
	case InvalidJsonResponseCode:
		return ErrInvalidJsonResponse
	case InvalidBytesResponseCode:
		return ErrInvalidBytesResponse
	case EmptyResponseCode:
		return ErrEmptyResponse
	case CannotCreateEndpointCode:
		return ErrCannotCreateEndpoint
	case CannotParseUrlCode:
		return ErrCannotParseUrl
	case CannotCreateStreamsDirectoryCode:
		return ErrCannotCreateStreamsDirectory
	case CannotCreateStreamDirectoryCode:
		return ErrCannotCreateStreamDirectory
	case CannotCreateStreamInfoCode:
		return ErrCannotCreateStreamInfo
	case CannotUpdateStreamInfoCode:
		return ErrCannotUpdateStreamInfo
	case CannotOpenStreamInfoCode:
		return ErrCannotOpenStreamInfo
	case CannotReadStreamInfoCode:
		return ErrCannotReadStreamInfo
	case CannotCreateStreamCode:
		return ErrCannotCreateStream
	case CannotDeleteStreamCode:
		return ErrCannotDeleteStream
	case CannotDeleteStreamDirectoryCode:
		return ErrCannotDeleteStreamDirectory
	case StreamIdNotFoundCode:
		return ErrStreamIdNotFound
	case StreamNameNotFoundCode:
		return ErrStreamNameNotFound
	case StreamIdAlreadyExistsCode:
		return ErrStreamIdAlreadyExists
	case StreamNameAlreadyExistsCode:
		return ErrStreamNameAlreadyExists
	case InvalidStreamNameCode:
		return ErrInvalidStreamName
	case InvalidStreamIdCode:
		return ErrInvalidStreamId
	case CannotReadStreamsCode:
		return ErrCannotReadStreams
	case InvalidTopicSizeCode:
		return ErrInvalidTopicSize
	case CannotCreateTopicsDirectoryCode:
		return ErrCannotCreateTopicsDirectory
	case CannotCreateTopicDirectoryCode:
		return ErrCannotCreateTopicDirectory
	case CannotCreateTopicInfoCode:
		return ErrCannotCreateTopicInfo
	case CannotUpdateTopicInfoCode:
		return ErrCannotUpdateTopicInfo
	case CannotOpenTopicInfoCode:
		return ErrCannotOpenTopicInfo
	case CannotReadTopicInfoCode:
		return ErrCannotReadTopicInfo
	case CannotCreateTopicCode:
		return ErrCannotCreateTopic
	case CannotDeleteTopicCode:
		return ErrCannotDeleteTopic
	case CannotDeleteTopicDirectoryCode:
		return ErrCannotDeleteTopicDirectory
	case CannotPollTopicCode:
		return ErrCannotPollTopic
	case TopicIdNotFoundCode:
		return ErrTopicIdNotFound
	case TopicNameNotFoundCode:
		return ErrTopicNameNotFound
	case TopicIdAlreadyExistsCode:
		return ErrTopicIdAlreadyExists
	case TopicNameAlreadyExistsCode:
		return ErrTopicNameAlreadyExists
	case InvalidTopicNameCode:
		return ErrInvalidTopicName
	case TooManyPartitionsCode:
		return ErrTooManyPartitions
	case InvalidTopicIdCode:
		return ErrInvalidTopicId
	case CannotReadTopicsCode:
		return ErrCannotReadTopics
	case InvalidReplicationFactorCode:
		return ErrInvalidReplicationFactor
	case CannotCreatePartitionCode:
		return ErrCannotCreatePartition
	case CannotCreatePartitionsDirectoryCode:
		return ErrCannotCreatePartitionsDirectory
	case CannotCreatePartitionDirectoryCode:
		return ErrCannotCreatePartitionDirectory
	case CannotOpenPartitionLogFileCode:
		return ErrCannotOpenPartitionLogFile
	case CannotReadPartitionsCode:
		return ErrCannotReadPartitions
	case CannotDeletePartitionCode:
		return ErrCannotDeletePartition
	case CannotDeletePartitionDirectoryCode:
		return ErrCannotDeletePartitionDirectory
	case PartitionNotFoundCode:
		return ErrPartitionNotFound
	case NoPartitionsCode:
		return ErrNoPartitions
	case TopicFullCode:
		return ErrTopicFull
	case CannotDeleteConsumerOffsetsDirectoryCode:
		return ErrCannotDeleteConsumerOffsetsDirectory
	case CannotDeleteConsumerOffsetFileCode:
		return ErrCannotDeleteConsumerOffsetFile
	case CannotCreateConsumerOffsetsDirectoryCode:
		return ErrCannotCreateConsumerOffsetsDirectory
	case CannotReadConsumerOffsetsCode:
		return ErrCannotReadConsumerOffsets
	case ConsumerOffsetNotFoundCode:
		return ErrConsumerOffsetNotFound
	case SegmentNotFoundCode:
		return ErrSegmentNotFound
	case SegmentClosedCode:
		return ErrSegmentClosed
	case InvalidSegmentSizeCode:
		return ErrInvalidSegmentSize
	case CannotCreateSegmentLogFileCode:
		return ErrCannotCreateSegmentLogFile
	case CannotCreateSegmentIndexFileCode:
		return ErrCannotCreateSegmentIndexFile
	case CannotCreateSegmentTimeIndexFileCode:
		return ErrCannotCreateSegmentTimeIndexFile
	case CannotSaveMessagesToSegmentCode:
		return ErrCannotSaveMessagesToSegment
	case CannotSaveIndexToSegmentCode:
		return ErrCannotSaveIndexToSegment
	case CannotSaveTimeIndexToSegmentCode:
		return ErrCannotSaveTimeIndexToSegment
	case InvalidMessagesCountCode:
		return ErrInvalidMessagesCount
	case CannotAppendMessageCode:
		return ErrCannotAppendMessage
	case CannotReadMessageCode:
		return ErrCannotReadMessage
	case CannotReadMessageIdCode:
		return ErrCannotReadMessageId
	case CannotReadMessageStateCode:
		return ErrCannotReadMessageState
	case CannotReadMessageTimestampCode:
		return ErrCannotReadMessageTimestamp
	case CannotReadHeadersLengthCode:
		return ErrCannotReadHeadersLength
	case CannotReadHeadersPayloadCode:
		return ErrCannotReadHeadersPayload
	case TooBigUserHeadersCode:
		return ErrTooBigUserHeaders
	case InvalidHeaderKeyCode:
		return ErrInvalidHeaderKey
	case InvalidHeaderValueCode:
		return ErrInvalidHeaderValue
	case CannotReadMessageLengthCode:
		return ErrCannotReadMessageLength
	case CannotReadMessagePayloadCode:
		return ErrCannotReadMessagePayload
	case TooBigMessagePayloadCode:
		return ErrTooBigMessagePayload
	case TooManyMessagesCode:
		return ErrTooManyMessages
	case EmptyMessagePayloadCode:
		return ErrEmptyMessagePayload
	case InvalidMessagePayloadLengthCode:
		return ErrInvalidMessagePayloadLength
	case CannotReadMessageChecksumCode:
		return ErrCannotReadMessageChecksum
	case InvalidMessageChecksumCode:
		return ErrInvalidMessageChecksum
	case InvalidKeyValueLengthCode:
		return ErrInvalidKeyValueLength
	case CommandLengthErrorCode:
		return ErrCommandLengthError
	case InvalidSegmentsCountCode:
		return ErrInvalidSegmentsCount
	case NonZeroOffsetCode:
		return ErrNonZeroOffset
	case NonZeroTimestampCode:
		return ErrNonZeroTimestamp
	case MissingIndexCode:
		return ErrMissingIndex
	case InvalidIndexesByteSizeCode:
		return ErrInvalidIndexesByteSize
	case InvalidIndexesCountCode:
		return ErrInvalidIndexesCount
	case InvalidMessagesSizeCode:
		return ErrInvalidMessagesSize
	case TooSmallMessageCode:
		return ErrTooSmallMessage
	case CannotSendMessagesDueToClientDisconnectionCode:
		return ErrCannotSendMessagesDueToClientDisconnection
	case BackgroundSendErrorCode:
		return ErrBackgroundSendError
	case BackgroundSendTimeoutCode:
		return ErrBackgroundSendTimeout
	case BackgroundSendBufferFullCode:
		return ErrBackgroundSendBufferFull
	case BackgroundWorkerDisconnectedCode:
		return ErrBackgroundWorkerDisconnected
	case BackgroundSendBufferOverflowCode:
		return ErrBackgroundSendBufferOverflow
	case ProducerSendFailedCode:
		return ErrProducerSendFailed
	case ProducerClosedCode:
		return ErrProducerClosed
	case InvalidOffsetCode:
		return ErrInvalidOffset
	case ConsumerGroupIdNotFoundCode:
		return ErrConsumerGroupIdNotFound
	case ConsumerGroupIdAlreadyExistsCode:
		return ErrConsumerGroupIdAlreadyExists
	case InvalidConsumerGroupIdCode:
		return ErrInvalidConsumerGroupId
	case ConsumerGroupNameNotFoundCode:
		return ErrConsumerGroupNameNotFound
	case ConsumerGroupNameAlreadyExistsCode:
		return ErrConsumerGroupNameAlreadyExists
	case InvalidConsumerGroupNameCode:
		return ErrInvalidConsumerGroupName
	case ConsumerGroupMemberNotFoundCode:
		return ErrConsumerGroupMemberNotFound
	case CannotCreateConsumerGroupInfoCode:
		return ErrCannotCreateConsumerGroupInfo
	case CannotDeleteConsumerGroupInfoCode:
		return ErrCannotDeleteConsumerGroupInfo
	case MissingBaseOffsetRetainedMessageBatchCode:
		return ErrMissingBaseOffsetRetainedMessageBatch
	case MissingLastOffsetDeltaRetainedMessageBatchCode:
		return ErrMissingLastOffsetDeltaRetainedMessageBatch
	case MissingMaxTimestampRetainedMessageBatchCode:
		return ErrMissingMaxTimestampRetainedMessageBatch
	case MissingLengthRetainedMessageBatchCode:
		return ErrMissingLengthRetainedMessageBatch
	case MissingPayloadRetainedMessageBatchCode:
		return ErrMissingPayloadRetainedMessageBatch
	case CannotReadBatchBaseOffsetCode:
		return ErrCannotReadBatchBaseOffset
	case CannotReadBatchLengthCode:
		return ErrCannotReadBatchLength
	case CannotReadLastOffsetDeltaCode:
		return ErrCannotReadLastOffsetDelta
	case CannotReadMaxTimestampCode:
		return ErrCannotReadMaxTimestamp
	case CannotReadBatchPayloadCode:
		return ErrCannotReadBatchPayload
	case InvalidConnectionStringCode:
		return ErrInvalidConnectionString
	case SnapshotFileCompletionFailedCode:
		return ErrSnapshotFileCompletionFailed
	case CannotSerializeResourceCode:
		return ErrCannotSerializeResource
	case CannotDeserializeResourceCode:
		return ErrCannotDeserializeResource
	case CannotReadFileCode:
		return ErrCannotReadFile
	case CannotReadFileMetadataCode:
		return ErrCannotReadFileMetadata
	case CannotSeekFileCode:
		return ErrCannotSeekFile
	case CannotAppendToFileCode:
		return ErrCannotAppendToFile
	case CannotWriteToFileCode:
		return ErrCannotWriteToFile
	case CannotOverwriteFileCode:
		return ErrCannotOverwriteFile
	case CannotDeleteFileCode:
		return ErrCannotDeleteFile
	case CannotSyncFileCode:
		return ErrCannotSyncFile
	case CannotReadIndexOffsetCode:
		return ErrCannotReadIndexOffset
	case CannotReadIndexPositionCode:
		return ErrCannotReadIndexPosition
	case CannotReadIndexTimestampCode:
		return ErrCannotReadIndexTimestamp
	default:
		return ErrError
	}
}
