/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.collector.collect.ipmi2.protocol.ipmi.command.chassis;

import java.nio.ByteBuffer;
import org.apache.hertzbeat.collector.collect.ipmi2.client.IpmiPacketContext;
import org.apache.hertzbeat.collector.collect.ipmi2.protocol.common.IpmiCode;
import org.apache.hertzbeat.collector.collect.ipmi2.protocol.ipmi.IpmiCommandName;
import org.apache.hertzbeat.collector.collect.ipmi2.protocol.ipmi.command.AbstractIpmiResponse;
import org.apache.hertzbeat.collector.collect.ipmi2.utils.ByteConvertUtils;

public class GetChassisStatusResponse
extends AbstractIpmiResponse {
    public boolean isPowerOn;
    public boolean isPowerOverload;
    public boolean isPowerInterlock;
    public boolean isPowerFault;
    public boolean isPowerControlFault;
    public String powerRestorePolicy;
    public String lastPowerEvent;
    public boolean isFanFault;
    public boolean isDriveFault;
    public boolean isFrontPanelLockoutActive;

    @Override
    public IpmiCommandName getCommandName() {
        return IpmiCommandName.GetChassisStatus;
    }

    @Override
    public void fromResponseData(IpmiPacketContext context, ByteBuffer buffer) {
        byte t = buffer.get();
        this.isPowerOn = GetChassisStatusResponse.getBits(t, 0, 1) == 1;
        this.isPowerOverload = GetChassisStatusResponse.getBits(t, 1, 1) == 1;
        this.isPowerInterlock = GetChassisStatusResponse.getBits(t, 2, 1) == 1;
        this.isPowerFault = GetChassisStatusResponse.getBits(t, 3, 1) == 1;
        this.isPowerControlFault = GetChassisStatusResponse.getBits(t, 4, 1) == 1;
        this.powerRestorePolicy = IpmiCode.fromByte(PowerRestorePolicy.class, GetChassisStatusResponse.getBits(t, 5, 3)).getDescription();
        t = buffer.get();
        this.lastPowerEvent = IpmiCode.fromByte(LastPowerEvent.class, GetChassisStatusResponse.getBits(t, 0, 31)).getDescription();
        t = buffer.get();
        this.isFrontPanelLockoutActive = GetChassisStatusResponse.getBits(t, 1, 1) == 1;
        this.isDriveFault = GetChassisStatusResponse.getBits(t, 2, 1) == 1;
        this.isFanFault = GetChassisStatusResponse.getBits(t, 3, 1) == 1;
        GetChassisStatusResponse.ignoreBytes(buffer, 1);
    }

    static enum PowerRestorePolicy implements IpmiCode.Code
    {
        alwaysOff(0, "Always Off"),
        previous(1, "Previous"),
        alwaysOn(2, "Always On"),
        unknown(3, "Unknown");

        private final byte code;
        private final String description;

        private PowerRestorePolicy(int code, String description) {
            this.code = ByteConvertUtils.checkCastByte(code);
            this.description = description;
        }

        @Override
        public byte getCode() {
            return this.code;
        }

        @Override
        public String getDescription() {
            return this.description;
        }
    }

    static enum LastPowerEvent implements IpmiCode.Code
    {
        none(0, "None"),
        unknown(1, "Unknown"),
        lastPowerOff(2, "Last Power Off"),
        lastPowerOn(3, "Last Power On");

        private final byte code;
        private final String description;

        private LastPowerEvent(int code, String description) {
            this.code = ByteConvertUtils.checkCastByte(code);
            this.description = description;
        }

        @Override
        public byte getCode() {
            return this.code;
        }

        @Override
        public String getDescription() {
            return this.description;
        }
    }
}

