/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.mappings;

import java.util.Iterator;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.ConversionException;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.OptimisticLockException;
import org.eclipse.persistence.internal.descriptors.CascadeLockingPolicy;
import org.eclipse.persistence.internal.helper.ConversionManager;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.ChangeRecord;
import org.eclipse.persistence.internal.sessions.CollectionChangeRecord;
import org.eclipse.persistence.internal.sessions.ObjectChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.OneToManyMapping;
import org.eclipse.persistence.queries.DeleteObjectQuery;
import org.eclipse.persistence.queries.ObjectLevelModifyQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReadQuery;
import org.eclipse.persistence.sessions.DatabaseRecord;

public class UnidirectionalOneToManyMapping
extends OneToManyMapping {
    protected boolean shouldIncrementTargetLockValueOnAddOrRemoveTarget = true;
    protected boolean shouldIncrementTargetLockValueOnDeleteSource = true;

    @Override
    protected AbstractRecord buildKeyRowForTargetUpdate(ObjectLevelModifyQuery query) {
        DatabaseRecord keyRow = new DatabaseRecord();
        int size = this.sourceKeyFields.size();
        for (int index = 0; index < size; ++index) {
            DatabaseField sourceKey = (DatabaseField)this.sourceKeyFields.get(index);
            DatabaseField targetForeignKey = (DatabaseField)this.targetForeignKeyFields.get(index);
            Object sourceKeyValue = query.getTranslationRow().get(sourceKey);
            keyRow.put(targetForeignKey, sourceKeyValue);
        }
        return keyRow;
    }

    @Override
    public ChangeRecord compareForChange(Object clone, Object backUp, ObjectChangeSet owner, AbstractSession uow) {
        ChangeRecord record = super.compareForChange(clone, backUp, owner, uow);
        if (record != null && this.getReferenceDescriptor().getOptimisticLockingPolicy() != null) {
            this.postCalculateChanges(record, (UnitOfWorkImpl)uow);
        }
        return record;
    }

    protected Vector extractSourceKeyFromRow(AbstractRecord row, AbstractSession session) {
        int size = this.sourceKeyFields.size();
        Vector<Object> key = new Vector<Object>(size);
        ConversionManager conversionManager = session.getDatasourcePlatform().getConversionManager();
        for (int index = 0; index < size; ++index) {
            DatabaseField targetField = (DatabaseField)this.targetForeignKeyFields.get(index);
            DatabaseField sourceField = (DatabaseField)this.sourceKeyFields.get(index);
            Object value = row.get(targetField);
            try {
                value = conversionManager.convertObject(value, sourceField.getType());
            }
            catch (ConversionException e) {
                throw ConversionException.couldNotBeConverted((Object)this, this.getDescriptor(), e);
            }
            key.addElement(value);
        }
        return key;
    }

    @Override
    public boolean isOwned() {
        return true;
    }

    @Override
    public boolean isUnidirectionalOneToManyMapping() {
        return true;
    }

    @Override
    public void initialize(AbstractSession session) throws DescriptorException {
        super.initialize(session);
        if (this.getReferenceDescriptor().getOptimisticLockingPolicy() != null) {
            if (this.shouldIncrementTargetLockValueOnAddOrRemoveTarget) {
                this.descriptor.addMappingsPostCalculateChanges(this);
            }
            if (this.shouldIncrementTargetLockValueOnDeleteSource && !this.isPrivateOwned) {
                this.descriptor.addMappingsPostCalculateChangesOnDeleted(this);
            }
        }
    }

    @Override
    public void postInitialize(AbstractSession session) {
        super.postInitialize(session);
        Iterator<DatabaseField> targetForeignKeys = this.getTargetForeignKeyFields().iterator();
        Iterator<DatabaseField> sourceKeys = this.getSourceKeyFields().iterator();
        while (targetForeignKeys.hasNext()) {
            DatabaseMapping mapping;
            DatabaseField targetForeignKey = targetForeignKeys.next();
            DatabaseField sourcePrimaryKey = sourceKeys.next();
            if (targetForeignKey.getType() != null || (mapping = this.getDescriptor().getObjectBuilder().getMappingForField(sourcePrimaryKey)) == null) continue;
            targetForeignKey.setType(mapping.getFieldClassification(sourcePrimaryKey));
        }
    }

    @Override
    protected AbstractRecord createModifyRowForAddTargetQuery() {
        AbstractRecord modifyRow = super.createModifyRowForAddTargetQuery();
        int size = this.targetForeignKeyFields.size();
        for (int index = 0; index < size; ++index) {
            DatabaseField targetForeignKey = (DatabaseField)this.targetForeignKeyFields.get(index);
            modifyRow.put(targetForeignKey, (Object)null);
        }
        return modifyRow;
    }

    @Override
    public void preDelete(DeleteObjectQuery query) throws DatabaseException, OptimisticLockException {
        if (this.shouldObjectModifyCascadeToParts(query)) {
            super.preDelete(query);
        } else {
            this.updateTargetRowPreDeleteSource(query);
        }
    }

    @Override
    public void prepareCascadeLockingPolicy() {
        CascadeLockingPolicy policy = new CascadeLockingPolicy(this.getDescriptor(), this.getReferenceDescriptor());
        policy.setQueryKeyFields(this.getSourceKeysToTargetForeignKeys());
        policy.setShouldHandleUnmappedFields(true);
        this.getReferenceDescriptor().addCascadeLockingPolicy(policy);
    }

    @Override
    public void postCalculateChanges(org.eclipse.persistence.sessions.changesets.ChangeRecord changeRecord, UnitOfWorkImpl uow) {
        CollectionChangeRecord collectionChangeRecord = (CollectionChangeRecord)changeRecord;
        for (ObjectChangeSet change : collectionChangeRecord.getAddObjectList().values()) {
            if (change.hasChanges()) continue;
            change.setShouldModifyVersionField(Boolean.TRUE);
            ((UnitOfWorkChangeSet)change.getUOWChangeSet()).addObjectChangeSet(change, uow, false);
        }
        for (ObjectChangeSet change : collectionChangeRecord.getRemoveObjectList().values()) {
            if (!this.isPrivateOwned()) {
                if (change.hasChanges()) continue;
                change.setShouldModifyVersionField(Boolean.TRUE);
                ((UnitOfWorkChangeSet)change.getUOWChangeSet()).addObjectChangeSet(change, uow, false);
                continue;
            }
            this.containerPolicy.postCalculateChanges(change, this.referenceDescriptor, this, uow);
        }
    }

    @Override
    public void postCalculateChangesOnDeleted(Object deletedObject, UnitOfWorkChangeSet uowChangeSet, UnitOfWorkImpl uow) {
        Object col = this.getRealCollectionAttributeValueFromObject(deletedObject, uow);
        if (col != null) {
            Object iterator = this.containerPolicy.iteratorFor(col);
            while (this.containerPolicy.hasNext(iterator)) {
                Object target = this.containerPolicy.next(iterator, uow);
                ObjectChangeSet change = this.referenceDescriptor.getObjectBuilder().createObjectChangeSet(target, uowChangeSet, uow);
                if (change.hasChanges()) continue;
                change.setShouldModifyVersionField(Boolean.TRUE);
                ((UnitOfWorkChangeSet)change.getUOWChangeSet()).addObjectChangeSet(change, uow, false);
            }
        }
    }

    @Override
    protected void postPrepareNestedBatchQuery(ReadQuery batchQuery, ObjectLevelReadQuery query) {
        super.postPrepareNestedBatchQuery(batchQuery, query);
        ReadAllQuery mappingBatchQuery = (ReadAllQuery)batchQuery;
        int size = this.targetForeignKeyFields.size();
        for (int i = 0; i < size; ++i) {
            mappingBatchQuery.addAdditionalField((DatabaseField)this.targetForeignKeyFields.get(i));
        }
    }

    @Override
    protected void prepareTranslationRow(AbstractRecord translationRow, Object object, ClassDescriptor descriptor, AbstractSession session) {
        int size = this.sourceKeyFields.size();
        for (int i = 0; i < size; ++i) {
            DatabaseField sourceKey = (DatabaseField)this.sourceKeyFields.get(i);
            if (translationRow.containsKey(sourceKey)) continue;
            Object value = descriptor.getObjectBuilder().extractValueFromObjectForField(object, sourceKey, session);
            translationRow.put(sourceKey, value);
        }
    }

    @Override
    public void recordPrivateOwnedRemovals(Object object, UnitOfWorkImpl uow) {
        if (this.isPrivateOwned) {
            super.recordPrivateOwnedRemovals(object, uow);
        }
    }

    @Override
    public boolean requiresDataModificationEvents() {
        return true;
    }

    public void setShouldIncrementTargetLockValueOnAddOrRemoveTarget(boolean shouldIncrementTargetLockValueOnAddOrRemoveTarget) {
        this.shouldIncrementTargetLockValueOnAddOrRemoveTarget = shouldIncrementTargetLockValueOnAddOrRemoveTarget;
    }

    public void setShouldIncrementTargetLockValueOnDeleteSource(boolean shouldIncrementTargetLockValueOnDeleteSource) {
        this.shouldIncrementTargetLockValueOnDeleteSource = shouldIncrementTargetLockValueOnDeleteSource;
    }

    public boolean shouldIncrementTargetLockValueOnAddOrRemoveTarget() {
        return this.shouldIncrementTargetLockValueOnAddOrRemoveTarget;
    }

    public boolean shouldIncrementTargetLockValueOnDeleteSource() {
        return this.shouldIncrementTargetLockValueOnDeleteSource;
    }

    @Override
    protected boolean shouldRemoveTargetQueryModifyTargetForeignKey() {
        return true;
    }

    @Override
    public boolean shouldDeferInsert() {
        if (this.shouldDeferInserts == null) {
            String property = PrivilegedAccessHelper.getSystemProperty("eclipselink.mapping.onetomany.defer-inserts");
            this.shouldDeferInserts = true;
            if (property != null) {
                this.shouldDeferInserts = "true".equalsIgnoreCase(property);
            } else {
                for (DatabaseField f : this.targetForeignKeyFields) {
                    if (f.isNullable()) continue;
                    this.shouldDeferInserts = false;
                    break;
                }
            }
        }
        return this.shouldDeferInserts;
    }
}

