/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.common.support.valid;

import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import org.apache.hertzbeat.common.support.valid.HostValid;
import org.apache.hertzbeat.common.util.IpDomainUtil;
import org.springframework.util.StringUtils;

public class HostParamValidator
implements ConstraintValidator<HostValid, String> {
    public static final String HTTP = "http://";
    public static final String HTTPS = "https://";
    public static final String BLANK = "";
    public static final String PATTERN_HTTP = "(?i)http://";
    public static final String PATTERN_HTTPS = "(?i)https://";

    public boolean isValid(String value, ConstraintValidatorContext context) {
        if (!StringUtils.hasText((String)value)) {
            return true;
        }
        if (value.toLowerCase().contains(HTTP)) {
            value = value.replaceFirst(PATTERN_HTTP, BLANK);
        }
        if (value.toLowerCase().contains(HTTPS)) {
            value = value.replaceFirst(PATTERN_HTTPS, BLANK);
        }
        return IpDomainUtil.validateIpDomain(value);
    }
}

