/*
 * Decompiled with CFR 0.152.
 */
package com.usthe.sureness.subject.creater;

import com.usthe.sureness.subject.Subject;
import com.usthe.sureness.subject.SubjectCreate;
import com.usthe.sureness.subject.support.JwtSubject;
import com.usthe.sureness.util.JsonWebTokenUtil;
import java.net.InetSocketAddress;
import org.springframework.http.server.reactive.ServerHttpRequest;

public class JwtSubjectWsSpringReactiveCreator
implements SubjectCreate {
    @Override
    public boolean canSupportSubject(Object context) {
        if (context instanceof ServerHttpRequest) {
            String token = (String)((ServerHttpRequest)context).getQueryParams().getFirst((Object)"token");
            return !JsonWebTokenUtil.isNotJsonWebToken(token);
        }
        return false;
    }

    @Override
    public Subject createSubject(Object context) {
        String token = (String)((ServerHttpRequest)context).getQueryParams().getFirst((Object)"token");
        if (token != null) {
            String jwtToken = token.trim();
            InetSocketAddress remoteAddress = ((ServerHttpRequest)context).getRemoteAddress();
            String remoteHost = remoteAddress == null ? "" : remoteAddress.getHostString();
            String requestUri = ((ServerHttpRequest)context).getPath().value();
            String requestType = ((ServerHttpRequest)context).getMethodValue();
            String targetUri = requestUri.concat("===").concat(requestType.toLowerCase());
            return JwtSubject.builder(jwtToken).setRemoteHost(remoteHost).setTargetResource(targetUri).build();
        }
        return null;
    }
}

