/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.collector.collect.registry.discovery.impl;

import com.ecwid.consul.v1.ConsulClient;
import com.ecwid.consul.v1.agent.model.Self;
import com.ecwid.consul.v1.health.model.Check;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.hertzbeat.collector.collect.registry.discovery.DiscoveryClient;
import org.apache.hertzbeat.collector.collect.registry.discovery.entity.ConnectConfig;
import org.apache.hertzbeat.collector.collect.registry.discovery.entity.ServerInfo;
import org.apache.hertzbeat.collector.collect.registry.discovery.entity.ServiceInstance;
import org.apache.hertzbeat.common.entity.job.protocol.RegistryProtocol;

public class ConsulDiscoveryClient
implements DiscoveryClient {
    private ConsulClient consulClient;

    @Override
    public ConnectConfig buildConnectConfig(RegistryProtocol registryProtocol) {
        return ConnectConfig.builder().host(registryProtocol.getHost()).port(Integer.parseInt(registryProtocol.getPort())).build();
    }

    @Override
    public void initClient(ConnectConfig connectConfig) {
        this.consulClient = new ConsulClient(connectConfig.getHost(), connectConfig.getPort());
    }

    @Override
    public ServerInfo getServerInfo() {
        Self self = (Self)this.consulClient.getAgentSelf().getValue();
        return ServerInfo.builder().address(self.getMember().getAddress()).port(String.valueOf(self.getMember().getPort())).build();
    }

    @Override
    public List<ServiceInstance> getServices() {
        Map serviceMap = (Map)this.consulClient.getAgentServices().getValue();
        ArrayList serviceInstanceList = Lists.newArrayListWithExpectedSize((int)serviceMap.size());
        Collection healthCheckList = ((Map)this.consulClient.getAgentChecks().getValue()).values();
        serviceMap.forEach((serviceId, instance) -> serviceInstanceList.add(ServiceInstance.builder().serviceId((String)serviceId).serviceName(instance.getService()).address(instance.getAddress()).port(instance.getPort()).metadata(instance.getMeta()).healthStatus(this.getHealthStatus((String)serviceId, healthCheckList)).build()));
        return serviceInstanceList;
    }

    @Override
    public boolean healthCheck() {
        List consulHealth = (List)this.consulClient.getHealthChecksForNode("consul", null).getValue();
        for (Check check : consulHealth) {
            Check.CheckStatus status = check.getStatus();
            if (status == Check.CheckStatus.PASSING) continue;
            return false;
        }
        return true;
    }

    @Override
    public void close() {
        this.consulClient = null;
    }

    private String getHealthStatus(String serviceId, Collection<com.ecwid.consul.v1.agent.model.Check> healthCheckList) {
        return healthCheckList.stream().filter(healthCheck -> StringUtils.equals((CharSequence)healthCheck.getServiceId(), (CharSequence)serviceId)).findFirst().map(check -> check.getStatus().name()).orElse("");
    }
}

