/*
 * Decompiled with CFR 0.152.
 */
package io.greptime.common.util;

import io.greptime.common.util.SystemPropertyUtil;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Platform {
    private static final Logger LOG = LoggerFactory.getLogger(Platform.class);
    private static final String WIN_KEY = "win";
    private static final String MAC_KEY = "mac os x";
    private static final boolean IS_WINDOWS = Platform.isWindows0();
    private static final boolean IS_MAC = Platform.isMac0();

    public static boolean isWindows() {
        return IS_WINDOWS;
    }

    public static boolean isMac() {
        return IS_MAC;
    }

    private static boolean isMac0() {
        boolean mac = Platform.checkOS(MAC_KEY);
        if (mac) {
            LOG.debug("Platform: Mac OS X");
        }
        return mac;
    }

    private static boolean isWindows0() {
        boolean windows = Platform.checkOS(WIN_KEY);
        if (windows) {
            LOG.debug("Platform: Windows");
        }
        return windows;
    }

    private static boolean checkOS(String osKey) {
        return SystemPropertyUtil.get("os.name", "").toLowerCase(Locale.US).contains(osKey);
    }
}

