/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.alert.service.impl;

import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Predicate;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.hertzbeat.alert.dao.GroupAlertDao;
import org.apache.hertzbeat.alert.dao.SingleAlertDao;
import org.apache.hertzbeat.alert.dto.AlertSummary;
import org.apache.hertzbeat.alert.reduce.AlarmCommonReduce;
import org.apache.hertzbeat.alert.service.AlertService;
import org.apache.hertzbeat.common.entity.alerter.GroupAlert;
import org.apache.hertzbeat.common.entity.alerter.SingleAlert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class AlertServiceImpl
implements AlertService {
    private static final Logger log = LoggerFactory.getLogger(AlertServiceImpl.class);
    @Autowired
    private GroupAlertDao groupAlertDao;
    @Autowired
    private SingleAlertDao singleAlertDao;
    @Autowired
    private AlarmCommonReduce alarmCommonReduce;

    @Override
    public Page<SingleAlert> getSingleAlerts(String status, String search, String sort, String order, int pageIndex, int pageSize) {
        Specification & Serializable specification = (Specification & Serializable)(root, query, criteriaBuilder) -> {
            ArrayList<Predicate> andList = new ArrayList<Predicate>();
            if (status != null) {
                Predicate predicate = criteriaBuilder.equal((Expression)root.get("status"), (Object)status);
                andList.add(predicate);
            }
            Predicate[] andPredicates = new Predicate[andList.size()];
            Predicate andPredicate = criteriaBuilder.and(andList.toArray(andPredicates));
            ArrayList<Predicate> orList = new ArrayList<Predicate>();
            if (search != null && !search.isEmpty()) {
                Predicate predicateContent = criteriaBuilder.like((Expression)root.get("content"), "%" + search + "%");
                orList.add(predicateContent);
                Predicate predicateLabels = criteriaBuilder.like((Expression)root.get("labels"), "%" + search + "%");
                orList.add(predicateLabels);
                Predicate predicateAnnotation = criteriaBuilder.like((Expression)root.get("annotations"), "%" + search + "%");
                orList.add(predicateAnnotation);
            }
            Predicate[] orPredicates = new Predicate[orList.size()];
            Predicate orPredicate = criteriaBuilder.or(orList.toArray(orPredicates));
            if (andPredicates.length == 0 && orPredicates.length == 0) {
                return query.where(new Predicate[0]).getRestriction();
            }
            if (andPredicates.length == 0) {
                return orPredicate;
            }
            if (orPredicates.length == 0) {
                return andPredicate;
            }
            return query.where(new Predicate[]{andPredicate, orPredicate}).getRestriction();
        };
        Sort sortExp = Sort.by((Sort.Order[])new Sort.Order[]{new Sort.Order(Sort.Direction.fromString((String)order), sort)});
        PageRequest pageRequest = PageRequest.of((int)pageIndex, (int)pageSize, (Sort)sortExp);
        return this.singleAlertDao.findAll(specification, (Pageable)pageRequest);
    }

    @Override
    public Page<GroupAlert> getGroupAlerts(String status, String search, String sort, String order, int pageIndex, int pageSize) {
        Specification & Serializable specification = (Specification & Serializable)(root, query, criteriaBuilder) -> {
            ArrayList<Predicate> andList = new ArrayList<Predicate>();
            if (status != null) {
                Predicate predicate = criteriaBuilder.equal((Expression)root.get("status"), (Object)status);
                andList.add(predicate);
            }
            Predicate[] andPredicates = new Predicate[andList.size()];
            Predicate andPredicate = criteriaBuilder.and(andList.toArray(andPredicates));
            ArrayList<Predicate> orList = new ArrayList<Predicate>();
            if (search != null && !search.isEmpty()) {
                Predicate predicateContent = criteriaBuilder.like((Expression)root.get("groupLabels"), "%" + search + "%");
                orList.add(predicateContent);
                Predicate predicateLabels = criteriaBuilder.like((Expression)root.get("commonLabels"), "%" + search + "%");
                orList.add(predicateLabels);
                Predicate predicateAnnotation = criteriaBuilder.like((Expression)root.get("commonAnnotations"), "%" + search + "%");
                orList.add(predicateAnnotation);
            }
            Predicate[] orPredicates = new Predicate[orList.size()];
            Predicate orPredicate = criteriaBuilder.or(orList.toArray(orPredicates));
            if (andPredicates.length == 0 && orPredicates.length == 0) {
                return query.where(new Predicate[0]).getRestriction();
            }
            if (andPredicates.length == 0) {
                return orPredicate;
            }
            if (orPredicates.length == 0) {
                return andPredicate;
            }
            return query.where(new Predicate[]{andPredicate, orPredicate}).getRestriction();
        };
        Sort sortExp = Sort.by((Sort.Order[])new Sort.Order[]{new Sort.Order(Sort.Direction.fromString((String)order), sort)});
        PageRequest pageRequest = PageRequest.of((int)pageIndex, (int)pageSize, (Sort)sortExp);
        Page groupAlertPage = this.groupAlertDao.findAll(specification, (Pageable)pageRequest);
        for (GroupAlert groupAlert : groupAlertPage.getContent()) {
            List firingAlerts = groupAlert.getAlertFingerprints();
            List<SingleAlert> singleAlerts = this.singleAlertDao.findSingleAlertsByFingerprintIn(firingAlerts);
            groupAlert.setAlerts(singleAlerts);
        }
        return groupAlertPage;
    }

    @Override
    public void deleteGroupAlerts(HashSet<Long> ids) {
        List<GroupAlert> groupAlerts = this.groupAlertDao.findGroupAlertsByIdIn(ids);
        for (GroupAlert groupAlert : groupAlerts) {
            List firingAlerts = groupAlert.getAlertFingerprints();
            this.singleAlertDao.deleteSingleAlertsByFingerprintIn(firingAlerts);
        }
        this.groupAlertDao.deleteGroupAlertsByIdIn(ids);
    }

    @Override
    public void deleteSingleAlerts(HashSet<Long> ids) {
        this.singleAlertDao.deleteSingleAlertsByIdIn(ids);
    }

    @Override
    public void editGroupAlertStatus(String status, List<Long> ids) {
        this.groupAlertDao.updateGroupAlertsStatus(status, ids);
    }

    @Override
    public void editSingleAlertStatus(String status, List<Long> ids) {
        this.singleAlertDao.updateSingleAlertsStatus(status, ids);
    }

    @Override
    public AlertSummary getAlertsSummary() {
        AlertSummary alertSummary = new AlertSummary();
        List<SingleAlert> firingAlerts = this.singleAlertDao.querySingleAlertsByStatus("firing");
        int emergencyNum = 0;
        int criticalNum = 0;
        int warningNum = 0;
        for (SingleAlert alert : firingAlerts) {
            String severity = (String)alert.getLabels().get("severity");
            if (severity != null) {
                switch (severity) {
                    case "emergency": {
                        ++emergencyNum;
                        break;
                    }
                    case "critical": {
                        ++criticalNum;
                        break;
                    }
                    case "warning": {
                        ++warningNum;
                        break;
                    }
                }
            }
            alertSummary.setPriorityCriticalNum(criticalNum);
            alertSummary.setPriorityEmergencyNum(emergencyNum);
            alertSummary.setPriorityWarningNum(warningNum);
        }
        long total = this.singleAlertDao.count();
        alertSummary.setTotal(total);
        long resolved = total - (long)firingAlerts.size();
        alertSummary.setDealNum(resolved);
        try {
            if (total == 0L) {
                alertSummary.setRate(100.0f);
            } else {
                float rate = BigDecimal.valueOf(100.0f * (float)resolved / (float)total).setScale(2, RoundingMode.HALF_UP).floatValue();
                alertSummary.setRate(rate);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return alertSummary;
    }
}

