/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.aws.resource;

import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.time.Duration;
import java.util.Collection;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;

final class SimpleHttpClient {
    private static final Logger logger = Logger.getLogger(SimpleHttpClient.class.getName());
    private static final Duration TIMEOUT = Duration.ofSeconds(2L);
    private static final RequestBody EMPTY_BODY = RequestBody.create((byte[])new byte[0]);

    SimpleHttpClient() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String fetchString(String httpMethod, String urlStr, Map<String, String> headers, @Nullable String certPath) {
        KeyStore keyStore;
        X509TrustManager trustManager;
        SSLSocketFactory socketFactory;
        OkHttpClient.Builder clientBuilder = new OkHttpClient.Builder().callTimeout(TIMEOUT).connectTimeout(TIMEOUT).readTimeout(TIMEOUT);
        if (urlStr.startsWith("https") && certPath != null && (socketFactory = SimpleHttpClient.buildSslSocketFactory(trustManager = SimpleHttpClient.buildTrustManager(keyStore = SimpleHttpClient.getKeystoreForTrustedCert(certPath)))) != null) {
            clientBuilder.sslSocketFactory(socketFactory, trustManager);
        }
        OkHttpClient client = clientBuilder.build();
        RequestBody requestBody = null;
        if (httpMethod.equals("PUT")) {
            requestBody = EMPTY_BODY;
        }
        Request.Builder requestBuilder = new Request.Builder().url(urlStr).method(httpMethod, requestBody);
        headers.forEach((arg_0, arg_1) -> ((Request.Builder)requestBuilder).addHeader(arg_0, arg_1));
        try (Response response = client.newCall(requestBuilder.build()).execute();){
            int responseCode = response.code();
            if (responseCode != 200) {
                logger.log(Level.FINE, "Error response from " + urlStr + " code (" + responseCode + ") text " + response.message());
                String string2 = "";
                return string2;
            }
            ResponseBody body = response.body();
            String string = body != null ? body.string() : "";
            return string;
        }
        catch (IOException e) {
            logger.log(Level.FINE, "SimpleHttpClient fetch string failed.", e);
            return "";
        }
    }

    @Nullable
    private static X509TrustManager buildTrustManager(@Nullable KeyStore keyStore) {
        if (keyStore == null) {
            return null;
        }
        try {
            String tmfAlgorithm = TrustManagerFactory.getDefaultAlgorithm();
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(tmfAlgorithm);
            tmf.init(keyStore);
            return (X509TrustManager)tmf.getTrustManagers()[0];
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Build SslSocketFactory for K8s restful client exception.", e);
            return null;
        }
    }

    @Nullable
    private static SSLSocketFactory buildSslSocketFactory(@Nullable TrustManager trustManager) {
        if (trustManager == null) {
            return null;
        }
        try {
            SSLContext context = SSLContext.getInstance("TLS");
            context.init(null, new TrustManager[]{trustManager}, null);
            return context.getSocketFactory();
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Build SslSocketFactory for K8s restful client exception.", e);
            return null;
        }
    }

    @Nullable
    private static KeyStore getKeystoreForTrustedCert(String certPath) {
        KeyStore keyStore;
        FileInputStream fis = new FileInputStream(certPath);
        try {
            KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
            trustStore.load(null, null);
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            Collection<? extends Certificate> certificates = certificateFactory.generateCertificates(fis);
            int i = 0;
            for (Certificate certificate : certificates) {
                trustStore.setCertificateEntry("cert_" + i, certificate);
                ++i;
            }
            keyStore = trustStore;
        }
        catch (Throwable throwable) {
            try {
                try {
                    fis.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Cannot load KeyStore from " + certPath);
                return null;
            }
        }
        fis.close();
        return keyStore;
    }
}

