/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.incubator.semconv.genai;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.context.Context;
import io.opentelemetry.instrumentation.api.incubator.semconv.genai.GenAiAttributesGetter;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.internal.AttributesExtractorUtil;
import java.util.List;
import javax.annotation.Nullable;

public final class GenAiAttributesExtractor<REQUEST, RESPONSE>
implements AttributesExtractor<REQUEST, RESPONSE> {
    static final AttributeKey<String> GEN_AI_OPERATION_NAME = AttributeKey.stringKey((String)"gen_ai.operation.name");
    private static final AttributeKey<List<String>> GEN_AI_REQUEST_ENCODING_FORMATS = AttributeKey.stringArrayKey((String)"gen_ai.request.encoding_formats");
    private static final AttributeKey<Double> GEN_AI_REQUEST_FREQUENCY_PENALTY = AttributeKey.doubleKey((String)"gen_ai.request.frequency_penalty");
    private static final AttributeKey<Long> GEN_AI_REQUEST_MAX_TOKENS = AttributeKey.longKey((String)"gen_ai.request.max_tokens");
    static final AttributeKey<String> GEN_AI_REQUEST_MODEL = AttributeKey.stringKey((String)"gen_ai.request.model");
    private static final AttributeKey<Double> GEN_AI_REQUEST_PRESENCE_PENALTY = AttributeKey.doubleKey((String)"gen_ai.request.presence_penalty");
    private static final AttributeKey<Long> GEN_AI_REQUEST_SEED = AttributeKey.longKey((String)"gen_ai.request.seed");
    private static final AttributeKey<List<String>> GEN_AI_REQUEST_STOP_SEQUENCES = AttributeKey.stringArrayKey((String)"gen_ai.request.stop_sequences");
    private static final AttributeKey<Double> GEN_AI_REQUEST_TEMPERATURE = AttributeKey.doubleKey((String)"gen_ai.request.temperature");
    private static final AttributeKey<Double> GEN_AI_REQUEST_TOP_K = AttributeKey.doubleKey((String)"gen_ai.request.top_k");
    private static final AttributeKey<Double> GEN_AI_REQUEST_TOP_P = AttributeKey.doubleKey((String)"gen_ai.request.top_p");
    private static final AttributeKey<List<String>> GEN_AI_RESPONSE_FINISH_REASONS = AttributeKey.stringArrayKey((String)"gen_ai.response.finish_reasons");
    private static final AttributeKey<String> GEN_AI_RESPONSE_ID = AttributeKey.stringKey((String)"gen_ai.response.id");
    static final AttributeKey<String> GEN_AI_RESPONSE_MODEL = AttributeKey.stringKey((String)"gen_ai.response.model");
    static final AttributeKey<String> GEN_AI_SYSTEM = AttributeKey.stringKey((String)"gen_ai.system");
    static final AttributeKey<Long> GEN_AI_USAGE_INPUT_TOKENS = AttributeKey.longKey((String)"gen_ai.usage.input_tokens");
    static final AttributeKey<Long> GEN_AI_USAGE_OUTPUT_TOKENS = AttributeKey.longKey((String)"gen_ai.usage.output_tokens");
    private final GenAiAttributesGetter<REQUEST, RESPONSE> getter;

    public static <REQUEST, RESPONSE> AttributesExtractor<REQUEST, RESPONSE> create(GenAiAttributesGetter<REQUEST, RESPONSE> attributesGetter) {
        return new GenAiAttributesExtractor<REQUEST, RESPONSE>(attributesGetter);
    }

    private GenAiAttributesExtractor(GenAiAttributesGetter<REQUEST, RESPONSE> getter) {
        this.getter = getter;
    }

    public void onStart(AttributesBuilder attributes, Context parentContext, REQUEST request) {
        AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, GEN_AI_OPERATION_NAME, (Object)this.getter.getOperationName(request));
        AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, GEN_AI_SYSTEM, (Object)this.getter.getSystem(request));
        AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, GEN_AI_REQUEST_MODEL, (Object)this.getter.getRequestModel(request));
        AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, GEN_AI_REQUEST_SEED, (Object)this.getter.getRequestSeed(request));
        AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, GEN_AI_REQUEST_ENCODING_FORMATS, this.getter.getRequestEncodingFormats(request));
        AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, GEN_AI_REQUEST_FREQUENCY_PENALTY, (Object)this.getter.getRequestFrequencyPenalty(request));
        AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, GEN_AI_REQUEST_MAX_TOKENS, (Object)this.getter.getRequestMaxTokens(request));
        AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, GEN_AI_REQUEST_PRESENCE_PENALTY, (Object)this.getter.getRequestPresencePenalty(request));
        AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, GEN_AI_REQUEST_STOP_SEQUENCES, this.getter.getRequestStopSequences(request));
        AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, GEN_AI_REQUEST_TEMPERATURE, (Object)this.getter.getRequestTemperature(request));
        AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, GEN_AI_REQUEST_TOP_K, (Object)this.getter.getRequestTopK(request));
        AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, GEN_AI_REQUEST_TOP_P, (Object)this.getter.getRequestTopP(request));
    }

    public void onEnd(AttributesBuilder attributes, Context context, REQUEST request, @Nullable RESPONSE response, @Nullable Throwable error) {
        List<String> finishReasons = this.getter.getResponseFinishReasons(request, response);
        if (finishReasons != null && !finishReasons.isEmpty()) {
            attributes.put(GEN_AI_RESPONSE_FINISH_REASONS, finishReasons);
        }
        AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, GEN_AI_RESPONSE_ID, (Object)this.getter.getResponseId(request, response));
        AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, GEN_AI_RESPONSE_MODEL, (Object)this.getter.getResponseModel(request, response));
        AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, GEN_AI_USAGE_INPUT_TOKENS, (Object)this.getter.getUsageInputTokens(request, response));
        AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, GEN_AI_USAGE_OUTPUT_TOKENS, (Object)this.getter.getUsageOutputTokens(request, response));
    }
}

