/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.manager.pojo.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.Size;

@Schema(description="Account information transfer body")
public class LoginDto {
    @Schema(description="type", example="1", accessMode=Schema.AccessMode.READ_ONLY)
    @Max(value=4L, message="1. Account (email username and mobile phone number) password login 2. github login 3. WeChat login")
    private @Max(value=4L, message="1. Account (email username and mobile phone number) password login 2. github login 3. WeChat login") Byte type;
    @Schema(description="user identification", example="1", accessMode=Schema.AccessMode.READ_ONLY)
    @NotBlank(message="Identifier can not null")
    private @NotBlank(message="Identifier can not null") String identifier;
    @Schema(description="Secret key", example="1", accessMode=Schema.AccessMode.READ_ONLY)
    @NotBlank(message="Credential can not null")
    @Size(max=512, message="credential max length 512")
    private @NotBlank(message="Credential can not null") @Size(max=512, message="credential max length 512") String credential;

    public static LoginDtoBuilder builder() {
        return new LoginDtoBuilder();
    }

    public Byte getType() {
        return this.type;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getCredential() {
        return this.credential;
    }

    public void setType(Byte type) {
        this.type = type;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public void setCredential(String credential) {
        this.credential = credential;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LoginDto)) {
            return false;
        }
        LoginDto other = (LoginDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Byte this$type = this.getType();
        Byte other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)this$type).equals(other$type)) {
            return false;
        }
        String this$identifier = this.getIdentifier();
        String other$identifier = other.getIdentifier();
        if (this$identifier == null ? other$identifier != null : !this$identifier.equals(other$identifier)) {
            return false;
        }
        String this$credential = this.getCredential();
        String other$credential = other.getCredential();
        return !(this$credential == null ? other$credential != null : !this$credential.equals(other$credential));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LoginDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Byte $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)$type).hashCode());
        String $identifier = this.getIdentifier();
        result = result * 59 + ($identifier == null ? 43 : $identifier.hashCode());
        String $credential = this.getCredential();
        result = result * 59 + ($credential == null ? 43 : $credential.hashCode());
        return result;
    }

    public String toString() {
        return "LoginDto(type=" + this.getType() + ", identifier=" + this.getIdentifier() + ", credential=" + this.getCredential() + ")";
    }

    public LoginDto(Byte type, String identifier, String credential) {
        this.type = type;
        this.identifier = identifier;
        this.credential = credential;
    }

    public LoginDto() {
    }

    public static class LoginDtoBuilder {
        private Byte type;
        private String identifier;
        private String credential;

        LoginDtoBuilder() {
        }

        public LoginDtoBuilder type(Byte type) {
            this.type = type;
            return this;
        }

        public LoginDtoBuilder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public LoginDtoBuilder credential(String credential) {
            this.credential = credential;
            return this;
        }

        public LoginDto build() {
            return new LoginDto(this.type, this.identifier, this.credential);
        }

        public String toString() {
            return "LoginDto.LoginDtoBuilder(type=" + this.type + ", identifier=" + this.identifier + ", credential=" + this.credential + ")";
        }
    }
}

