/*
 * Decompiled with CFR 0.152.
 */
package io.greptime.signal;

import io.greptime.GreptimeDB;
import io.greptime.common.Display;
import io.greptime.common.SPI;
import io.greptime.common.signal.FileOutputHelper;
import io.greptime.common.signal.FileSignalHelper;
import io.greptime.common.signal.SignalHandler;
import io.greptime.common.util.Files;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SPI(priority=98)
public class DisplaySignalHandler
implements SignalHandler {
    private static final Logger LOG = LoggerFactory.getLogger(DisplaySignalHandler.class);
    private static final String BASE_NAME = "greptimedb_client_display.log";

    public void handle(String signalName) {
        if (FileSignalHelper.ignoreFileOutputSignal()) {
            return;
        }
        List<GreptimeDB> instances = GreptimeDB.instances();
        if (instances.isEmpty()) {
            return;
        }
        try {
            File file = FileOutputHelper.getOutputFile((String)BASE_NAME);
            LOG.info("Displaying GreptimeDB clients triggered by signal: {} to file: {}.", (Object)signalName, (Object)file.getAbsoluteFile());
            try (PrintWriter out = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file, true), StandardCharsets.UTF_8));){
                Display.DefaultPrinter printer = new Display.DefaultPrinter(out);
                for (GreptimeDB ins : instances) {
                    ins.display((Display.Printer)printer);
                }
                out.flush();
            }
            Files.fsync((File)file);
        }
        catch (IOException e) {
            LOG.error("Fail to display GreptimeDB clients: {}.", instances, (Object)e);
        }
    }
}

