/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.fluss.metadata;

import java.util.Objects;

/** An entity for kv snapshot of table bucket. */
public class TableBucketSnapshot {
    private final TableBucket tableBucket;
    private final long snapshotId;

    public TableBucketSnapshot(TableBucket tableBucket, long snapshotId) {
        this.tableBucket = tableBucket;
        this.snapshotId = snapshotId;
    }

    public TableBucket getTableBucket() {
        return tableBucket;
    }

    public long getSnapshotId() {
        return snapshotId;
    }

    @Override
    public String toString() {
        return "TableBucketSnapshot{"
                + "tableBucket="
                + tableBucket
                + ", snapshotId="
                + snapshotId
                + '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        TableBucketSnapshot that = (TableBucketSnapshot) o;
        return snapshotId == that.snapshotId && Objects.equals(tableBucket, that.tableBucket);
    }

    @Override
    public int hashCode() {
        return Objects.hash(tableBucket, snapshotId);
    }
}
