/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basekv.localengine.memory;

import com.google.protobuf.ByteString;
import java.util.function.Consumer;
import org.apache.bifromq.basekv.localengine.IKVSpaceWriter;
import org.apache.bifromq.basekv.localengine.ISyncContext;
import org.apache.bifromq.basekv.localengine.KVEngineException;
import org.apache.bifromq.basekv.localengine.memory.InMemKVEngine;
import org.apache.bifromq.basekv.localengine.memory.InMemKVSpace;
import org.apache.bifromq.basekv.localengine.memory.InMemKVSpaceEpoch;
import org.apache.bifromq.basekv.localengine.memory.InMemKVSpaceWriterHelper;
import org.apache.bifromq.basekv.localengine.metrics.KVSpaceOpMeters;
import org.apache.bifromq.basekv.proto.Boundary;
import org.slf4j.Logger;

class InMemKVSpaceWriter<E extends InMemKVEngine<E, T>, T extends InMemKVSpace<E, T>>
implements IKVSpaceWriter {
    protected final String id;
    protected final KVSpaceOpMeters opMeters;
    protected final Logger logger;
    protected final InMemKVSpaceWriterHelper helper;
    protected final E engine;
    protected final InMemKVSpaceEpoch epoch;

    InMemKVSpaceWriter(String id, InMemKVSpaceEpoch epoch, E engine, ISyncContext syncContext, Consumer<Boolean> afterWrite, Consumer<InMemKVSpaceWriterHelper.WriteImpact> impactListener, KVSpaceOpMeters readOpMeters, Logger logger) {
        this(id, epoch, engine, syncContext, new InMemKVSpaceWriterHelper(), afterWrite, impactListener, readOpMeters, logger);
    }

    private InMemKVSpaceWriter(String id, InMemKVSpaceEpoch epoch, E engine, ISyncContext syncContext, InMemKVSpaceWriterHelper writerHelper, Consumer<Boolean> afterWrite, Consumer<InMemKVSpaceWriterHelper.WriteImpact> impactListener, KVSpaceOpMeters readOpMeters, Logger logger) {
        this.id = id;
        this.opMeters = readOpMeters;
        this.logger = logger;
        this.epoch = epoch;
        this.engine = engine;
        this.helper = writerHelper;
        writerHelper.addMutators(id, epoch, syncContext.mutator());
        writerHelper.addAfterWriteCallback(id, afterWrite);
        if (impactListener != null) {
            writerHelper.addAfterImpactCallback(id, impactListener);
        }
    }

    public String id() {
        return this.id;
    }

    public IKVSpaceWriter metadata(ByteString metaKey, ByteString metaValue) {
        this.helper.metadata(this.id, metaKey, metaValue);
        return this;
    }

    public IKVSpaceWriter insert(ByteString key, ByteString value) {
        this.helper.insert(this.id, key, value);
        return this;
    }

    public IKVSpaceWriter put(ByteString key, ByteString value) {
        this.helper.put(this.id, key, value);
        return this;
    }

    public IKVSpaceWriter delete(ByteString key) {
        this.helper.delete(this.id, key);
        return this;
    }

    public IKVSpaceWriter clear() {
        this.helper.clear(this.id, Boundary.getDefaultInstance());
        return this;
    }

    public IKVSpaceWriter clear(Boundary boundary) {
        this.helper.clear(this.id, boundary);
        return this;
    }

    public void done() {
        this.opMeters.batchWriteCallTimer.record(() -> {
            try {
                this.helper.done();
            }
            catch (Throwable e) {
                this.logger.error("Write Batch commit failed", e);
                throw new KVEngineException("Batch commit failed", e);
            }
        });
    }

    public void abort() {
        this.helper.abort();
    }

    public int count() {
        return this.helper.count();
    }
}

