/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.internal;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import io.grpc.LongCounterMetricInstrument;
import io.grpc.LongUpDownCounterMetricInstrument;
import io.grpc.MetricInstrumentRegistry;
import io.grpc.MetricRecorder;
import java.util.List;
import javax.annotation.Nullable;

final class SubchannelMetrics {
    private static final LongCounterMetricInstrument disconnections;
    private static final LongCounterMetricInstrument connectionAttemptsSucceeded;
    private static final LongCounterMetricInstrument connectionAttemptsFailed;
    private static final LongUpDownCounterMetricInstrument openConnections;
    private final MetricRecorder metricRecorder;

    public SubchannelMetrics(MetricRecorder metricRecorder) {
        this.metricRecorder = metricRecorder;
    }

    public void recordConnectionAttemptSucceeded(String target, String backendService, String locality, String securityLevel) {
        this.metricRecorder.addLongCounter(connectionAttemptsSucceeded, 1L, (List)ImmutableList.of((Object)target), (List)ImmutableList.of((Object)backendService, (Object)locality));
        this.metricRecorder.addLongUpDownCounter(openConnections, 1L, (List)ImmutableList.of((Object)target), (List)ImmutableList.of((Object)securityLevel, (Object)backendService, (Object)locality));
    }

    public void recordConnectionAttemptFailed(String target, String backendService, String locality) {
        this.metricRecorder.addLongCounter(connectionAttemptsFailed, 1L, (List)ImmutableList.of((Object)target), (List)ImmutableList.of((Object)backendService, (Object)locality));
    }

    public void recordDisconnection(String target, String backendService, String locality, String disconnectError, String securityLevel) {
        this.metricRecorder.addLongCounter(disconnections, 1L, (List)ImmutableList.of((Object)target), (List)ImmutableList.of((Object)backendService, (Object)locality, (Object)disconnectError));
        this.metricRecorder.addLongUpDownCounter(openConnections, -1L, (List)ImmutableList.of((Object)target), (List)ImmutableList.of((Object)securityLevel, (Object)backendService, (Object)locality));
    }

    static {
        MetricInstrumentRegistry metricInstrumentRegistry = MetricInstrumentRegistry.getDefaultRegistry();
        disconnections = metricInstrumentRegistry.registerLongCounter("grpc.subchannel.disconnections", "EXPERIMENTAL. Number of times the selected subchannel becomes disconnected", "{disconnection}", (List)Lists.newArrayList((Object[])new String[]{"grpc.target"}), (List)Lists.newArrayList((Object[])new String[]{"grpc.lb.backend_service", "grpc.lb.locality", "grpc.disconnect_error"}), false);
        connectionAttemptsSucceeded = metricInstrumentRegistry.registerLongCounter("grpc.subchannel.connection_attempts_succeeded", "EXPERIMENTAL. Number of successful connection attempts", "{attempt}", (List)Lists.newArrayList((Object[])new String[]{"grpc.target"}), (List)Lists.newArrayList((Object[])new String[]{"grpc.lb.backend_service", "grpc.lb.locality"}), false);
        connectionAttemptsFailed = metricInstrumentRegistry.registerLongCounter("grpc.subchannel.connection_attempts_failed", "EXPERIMENTAL. Number of failed connection attempts", "{attempt}", (List)Lists.newArrayList((Object[])new String[]{"grpc.target"}), (List)Lists.newArrayList((Object[])new String[]{"grpc.lb.backend_service", "grpc.lb.locality"}), false);
        openConnections = metricInstrumentRegistry.registerLongUpDownCounter("grpc.subchannel.open_connections", "EXPERIMENTAL. Number of open connections.", "{connection}", (List)Lists.newArrayList((Object[])new String[]{"grpc.target"}), (List)Lists.newArrayList((Object[])new String[]{"grpc.security_level", "grpc.lb.backend_service", "grpc.lb.locality"}), false);
    }

    public static enum DisconnectError {
        GOAWAY("goaway"),
        SUBCHANNEL_SHUTDOWN("subchannel shutdown"),
        CONNECTION_RESET("connection reset"),
        CONNECTION_TIMED_OUT("connection timed out"),
        CONNECTION_ABORTED("connection aborted"),
        SOCKET_ERROR("socket error"),
        UNKNOWN("unknown");

        private final String errorTag;

        private DisconnectError(String errorTag) {
            this.errorTag = errorTag;
        }

        public String getErrorString(@Nullable String goawayErrorCode) {
            if (this == GOAWAY) {
                if (goawayErrorCode == null || goawayErrorCode.isEmpty()) {
                    return this.errorTag;
                }
                return this.errorTag + " " + goawayErrorCode;
            }
            return this.errorTag;
        }
    }
}

