/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.mqtt.handler.v5;

import com.google.common.base.Strings;
import com.google.protobuf.ByteString;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.mqtt.MqttConnAckMessage;
import io.netty.handler.codec.mqtt.MqttConnectMessage;
import io.netty.handler.codec.mqtt.MqttConnectReturnCode;
import io.netty.handler.codec.mqtt.MqttMessage;
import io.netty.handler.codec.mqtt.MqttMessageBuilders;
import io.netty.handler.codec.mqtt.MqttProperties;
import io.netty.handler.codec.mqtt.MqttReasonCodeAndPropertiesVariableHeader;
import java.net.InetSocketAddress;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import lombok.Generated;
import org.apache.bifromq.inbox.storage.proto.InboxVersion;
import org.apache.bifromq.inbox.storage.proto.LWT;
import org.apache.bifromq.metrics.ITenantMeter;
import org.apache.bifromq.metrics.TenantMetric;
import org.apache.bifromq.mqtt.handler.ChannelAttrs;
import org.apache.bifromq.mqtt.handler.MQTTConnectHandler;
import org.apache.bifromq.mqtt.handler.MQTTSessionHandler;
import org.apache.bifromq.mqtt.handler.TenantSettings;
import org.apache.bifromq.mqtt.handler.condition.DirectMemPressureCondition;
import org.apache.bifromq.mqtt.handler.condition.HeapMemPressureCondition;
import org.apache.bifromq.mqtt.handler.condition.ORCondition;
import org.apache.bifromq.mqtt.handler.record.GoAway;
import org.apache.bifromq.mqtt.handler.v5.MQTT5MessageBuilders;
import org.apache.bifromq.mqtt.handler.v5.MQTT5MessageUtils;
import org.apache.bifromq.mqtt.handler.v5.MQTT5PersistentSessionHandler;
import org.apache.bifromq.mqtt.handler.v5.MQTT5TransientSessionHandler;
import org.apache.bifromq.mqtt.handler.v5.reason.MQTT5AuthReasonCode;
import org.apache.bifromq.mqtt.utils.AuthUtil;
import org.apache.bifromq.mqtt.utils.IMQTTMessageSizer;
import org.apache.bifromq.plugin.authprovider.IAuthProvider;
import org.apache.bifromq.plugin.authprovider.type.Continue;
import org.apache.bifromq.plugin.authprovider.type.Failed;
import org.apache.bifromq.plugin.authprovider.type.MQTT5AuthData;
import org.apache.bifromq.plugin.authprovider.type.MQTT5ExtendedAuthData;
import org.apache.bifromq.plugin.authprovider.type.MQTTAction;
import org.apache.bifromq.plugin.authprovider.type.Success;
import org.apache.bifromq.plugin.clientbalancer.IClientBalancer;
import org.apache.bifromq.plugin.eventcollector.Event;
import org.apache.bifromq.plugin.eventcollector.OutOfTenantResource;
import org.apache.bifromq.plugin.eventcollector.ThreadLocalEventPool;
import org.apache.bifromq.plugin.eventcollector.mqttbroker.channelclosed.AuthError;
import org.apache.bifromq.plugin.eventcollector.mqttbroker.channelclosed.EnhancedAuthAbortByClient;
import org.apache.bifromq.plugin.eventcollector.mqttbroker.channelclosed.MalformedClientIdentifier;
import org.apache.bifromq.plugin.eventcollector.mqttbroker.channelclosed.MalformedUserName;
import org.apache.bifromq.plugin.eventcollector.mqttbroker.channelclosed.MalformedWillTopic;
import org.apache.bifromq.plugin.eventcollector.mqttbroker.channelclosed.NotAuthorizedClient;
import org.apache.bifromq.plugin.eventcollector.mqttbroker.channelclosed.ProtocolError;
import org.apache.bifromq.plugin.eventcollector.mqttbroker.channelclosed.UnauthenticatedClient;
import org.apache.bifromq.plugin.eventcollector.mqttbroker.clientdisconnect.InboxTransientError;
import org.apache.bifromq.plugin.eventcollector.mqttbroker.clientdisconnect.InvalidTopic;
import org.apache.bifromq.plugin.eventcollector.mqttbroker.clientdisconnect.ProtocolViolation;
import org.apache.bifromq.plugin.eventcollector.mqttbroker.clientdisconnect.Redirect;
import org.apache.bifromq.plugin.eventcollector.mqttbroker.clientdisconnect.ResourceThrottled;
import org.apache.bifromq.plugin.eventcollector.mqttbroker.clientdisconnect.ServerBusy;
import org.apache.bifromq.plugin.resourcethrottler.TenantResourceType;
import org.apache.bifromq.sysprops.props.MaxMqtt5ClientIdLength;
import org.apache.bifromq.type.ClientInfo;
import org.apache.bifromq.type.QoS;
import org.apache.bifromq.type.StringPair;
import org.apache.bifromq.type.UserProperties;
import org.apache.bifromq.util.TopicUtil;
import org.apache.bifromq.util.UTF8Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MQTT5ConnectHandler
extends MQTTConnectHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MQTT5ConnectHandler.class);
    public static final String NAME = "MQTT5ConnectHandler";
    private static final int MAX_CLIENT_ID_LEN = (Integer)MaxMqtt5ClientIdLength.INSTANCE.get();
    private ChannelHandlerContext ctx;
    private IClientBalancer clientBalancer;
    private IAuthProvider authProvider;
    private boolean isAuthing;
    private MqttConnectMessage connMsg = null;
    private boolean requestProblemInfo;
    private String authMethod = null;
    private CompletableFuture<MQTTConnectHandler.AuthResult> extendedAuthFuture;

    @Override
    public void handlerAdded(ChannelHandlerContext ctx) {
        super.handlerAdded(ctx);
        this.ctx = ctx;
        this.authProvider = ChannelAttrs.mqttSessionContext(ctx).authProvider(ctx);
        this.clientBalancer = ChannelAttrs.mqttSessionContext((ChannelHandlerContext)ctx).clientBalancer;
    }

    @Override
    protected GoAway sanityCheck(MqttConnectMessage connMsg) {
        InetSocketAddress clientAddress = ChannelAttrs.socketAddress(this.ctx.channel());
        String requestClientId = connMsg.payload().clientIdentifier();
        if (!UTF8Util.isWellFormed((String)requestClientId, (boolean)SANITY_CHECK)) {
            return new GoAway((MqttMessage)MqttMessageBuilders.connAck().properties(MQTT5MessageBuilders.connAckProperties().reasonString("Malformed clientId").build()).returnCode(MqttConnectReturnCode.CONNECTION_REFUSED_CLIENT_IDENTIFIER_NOT_VALID).build(), new Event[]{((MalformedClientIdentifier)ThreadLocalEventPool.getLocal(MalformedClientIdentifier.class)).peerAddress(clientAddress)});
        }
        if (requestClientId.length() > MAX_CLIENT_ID_LEN) {
            return new GoAway((MqttMessage)MqttMessageBuilders.connAck().properties(MQTT5MessageBuilders.connAckProperties().reasonString("Max " + MAX_CLIENT_ID_LEN + "chars allowed").build()).returnCode(MqttConnectReturnCode.CONNECTION_REFUSED_CLIENT_IDENTIFIER_NOT_VALID).build(), new Event[]{((MalformedClientIdentifier)ThreadLocalEventPool.getLocal(MalformedClientIdentifier.class)).peerAddress(clientAddress)});
        }
        if (!connMsg.variableHeader().isCleanSession() && requestClientId.isEmpty()) {
            return new GoAway((MqttMessage)MqttMessageBuilders.connAck().properties(MQTT5MessageBuilders.connAckProperties().reasonString("ClientId missing when CleanStart is set to true").build()).returnCode(MqttConnectReturnCode.CONNECTION_REFUSED_CLIENT_IDENTIFIER_NOT_VALID).build(), new Event[]{((MalformedClientIdentifier)ThreadLocalEventPool.getLocal(MalformedClientIdentifier.class)).peerAddress(clientAddress)});
        }
        if (connMsg.variableHeader().hasUserName() && !UTF8Util.isWellFormed((String)connMsg.payload().userName(), (boolean)SANITY_CHECK)) {
            return new GoAway((MqttMessage)MqttMessageBuilders.connAck().properties(MQTT5MessageBuilders.connAckProperties().reasonString("Malformed username").build()).returnCode(MqttConnectReturnCode.CONNECTION_REFUSED_MALFORMED_PACKET).build(), new Event[]{((MalformedUserName)ThreadLocalEventPool.getLocal(MalformedUserName.class)).peerAddress(clientAddress)});
        }
        if (MQTT5MessageUtils.authMethod(connMsg.variableHeader().properties()).isEmpty() && MQTT5MessageUtils.authData(connMsg.variableHeader().properties()).isPresent()) {
            return new GoAway((MqttMessage)MqttMessageBuilders.connAck().properties(MQTT5MessageBuilders.connAckProperties().reasonString("Missing auth method for authData").build()).returnCode(MqttConnectReturnCode.CONNECTION_REFUSED_PROTOCOL_ERROR).build(), new Event[]{((ProtocolError)ThreadLocalEventPool.getLocal(ProtocolError.class)).statement("Missing auth method for authData").peerAddress(clientAddress)});
        }
        if (connMsg.variableHeader().isWillFlag() && !UTF8Util.isWellFormed((String)connMsg.payload().willTopic(), (boolean)SANITY_CHECK)) {
            return new GoAway((MqttMessage)MqttMessageBuilders.connAck().properties(MQTT5MessageBuilders.connAckProperties().reasonString("Malformed will topic").build()).returnCode(MqttConnectReturnCode.CONNECTION_REFUSED_MALFORMED_PACKET).build(), new Event[]{((MalformedWillTopic)ThreadLocalEventPool.getLocal(MalformedWillTopic.class)).peerAddress(clientAddress)});
        }
        Optional<Integer> receiveMaxProps = MQTT5MessageUtils.receiveMaximum(connMsg.variableHeader().properties());
        if (receiveMaxProps.isPresent() && receiveMaxProps.get() == 0) {
            return new GoAway((MqttMessage)MqttMessageBuilders.connAck().returnCode(MqttConnectReturnCode.CONNECTION_REFUSED_PROTOCOL_ERROR).properties(MQTT5MessageBuilders.connAckProperties().reasonString("MQTT5-3.1.2.11.3").build()).build(), new Event[]{((ProtocolError)ThreadLocalEventPool.getLocal(ProtocolError.class)).statement("MQTT5-3.1.2.11.3")});
        }
        return null;
    }

    @Override
    protected CompletableFuture<MQTTConnectHandler.AuthResult> authenticate(MqttConnectMessage message) {
        this.connMsg = message;
        this.requestProblemInfo = MQTT5MessageUtils.requestProblemInformation(message.variableHeader().properties());
        Optional<String> authMethodOpt = MQTT5MessageUtils.authMethod(message.variableHeader().properties());
        if (authMethodOpt.isEmpty()) {
            MQTT5AuthData mqtt5AuthData = AuthUtil.buildMQTT5AuthData(this.ctx.channel(), message);
            return this.authProvider.auth(mqtt5AuthData).thenApplyAsync(authResult -> {
                InetSocketAddress clientAddress = ChannelAttrs.socketAddress(this.ctx.channel());
                switch (authResult.getTypeCase()) {
                    case SUCCESS: {
                        ClientInfo clientInfo = this.buildClientInfo(clientAddress, authResult.getSuccess());
                        Success success = authResult.getSuccess();
                        Optional<String> respInfo = Optional.ofNullable(success.hasResponseInfo() ? success.getResponseInfo() : null);
                        Optional<ByteString> authData = Optional.ofNullable(success.hasAuthData() ? success.getAuthData() : null);
                        MQTTConnectHandler.SuccessInfo successInfo = new MQTTConnectHandler.SuccessInfo(clientInfo, respInfo, authData, success.getUserProps());
                        return MQTTConnectHandler.AuthResult.ok(successInfo);
                    }
                    case FAILED: {
                        Failed failed = authResult.getFailed();
                        if (failed.hasTenantId()) {
                            ITenantMeter.get((String)failed.getTenantId()).recordCount(TenantMetric.MqttAuthFailureCount);
                        }
                        switch (failed.getCode()) {
                            case NotAuthorized: {
                                return MQTTConnectHandler.AuthResult.goAway((MqttMessage)MqttMessageBuilders.connAck().returnCode(MqttConnectReturnCode.CONNECTION_REFUSED_NOT_AUTHORIZED_5).properties(MQTT5MessageUtils.mqttProps().addUserProperties(failed.getUserProps()).build()).build(), new Event[]{((NotAuthorizedClient)ThreadLocalEventPool.getLocal(NotAuthorizedClient.class)).tenantId(failed.getTenantId()).userId(failed.getUserId()).clientId(mqtt5AuthData.getClientId()).peerAddress(clientAddress)});
                            }
                            case BadPass: {
                                return MQTTConnectHandler.AuthResult.goAway((MqttMessage)MqttMessageBuilders.connAck().returnCode(MqttConnectReturnCode.CONNECTION_REFUSED_BAD_USERNAME_OR_PASSWORD).properties(MQTT5MessageUtils.mqttProps().addUserProperties(failed.getUserProps()).build()).build(), new Event[]{((UnauthenticatedClient)ThreadLocalEventPool.getLocal(UnauthenticatedClient.class)).tenantId(failed.getTenantId()).userId(failed.getUserId()).clientId(mqtt5AuthData.getClientId()).peerAddress(clientAddress)});
                            }
                            case Banned: {
                                return MQTTConnectHandler.AuthResult.goAway((MqttMessage)MqttMessageBuilders.connAck().returnCode(MqttConnectReturnCode.CONNECTION_REFUSED_BANNED).properties(MQTT5MessageUtils.mqttProps().addUserProperties(failed.getUserProps()).build()).build(), new Event[]{((UnauthenticatedClient)ThreadLocalEventPool.getLocal(UnauthenticatedClient.class)).peerAddress(clientAddress)});
                            }
                            case BadAuthMethod: {
                                return MQTTConnectHandler.AuthResult.goAway((MqttMessage)MqttMessageBuilders.connAck().returnCode(MqttConnectReturnCode.CONNECTION_REFUSED_BAD_AUTHENTICATION_METHOD).properties(MQTT5MessageUtils.mqttProps().addUserProperties(failed.getUserProps()).build()).build(), new Event[]{((AuthError)ThreadLocalEventPool.getLocal(AuthError.class)).cause(failed.getReason()).peerAddress(clientAddress)});
                            }
                        }
                        log.error("Unexpected auth error:{}", (Object)failed.getReason());
                        return MQTTConnectHandler.AuthResult.goAway((MqttMessage)MqttMessageBuilders.connAck().returnCode(MqttConnectReturnCode.CONNECTION_REFUSED_UNSPECIFIED_ERROR).build(), new Event[]{((AuthError)ThreadLocalEventPool.getLocal(AuthError.class)).cause(failed.getReason()).peerAddress(clientAddress)});
                    }
                }
                log.error("Unexpected auth result: {}", (Object)authResult.getTypeCase());
                return MQTTConnectHandler.AuthResult.goAway((MqttMessage)MqttMessageBuilders.connAck().returnCode(MqttConnectReturnCode.CONNECTION_REFUSED_UNSPECIFIED_ERROR).build(), new Event[]{((AuthError)((AuthError)ThreadLocalEventPool.getLocal(AuthError.class)).peerAddress(clientAddress)).cause("Unknown auth result")});
            }, (Executor)this.ctx.executor());
        }
        this.authMethod = authMethodOpt.get();
        this.extendedAuthFuture = new CompletableFuture();
        this.ctx.channel().config().setAutoRead(true);
        this.ctx.read();
        this.extendedAuth(AuthUtil.buildMQTT5ExtendedAuthData(this.ctx.channel(), message));
        return this.extendedAuthFuture;
    }

    @Override
    protected CompletableFuture<MQTTConnectHandler.AuthResult> checkConnectPermission(MqttConnectMessage message, MQTTConnectHandler.SuccessInfo successInfo) {
        MQTTAction connAction = AuthUtil.buildConnAction(MQTT5MessageUtils.toUserProperties(message.variableHeader().properties()));
        return this.authProvider.checkPermission(successInfo.clientInfo(), connAction).thenApply(checkResult -> {
            switch (checkResult.getTypeCase()) {
                case GRANTED: {
                    return MQTTConnectHandler.AuthResult.ok(successInfo);
                }
                case DENIED: {
                    return MQTTConnectHandler.AuthResult.goAway((MqttMessage)MqttMessageBuilders.connAck().properties(MQTT5MessageBuilders.connAckProperties().reasonString("Not authorized").build()).returnCode(MqttConnectReturnCode.CONNECTION_REFUSED_NOT_AUTHORIZED_5).build(), new Event[]{((NotAuthorizedClient)ThreadLocalEventPool.getLocal(NotAuthorizedClient.class)).tenantId(successInfo.clientInfo().getTenantId()).userId(successInfo.clientInfo().getMetadataOrDefault("userId", "")).clientId(this.connMsg.payload().clientIdentifier()).peerAddress(ChannelAttrs.socketAddress(this.ctx.channel()))});
                }
            }
            return MQTTConnectHandler.AuthResult.goAway((MqttMessage)MqttMessageBuilders.connAck().properties(MQTT5MessageBuilders.connAckProperties().reasonString("Failed to check connect permission").build()).returnCode(MqttConnectReturnCode.CONNECTION_REFUSED_UNSPECIFIED_ERROR).build(), new Event[]{((AuthError)ThreadLocalEventPool.getLocal(AuthError.class)).cause("Failed to check connect permission").peerAddress(ChannelAttrs.socketAddress(this.ctx.channel()))});
        });
    }

    private void extendedAuth(MQTT5ExtendedAuthData authData) {
        this.isAuthing = true;
        this.authProvider.extendedAuth(authData).thenAcceptAsync(authResult -> {
            this.isAuthing = false;
            InetSocketAddress clientAddress = ChannelAttrs.socketAddress(this.ctx.channel());
            block0 : switch (authResult.getTypeCase()) {
                case SUCCESS: {
                    this.extendedAuthFuture.complete(MQTTConnectHandler.AuthResult.ok(authResult.getSuccess(), this.buildClientInfo(clientAddress, authResult.getSuccess())));
                    break;
                }
                case CONTINUE: {
                    Continue authContinue = authResult.getContinue();
                    MQTT5MessageBuilders.AuthBuilder authBuilder = MQTT5MessageBuilders.auth(this.authMethod).reasonCode(MQTT5AuthReasonCode.Continue).authData(authContinue.getAuthData());
                    if (this.requestProblemInfo) {
                        if (authContinue.hasReason()) {
                            authBuilder.reasonString(authContinue.getReason());
                        }
                        authBuilder.userProperties(authContinue.getUserProps());
                    }
                    this.ctx.channel().writeAndFlush((Object)authBuilder.build());
                    break;
                }
                default: {
                    Failed failed = authResult.getFailed();
                    switch (failed.getCode()) {
                        case NotAuthorized: {
                            this.extendedAuthFuture.complete(MQTTConnectHandler.AuthResult.goAway((MqttMessage)MqttMessageBuilders.connAck().returnCode(MqttConnectReturnCode.CONNECTION_REFUSED_NOT_AUTHORIZED_5).build(), new Event[]{((NotAuthorizedClient)ThreadLocalEventPool.getLocal(NotAuthorizedClient.class)).tenantId(failed.getTenantId()).userId(failed.getUserId()).clientId(this.connMsg.payload().clientIdentifier()).peerAddress(clientAddress)}));
                            break block0;
                        }
                        case BadPass: {
                            this.extendedAuthFuture.complete(MQTTConnectHandler.AuthResult.goAway((MqttMessage)MqttMessageBuilders.connAck().returnCode(MqttConnectReturnCode.CONNECTION_REFUSED_BAD_USERNAME_OR_PASSWORD).build(), new Event[]{((UnauthenticatedClient)ThreadLocalEventPool.getLocal(UnauthenticatedClient.class)).tenantId(failed.getTenantId()).userId(failed.getUserId()).clientId(this.connMsg.payload().clientIdentifier()).peerAddress(clientAddress)}));
                            break block0;
                        }
                        case Banned: {
                            this.extendedAuthFuture.complete(MQTTConnectHandler.AuthResult.goAway((MqttMessage)MqttMessageBuilders.connAck().returnCode(MqttConnectReturnCode.CONNECTION_REFUSED_BANNED).build(), new Event[]{((UnauthenticatedClient)ThreadLocalEventPool.getLocal(UnauthenticatedClient.class)).tenantId(failed.getTenantId()).userId(failed.getUserId()).clientId(this.connMsg.payload().clientIdentifier()).peerAddress(clientAddress)}));
                            break block0;
                        }
                    }
                    log.error("Unexpected ext-auth error:{}", (Object)failed.getReason());
                    this.extendedAuthFuture.complete(MQTTConnectHandler.AuthResult.goAway((MqttMessage)MqttMessageBuilders.connAck().returnCode(MqttConnectReturnCode.CONNECTION_REFUSED_UNSPECIFIED_ERROR).build(), new Event[]{((AuthError)ThreadLocalEventPool.getLocal(AuthError.class)).cause(failed.getReason()).peerAddress(clientAddress)}));
                }
            }
        }, (Executor)this.ctx.executor());
    }

    private ClientInfo buildClientInfo(InetSocketAddress clientAddress, Success success) {
        String clientId = this.connMsg.payload().clientIdentifier();
        if (Strings.isNullOrEmpty((String)clientId)) {
            clientId = this.ctx.channel().id().asLongText();
        }
        ClientInfo.Builder clientInfoBuilder = ClientInfo.newBuilder().setTenantId(success.getTenantId()).setType("MQTT").putAllMetadata(success.getAttrsMap()).putMetadata("ver", "5").putMetadata("userId", success.getUserId()).putMetadata("clientId", clientId).putMetadata("channelId", this.ctx.channel().id().asLongText()).putMetadata("address", Optional.ofNullable(clientAddress).map(InetSocketAddress::toString).orElse("")).putMetadata("broker", ChannelAttrs.mqttSessionContext((ChannelHandlerContext)this.ctx).serverId);
        return clientInfoBuilder.build();
    }

    @Override
    protected void handleMqttMessage(MqttMessage message) {
        if (this.isAuthing) {
            switch (message.fixedHeader().messageType()) {
                case AUTH: {
                    this.handleGoAway(GoAway.now(new Event[]{((ProtocolError)ThreadLocalEventPool.getLocal(ProtocolError.class)).statement("Enhanced Auth in progress").peerAddress(ChannelAttrs.socketAddress(this.ctx.channel()))}));
                    break;
                }
                case DISCONNECT: {
                    this.handleGoAway(GoAway.now(ThreadLocalEventPool.getLocal(EnhancedAuthAbortByClient.class)));
                    break;
                }
                default: {
                    this.handleGoAway(GoAway.now(new Event[]{((ProtocolError)ThreadLocalEventPool.getLocal(ProtocolError.class)).statement("Unexpected control packet during enhanced auth: " + String.valueOf(message.fixedHeader().messageType())).peerAddress(ChannelAttrs.socketAddress(this.ctx.channel()))}));
                    break;
                }
            }
        } else {
            switch (message.fixedHeader().messageType()) {
                case AUTH: {
                    MQTT5AuthReasonCode reasonCode = MQTT5AuthReasonCode.valueOf(((MqttReasonCodeAndPropertiesVariableHeader)message.variableHeader()).reasonCode());
                    if (reasonCode != MQTT5AuthReasonCode.Continue) {
                        this.handleGoAway(GoAway.now(new Event[]{((ProtocolError)ThreadLocalEventPool.getLocal(ProtocolError.class)).statement("Invalid auth reason code: " + String.valueOf((Object)reasonCode)).peerAddress(ChannelAttrs.socketAddress(this.ctx.channel()))}));
                        return;
                    }
                    MQTT5ExtendedAuthData authData = AuthUtil.buildMQTT5ExtendedAuthData(message, false);
                    if (!authData.getAuth().getAuthMethod().equals(this.authMethod)) {
                        this.handleGoAway(GoAway.now(new Event[]{((ProtocolError)ThreadLocalEventPool.getLocal(ProtocolError.class)).statement("Invalid auth method: " + authData.getAuth().getAuthMethod()).peerAddress(ChannelAttrs.socketAddress(this.ctx.channel()))}));
                        return;
                    }
                    this.extendedAuth(authData);
                    break;
                }
                case DISCONNECT: {
                    this.handleGoAway(GoAway.now(ThreadLocalEventPool.getLocal(EnhancedAuthAbortByClient.class)));
                    break;
                }
                default: {
                    this.handleGoAway(GoAway.now(new Event[]{((ProtocolError)ThreadLocalEventPool.getLocal(ProtocolError.class)).statement("Unexpected control packet during enhanced auth: " + String.valueOf(message.fixedHeader().messageType())).peerAddress(ChannelAttrs.socketAddress(this.ctx.channel()))}));
                }
            }
        }
    }

    @Override
    protected GoAway onNoEnoughResources(MqttConnectMessage message, TenantResourceType resourceType, ClientInfo clientInfo) {
        return new GoAway((MqttMessage)MqttMessageBuilders.connAck().returnCode(MqttConnectReturnCode.CONNECTION_REFUSED_QUOTA_EXCEEDED).properties(MQTT5MessageBuilders.connAckProperties().reasonString(resourceType.name()).build()).build(), new Event[]{((OutOfTenantResource)ThreadLocalEventPool.getLocal(OutOfTenantResource.class)).reason(resourceType.name()).clientInfo(clientInfo), ((ResourceThrottled)ThreadLocalEventPool.getLocal(ResourceThrottled.class)).reason(resourceType.name()).clientInfo(clientInfo)});
    }

    @Override
    protected GoAway validate(MqttConnectMessage message, TenantSettings settings, ClientInfo clientInfo) {
        Optional<Integer> topicAliasMaximum;
        if (message.variableHeader().version() == 5 && !settings.mqtt5Enabled) {
            return new GoAway((MqttMessage)MqttMessageBuilders.connAck().returnCode(MqttConnectReturnCode.CONNECTION_REFUSED_UNSUPPORTED_PROTOCOL_VERSION).properties(MQTT5MessageBuilders.connAckProperties().reasonString("MQTT5 not enabled").build()).build(), new Event[]{((ProtocolViolation)ThreadLocalEventPool.getLocal(ProtocolViolation.class)).statement("MQTT5 not enabled").clientInfo(clientInfo)});
        }
        if (IMQTTMessageSizer.mqtt5().lastWillSize(message) > settings.maxLastWillSize) {
            return new GoAway((MqttMessage)MqttMessageBuilders.connAck().returnCode(MqttConnectReturnCode.CONNECTION_REFUSED_PACKET_TOO_LARGE).properties(MQTT5MessageBuilders.connAckProperties().reasonString("Too large connect packet: max=" + settings.maxPacketSize).build()).build(), new Event[]{((ProtocolViolation)ThreadLocalEventPool.getLocal(ProtocolViolation.class)).statement("Too large connect packet").clientInfo(clientInfo)});
        }
        Optional<Integer> requestMaxPacketSize = MQTT5MessageUtils.maximumPacketSize(message.variableHeader().properties());
        if (requestMaxPacketSize.isPresent()) {
            if (requestMaxPacketSize.get() < 16) {
                return new GoAway((MqttMessage)MqttMessageBuilders.connAck().returnCode(MqttConnectReturnCode.CONNECTION_REFUSED_IMPLEMENTATION_SPECIFIC).properties(MQTT5MessageBuilders.connAckProperties().reasonString("Invalid max packet size: " + String.valueOf(requestMaxPacketSize.get())).build()).build(), new Event[]{((ProtocolViolation)ThreadLocalEventPool.getLocal(ProtocolViolation.class)).statement("Invalid max packet size:" + String.valueOf(requestMaxPacketSize.get())).clientInfo(clientInfo)});
            }
            if (requestMaxPacketSize.get() > settings.maxPacketSize) {
                return new GoAway((MqttMessage)MqttMessageBuilders.connAck().returnCode(MqttConnectReturnCode.CONNECTION_REFUSED_IMPLEMENTATION_SPECIFIC).properties(MQTT5MessageBuilders.connAckProperties().reasonString("Max packet size: " + settings.maxPacketSize).build()).build(), new Event[]{((ProtocolViolation)ThreadLocalEventPool.getLocal(ProtocolViolation.class)).statement("Invalid max packet size: " + String.valueOf(requestMaxPacketSize.get())).clientInfo(clientInfo)});
            }
        }
        if ((topicAliasMaximum = MQTT5MessageUtils.topicAliasMaximum(message.variableHeader().properties())).orElse(0) > settings.maxTopicAlias) {
            return new GoAway((MqttMessage)MqttMessageBuilders.connAck().returnCode(MqttConnectReturnCode.CONNECTION_REFUSED_QUOTA_EXCEEDED).properties(MQTT5MessageBuilders.connAckProperties().reasonString("Too large TopicAliasMaximum: max=" + settings.maxTopicAlias).build()).build(), new Event[]{((InvalidTopic)ThreadLocalEventPool.getLocal(InvalidTopic.class)).topic(message.payload().willTopic()).clientInfo(clientInfo)});
        }
        if (message.variableHeader().isWillFlag()) {
            if (!TopicUtil.isValidTopic((String)message.payload().willTopic(), (int)settings.maxTopicLevelLength, (int)settings.maxTopicLevels, (int)settings.maxTopicLength)) {
                return new GoAway((MqttMessage)MqttMessageBuilders.connAck().returnCode(MqttConnectReturnCode.CONNECTION_REFUSED_TOPIC_NAME_INVALID).properties(MQTT5MessageBuilders.connAckProperties().reasonString("Invalid will topic:" + message.payload().willTopic()).build()).build(), new Event[]{((InvalidTopic)ThreadLocalEventPool.getLocal(InvalidTopic.class)).topic(message.payload().willTopic()).clientInfo(clientInfo)});
            }
            if (message.variableHeader().isWillRetain() && !settings.retainEnabled) {
                return new GoAway((MqttMessage)MqttMessageBuilders.connAck().returnCode(MqttConnectReturnCode.CONNECTION_REFUSED_RETAIN_NOT_SUPPORTED).build(), new Event[]{((ProtocolViolation)ThreadLocalEventPool.getLocal(ProtocolViolation.class)).statement("Retain not supported").clientInfo(clientInfo)});
            }
            if (message.variableHeader().willQos() > settings.maxQoS.getNumber()) {
                return new GoAway((MqttMessage)MqttMessageBuilders.connAck().returnCode(MqttConnectReturnCode.CONNECTION_REFUSED_QOS_NOT_SUPPORTED).build(), new Event[]{((ProtocolViolation)ThreadLocalEventPool.getLocal(ProtocolViolation.class)).statement("Will QoS not supported").clientInfo(clientInfo)});
            }
            if (settings.payloadFormatValidationEnabled && MQTT5MessageUtils.isUTF8Payload(this.connMsg.payload().willProperties()) && !UTF8Util.isValidUTF8Payload((byte[])this.connMsg.payload().willMessageInBytes())) {
                return new GoAway((MqttMessage)MqttMessageBuilders.connAck().properties(MQTT5MessageBuilders.connAckProperties().reasonString("Invalid payload format").build()).returnCode(MqttConnectReturnCode.CONNECTION_REFUSED_PAYLOAD_FORMAT_INVALID).build(), new Event[]{((ProtocolViolation)ThreadLocalEventPool.getLocal(ProtocolViolation.class)).statement("Invalid payload format").clientInfo(clientInfo)});
            }
        }
        return null;
    }

    @Override
    protected GoAway needRedirect(ClientInfo clientInfo) {
        Optional redirection = this.clientBalancer.needRedirect(clientInfo);
        return redirection.map(value -> new GoAway((MqttMessage)MqttMessageBuilders.connAck().properties(MQTT5MessageBuilders.connAckProperties().serverReference(value.serverReference().orElse(null)).build()).returnCode(value.permanentMove() ? MqttConnectReturnCode.CONNECTION_REFUSED_SERVER_MOVED : MqttConnectReturnCode.CONNECTION_REFUSED_USE_ANOTHER_SERVER).build(), new Event[]{((Redirect)ThreadLocalEventPool.getLocal(Redirect.class)).isPermanent(value.permanentMove()).serverReference((String)value.serverReference().orElse(null)).clientInfo(clientInfo)})).orElse(null);
    }

    @Override
    protected LWT getWillMessage(MqttConnectMessage message, ClientInfo clientInfo) {
        return MQTT5MessageUtils.toWillMessage(message, clientInfo, this.sessionCtx.userPropsCustomizer);
    }

    @Override
    protected boolean isCleanStart(MqttConnectMessage message, TenantSettings settings) {
        return settings.forceTransient || message.variableHeader().isCleanSession();
    }

    @Override
    protected int getSessionExpiryInterval(MqttConnectMessage message, TenantSettings settings) {
        if (settings.forceTransient) {
            return 0;
        }
        int requestSEI = Optional.ofNullable((MqttProperties.IntegerProperty)message.variableHeader().properties().getProperty(MqttProperties.MqttPropertyType.SESSION_EXPIRY_INTERVAL.value())).map(MqttProperties.MqttProperty::value).orElse(0);
        if (requestSEI == 0) {
            return 0;
        }
        if (Integer.compareUnsigned(requestSEI, settings.minSEI) < 0) {
            return settings.minSEI;
        }
        if (Integer.compareUnsigned(requestSEI, settings.maxSEI) > 0) {
            return settings.maxSEI;
        }
        return requestSEI;
    }

    @Override
    protected GoAway onInboxCallError(ClientInfo clientInfo, String reason) {
        return new GoAway((MqttMessage)MqttMessageBuilders.connAck().returnCode(MqttConnectReturnCode.CONNECTION_REFUSED_IMPLEMENTATION_SPECIFIC).properties(MQTT5MessageBuilders.connAckProperties().reasonString(reason).build()).build(), new Event[]{((InboxTransientError)ThreadLocalEventPool.getLocal(InboxTransientError.class)).reason(reason).clientInfo(clientInfo)});
    }

    @Override
    protected GoAway onInboxCallRetry(ClientInfo clientInfo, String reason) {
        return new GoAway((MqttMessage)MqttMessageBuilders.connAck().returnCode(MqttConnectReturnCode.CONNECTION_REFUSED_IMPLEMENTATION_SPECIFIC).properties(MQTT5MessageBuilders.connAckProperties().reasonString(reason).build()).build(), new Event[]{((InboxTransientError)ThreadLocalEventPool.getLocal(InboxTransientError.class)).reason(reason).clientInfo(clientInfo)});
    }

    @Override
    protected GoAway onInboxCallBusy(ClientInfo clientInfo, String reason) {
        return new GoAway((MqttMessage)MqttMessageBuilders.connAck().returnCode(MqttConnectReturnCode.CONNECTION_REFUSED_SERVER_BUSY).properties(MQTT5MessageBuilders.connAckProperties().reasonString(reason).build()).build(), new Event[]{((ServerBusy)ThreadLocalEventPool.getLocal(ServerBusy.class)).reason(reason).clientInfo(clientInfo)});
    }

    @Override
    protected MQTTSessionHandler buildTransientSessionHandler(MqttConnectMessage connMsg, TenantSettings settings, ITenantMeter tenantMeter, String userSessionId, int keepAliveSeconds, LWT willMessage, ClientInfo clientInfo, ChannelHandlerContext ctx) {
        return MQTT5TransientSessionHandler.builder().connMsg(connMsg).settings(settings).tenantMeter(tenantMeter).oomCondition(ORCondition.or(DirectMemPressureCondition.INSTANCE, HeapMemPressureCondition.INSTANCE)).userSessionId(userSessionId).clientInfo(clientInfo).keepAliveTimeSeconds(keepAliveSeconds).willMessage(willMessage).ctx(ctx).build();
    }

    @Override
    protected MQTTSessionHandler buildPersistentSessionHandler(MqttConnectMessage connMsg, TenantSettings settings, ITenantMeter tenantMeter, String userSessionId, int keepAliveSeconds, int sessionExpiryInterval, InboxVersion inboxVersion, LWT noDelayLWT, ClientInfo clientInfo, ChannelHandlerContext ctx) {
        return MQTT5PersistentSessionHandler.builder().connMsg(connMsg).settings(settings).tenantMeter(tenantMeter).oomCondition(ORCondition.or(DirectMemPressureCondition.INSTANCE, HeapMemPressureCondition.INSTANCE)).userSessionId(userSessionId).clientInfo(clientInfo).inboxVersion(inboxVersion).keepAliveTimeSeconds(keepAliveSeconds).sessionExpirySeconds(sessionExpiryInterval).noDelayLWT(noDelayLWT).ctx(ctx).build();
    }

    @Override
    protected MqttConnAckMessage onConnected(MqttConnectMessage connMsg, TenantSettings settings, String userSessionId, int keepAliveSeconds, int sessionExpiryInterval, boolean sessionExists, ClientInfo clientInfo, Optional<String> responseInfo, Optional<ByteString> authData, UserProperties userProperties) {
        MqttProperties connProps;
        MqttProperties.IntegerProperty intProp;
        MQTT5MessageBuilders.ConnAckPropertiesBuilder connPropsBuilder = MQTT5MessageBuilders.connAckProperties();
        if (connMsg.variableHeader().keepAliveTimeSeconds() != keepAliveSeconds) {
            connPropsBuilder.serverKeepAlive(keepAliveSeconds);
        }
        if ((intProp = (MqttProperties.IntegerProperty)(connProps = connMsg.variableHeader().properties()).getProperty(MqttProperties.MqttPropertyType.SESSION_EXPIRY_INTERVAL.value())) != null && (Integer)intProp.value() != sessionExpiryInterval) {
            connPropsBuilder.sessionExpiryInterval(sessionExpiryInterval);
        }
        if (Strings.isNullOrEmpty((String)connMsg.payload().clientIdentifier())) {
            connPropsBuilder.assignedClientId(clientInfo.getMetadataOrDefault("clientId", ""));
        }
        if (!settings.retainEnabled) {
            connPropsBuilder.retainAvailable(false);
        }
        if (!settings.wildcardSubscriptionEnabled) {
            connPropsBuilder.wildcardSubscriptionAvailable(false);
        }
        if (!settings.subscriptionIdentifierEnabled) {
            connPropsBuilder.subscriptionIdentifiersAvailable(false);
        }
        if (!settings.sharedSubscriptionEnabled) {
            connPropsBuilder.sharedSubscriptionAvailable(false);
        }
        if (settings.maxQoS != QoS.EXACTLY_ONCE) {
            connPropsBuilder.maximumQos((byte)settings.maxQoS.getNumber());
        }
        connPropsBuilder.maximumPacketSize(settings.maxPacketSize);
        connPropsBuilder.topicAliasMaximum(settings.maxTopicAlias);
        connPropsBuilder.receiveMaximum(settings.receiveMaximum);
        if (MQTT5MessageUtils.requestResponseInformation(connProps) && responseInfo.isPresent()) {
            connPropsBuilder.responseInformation(responseInfo.get());
        }
        MQTT5MessageUtils.authMethod(connProps).ifPresent(methodName -> {
            connPropsBuilder.authenticationMethod((String)methodName);
            authData.ifPresent(bytes -> connPropsBuilder.authenticationData(bytes.toByteArray()));
        });
        for (StringPair userProp : userProperties.getUserPropertiesList()) {
            connPropsBuilder.userProperty(userProp.getKey(), userProp.getValue());
        }
        return MqttMessageBuilders.connAck().sessionPresent(sessionExists).properties(connPropsBuilder.build()).returnCode(MqttConnectReturnCode.CONNECTION_ACCEPTED).build();
    }

    @Override
    protected int maxPacketSize(MqttConnectMessage connMsg, TenantSettings settings) {
        return MQTT5MessageUtils.maximumPacketSize(connMsg.variableHeader().properties()).orElse(settings.maxPacketSize);
    }
}

