/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.util.index;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.BiConsumer;
import org.apache.bifromq.util.index.Branch;
import org.apache.bifromq.util.index.BranchTable;
import org.pcollections.HashTreePMap;
import org.pcollections.PMap;

final class ShardedBranchTable<V>
implements BranchTable<V> {
    private final PMap<String, Branch<V>>[][] segments;
    private final int shardBits;
    private final int segBits;
    private final int size;

    ShardedBranchTable(PMap<String, Branch<V>>[][] segments, int shardBits, int segBits, int size) {
        this.segments = segments;
        this.shardBits = shardBits;
        this.segBits = segBits;
        this.size = size;
    }

    static <T> ShardedBranchTable<T> from(PMap<String, Branch<T>> map, int shardBits, int segBits) {
        int segNum = 1 << segBits;
        int perSeg = 1 << shardBits - segBits;
        PMap[][] segs = new PMap[segNum][perSeg];
        for (int s = 0; s < segNum; ++s) {
            for (int i = 0; i < perSeg; ++i) {
                segs[s][i] = HashTreePMap.empty();
            }
        }
        int count = 0;
        for (Map.Entry e : map.entrySet()) {
            int idx = ShardedBranchTable.idx((String)e.getKey(), shardBits);
            int si = ShardedBranchTable.segIdx(idx, shardBits, segBits);
            int wi = ShardedBranchTable.withinIdx(idx, shardBits, segBits);
            PMap shard = segs[si][wi];
            segs[si][wi] = shard.plus((Object)((String)e.getKey()), (Object)((Branch)e.getValue()));
            ++count;
        }
        return new ShardedBranchTable(segs, shardBits, segBits, count);
    }

    private static int smear(int h) {
        h ^= h >>> 16;
        h *= 2146121005;
        h ^= h >>> 15;
        h *= -2073254261;
        h ^= h >>> 16;
        return h;
    }

    private static int idx(String key, int shardBits) {
        int h = ShardedBranchTable.smear(key.hashCode());
        return h & (1 << shardBits) - 1;
    }

    private static int segIdx(int idx, int shardBits, int segBits) {
        return idx >>> shardBits - segBits;
    }

    private static int withinIdx(int idx, int shardBits, int segBits) {
        return idx & (1 << shardBits - segBits) - 1;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Branch<V> get(String key) {
        int idx = ShardedBranchTable.idx(key, this.shardBits);
        PMap<String, Branch<V>> shard = this.segments[ShardedBranchTable.segIdx(idx, this.shardBits, this.segBits)][ShardedBranchTable.withinIdx(idx, this.shardBits, this.segBits)];
        return (Branch)shard.get((Object)key);
    }

    @Override
    public BranchTable<V> plus(String key, Branch<V> value) {
        int idx = ShardedBranchTable.idx(key, this.shardBits);
        int si = ShardedBranchTable.segIdx(idx, this.shardBits, this.segBits);
        int wi = ShardedBranchTable.withinIdx(idx, this.shardBits, this.segBits);
        PMap<String, Branch<V>> old = this.segments[si][wi];
        Branch existed = (Branch)old.get((Object)key);
        PMap neu = old.plus((Object)key, value);
        if (neu == old) {
            return this;
        }
        PMap[] rowCopy = (PMap[])this.segments[si].clone();
        rowCopy[wi] = neu;
        PMap[][] segsCopy = (PMap[][])this.segments.clone();
        segsCopy[si] = rowCopy;
        return new ShardedBranchTable<V>(segsCopy, this.shardBits, this.segBits, existed == null ? this.size + 1 : this.size);
    }

    @Override
    public BranchTable<V> minus(String key) {
        int wi;
        int idx = ShardedBranchTable.idx(key, this.shardBits);
        int si = ShardedBranchTable.segIdx(idx, this.shardBits, this.segBits);
        PMap<String, Branch<V>> old = this.segments[si][wi = ShardedBranchTable.withinIdx(idx, this.shardBits, this.segBits)];
        Branch existed = (Branch)old.get((Object)key);
        if (existed == null) {
            return this;
        }
        PMap neu = old.minus((Object)key);
        PMap[] rowCopy = (PMap[])this.segments[si].clone();
        rowCopy[wi] = neu;
        PMap[][] segsCopy = (PMap[][])this.segments.clone();
        segsCopy[si] = rowCopy;
        return new ShardedBranchTable<V>(segsCopy, this.shardBits, this.segBits, this.size - 1);
    }

    @Override
    public void forEach(BiConsumer<String, Branch<V>> consumer) {
        PMap<String, Branch<V>>[][] pMapArray = this.segments;
        int n = pMapArray.length;
        for (int i = 0; i < n; ++i) {
            PMap<String, Branch<V>>[] row;
            for (PMap<String, Branch<V>> shard : row = pMapArray[i]) {
                for (Map.Entry e : shard.entrySet()) {
                    consumer.accept((String)e.getKey(), (Branch)e.getValue());
                }
            }
        }
    }

    @Override
    public Map<String, Branch<V>> asMapView() {
        return new AbstractMap<String, Branch<V>>(){

            @Override
            public Branch<V> get(Object key) {
                if (!(key instanceof String)) {
                    return null;
                }
                String s = (String)key;
                return ShardedBranchTable.this.get(s);
            }

            @Override
            public boolean containsKey(Object key) {
                return this.get(key) != null;
            }

            @Override
            public Set<Map.Entry<String, Branch<V>>> entrySet() {
                return new EntrySetView();
            }

            @Override
            public int size() {
                return ShardedBranchTable.this.size();
            }
        };
    }

    private final class EntrySetView
    extends AbstractSet<Map.Entry<String, Branch<V>>> {
        private EntrySetView() {
        }

        @Override
        public Iterator<Map.Entry<String, Branch<V>>> iterator() {
            return new Iterator<Map.Entry<String, Branch<V>>>(){
                int si = 0;
                int wi = 0;
                Iterator<Map.Entry<String, Branch<V>>> it;
                {
                    this.it = ShardedBranchTable.this.segments.length == 0 ? Collections.emptyIterator() : ShardedBranchTable.this.segments[0][0].entrySet().iterator();
                }

                private void advance() {
                    while (this.it != null && !this.it.hasNext()) {
                        ++this.wi;
                        if (this.si < ShardedBranchTable.this.segments.length && this.wi < ShardedBranchTable.this.segments[this.si].length) {
                            this.it = ShardedBranchTable.this.segments[this.si][this.wi].entrySet().iterator();
                            continue;
                        }
                        ++this.si;
                        if (this.si >= ShardedBranchTable.this.segments.length) {
                            this.it = Collections.emptyIterator();
                            return;
                        }
                        this.wi = 0;
                        this.it = ShardedBranchTable.this.segments[this.si][this.wi].entrySet().iterator();
                    }
                }

                @Override
                public boolean hasNext() {
                    this.advance();
                    return this.it != null && this.it.hasNext();
                }

                @Override
                public Map.Entry<String, Branch<V>> next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    return this.it.next();
                }
            };
        }

        @Override
        public int size() {
            return ShardedBranchTable.this.size();
        }
    }
}

