/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.inbox.server.scheduler;

import java.util.Iterator;
import java.util.Queue;
import lombok.Generated;
import org.apache.bifromq.basekv.client.IQueryPipeline;
import org.apache.bifromq.basekv.client.exception.BadVersionException;
import org.apache.bifromq.basekv.client.exception.TryLaterException;
import org.apache.bifromq.basekv.client.scheduler.BatchQueryCall;
import org.apache.bifromq.basekv.client.scheduler.QueryCallBatcherKey;
import org.apache.bifromq.basekv.store.proto.ROCoProcInput;
import org.apache.bifromq.basekv.store.proto.ROCoProcOutput;
import org.apache.bifromq.baserpc.client.exception.ServerNotFoundException;
import org.apache.bifromq.basescheduler.ICallTask;
import org.apache.bifromq.inbox.rpc.proto.SendLWTReply;
import org.apache.bifromq.inbox.rpc.proto.SendLWTRequest;
import org.apache.bifromq.inbox.storage.proto.BatchSendLWTReply;
import org.apache.bifromq.inbox.storage.proto.BatchSendLWTRequest;
import org.apache.bifromq.inbox.storage.proto.InboxServiceROCoProcInput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BatchSendLWTCall
extends BatchQueryCall<SendLWTRequest, SendLWTReply> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BatchSendLWTCall.class);

    protected BatchSendLWTCall(IQueryPipeline pipeline, QueryCallBatcherKey batcherKey) {
        super(pipeline, batcherKey);
    }

    protected ROCoProcInput makeBatch(Iterator<SendLWTRequest> reqIterator) {
        BatchSendLWTRequest.Builder reqBuilder = BatchSendLWTRequest.newBuilder();
        reqIterator.forEachRemaining(request -> reqBuilder.addParams(BatchSendLWTRequest.Params.newBuilder().setTenantId(request.getTenantId()).setInboxId(request.getInboxId()).setVersion(request.getVersion()).setNow(request.getNow()).build()));
        long reqId = System.nanoTime();
        return ROCoProcInput.newBuilder().setInboxService(InboxServiceROCoProcInput.newBuilder().setReqId(reqId).setBatchSendLWT(reqBuilder.build()).build()).build();
    }

    protected void handleOutput(Queue<ICallTask<SendLWTRequest, SendLWTReply, QueryCallBatcherKey>> batchedTasks, ROCoProcOutput output) {
        ICallTask<SendLWTRequest, SendLWTReply, QueryCallBatcherKey> task;
        assert (batchedTasks.size() == output.getInboxService().getBatchSendLWT().getCodeCount());
        int i = 0;
        while ((task = batchedTasks.poll()) != null) {
            BatchSendLWTReply.Code code = output.getInboxService().getBatchSendLWT().getCode(i++);
            switch (code) {
                case OK: {
                    task.resultPromise().complete(SendLWTReply.newBuilder().setReqId(((SendLWTRequest)task.call()).getReqId()).setCode(SendLWTReply.Code.OK).build());
                    break;
                }
                case NO_INBOX: {
                    task.resultPromise().complete(SendLWTReply.newBuilder().setReqId(((SendLWTRequest)task.call()).getReqId()).setCode(SendLWTReply.Code.NO_INBOX).build());
                    break;
                }
                case CONFLICT: {
                    task.resultPromise().complete(SendLWTReply.newBuilder().setReqId(((SendLWTRequest)task.call()).getReqId()).setCode(SendLWTReply.Code.CONFLICT).build());
                    break;
                }
                case TRY_LATER: {
                    task.resultPromise().complete(SendLWTReply.newBuilder().setReqId(((SendLWTRequest)task.call()).getReqId()).setCode(SendLWTReply.Code.TRY_LATER).build());
                    break;
                }
                case ERROR: {
                    task.resultPromise().complete(SendLWTReply.newBuilder().setReqId(((SendLWTRequest)task.call()).getReqId()).setCode(SendLWTReply.Code.ERROR).build());
                }
            }
        }
    }

    protected void handleException(ICallTask<SendLWTRequest, SendLWTReply, QueryCallBatcherKey> callTask, Throwable e) {
        if (e instanceof ServerNotFoundException) {
            callTask.resultPromise().complete(SendLWTReply.newBuilder().setReqId(((SendLWTRequest)callTask.call()).getReqId()).setCode(SendLWTReply.Code.TRY_LATER).build());
            return;
        }
        if (e instanceof BadVersionException) {
            callTask.resultPromise().complete(SendLWTReply.newBuilder().setReqId(((SendLWTRequest)callTask.call()).getReqId()).setCode(SendLWTReply.Code.TRY_LATER).build());
            return;
        }
        if (e instanceof TryLaterException) {
            callTask.resultPromise().complete(SendLWTReply.newBuilder().setReqId(((SendLWTRequest)callTask.call()).getReqId()).setCode(SendLWTReply.Code.TRY_LATER).build());
            return;
        }
        callTask.resultPromise().completeExceptionally(e);
    }
}

